# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
#
# MIT License
#
# Copyright (c) 2022 KuFlow
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# --------------------------------------------------------------------------
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
#
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AbstractAudited(_serialization.Model):
    """AbstractAudited.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_at = last_modified_at


class Authentication(AbstractAudited):
    """Authentication.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar type: Known values are: "ENGINE_TOKEN" and "ENGINE_CERTIFICATE".
    :vartype type: str or ~kuflow.rest.models.AuthenticationType
    :ivar tenant_id: Tenant id. This attribute is required when an OAuth2 authentication is used.
    :vartype tenant_id: str
    :ivar engine_token:
    :vartype engine_token: ~kuflow.rest.models.AuthenticationEngineToken
    :ivar engine_certificate:
    :vartype engine_certificate: ~kuflow.rest.models.AuthenticationEngineCertificate
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "engine_token": {"key": "engineToken", "type": "AuthenticationEngineToken"},
        "engine_certificate": {"key": "engineCertificate", "type": "AuthenticationEngineCertificate"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        tenant_id: Optional[str] = None,
        engine_token: Optional["_models.AuthenticationEngineToken"] = None,
        engine_certificate: Optional["_models.AuthenticationEngineCertificate"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id:
        :paramtype id: str
        :keyword type: Known values are: "ENGINE_TOKEN" and "ENGINE_CERTIFICATE".
        :paramtype type: str or ~kuflow.rest.models.AuthenticationType
        :keyword tenant_id: Tenant id. This attribute is required when an OAuth2 authentication is
         used.
        :paramtype tenant_id: str
        :keyword engine_token:
        :paramtype engine_token: ~kuflow.rest.models.AuthenticationEngineToken
        :keyword engine_certificate:
        :paramtype engine_certificate: ~kuflow.rest.models.AuthenticationEngineCertificate
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.type = type
        self.tenant_id = tenant_id
        self.engine_token = engine_token
        self.engine_certificate = engine_certificate


class AuthenticationCreateParams(_serialization.Model):
    """AuthenticationCreateParams.

    All required parameters must be populated in order to send to server.

    :ivar type: Required. Known values are: "ENGINE_TOKEN" and "ENGINE_CERTIFICATE".
    :vartype type: str or ~kuflow.rest.models.AuthenticationType
    :ivar tenant_id: Tenant id. This attribute is required when an OAuth2 authentication is used.
    :vartype tenant_id: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self, *, type: Union[str, "_models.AuthenticationType"], tenant_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Required. Known values are: "ENGINE_TOKEN" and "ENGINE_CERTIFICATE".
        :paramtype type: str or ~kuflow.rest.models.AuthenticationType
        :keyword tenant_id: Tenant id. This attribute is required when an OAuth2 authentication is
         used.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id = tenant_id


class AuthenticationEngineCertificate(_serialization.Model):
    """AuthenticationEngineCertificate.

    All required parameters must be populated in order to send to server.

    :ivar namespace: Required.
    :vartype namespace: str
    :ivar tls: Required.
    :vartype tls: ~kuflow.rest.models.AuthenticationEngineCertificateTls
    """

    _validation = {
        "namespace": {"required": True},
        "tls": {"required": True},
    }

    _attribute_map = {
        "namespace": {"key": "namespace", "type": "str"},
        "tls": {"key": "tls", "type": "AuthenticationEngineCertificateTls"},
    }

    def __init__(self, *, namespace: str, tls: "_models.AuthenticationEngineCertificateTls", **kwargs: Any) -> None:
        """
        :keyword namespace: Required.
        :paramtype namespace: str
        :keyword tls: Required.
        :paramtype tls: ~kuflow.rest.models.AuthenticationEngineCertificateTls
        """
        super().__init__(**kwargs)
        self.namespace = namespace
        self.tls = tls


class AuthenticationEngineCertificateTls(_serialization.Model):
    """AuthenticationEngineCertificateTls.

    All required parameters must be populated in order to send to server.

    :ivar server_root_ca_certificate: Required.
    :vartype server_root_ca_certificate: str
    :ivar client_certificate: Required.
    :vartype client_certificate: str
    :ivar client_private_key: Required.
    :vartype client_private_key: str
    """

    _validation = {
        "server_root_ca_certificate": {"required": True},
        "client_certificate": {"required": True},
        "client_private_key": {"required": True},
    }

    _attribute_map = {
        "server_root_ca_certificate": {"key": "serverRootCaCertificate", "type": "str"},
        "client_certificate": {"key": "clientCertificate", "type": "str"},
        "client_private_key": {"key": "clientPrivateKey", "type": "str"},
    }

    def __init__(
        self, *, server_root_ca_certificate: str, client_certificate: str, client_private_key: str, **kwargs: Any
    ) -> None:
        """
        :keyword server_root_ca_certificate: Required.
        :paramtype server_root_ca_certificate: str
        :keyword client_certificate: Required.
        :paramtype client_certificate: str
        :keyword client_private_key: Required.
        :paramtype client_private_key: str
        """
        super().__init__(**kwargs)
        self.server_root_ca_certificate = server_root_ca_certificate
        self.client_certificate = client_certificate
        self.client_private_key = client_private_key


class AuthenticationEngineToken(_serialization.Model):
    """AuthenticationEngineToken.

    All required parameters must be populated in order to send to server.

    :ivar token: Engine authentication token. Required.
    :vartype token: str
    :ivar expired_at: Required.
    :vartype expired_at: ~datetime.datetime
    """

    _validation = {
        "token": {"required": True},
        "expired_at": {"required": True},
    }

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
        "expired_at": {"key": "expiredAt", "type": "iso-8601"},
    }

    def __init__(self, *, token: str, expired_at: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword token: Engine authentication token. Required.
        :paramtype token: str
        :keyword expired_at: Required.
        :paramtype expired_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.token = token
        self.expired_at = expired_at


class DefaultError(_serialization.Model):
    """Default error.

    All required parameters must be populated in order to send to server.

    :ivar timestamp: Timestamp indicating when the error happened. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar status: HTTP Status. Required.
    :vartype status: int
    :ivar message: Message Status. Required.
    :vartype message: str
    :ivar errors: Related error information.
    :vartype errors: list[~kuflow.rest.models.DefaultErrorInfo]
    """

    _validation = {
        "timestamp": {"required": True},
        "status": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "int"},
        "message": {"key": "message", "type": "str"},
        "errors": {"key": "errors", "type": "[DefaultErrorInfo]"},
    }

    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        status: int,
        message: str,
        errors: Optional[List["_models.DefaultErrorInfo"]] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword timestamp: Timestamp indicating when the error happened. Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword status: HTTP Status. Required.
        :paramtype status: int
        :keyword message: Message Status. Required.
        :paramtype message: str
        :keyword errors: Related error information.
        :paramtype errors: list[~kuflow.rest.models.DefaultErrorInfo]
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.status = status
        self.message = message
        self.errors = errors


class DefaultErrorInfo(_serialization.Model):
    """DefaultErrorInfo.

    All required parameters must be populated in order to send to server.

    :ivar code: Required.
    :vartype code: str
    :ivar message: Required.
    :vartype message: str
    :ivar location:
    :vartype location: str
    :ivar location_type:
    :vartype location_type: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "location_type": {"key": "locationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        location: Optional[str] = None,
        location_type: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword code: Required.
        :paramtype code: str
        :keyword message: Required.
        :paramtype message: str
        :keyword location:
        :paramtype location: str
        :keyword location_type:
        :paramtype location_type: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.location = location
        self.location_type = location_type


class DocumentReference(_serialization.Model):
    """DocumentReference.

    All required parameters must be populated in order to send to server.

    :ivar document_uri: JSON value representing the uploaded file.

     Example: ``kuflow-file:uri=xxx-yyy-zzz;type=application/json;size=500;name=file.json;``.
     Required.
    :vartype document_uri: str
    """

    _validation = {
        "document_uri": {"required": True},
    }

    _attribute_map = {
        "document_uri": {"key": "documentUri", "type": "str"},
    }

    def __init__(self, *, document_uri: str, **kwargs: Any) -> None:
        """
        :keyword document_uri: JSON value representing the uploaded file.

         Example: ``kuflow-file:uri=xxx-yyy-zzz;type=application/json;size=500;name=file.json;``.
         Required.
        :paramtype document_uri: str
        """
        super().__init__(**kwargs)
        self.document_uri = document_uri


class JsonPatchOperation(_serialization.Model):
    """JsonPatchOperation.

    All required parameters must be populated in order to send to server.

    :ivar op: The operation to perform. Required. Known values are: "add", "remove", "replace",
     "move", "copy", and "test".
    :vartype op: str or ~kuflow.rest.models.JsonPatchOperationType
    :ivar from_property: A JSON Pointer path used when op is "copy" or "move".
    :vartype from_property: str
    :ivar path: A JSON Pointer path. Required.
    :vartype path: str
    :ivar value: The value to "add", "replace" or "test".
    :vartype value: any
    """

    _validation = {
        "op": {"required": True},
        "path": {"required": True},
    }

    _attribute_map = {
        "op": {"key": "op", "type": "str"},
        "from_property": {"key": "from", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(
        self,
        *,
        op: Union[str, "_models.JsonPatchOperationType"],
        path: str,
        from_property: Optional[str] = None,
        value: Optional[Any] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword op: The operation to perform. Required. Known values are: "add", "remove", "replace",
         "move", "copy", and "test".
        :paramtype op: str or ~kuflow.rest.models.JsonPatchOperationType
        :keyword from_property: A JSON Pointer path used when op is "copy" or "move".
        :paramtype from_property: str
        :keyword path: A JSON Pointer path. Required.
        :paramtype path: str
        :keyword value: The value to "add", "replace" or "test".
        :paramtype value: any
        """
        super().__init__(**kwargs)
        self.op = op
        self.from_property = from_property
        self.path = path
        self.value = value


class JsonValue(_serialization.Model):
    """Json value.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar valid: true if the data complain the related json schema.
    :vartype valid: bool
    :ivar value: json value filled that complain with the related json schema. Required.
    :vartype value: dict[str, any]
    :ivar errors:
    :vartype errors: list[~kuflow.rest.models.JsonValueError]
    """

    _validation = {
        "valid": {"readonly": True},
        "value": {"required": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "value": {"key": "value", "type": "{object}"},
        "errors": {"key": "errors", "type": "[JsonValueError]"},
    }

    def __init__(self, *, value: Dict[str, Any], **kwargs: Any) -> None:
        """
        :keyword value: json value filled that complain with the related json schema. Required.
        :paramtype value: dict[str, any]
        """
        super().__init__(**kwargs)
        self.valid = None
        self.value = value
        self.errors = None


class JsonValueError(_serialization.Model):
    """Json value.

    :ivar property_path: JSON pointer to the property with the error. See:
     https://datatracker.ietf.org/doc/html/rfc6901

     ie: /user/name or /users/1/name.
    :vartype property_path: str
    :ivar type: Error type.
    :vartype type: str
    """

    _attribute_map = {
        "property_path": {"key": "propertyPath", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, property_path: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword property_path: JSON pointer to the property with the error. See:
         https://datatracker.ietf.org/doc/html/rfc6901

         ie: /user/name or /users/1/name.
        :paramtype property_path: str
        :keyword type: Error type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.property_path = property_path
        self.type = type


class Page(_serialization.Model):
    """Page.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    """

    _validation = {
        "metadata": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
    }

    def __init__(self, *, metadata: "_models.PageMetadata", **kwargs: Any) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        """
        super().__init__(**kwargs)
        self.metadata = metadata


class PageMetadata(_serialization.Model):
    """PageMetadata.

    All required parameters must be populated in order to send to server.

    :ivar size: Required.
    :vartype size: int
    :ivar page: Required.
    :vartype page: int
    :ivar total_elements: Required.
    :vartype total_elements: int
    :ivar total_pages: Required.
    :vartype total_pages: int
    """

    _validation = {
        "size": {"required": True, "minimum": 0},
        "page": {"required": True, "minimum": 0},
        "total_elements": {"required": True},
        "total_pages": {"required": True},
    }

    _attribute_map = {
        "size": {"key": "size", "type": "int"},
        "page": {"key": "page", "type": "int"},
        "total_elements": {"key": "totalElements", "type": "int"},
        "total_pages": {"key": "totalPages", "type": "int"},
    }

    def __init__(self, *, size: int, page: int, total_elements: int, total_pages: int, **kwargs: Any) -> None:
        """
        :keyword size: Required.
        :paramtype size: int
        :keyword page: Required.
        :paramtype page: int
        :keyword total_elements: Required.
        :paramtype total_elements: int
        :keyword total_pages: Required.
        :paramtype total_pages: int
        """
        super().__init__(**kwargs)
        self.size = size
        self.page = page
        self.total_elements = total_elements
        self.total_pages = total_pages


class Principal(_serialization.Model):
    """Principal.

    :ivar id:
    :vartype id: str
    :ivar type: Known values are: "USER", "APPLICATION", and "SYSTEM".
    :vartype type: str or ~kuflow.rest.models.PrincipalType
    :ivar name:
    :vartype name: str
    :ivar user:
    :vartype user: ~kuflow.rest.models.PrincipalUser
    :ivar application:
    :vartype application: ~kuflow.rest.models.PrincipalApplication
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "user": {"key": "user", "type": "PrincipalUser"},
        "application": {"key": "application", "type": "PrincipalApplication"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[Union[str, "_models.PrincipalType"]] = None,
        name: Optional[str] = None,
        user: Optional["_models.PrincipalUser"] = None,
        application: Optional["_models.PrincipalApplication"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword type: Known values are: "USER", "APPLICATION", and "SYSTEM".
        :paramtype type: str or ~kuflow.rest.models.PrincipalType
        :keyword name:
        :paramtype name: str
        :keyword user:
        :paramtype user: ~kuflow.rest.models.PrincipalUser
        :keyword application:
        :paramtype application: ~kuflow.rest.models.PrincipalApplication
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.user = user
        self.application = application


class PrincipalApplication(_serialization.Model):
    """PrincipalApplication.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrincipalPage(Page):
    """PrincipalPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.PrincipalPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[PrincipalPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.PrincipalPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.PrincipalPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class PrincipalPageItem(_serialization.Model):
    """PrincipalPageItem.

    :ivar id:
    :vartype id: str
    :ivar type: Known values are: "USER", "APPLICATION", and "SYSTEM".
    :vartype type: str or ~kuflow.rest.models.PrincipalType
    :ivar name:
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[Union[str, "_models.PrincipalType"]] = None,
        name: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword type: Known values are: "USER", "APPLICATION", and "SYSTEM".
        :paramtype type: str or ~kuflow.rest.models.PrincipalType
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name


class PrincipalUser(_serialization.Model):
    """PrincipalUser.

    :ivar id:
    :vartype id: str
    :ivar email:
    :vartype email: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        email: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword email:
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.email = email


class Process(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """Process.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Process ID. Required.
    :vartype id: str
    :ivar state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
     "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessState
    :ivar process_definition: Required.
    :vartype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
    :ivar metadata: Json value.
    :vartype metadata: ~kuflow.rest.models.JsonValue
    :ivar entity: Json value.
    :vartype entity: ~kuflow.rest.models.JsonValue
    :ivar process_related:
    :vartype process_related: ~kuflow.rest.models.ProcessRelated
    :ivar initiator_id: Process initiator id, Principal ID.
    :vartype initiator_id: str
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True},
        "state": {"required": True},
        "process_definition": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "process_definition": {"key": "processDefinition", "type": "ProcessDefinitionSummary"},
        "metadata": {"key": "metadata", "type": "JsonValue"},
        "entity": {"key": "entity", "type": "JsonValue"},
        "process_related": {"key": "processRelated", "type": "ProcessRelated"},
        "initiator_id": {"key": "initiatorId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        state: Union[str, "_models.ProcessState"],
        process_definition: "_models.ProcessDefinitionSummary",
        tenant_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        metadata: Optional["_models.JsonValue"] = None,
        entity: Optional["_models.JsonValue"] = None,
        process_related: Optional["_models.ProcessRelated"] = None,
        initiator_id: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Process ID. Required.
        :paramtype id: str
        :keyword state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
         "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessState
        :keyword process_definition: Required.
        :paramtype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
        :keyword metadata: Json value.
        :paramtype metadata: ~kuflow.rest.models.JsonValue
        :keyword entity: Json value.
        :paramtype entity: ~kuflow.rest.models.JsonValue
        :keyword process_related:
        :paramtype process_related: ~kuflow.rest.models.ProcessRelated
        :keyword initiator_id: Process initiator id, Principal ID.
        :paramtype initiator_id: str
        :keyword tenant_id: Tenant ID. Required.
        :paramtype tenant_id: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.state = state
        self.process_definition = process_definition
        self.metadata = metadata
        self.entity = entity
        self.process_related = process_related
        self.initiator_id = initiator_id
        self.tenant_id = tenant_id


class ProcessChangeInitiatorParams(_serialization.Model):
    """Params to change the process initiator, only one option is required.

    :ivar initiator_id:
    :vartype initiator_id: str
    :ivar initiator_email:
    :vartype initiator_email: str
    """

    _attribute_map = {
        "initiator_id": {"key": "initiatorId", "type": "str"},
        "initiator_email": {"key": "initiatorEmail", "type": "str"},
    }

    def __init__(
        self, *, initiator_id: Optional[str] = None, initiator_email: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword initiator_id:
        :paramtype initiator_id: str
        :keyword initiator_email:
        :paramtype initiator_email: str
        """
        super().__init__(**kwargs)
        self.initiator_id = initiator_id
        self.initiator_email = initiator_email


class ProcessCreateParams(_serialization.Model):
    """ProcessCreateParams.

    All required parameters must be populated in order to send to server.

    :ivar id:
    :vartype id: str
    :ivar process_definition_id: Required.
    :vartype process_definition_id: str
    :ivar metadata: Json value.
    :vartype metadata: ~kuflow.rest.models.JsonValue
    :ivar initiator_id:
    :vartype initiator_id: str
    :ivar initiator_email:
    :vartype initiator_email: str
    """

    _validation = {
        "process_definition_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "process_definition_id": {"key": "processDefinitionId", "type": "str"},
        "metadata": {"key": "metadata", "type": "JsonValue"},
        "initiator_id": {"key": "initiatorId", "type": "str"},
        "initiator_email": {"key": "initiatorEmail", "type": "str"},
    }

    def __init__(
        self,
        *,
        process_definition_id: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.JsonValue"] = None,
        initiator_id: Optional[str] = None,
        initiator_email: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword process_definition_id: Required.
        :paramtype process_definition_id: str
        :keyword metadata: Json value.
        :paramtype metadata: ~kuflow.rest.models.JsonValue
        :keyword initiator_id:
        :paramtype initiator_id: str
        :keyword initiator_email:
        :paramtype initiator_email: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.process_definition_id = process_definition_id
        self.metadata = metadata
        self.initiator_id = initiator_id
        self.initiator_email = initiator_email


class ProcessDefinitionSummary(_serialization.Model):
    """ProcessDefinitionSummary.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "name": {"required": True, "max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        name: str,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.name = name


class ProcessEntityUpdateParams(_serialization.Model):
    """ProcessEntityUpdateParams.

    All required parameters must be populated in order to send to server.

    :ivar entity: Json value. Required.
    :vartype entity: ~kuflow.rest.models.JsonValue
    """

    _validation = {
        "entity": {"required": True},
    }

    _attribute_map = {
        "entity": {"key": "entity", "type": "JsonValue"},
    }

    def __init__(self, *, entity: "_models.JsonValue", **kwargs: Any) -> None:
        """
        :keyword entity: Json value. Required.
        :paramtype entity: ~kuflow.rest.models.JsonValue
        """
        super().__init__(**kwargs)
        self.entity = entity


class ProcessItem(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """ProcessItem.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Required.
    :vartype id: str
    :ivar type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
    :vartype type: str or ~kuflow.rest.models.ProcessItemType
    :ivar process_id: Required.
    :vartype process_id: str
    :ivar owner_id: Owner Principal ID.
    :vartype owner_id: str
    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    :ivar task:
    :vartype task: ~kuflow.rest.models.ProcessItemTask
    :ivar message:
    :vartype message: ~kuflow.rest.models.ProcessItemMessage
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "process_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "process_id": {"key": "processId", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "task": {"key": "task", "type": "ProcessItemTask"},
        "message": {"key": "message", "type": "ProcessItemMessage"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.ProcessItemType"],
        process_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        owner_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        task: Optional["_models.ProcessItemTask"] = None,
        message: Optional["_models.ProcessItemMessage"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Required.
        :paramtype id: str
        :keyword type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
        :paramtype type: str or ~kuflow.rest.models.ProcessItemType
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword owner_id: Owner Principal ID.
        :paramtype owner_id: str
        :keyword tenant_id: Tenant ID.
        :paramtype tenant_id: str
        :keyword task:
        :paramtype task: ~kuflow.rest.models.ProcessItemTask
        :keyword message:
        :paramtype message: ~kuflow.rest.models.ProcessItemMessage
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.type = type
        self.process_id = process_id
        self.owner_id = owner_id
        self.tenant_id = tenant_id
        self.task = task
        self.message = message


class ProcessItemCreateParams(_serialization.Model):
    """ProcessItemCreateParams.

    All required parameters must be populated in order to send to server.

    :ivar id:
    :vartype id: str
    :ivar type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
    :vartype type: str or ~kuflow.rest.models.ProcessItemType
    :ivar process_id: Required.
    :vartype process_id: str
    :ivar owner_id:
    :vartype owner_id: str
    :ivar owner_email:
    :vartype owner_email: str
    :ivar task:
    :vartype task: ~kuflow.rest.models.ProcessItemTaskCreateParams
    :ivar message:
    :vartype message: ~kuflow.rest.models.ProcessItemMessageCreateParams
    """

    _validation = {
        "type": {"required": True},
        "process_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "process_id": {"key": "processId", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_email": {"key": "ownerEmail", "type": "str"},
        "task": {"key": "task", "type": "ProcessItemTaskCreateParams"},
        "message": {"key": "message", "type": "ProcessItemMessageCreateParams"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ProcessItemType"],
        process_id: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        owner_id: Optional[str] = None,
        owner_email: Optional[str] = None,
        task: Optional["_models.ProcessItemTaskCreateParams"] = None,
        message: Optional["_models.ProcessItemMessageCreateParams"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
        :paramtype type: str or ~kuflow.rest.models.ProcessItemType
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword owner_id:
        :paramtype owner_id: str
        :keyword owner_email:
        :paramtype owner_email: str
        :keyword task:
        :paramtype task: ~kuflow.rest.models.ProcessItemTaskCreateParams
        :keyword message:
        :paramtype message: ~kuflow.rest.models.ProcessItemMessageCreateParams
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.process_id = process_id
        self.owner_id = owner_id
        self.owner_email = owner_email
        self.task = task
        self.message = message


class ProcessItemMessage(_serialization.Model):
    """ProcessItemMessage.

    :ivar text: Message text in Markdown format according to the specification
     https://spec.commonmark.org/.
    :vartype text: str
    :ivar data: Json value.
    :vartype data: ~kuflow.rest.models.JsonValue
    :ivar data_structure_data_definition_code:
    :vartype data_structure_data_definition_code: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "data": {"key": "data", "type": "JsonValue"},
        "data_structure_data_definition_code": {"key": "dataStructureDataDefinitionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        data: Optional["_models.JsonValue"] = None,
        data_structure_data_definition_code: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword text: Message text in Markdown format according to the specification
         https://spec.commonmark.org/.
        :paramtype text: str
        :keyword data: Json value.
        :paramtype data: ~kuflow.rest.models.JsonValue
        :keyword data_structure_data_definition_code:
        :paramtype data_structure_data_definition_code: str
        """
        super().__init__(**kwargs)
        self.text = text
        self.data = data
        self.data_structure_data_definition_code = data_structure_data_definition_code


class ProcessItemMessageCreateParams(_serialization.Model):
    """ProcessItemMessageCreateParams.

    :ivar text: Message text in Markdown format according to the specification
     https://spec.commonmark.org/.
    :vartype text: str
    :ivar data: Json value.
    :vartype data: ~kuflow.rest.models.JsonValue
    :ivar data_structure_data_definition_code:
    :vartype data_structure_data_definition_code: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "data": {"key": "data", "type": "JsonValue"},
        "data_structure_data_definition_code": {"key": "dataStructureDataDefinitionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        data: Optional["_models.JsonValue"] = None,
        data_structure_data_definition_code: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword text: Message text in Markdown format according to the specification
         https://spec.commonmark.org/.
        :paramtype text: str
        :keyword data: Json value.
        :paramtype data: ~kuflow.rest.models.JsonValue
        :keyword data_structure_data_definition_code:
        :paramtype data_structure_data_definition_code: str
        """
        super().__init__(**kwargs)
        self.text = text
        self.data = data
        self.data_structure_data_definition_code = data_structure_data_definition_code


class ProcessItemMessagePageItem(_serialization.Model):
    """ProcessItemMessagePageItem.

    :ivar text: Message text in Markdown format according to the specification
     https://spec.commonmark.org/.
    :vartype text: str
    :ivar data_structure_data_definition_code:
    :vartype data_structure_data_definition_code: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "data_structure_data_definition_code": {"key": "dataStructureDataDefinitionCode", "type": "str"},
    }

    def __init__(
        self, *, text: Optional[str] = None, data_structure_data_definition_code: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword text: Message text in Markdown format according to the specification
         https://spec.commonmark.org/.
        :paramtype text: str
        :keyword data_structure_data_definition_code:
        :paramtype data_structure_data_definition_code: str
        """
        super().__init__(**kwargs)
        self.text = text
        self.data_structure_data_definition_code = data_structure_data_definition_code


class ProcessItemPage(Page):
    """ProcessItemPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.ProcessItemPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[ProcessItemPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.ProcessItemPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.ProcessItemPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class ProcessItemPageItem(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """ProcessItemPageItem.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Required.
    :vartype id: str
    :ivar type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
    :vartype type: str or ~kuflow.rest.models.ProcessItemType
    :ivar process_id: Required.
    :vartype process_id: str
    :ivar owner_id: Principal ID.
    :vartype owner_id: str
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    :ivar task:
    :vartype task: ~kuflow.rest.models.ProcessItemTaskPageItem
    :ivar message:
    :vartype message: ~kuflow.rest.models.ProcessItemMessagePageItem
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "process_id": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "process_id": {"key": "processId", "type": "str"},
        "owner_id": {"key": "ownerId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "task": {"key": "task", "type": "ProcessItemTaskPageItem"},
        "message": {"key": "message", "type": "ProcessItemMessagePageItem"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.ProcessItemType"],
        process_id: str,
        tenant_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        owner_id: Optional[str] = None,
        task: Optional["_models.ProcessItemTaskPageItem"] = None,
        message: Optional["_models.ProcessItemMessagePageItem"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Required.
        :paramtype id: str
        :keyword type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
        :paramtype type: str or ~kuflow.rest.models.ProcessItemType
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword owner_id: Principal ID.
        :paramtype owner_id: str
        :keyword tenant_id: Tenant ID. Required.
        :paramtype tenant_id: str
        :keyword task:
        :paramtype task: ~kuflow.rest.models.ProcessItemTaskPageItem
        :keyword message:
        :paramtype message: ~kuflow.rest.models.ProcessItemMessagePageItem
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.type = type
        self.process_id = process_id
        self.owner_id = owner_id
        self.tenant_id = tenant_id
        self.task = task
        self.message = message


class ProcessItemTask(_serialization.Model):
    """ProcessItemTask.

    All required parameters must be populated in order to send to server.

    :ivar state: Process Item Task state. Required. Known values are: "READY", "CLAIMED",
     "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessItemTaskState
    :ivar task_definition: Required.
    :vartype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
    :ivar data: Json value.
    :vartype data: ~kuflow.rest.models.JsonValue
    :ivar logs:
    :vartype logs: list[~kuflow.rest.models.ProcessItemTaskLog]
    """

    _validation = {
        "state": {"required": True},
        "task_definition": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "task_definition": {"key": "taskDefinition", "type": "TaskDefinitionSummary"},
        "data": {"key": "data", "type": "JsonValue"},
        "logs": {"key": "logs", "type": "[ProcessItemTaskLog]"},
    }

    def __init__(
        self,
        *,
        state: Union[str, "_models.ProcessItemTaskState"],
        task_definition: "_models.TaskDefinitionSummary",
        data: Optional["_models.JsonValue"] = None,
        logs: Optional[List["_models.ProcessItemTaskLog"]] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword state: Process Item Task state. Required. Known values are: "READY", "CLAIMED",
         "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessItemTaskState
        :keyword task_definition: Required.
        :paramtype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
        :keyword data: Json value.
        :paramtype data: ~kuflow.rest.models.JsonValue
        :keyword logs:
        :paramtype logs: list[~kuflow.rest.models.ProcessItemTaskLog]
        """
        super().__init__(**kwargs)
        self.state = state
        self.task_definition = task_definition
        self.data = data
        self.logs = logs


class ProcessItemTaskAppendLogParams(_serialization.Model):
    """ProcessItemTaskAppendLogParams.

    All required parameters must be populated in order to send to server.

    :ivar message: Required.
    :vartype message: str
    :ivar level: Required. Known values are: "INFO", "WARN", and "ERROR".
    :vartype level: str or ~kuflow.rest.models.ProcessItemTaskLogLevel
    """

    _validation = {
        "message": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, message: str, level: Union[str, "_models.ProcessItemTaskLogLevel"], **kwargs: Any) -> None:
        """
        :keyword message: Required.
        :paramtype message: str
        :keyword level: Required. Known values are: "INFO", "WARN", and "ERROR".
        :paramtype level: str or ~kuflow.rest.models.ProcessItemTaskLogLevel
        """
        super().__init__(**kwargs)
        self.message = message
        self.level = level


class ProcessItemTaskAssignParams(_serialization.Model):
    """Params to assign a process item task, only one option is required.

    :ivar owner_id:
    :vartype owner_id: str
    :ivar owner_email:
    :vartype owner_email: str
    """

    _attribute_map = {
        "owner_id": {"key": "ownerId", "type": "str"},
        "owner_email": {"key": "ownerEmail", "type": "str"},
    }

    def __init__(self, *, owner_id: Optional[str] = None, owner_email: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword owner_id:
        :paramtype owner_id: str
        :keyword owner_email:
        :paramtype owner_email: str
        """
        super().__init__(**kwargs)
        self.owner_id = owner_id
        self.owner_email = owner_email


class ProcessItemTaskCreateParams(_serialization.Model):
    """ProcessItemTaskCreateParams.

    All required parameters must be populated in order to send to server.

    :ivar task_definition_code: Required.
    :vartype task_definition_code: str
    :ivar data: Json value.
    :vartype data: ~kuflow.rest.models.JsonValue
    """

    _validation = {
        "task_definition_code": {"required": True},
    }

    _attribute_map = {
        "task_definition_code": {"key": "taskDefinitionCode", "type": "str"},
        "data": {"key": "data", "type": "JsonValue"},
    }

    def __init__(self, *, task_definition_code: str, data: Optional["_models.JsonValue"] = None, **kwargs: Any) -> None:
        """
        :keyword task_definition_code: Required.
        :paramtype task_definition_code: str
        :keyword data: Json value.
        :paramtype data: ~kuflow.rest.models.JsonValue
        """
        super().__init__(**kwargs)
        self.task_definition_code = task_definition_code
        self.data = data


class ProcessItemTaskDataUpdateParams(_serialization.Model):
    """ProcessItemTaskDataUpdateParams.

    All required parameters must be populated in order to send to server.

    :ivar data: Json value. Required.
    :vartype data: ~kuflow.rest.models.JsonValue
    """

    _validation = {
        "data": {"required": True},
    }

    _attribute_map = {
        "data": {"key": "data", "type": "JsonValue"},
    }

    def __init__(self, *, data: "_models.JsonValue", **kwargs: Any) -> None:
        """
        :keyword data: Json value. Required.
        :paramtype data: ~kuflow.rest.models.JsonValue
        """
        super().__init__(**kwargs)
        self.data = data


class ProcessItemTaskLog(_serialization.Model):
    """ProcessItemTaskLog.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar timestamp: When this model was created. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar message: Required.
    :vartype message: str
    :ivar level: Required. Known values are: "INFO", "WARN", and "ERROR".
    :vartype level: str or ~kuflow.rest.models.ProcessItemTaskLogLevel
    """

    _validation = {
        "id": {"required": True},
        "timestamp": {"required": True},
        "message": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        timestamp: datetime.datetime,
        message: str,
        level: Union[str, "_models.ProcessItemTaskLogLevel"],
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword timestamp: When this model was created. Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword message: Required.
        :paramtype message: str
        :keyword level: Required. Known values are: "INFO", "WARN", and "ERROR".
        :paramtype level: str or ~kuflow.rest.models.ProcessItemTaskLogLevel
        """
        super().__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.message = message
        self.level = level


class ProcessItemTaskPageItem(_serialization.Model):
    """ProcessItemTaskPageItem.

    All required parameters must be populated in order to send to server.

    :ivar state: Process Item Task state. Required. Known values are: "READY", "CLAIMED",
     "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessItemTaskState
    :ivar task_definition: Required.
    :vartype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
    """

    _validation = {
        "state": {"required": True},
        "task_definition": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "task_definition": {"key": "taskDefinition", "type": "TaskDefinitionSummary"},
    }

    def __init__(
        self,
        *,
        state: Union[str, "_models.ProcessItemTaskState"],
        task_definition: "_models.TaskDefinitionSummary",
        **kwargs: Any,
    ) -> None:
        """
        :keyword state: Process Item Task state. Required. Known values are: "READY", "CLAIMED",
         "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessItemTaskState
        :keyword task_definition: Required.
        :paramtype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
        """
        super().__init__(**kwargs)
        self.state = state
        self.task_definition = task_definition


class ProcessMetadataUpdateParams(_serialization.Model):
    """Params to save metadata data.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Json value. Required.
    :vartype metadata: ~kuflow.rest.models.JsonValue
    """

    _validation = {
        "metadata": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "JsonValue"},
    }

    def __init__(self, *, metadata: "_models.JsonValue", **kwargs: Any) -> None:
        """
        :keyword metadata: Json value. Required.
        :paramtype metadata: ~kuflow.rest.models.JsonValue
        """
        super().__init__(**kwargs)
        self.metadata = metadata


class ProcessPage(Page):
    """ProcessPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.ProcessPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[ProcessPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.ProcessPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.ProcessPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class ProcessPageItem(AbstractAudited):
    """ProcessPageItem.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Process ID. Required.
    :vartype id: str
    :ivar state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
     "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessState
    :ivar process_definition: Required.
    :vartype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
    :ivar initiator_id: Principal ID.
    :vartype initiator_id: str
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True},
        "state": {"required": True},
        "process_definition": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "process_definition": {"key": "processDefinition", "type": "ProcessDefinitionSummary"},
        "initiator_id": {"key": "initiatorId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        state: Union[str, "_models.ProcessState"],
        process_definition: "_models.ProcessDefinitionSummary",
        tenant_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        initiator_id: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Process ID. Required.
        :paramtype id: str
        :keyword state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
         "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessState
        :keyword process_definition: Required.
        :paramtype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
        :keyword initiator_id: Principal ID.
        :paramtype initiator_id: str
        :keyword tenant_id: Tenant ID. Required.
        :paramtype tenant_id: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.state = state
        self.process_definition = process_definition
        self.initiator_id = initiator_id
        self.tenant_id = tenant_id


class ProcessRelated(_serialization.Model):
    """ProcessRelated.

    :ivar incoming: Processes whose relationship target is the current process.
    :vartype incoming: list[str]
    :ivar outcoming: Processes to which the current process relates.
    :vartype outcoming: list[str]
    """

    _attribute_map = {
        "incoming": {"key": "incoming", "type": "[str]"},
        "outcoming": {"key": "outcoming", "type": "[str]"},
    }

    def __init__(
        self, *, incoming: Optional[List[str]] = None, outcoming: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword incoming: Processes whose relationship target is the current process.
        :paramtype incoming: list[str]
        :keyword outcoming: Processes to which the current process relates.
        :paramtype outcoming: list[str]
        """
        super().__init__(**kwargs)
        self.incoming = incoming
        self.outcoming = outcoming


class Robot(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """Robot.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Robot ID. Required.
    :vartype id: str
    :ivar code: Robot Code. Required.
    :vartype code: str
    :ivar name: Robot name. Required.
    :vartype name: str
    :ivar description: Robot description.
    :vartype description: str
    :ivar source_type: Robot source type. Required. Known values are: "PACKAGE" and "UNKNOWN".
    :vartype source_type: str or ~kuflow.rest.models.RobotSourceType
    :ivar source_file: Robot source type. Required.
    :vartype source_file: ~kuflow.rest.models.RobotSourceFile
    :ivar environment_variables: Environment variables to load when the robot is executed.
    :vartype environment_variables: dict[str, str]
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True},
        "code": {"required": True, "max_length": 50, "min_length": 1},
        "name": {"required": True, "max_length": 50, "min_length": 1},
        "description": {"max_length": 4000, "min_length": 1},
        "source_type": {"required": True},
        "source_file": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_type": {"key": "sourceType", "type": "str"},
        "source_file": {"key": "sourceFile", "type": "RobotSourceFile"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        code: str,
        name: str,
        source_type: Union[str, "_models.RobotSourceType"],
        source_file: "_models.RobotSourceFile",
        tenant_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Robot ID. Required.
        :paramtype id: str
        :keyword code: Robot Code. Required.
        :paramtype code: str
        :keyword name: Robot name. Required.
        :paramtype name: str
        :keyword description: Robot description.
        :paramtype description: str
        :keyword source_type: Robot source type. Required. Known values are: "PACKAGE" and "UNKNOWN".
        :paramtype source_type: str or ~kuflow.rest.models.RobotSourceType
        :keyword source_file: Robot source type. Required.
        :paramtype source_file: ~kuflow.rest.models.RobotSourceFile
        :keyword environment_variables: Environment variables to load when the robot is executed.
        :paramtype environment_variables: dict[str, str]
        :keyword tenant_id: Tenant ID. Required.
        :paramtype tenant_id: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.code = code
        self.name = name
        self.description = description
        self.source_type = source_type
        self.source_file = source_file
        self.environment_variables = environment_variables
        self.tenant_id = tenant_id


class RobotPage(Page):
    """RobotPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.RobotPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[RobotPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.RobotPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.RobotPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class RobotPageItem(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """RobotPageItem.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Robot ID. Required.
    :vartype id: str
    :ivar code: Robot Code. Required.
    :vartype code: str
    :ivar name: Robot name. Required.
    :vartype name: str
    :ivar description: Robot description.
    :vartype description: str
    :ivar source_type: Robot source type. Required. Known values are: "PACKAGE" and "UNKNOWN".
    :vartype source_type: str or ~kuflow.rest.models.RobotSourceType
    :ivar source_file: Robot source type. Required.
    :vartype source_file: ~kuflow.rest.models.RobotSourceFile
    :ivar tenant_id: Tenant ID. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True},
        "code": {"required": True, "max_length": 50, "min_length": 1},
        "name": {"required": True, "max_length": 50, "min_length": 1},
        "description": {"max_length": 4000, "min_length": 1},
        "source_type": {"required": True},
        "source_file": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_type": {"key": "sourceType", "type": "str"},
        "source_file": {"key": "sourceFile", "type": "RobotSourceFile"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        code: str,
        name: str,
        source_type: Union[str, "_models.RobotSourceType"],
        source_file: "_models.RobotSourceFile",
        tenant_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        description: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Robot ID. Required.
        :paramtype id: str
        :keyword code: Robot Code. Required.
        :paramtype code: str
        :keyword name: Robot name. Required.
        :paramtype name: str
        :keyword description: Robot description.
        :paramtype description: str
        :keyword source_type: Robot source type. Required. Known values are: "PACKAGE" and "UNKNOWN".
        :paramtype source_type: str or ~kuflow.rest.models.RobotSourceType
        :keyword source_file: Robot source type. Required.
        :paramtype source_file: ~kuflow.rest.models.RobotSourceFile
        :keyword tenant_id: Tenant ID. Required.
        :paramtype tenant_id: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.code = code
        self.name = name
        self.description = description
        self.source_type = source_type
        self.source_file = source_file
        self.tenant_id = tenant_id


class RobotSourceFile(_serialization.Model):
    """Robot source type.

    All required parameters must be populated in order to send to server.

    :ivar id: Robot ID. Required.
    :vartype id: str
    :ivar name: Source file name. Required.
    :vartype name: str
    :ivar content_type: Source file content type. Required.
    :vartype content_type: str
    :ivar content_length: Source file length. Required.
    :vartype content_length: int
    :ivar content_hash: Source file to check the integrity. Required.
    :vartype content_hash: str
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
        "content_type": {"required": True},
        "content_length": {"required": True},
        "content_hash": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "content_length": {"key": "contentLength", "type": "int"},
        "content_hash": {"key": "contentHash", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        content_type: str,
        content_length: int,
        content_hash: str,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Robot ID. Required.
        :paramtype id: str
        :keyword name: Source file name. Required.
        :paramtype name: str
        :keyword content_type: Source file content type. Required.
        :paramtype content_type: str
        :keyword content_length: Source file length. Required.
        :paramtype content_length: int
        :keyword content_hash: Source file to check the integrity. Required.
        :paramtype content_hash: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.content_type = content_type
        self.content_length = content_length
        self.content_hash = content_hash


class TaskDefinitionSummary(_serialization.Model):
    """TaskDefinitionSummary.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar code: Required.
    :vartype code: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "code": {"required": True},
        "name": {"required": True, "max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        code: str,
        name: str,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword code: Required.
        :paramtype code: str
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.code = code
        self.name = name


class Tenant(AbstractAudited):
    """Tenant.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Required.
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar plan: Tenant pricing plan. Required. Known values are: "FREE", "PREMIUM", and
     "UNLIMITED".
    :vartype plan: str or ~kuflow.rest.models.TenantPricingPlan
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
        "plan": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "plan": {"key": "plan", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        plan: Union[str, "_models.TenantPricingPlan"],
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword plan: Tenant pricing plan. Required. Known values are: "FREE", "PREMIUM", and
         "UNLIMITED".
        :paramtype plan: str or ~kuflow.rest.models.TenantPricingPlan
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.name = name
        self.plan = plan


class TenantPage(Page):
    """TenantPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.TenantPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[TenantPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.TenantPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.TenantPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class TenantPageItem(_serialization.Model):
    """TenantPageItem.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class TenantUser(AbstractAudited):
    """TenantUser.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Required.
    :vartype id: str
    :ivar metadata: Json value.
    :vartype metadata: ~kuflow.rest.models.JsonValue
    :ivar principal: Required.
    :vartype principal: ~kuflow.rest.models.Principal
    :ivar tenant_id: Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True},
        "principal": {"required": True},
        "tenant_id": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "JsonValue"},
        "principal": {"key": "principal", "type": "Principal"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        principal: "_models.Principal",
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        metadata: Optional["_models.JsonValue"] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Required.
        :paramtype id: str
        :keyword metadata: Json value.
        :paramtype metadata: ~kuflow.rest.models.JsonValue
        :keyword principal: Required.
        :paramtype principal: ~kuflow.rest.models.Principal
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.metadata = metadata
        self.principal = principal
        self.tenant_id = None


class TenantUserPage(Page):
    """TenantUserPage.

    All required parameters must be populated in order to send to server.

    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.TenantUserPageItem]
    """

    _validation = {
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[TenantUserPageItem]"},
    }

    def __init__(
        self, *, metadata: "_models.PageMetadata", content: List["_models.TenantUserPageItem"], **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.TenantUserPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.content = content


class TenantUserPageItem(AbstractAudited):
    """TenantUserPageItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Required.
    :vartype id: str
    :ivar principal_id: Required.
    :vartype principal_id: str
    :ivar tenant_id: Required.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"required": True, "readonly": True},
        "principal_id": {"required": True, "readonly": True},
        "tenant_id": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = None
        self.principal_id = None
        self.tenant_id = None


class WebhookEvent(_serialization.Model):
    """WebhookEvent.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WebhookEventProcessCreated, WebhookEventProcessStateChanged, WebhookEventProcessItemCreated,
    WebhookEventProcessItemTaskStateChanged

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.CREATED",
     "PROCESS.STATE_CHANGED", "PROCESS_ITEM.CREATED", and "PROCESS_ITEM.TASK_STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    _subtype_map = {
        "type": {
            "PROCESS.CREATED": "WebhookEventProcessCreated",
            "PROCESS.STATE_CHANGED": "WebhookEventProcessStateChanged",
            "PROCESS_ITEM.CREATED": "WebhookEventProcessItemCreated",
            "PROCESS_ITEM.TASK_STATE_CHANGED": "WebhookEventProcessItemTaskStateChanged",
        }
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        timestamp: datetime.datetime,
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.type: Optional[str] = None
        self.timestamp = timestamp


class WebhookEventProcessCreated(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.CREATED",
     "PROCESS.STATE_CHANGED", "PROCESS_ITEM.CREATED", and "PROCESS_ITEM.TASK_STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventProcessCreatedData
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventProcessCreatedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        timestamp: datetime.datetime,
        data: "_models.WebhookEventProcessCreatedData",
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventProcessCreatedData
        """
        super().__init__(id=id, version=version, timestamp=timestamp, **kwargs)
        self.type: str = "PROCESS.CREATED"
        self.data = data


class WebhookEventProcessCreatedData(_serialization.Model):
    """WebhookEventProcessCreatedData.

    All required parameters must be populated in order to send to server.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
     "CANCELLED".
    :vartype process_state: str or ~kuflow.rest.models.ProcessState
    """

    _validation = {
        "process_id": {"required": True},
        "process_state": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "process_state": {"key": "processState", "type": "str"},
    }

    def __init__(self, *, process_id: str, process_state: Union[str, "_models.ProcessState"], **kwargs: Any) -> None:
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
         "CANCELLED".
        :paramtype process_state: str or ~kuflow.rest.models.ProcessState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.process_state = process_state


class WebhookEventProcessItemCreated(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.CREATED",
     "PROCESS.STATE_CHANGED", "PROCESS_ITEM.CREATED", and "PROCESS_ITEM.TASK_STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventProcessItemCreatedData
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventProcessItemCreatedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        timestamp: datetime.datetime,
        data: "_models.WebhookEventProcessItemCreatedData",
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventProcessItemCreatedData
        """
        super().__init__(id=id, version=version, timestamp=timestamp, **kwargs)
        self.type: str = "PROCESS_ITEM.CREATED"
        self.data = data


class WebhookEventProcessItemCreatedData(_serialization.Model):
    """WebhookEventProcessItemCreatedData.

    All required parameters must be populated in order to send to server.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar process_item_id: Required.
    :vartype process_item_id: str
    :ivar process_item_type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
    :vartype process_item_type: str or ~kuflow.rest.models.ProcessItemType
    :ivar process_item_task_code:
    :vartype process_item_task_code: str
    :ivar process_item_state: Process Item Task state. Known values are: "READY", "CLAIMED",
     "COMPLETED", and "CANCELLED".
    :vartype process_item_state: str or ~kuflow.rest.models.ProcessItemTaskState
    """

    _validation = {
        "process_id": {"required": True},
        "process_item_id": {"required": True},
        "process_item_type": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "process_item_id": {"key": "processItemId", "type": "str"},
        "process_item_type": {"key": "processItemType", "type": "str"},
        "process_item_task_code": {"key": "processItemTaskCode", "type": "str"},
        "process_item_state": {"key": "processItemState", "type": "str"},
    }

    def __init__(
        self,
        *,
        process_id: str,
        process_item_id: str,
        process_item_type: Union[str, "_models.ProcessItemType"],
        process_item_task_code: Optional[str] = None,
        process_item_state: Optional[Union[str, "_models.ProcessItemTaskState"]] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword process_item_id: Required.
        :paramtype process_item_id: str
        :keyword process_item_type: Process Item Type. Required. Known values are: "TASK" and
         "MESSAGE".
        :paramtype process_item_type: str or ~kuflow.rest.models.ProcessItemType
        :keyword process_item_task_code:
        :paramtype process_item_task_code: str
        :keyword process_item_state: Process Item Task state. Known values are: "READY", "CLAIMED",
         "COMPLETED", and "CANCELLED".
        :paramtype process_item_state: str or ~kuflow.rest.models.ProcessItemTaskState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.process_item_id = process_item_id
        self.process_item_type = process_item_type
        self.process_item_task_code = process_item_task_code
        self.process_item_state = process_item_state


class WebhookEventProcessItemTaskStateChanged(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.CREATED",
     "PROCESS.STATE_CHANGED", "PROCESS_ITEM.CREATED", and "PROCESS_ITEM.TASK_STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventProcessItemTaskStateChangedData
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventProcessItemTaskStateChangedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        timestamp: datetime.datetime,
        data: "_models.WebhookEventProcessItemTaskStateChangedData",
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventProcessItemTaskStateChangedData
        """
        super().__init__(id=id, version=version, timestamp=timestamp, **kwargs)
        self.type: str = "PROCESS_ITEM.TASK_STATE_CHANGED"
        self.data = data


class WebhookEventProcessItemTaskStateChangedData(_serialization.Model):  # pylint: disable=name-too-long
    """WebhookEventProcessItemTaskStateChangedData.

    All required parameters must be populated in order to send to server.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar process_item_id: Required.
    :vartype process_item_id: str
    :ivar process_item_type: Process Item Type. Required. Known values are: "TASK" and "MESSAGE".
    :vartype process_item_type: str or ~kuflow.rest.models.ProcessItemType
    :ivar process_item_task_code: Required.
    :vartype process_item_task_code: str
    :ivar process_item_state: Process Item Task state. Required. Known values are: "READY",
     "CLAIMED", "COMPLETED", and "CANCELLED".
    :vartype process_item_state: str or ~kuflow.rest.models.ProcessItemTaskState
    """

    _validation = {
        "process_id": {"required": True},
        "process_item_id": {"required": True},
        "process_item_type": {"required": True},
        "process_item_task_code": {"required": True},
        "process_item_state": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "process_item_id": {"key": "processItemId", "type": "str"},
        "process_item_type": {"key": "processItemType", "type": "str"},
        "process_item_task_code": {"key": "processItemTaskCode", "type": "str"},
        "process_item_state": {"key": "processItemState", "type": "str"},
    }

    def __init__(
        self,
        *,
        process_id: str,
        process_item_id: str,
        process_item_type: Union[str, "_models.ProcessItemType"],
        process_item_task_code: str,
        process_item_state: Union[str, "_models.ProcessItemTaskState"],
        **kwargs: Any,
    ) -> None:
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword process_item_id: Required.
        :paramtype process_item_id: str
        :keyword process_item_type: Process Item Type. Required. Known values are: "TASK" and
         "MESSAGE".
        :paramtype process_item_type: str or ~kuflow.rest.models.ProcessItemType
        :keyword process_item_task_code: Required.
        :paramtype process_item_task_code: str
        :keyword process_item_state: Process Item Task state. Required. Known values are: "READY",
         "CLAIMED", "COMPLETED", and "CANCELLED".
        :paramtype process_item_state: str or ~kuflow.rest.models.ProcessItemTaskState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.process_item_id = process_item_id
        self.process_item_type = process_item_type
        self.process_item_task_code = process_item_task_code
        self.process_item_state = process_item_state


class WebhookEventProcessStateChanged(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar version: Required.
    :vartype version: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.CREATED",
     "PROCESS.STATE_CHANGED", "PROCESS_ITEM.CREATED", and "PROCESS_ITEM.TASK_STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventProcessStateChangedData
    """

    _validation = {
        "id": {"required": True},
        "version": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventProcessStateChangedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: str,
        timestamp: datetime.datetime,
        data: "_models.WebhookEventProcessStateChangedData",
        **kwargs: Any,
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version: Required.
        :paramtype version: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventProcessStateChangedData
        """
        super().__init__(id=id, version=version, timestamp=timestamp, **kwargs)
        self.type: str = "PROCESS.STATE_CHANGED"
        self.data = data


class WebhookEventProcessStateChangedData(_serialization.Model):
    """WebhookEventProcessStateChangedData.

    All required parameters must be populated in order to send to server.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
     "CANCELLED".
    :vartype process_state: str or ~kuflow.rest.models.ProcessState
    """

    _validation = {
        "process_id": {"required": True},
        "process_state": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "process_state": {"key": "processState", "type": "str"},
    }

    def __init__(self, *, process_id: str, process_state: Union[str, "_models.ProcessState"], **kwargs: Any) -> None:
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
         "CANCELLED".
        :paramtype process_state: str or ~kuflow.rest.models.ProcessState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.process_state = process_state


class Worker(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """Worker.

    All required parameters must be populated in order to send to server.

    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar identity: Required.
    :vartype identity: str
    :ivar task_queue: Required.
    :vartype task_queue: str
    :ivar workflow_types:
    :vartype workflow_types: list[str]
    :ivar activity_types:
    :vartype activity_types: list[str]
    :ivar hostname: Required.
    :vartype hostname: str
    :ivar ip: Required.
    :vartype ip: str
    :ivar installation_id: Installation Id.
    :vartype installation_id: str
    :ivar robot_ids: Robot Ids that this worker implements.
    :vartype robot_ids: list[str]
    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    """

    _validation = {
        "identity": {"required": True, "max_length": 255, "min_length": 1},
        "task_queue": {"required": True, "max_length": 255, "min_length": 1},
        "hostname": {"required": True, "max_length": 255, "min_length": 1},
        "ip": {"required": True, "max_length": 40, "min_length": 7},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
        "task_queue": {"key": "taskQueue", "type": "str"},
        "workflow_types": {"key": "workflowTypes", "type": "[str]"},
        "activity_types": {"key": "activityTypes", "type": "[str]"},
        "hostname": {"key": "hostname", "type": "str"},
        "ip": {"key": "ip", "type": "str"},
        "installation_id": {"key": "installationId", "type": "str"},
        "robot_ids": {"key": "robotIds", "type": "[str]"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: str,
        task_queue: str,
        hostname: str,
        ip: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        workflow_types: Optional[List[str]] = None,
        activity_types: Optional[List[str]] = None,
        installation_id: Optional[str] = None,
        robot_ids: Optional[List[str]] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id:
        :paramtype id: str
        :keyword identity: Required.
        :paramtype identity: str
        :keyword task_queue: Required.
        :paramtype task_queue: str
        :keyword workflow_types:
        :paramtype workflow_types: list[str]
        :keyword activity_types:
        :paramtype activity_types: list[str]
        :keyword hostname: Required.
        :paramtype hostname: str
        :keyword ip: Required.
        :paramtype ip: str
        :keyword installation_id: Installation Id.
        :paramtype installation_id: str
        :keyword robot_ids: Robot Ids that this worker implements.
        :paramtype robot_ids: list[str]
        :keyword tenant_id: Tenant ID.
        :paramtype tenant_id: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.id = id
        self.identity = identity
        self.task_queue = task_queue
        self.workflow_types = workflow_types
        self.activity_types = activity_types
        self.hostname = hostname
        self.ip = ip
        self.installation_id = installation_id
        self.robot_ids = robot_ids
        self.tenant_id = tenant_id


class WorkerCreateParams(_serialization.Model):
    """WorkerCreateParams.

    All required parameters must be populated in order to send to server.

    :ivar identity: Required.
    :vartype identity: str
    :ivar task_queue: Required.
    :vartype task_queue: str
    :ivar workflow_types:
    :vartype workflow_types: list[str]
    :ivar activity_types:
    :vartype activity_types: list[str]
    :ivar hostname: Required.
    :vartype hostname: str
    :ivar ip: Required.
    :vartype ip: str
    :ivar installation_id: Installation Id.
    :vartype installation_id: str
    :ivar robot_ids: Robot Ids that this worker implements.
    :vartype robot_ids: list[str]
    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    """

    _validation = {
        "identity": {"required": True, "max_length": 255, "min_length": 1},
        "task_queue": {"required": True, "max_length": 255, "min_length": 1},
        "hostname": {"required": True, "max_length": 255, "min_length": 1},
        "ip": {"required": True, "max_length": 40, "min_length": 7},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "task_queue": {"key": "taskQueue", "type": "str"},
        "workflow_types": {"key": "workflowTypes", "type": "[str]"},
        "activity_types": {"key": "activityTypes", "type": "[str]"},
        "hostname": {"key": "hostname", "type": "str"},
        "ip": {"key": "ip", "type": "str"},
        "installation_id": {"key": "installationId", "type": "str"},
        "robot_ids": {"key": "robotIds", "type": "[str]"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: str,
        task_queue: str,
        hostname: str,
        ip: str,
        workflow_types: Optional[List[str]] = None,
        activity_types: Optional[List[str]] = None,
        installation_id: Optional[str] = None,
        robot_ids: Optional[List[str]] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any,
    ) -> None:
        """
        :keyword identity: Required.
        :paramtype identity: str
        :keyword task_queue: Required.
        :paramtype task_queue: str
        :keyword workflow_types:
        :paramtype workflow_types: list[str]
        :keyword activity_types:
        :paramtype activity_types: list[str]
        :keyword hostname: Required.
        :paramtype hostname: str
        :keyword ip: Required.
        :paramtype ip: str
        :keyword installation_id: Installation Id.
        :paramtype installation_id: str
        :keyword robot_ids: Robot Ids that this worker implements.
        :paramtype robot_ids: list[str]
        :keyword tenant_id: Tenant ID.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.task_queue = task_queue
        self.workflow_types = workflow_types
        self.activity_types = activity_types
        self.hostname = hostname
        self.ip = ip
        self.installation_id = installation_id
        self.robot_ids = robot_ids
        self.tenant_id = tenant_id
