"""
EmberQuant: The Agentic Framework for AccountingTech

EmberQuant shifts accounting from syntactic to semantic processing,
providing autonomous financial reasoning infrastructure for enterprises.
"""

from emberquant.agents.auditor import AuditorAgent
from emberquant.agents.clerk import ClerkAgent
from emberquant.agents.modeler import ModelerAgent
from emberquant.agents.controller import ControllerAgent
from emberquant.core.connection import connect
from emberquant.core.emberframe import EmberFrame
from emberquant.core.embергraph import EmberGraph, ExecutionPlan
from emberquant.core.planning import execute_plan, plan

__version__ = "0.2.0"
__all__ = [
    "EmberFrame",
    "EmberGraph",
    "ExecutionPlan",
    "connect",
    "plan",
    "execute_plan",
    "ClerkAgent",
    "AuditorAgent",
    "ModelerAgent",
    "ControllerAgent",
]
