# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, account_id=None, cft_url=None, external_id=None, id=None, onboarding_status=None, origin=None, service_account_id=None, sns_topic_arn=None, trusted_account=None, update_token=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if cft_url and not isinstance(cft_url, str):
            raise TypeError("Expected argument 'cft_url' to be a str")
        pulumi.set(__self__, "cft_url", cft_url)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if onboarding_status and not isinstance(onboarding_status, str):
            raise TypeError("Expected argument 'onboarding_status' to be a str")
        pulumi.set(__self__, "onboarding_status", onboarding_status)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if sns_topic_arn and not isinstance(sns_topic_arn, str):
            raise TypeError("Expected argument 'sns_topic_arn' to be a str")
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)
        if trusted_account and not isinstance(trusted_account, str):
            raise TypeError("Expected argument 'trusted_account' to be a str")
        pulumi.set(__self__, "trusted_account", trusted_account)
        if update_token and not isinstance(update_token, str):
            raise TypeError("Expected argument 'update_token' to be a str")
        pulumi.set(__self__, "update_token", update_token)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="cftUrl")
    def cft_url(self) -> _builtins.str:
        """
        The CFT URL.
        """
        return pulumi.get(self, "cft_url")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        The external ID of the account
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="onboardingStatus")
    def onboarding_status(self) -> _builtins.str:
        """
        The Account onboarding status
        """
        return pulumi.get(self, "onboarding_status")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        Origin of account onboarding
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        The account ID of cloud NGFW service
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> _builtins.str:
        """
        The SNS topic ARN
        """
        return pulumi.get(self, "sns_topic_arn")

    @_builtins.property
    @pulumi.getter(name="trustedAccount")
    def trusted_account(self) -> _builtins.str:
        """
        The trusted account ID
        """
        return pulumi.get(self, "trusted_account")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> _builtins.str:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            account_id=self.account_id,
            cft_url=self.cft_url,
            external_id=self.external_id,
            id=self.id,
            onboarding_status=self.onboarding_status,
            origin=self.origin,
            service_account_id=self.service_account_id,
            sns_topic_arn=self.sns_topic_arn,
            trusted_account=self.trusted_account,
            update_token=self.update_token)


def get_account(account_id: Optional[_builtins.str] = None,
                cft_url: Optional[_builtins.str] = None,
                external_id: Optional[_builtins.str] = None,
                onboarding_status: Optional[_builtins.str] = None,
                origin: Optional[_builtins.str] = None,
                service_account_id: Optional[_builtins.str] = None,
                sns_topic_arn: Optional[_builtins.str] = None,
                trusted_account: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Data source for retrieving account information.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)


    :param _builtins.str account_id: The account ID
    :param _builtins.str cft_url: The CFT URL.
    :param _builtins.str external_id: The external ID of the account
    :param _builtins.str onboarding_status: The Account onboarding status
    :param _builtins.str origin: Origin of account onboarding
    :param _builtins.str service_account_id: The account ID of cloud NGFW service
    :param _builtins.str sns_topic_arn: The SNS topic ARN
    :param _builtins.str trusted_account: The trusted account ID
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['cftUrl'] = cft_url
    __args__['externalId'] = external_id
    __args__['onboardingStatus'] = onboarding_status
    __args__['origin'] = origin
    __args__['serviceAccountId'] = service_account_id
    __args__['snsTopicArn'] = sns_topic_arn
    __args__['trustedAccount'] = trusted_account
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudngfwaws:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        cft_url=pulumi.get(__ret__, 'cft_url'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'),
        onboarding_status=pulumi.get(__ret__, 'onboarding_status'),
        origin=pulumi.get(__ret__, 'origin'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        sns_topic_arn=pulumi.get(__ret__, 'sns_topic_arn'),
        trusted_account=pulumi.get(__ret__, 'trusted_account'),
        update_token=pulumi.get(__ret__, 'update_token'))
def get_account_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       cft_url: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       external_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       onboarding_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       origin: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       service_account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       sns_topic_arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       trusted_account: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    Data source for retrieving account information.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)


    :param _builtins.str account_id: The account ID
    :param _builtins.str cft_url: The CFT URL.
    :param _builtins.str external_id: The external ID of the account
    :param _builtins.str onboarding_status: The Account onboarding status
    :param _builtins.str origin: Origin of account onboarding
    :param _builtins.str service_account_id: The account ID of cloud NGFW service
    :param _builtins.str sns_topic_arn: The SNS topic ARN
    :param _builtins.str trusted_account: The trusted account ID
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['cftUrl'] = cft_url
    __args__['externalId'] = external_id
    __args__['onboardingStatus'] = onboarding_status
    __args__['origin'] = origin
    __args__['serviceAccountId'] = service_account_id
    __args__['snsTopicArn'] = sns_topic_arn
    __args__['trustedAccount'] = trusted_account
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudngfwaws:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        account_id=pulumi.get(__response__, 'account_id'),
        cft_url=pulumi.get(__response__, 'cft_url'),
        external_id=pulumi.get(__response__, 'external_id'),
        id=pulumi.get(__response__, 'id'),
        onboarding_status=pulumi.get(__response__, 'onboarding_status'),
        origin=pulumi.get(__response__, 'origin'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        sns_topic_arn=pulumi.get(__response__, 'sns_topic_arn'),
        trusted_account=pulumi.get(__response__, 'trusted_account'),
        update_token=pulumi.get(__response__, 'update_token')))
