# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'NgfwLogProfileLogDestination',
    'NgfwStatus',
    'NgfwStatusAttachment',
    'NgfwSubnetMapping',
    'RulestackProfileConfig',
    'SecurityRuleCategory',
    'SecurityRuleDestination',
    'SecurityRuleSource',
    'GetAccountsAccountDetailResult',
    'GetNgfwLogProfileLogDestinationResult',
    'GetNgfwStatusResult',
    'GetNgfwStatusAttachmentResult',
    'GetNgfwSubnetMappingResult',
    'GetNgfwsInstanceResult',
    'GetRulestackProfileConfigResult',
    'GetSecurityRuleCategoryResult',
    'GetSecurityRuleDestinationResult',
    'GetSecurityRuleSourceResult',
]

@pulumi.output_type
class NgfwLogProfileLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwLogProfileLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwLogProfileLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwLogProfileLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[_builtins.str] = None,
                 destination_type: Optional[_builtins.str] = None,
                 log_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: The log destination details.
        :param _builtins.str destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param _builtins.str log_type: The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The log destination details.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[_builtins.str]:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[_builtins.str]:
        """
        The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class NgfwStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureReason":
            suggest = "failure_reason"
        elif key == "firewallStatus":
            suggest = "firewall_status"
        elif key == "rulestackStatus":
            suggest = "rulestack_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attachments: Optional[Sequence['outputs.NgfwStatusAttachment']] = None,
                 failure_reason: Optional[_builtins.str] = None,
                 firewall_status: Optional[_builtins.str] = None,
                 rulestack_status: Optional[_builtins.str] = None):
        """
        :param Sequence['NgfwStatusAttachmentArgs'] attachments: The firewall attachments.
        :param _builtins.str failure_reason: The firewall failure reason.
        :param _builtins.str firewall_status: The firewall status.
        :param _builtins.str rulestack_status: The rulestack status.
        """
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if firewall_status is not None:
            pulumi.set(__self__, "firewall_status", firewall_status)
        if rulestack_status is not None:
            pulumi.set(__self__, "rulestack_status", rulestack_status)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Optional[Sequence['outputs.NgfwStatusAttachment']]:
        """
        The firewall attachments.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[_builtins.str]:
        """
        The firewall failure reason.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="firewallStatus")
    def firewall_status(self) -> Optional[_builtins.str]:
        """
        The firewall status.
        """
        return pulumi.get(self, "firewall_status")

    @_builtins.property
    @pulumi.getter(name="rulestackStatus")
    def rulestack_status(self) -> Optional[_builtins.str]:
        """
        The rulestack status.
        """
        return pulumi.get(self, "rulestack_status")


@pulumi.output_type
class NgfwStatusAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointId":
            suggest = "endpoint_id"
        elif key == "rejectedReason":
            suggest = "rejected_reason"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwStatusAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwStatusAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwStatusAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_id: Optional[_builtins.str] = None,
                 rejected_reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint_id: The endpoint id.
        :param _builtins.str rejected_reason: The reject reason.
        :param _builtins.str status: The attachment status.
        :param _builtins.str subnet_id: The subnet id.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if rejected_reason is not None:
            pulumi.set(__self__, "rejected_reason", rejected_reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        The endpoint id.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="rejectedReason")
    def rejected_reason(self) -> Optional[_builtins.str]:
        """
        The reject reason.
        """
        return pulumi.get(self, "rejected_reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The attachment status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NgfwSubnetMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "availabilityZoneId":
            suggest = "availability_zone_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwSubnetMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwSubnetMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwSubnetMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[_builtins.str] = None,
                 availability_zone_id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_zone: The availability zone, for when the endpoint mode is customer managed.
        :param _builtins.str availability_zone_id: The availability zone ID, for when the endpoint mode is customer managed.
        :param _builtins.str subnet_id: The subnet id, for when the endpoint mode is service managed.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The availability zone, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[_builtins.str]:
        """
        The availability zone ID, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet id, for when the endpoint mode is service managed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class RulestackProfileConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antiSpyware":
            suggest = "anti_spyware"
        elif key == "antiVirus":
            suggest = "anti_virus"
        elif key == "fileBlocking":
            suggest = "file_blocking"
        elif key == "outboundTrustCertificate":
            suggest = "outbound_trust_certificate"
        elif key == "outboundUntrustCertificate":
            suggest = "outbound_untrust_certificate"
        elif key == "urlFiltering":
            suggest = "url_filtering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulestackProfileConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulestackProfileConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulestackProfileConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anti_spyware: Optional[_builtins.str] = None,
                 anti_virus: Optional[_builtins.str] = None,
                 file_blocking: Optional[_builtins.str] = None,
                 outbound_trust_certificate: Optional[_builtins.str] = None,
                 outbound_untrust_certificate: Optional[_builtins.str] = None,
                 url_filtering: Optional[_builtins.str] = None,
                 vulnerability: Optional[_builtins.str] = None):
        """
        :param _builtins.str anti_spyware: Anti-spyware profile setting. Defaults to `BestPractice`.
        :param _builtins.str anti_virus: Anti-virus profile setting. Defaults to `BestPractice`.
        :param _builtins.str file_blocking: File blocking profile setting. Defaults to `BestPractice`.
        :param _builtins.str outbound_trust_certificate: Outbound trust certificate.
        :param _builtins.str outbound_untrust_certificate: Outbound untrust certificate.
        :param _builtins.str url_filtering: URL filtering profile setting. Defaults to `None`.
        :param _builtins.str vulnerability: Vulnerability profile setting. Defaults to `BestPractice`.
        """
        if anti_spyware is not None:
            pulumi.set(__self__, "anti_spyware", anti_spyware)
        if anti_virus is not None:
            pulumi.set(__self__, "anti_virus", anti_virus)
        if file_blocking is not None:
            pulumi.set(__self__, "file_blocking", file_blocking)
        if outbound_trust_certificate is not None:
            pulumi.set(__self__, "outbound_trust_certificate", outbound_trust_certificate)
        if outbound_untrust_certificate is not None:
            pulumi.set(__self__, "outbound_untrust_certificate", outbound_untrust_certificate)
        if url_filtering is not None:
            pulumi.set(__self__, "url_filtering", url_filtering)
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter(name="antiSpyware")
    def anti_spyware(self) -> Optional[_builtins.str]:
        """
        Anti-spyware profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "anti_spyware")

    @_builtins.property
    @pulumi.getter(name="antiVirus")
    def anti_virus(self) -> Optional[_builtins.str]:
        """
        Anti-virus profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "anti_virus")

    @_builtins.property
    @pulumi.getter(name="fileBlocking")
    def file_blocking(self) -> Optional[_builtins.str]:
        """
        File blocking profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "file_blocking")

    @_builtins.property
    @pulumi.getter(name="outboundTrustCertificate")
    def outbound_trust_certificate(self) -> Optional[_builtins.str]:
        """
        Outbound trust certificate.
        """
        return pulumi.get(self, "outbound_trust_certificate")

    @_builtins.property
    @pulumi.getter(name="outboundUntrustCertificate")
    def outbound_untrust_certificate(self) -> Optional[_builtins.str]:
        """
        Outbound untrust certificate.
        """
        return pulumi.get(self, "outbound_untrust_certificate")

    @_builtins.property
    @pulumi.getter(name="urlFiltering")
    def url_filtering(self) -> Optional[_builtins.str]:
        """
        URL filtering profile setting. Defaults to `None`.
        """
        return pulumi.get(self, "url_filtering")

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> Optional[_builtins.str]:
        """
        Vulnerability profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class SecurityRuleCategory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlCategoryNames":
            suggest = "url_category_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleCategory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleCategory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleCategory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 url_category_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] url_category_names: List of URL category names.
        """
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if url_category_names is not None:
            pulumi.set(__self__, "url_category_names", url_category_names)

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="urlCategoryNames")
    def url_category_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of URL category names.
        """
        return pulumi.get(self, "url_category_names")


@pulumi.output_type
class SecurityRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fqdnLists":
            suggest = "fqdn_lists"
        elif key == "prefixLists":
            suggest = "prefix_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidrs: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 fqdn_lists: Optional[Sequence[_builtins.str]] = None,
                 prefix_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] fqdn_lists: List of FQDN lists.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if fqdn_lists is not None:
            pulumi.set(__self__, "fqdn_lists", fqdn_lists)
        if prefix_lists is not None:
            pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="fqdnLists")
    def fqdn_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of FQDN lists.
        """
        return pulumi.get(self, "fqdn_lists")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class SecurityRuleSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixLists":
            suggest = "prefix_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidrs: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 prefix_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if prefix_lists is not None:
            pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class GetAccountsAccountDetailResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 external_id: _builtins.str,
                 onboarding_status: _builtins.str):
        """
        :param _builtins.str account_id: The account id.
        :param _builtins.str external_id: External Id of the onboarded account
        :param _builtins.str onboarding_status: Onboarding status of the account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "onboarding_status", onboarding_status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        External Id of the onboarded account
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="onboardingStatus")
    def onboarding_status(self) -> _builtins.str:
        """
        Onboarding status of the account.
        """
        return pulumi.get(self, "onboarding_status")


@pulumi.output_type
class GetNgfwLogProfileLogDestinationResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 destination_type: _builtins.str,
                 log_type: _builtins.str):
        """
        :param _builtins.str destination: The log destination details.
        :param _builtins.str destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param _builtins.str log_type: The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_type", log_type)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The log destination details.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> _builtins.str:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> _builtins.str:
        """
        The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetNgfwStatusResult(dict):
    def __init__(__self__, *,
                 attachments: Sequence['outputs.GetNgfwStatusAttachmentResult'],
                 failure_reason: _builtins.str,
                 firewall_status: _builtins.str,
                 rulestack_status: _builtins.str):
        """
        :param Sequence['GetNgfwStatusAttachmentArgs'] attachments: The firewall attachments.
        :param _builtins.str failure_reason: The firewall failure reason.
        :param _builtins.str firewall_status: The firewall status.
        :param _builtins.str rulestack_status: The rulestack status.
        """
        pulumi.set(__self__, "attachments", attachments)
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "firewall_status", firewall_status)
        pulumi.set(__self__, "rulestack_status", rulestack_status)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetNgfwStatusAttachmentResult']:
        """
        The firewall attachments.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> _builtins.str:
        """
        The firewall failure reason.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="firewallStatus")
    def firewall_status(self) -> _builtins.str:
        """
        The firewall status.
        """
        return pulumi.get(self, "firewall_status")

    @_builtins.property
    @pulumi.getter(name="rulestackStatus")
    def rulestack_status(self) -> _builtins.str:
        """
        The rulestack status.
        """
        return pulumi.get(self, "rulestack_status")


@pulumi.output_type
class GetNgfwStatusAttachmentResult(dict):
    def __init__(__self__, *,
                 endpoint_id: _builtins.str,
                 rejected_reason: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str endpoint_id: The endpoint id.
        :param _builtins.str rejected_reason: The reject reason.
        :param _builtins.str status: The attachment status.
        :param _builtins.str subnet_id: The subnet id.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "rejected_reason", rejected_reason)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The endpoint id.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="rejectedReason")
    def rejected_reason(self) -> _builtins.str:
        """
        The reject reason.
        """
        return pulumi.get(self, "rejected_reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The attachment status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNgfwSubnetMappingResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 availability_zone_id: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str availability_zone: The availability zone, for when the endpoint mode is customer managed.
        :param _builtins.str availability_zone_id: The availability zone ID, for when the endpoint mode is customer managed.
        :param _builtins.str subnet_id: The subnet id, for when the endpoint mode is service managed.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> _builtins.str:
        """
        The availability zone ID, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet id, for when the endpoint mode is service managed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNgfwsInstanceResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str account_id: The account id.
        :param _builtins.str name: The NGFW name.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The NGFW name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetRulestackProfileConfigResult(dict):
    def __init__(__self__, *,
                 anti_spyware: _builtins.str,
                 anti_virus: _builtins.str,
                 file_blocking: _builtins.str,
                 outbound_trust_certificate: _builtins.str,
                 outbound_untrust_certificate: _builtins.str,
                 url_filtering: _builtins.str,
                 vulnerability: _builtins.str):
        """
        :param _builtins.str anti_spyware: Anti-spyware profile setting.
        :param _builtins.str anti_virus: Anti-virus profile setting.
        :param _builtins.str file_blocking: File blocking profile setting.
        :param _builtins.str outbound_trust_certificate: Outbound trust certificate.
        :param _builtins.str outbound_untrust_certificate: Outbound untrust certificate.
        :param _builtins.str url_filtering: URL filtering profile setting.
        :param _builtins.str vulnerability: Vulnerability profile setting.
        """
        pulumi.set(__self__, "anti_spyware", anti_spyware)
        pulumi.set(__self__, "anti_virus", anti_virus)
        pulumi.set(__self__, "file_blocking", file_blocking)
        pulumi.set(__self__, "outbound_trust_certificate", outbound_trust_certificate)
        pulumi.set(__self__, "outbound_untrust_certificate", outbound_untrust_certificate)
        pulumi.set(__self__, "url_filtering", url_filtering)
        pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter(name="antiSpyware")
    def anti_spyware(self) -> _builtins.str:
        """
        Anti-spyware profile setting.
        """
        return pulumi.get(self, "anti_spyware")

    @_builtins.property
    @pulumi.getter(name="antiVirus")
    def anti_virus(self) -> _builtins.str:
        """
        Anti-virus profile setting.
        """
        return pulumi.get(self, "anti_virus")

    @_builtins.property
    @pulumi.getter(name="fileBlocking")
    def file_blocking(self) -> _builtins.str:
        """
        File blocking profile setting.
        """
        return pulumi.get(self, "file_blocking")

    @_builtins.property
    @pulumi.getter(name="outboundTrustCertificate")
    def outbound_trust_certificate(self) -> _builtins.str:
        """
        Outbound trust certificate.
        """
        return pulumi.get(self, "outbound_trust_certificate")

    @_builtins.property
    @pulumi.getter(name="outboundUntrustCertificate")
    def outbound_untrust_certificate(self) -> _builtins.str:
        """
        Outbound untrust certificate.
        """
        return pulumi.get(self, "outbound_untrust_certificate")

    @_builtins.property
    @pulumi.getter(name="urlFiltering")
    def url_filtering(self) -> _builtins.str:
        """
        URL filtering profile setting.
        """
        return pulumi.get(self, "url_filtering")

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> _builtins.str:
        """
        Vulnerability profile setting.
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetSecurityRuleCategoryResult(dict):
    def __init__(__self__, *,
                 feeds: Sequence[_builtins.str],
                 url_category_names: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] url_category_names: List of URL category names.
        """
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "url_category_names", url_category_names)

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="urlCategoryNames")
    def url_category_names(self) -> Sequence[_builtins.str]:
        """
        List of URL category names.
        """
        return pulumi.get(self, "url_category_names")


@pulumi.output_type
class GetSecurityRuleDestinationResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 feeds: Sequence[_builtins.str],
                 fqdn_lists: Sequence[_builtins.str],
                 prefix_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] fqdn_lists: List of FQDN lists.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "fqdn_lists", fqdn_lists)
        pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="fqdnLists")
    def fqdn_lists(self) -> Sequence[_builtins.str]:
        """
        List of FQDN lists.
        """
        return pulumi.get(self, "fqdn_lists")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Sequence[_builtins.str]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class GetSecurityRuleSourceResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 feeds: Sequence[_builtins.str],
                 prefix_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Sequence[_builtins.str]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


