# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PredefinedUrlCategoryOverrideArgs', 'PredefinedUrlCategoryOverride']

@pulumi.input_type
class PredefinedUrlCategoryOverrideArgs:
    def __init__(__self__, *,
                 rulestack: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PredefinedUrlCategoryOverride resource.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] name: The name.
        """
        pulumi.set(__self__, "rulestack", rulestack)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Input[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PredefinedUrlCategoryOverrideState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PredefinedUrlCategoryOverride resources.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] update_token: Update token.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rulestack is not None:
            pulumi.set(__self__, "rulestack", rulestack)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update token.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)


@pulumi.type_token("cloudngfwaws:index/predefinedUrlCategoryOverride:PredefinedUrlCategoryOverride")
class PredefinedUrlCategoryOverride(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for predefined URL category override management.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        example = cloudngfwaws.PredefinedUrlCategoryOverride("example",
            rulestack=r.name,
            name="foobar",
            action="block")
        ```

        ## Import

        import name is <rulestack>:<predefined_url_category_override_name>

        ```sh
        $ pulumi import cloudngfwaws:index/predefinedUrlCategoryOverride:PredefinedUrlCategoryOverride example terraform-rulestack:foobar
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PredefinedUrlCategoryOverrideArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for predefined URL category override management.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        example = cloudngfwaws.PredefinedUrlCategoryOverride("example",
            rulestack=r.name,
            name="foobar",
            action="block")
        ```

        ## Import

        import name is <rulestack>:<predefined_url_category_override_name>

        ```sh
        $ pulumi import cloudngfwaws:index/predefinedUrlCategoryOverride:PredefinedUrlCategoryOverride example terraform-rulestack:foobar
        ```

        :param str resource_name: The name of the resource.
        :param PredefinedUrlCategoryOverrideArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PredefinedUrlCategoryOverrideArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PredefinedUrlCategoryOverrideArgs.__new__(PredefinedUrlCategoryOverrideArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["audit_comment"] = audit_comment
            __props__.__dict__["name"] = name
            if rulestack is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack'")
            __props__.__dict__["rulestack"] = rulestack
            __props__.__dict__["update_token"] = None
        super(PredefinedUrlCategoryOverride, __self__).__init__(
            'cloudngfwaws:index/predefinedUrlCategoryOverride:PredefinedUrlCategoryOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack: Optional[pulumi.Input[_builtins.str]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'PredefinedUrlCategoryOverride':
        """
        Get an existing PredefinedUrlCategoryOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] update_token: Update token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PredefinedUrlCategoryOverrideState.__new__(_PredefinedUrlCategoryOverrideState)

        __props__.__dict__["action"] = action
        __props__.__dict__["audit_comment"] = audit_comment
        __props__.__dict__["name"] = name
        __props__.__dict__["rulestack"] = rulestack
        __props__.__dict__["update_token"] = update_token
        return PredefinedUrlCategoryOverride(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The action to take. Valid values are `none`, `allow`, `alert`, or `block`. Defaults to `none`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Output[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        Update token.
        """
        return pulumi.get(self, "update_token")

