# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_admin_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 gra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 lfa_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region_host: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_key: (Used for the initial `sts assume role`) AWS access key. Environment variable: `CLOUDNGFWAWS_ACCESS_KEY`. JSON conf file
               variable: `access-key`.
        :param pulumi.Input[_builtins.str] account_admin_arn: The ARN allowing account admin permissions. Environment variable: `CLOUDNGFWAWS_ACCT_ADMIN_ARN`. JSON conf file
               variable: `account-admin-arn`.
        :param pulumi.Input[_builtins.str] arn: The ARN allowing firewall, rulestack, and global rulestack admin permissions. Global rulestack admin permissions can be
               enabled only if the AWS account is onboarded by AWS Firewall Manager. Use 'lfa_arn' and 'lra_arn' if you want to enable
               only firewall and rulestack admin permissions. Environment variable: `CLOUDNGFWAWS_ARN`. JSON conf file variable: `arn`.
        :param pulumi.Input[_builtins.str] gra_arn: The ARN allowing global rulestack admin permissions. Global rulestack admin permissions can be enabled only if the AWS
               account is onboarded by AWS Firewall Manager. 'gra_arn' is preferentially used over the `arn` param if both are
               specified. Environment variable: `CLOUDNGFWAWS_GRA_ARN`. JSON conf file variable: `gra-arn`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] headers: Additional HTTP headers to send with API calls. Environment variable: `CLOUDNGFWAWS_HEADERS`. JSON conf file variable:
               `headers`.
        :param pulumi.Input[_builtins.str] host: The hostname of the API (default: `api.us-east-1.aws.cloudngfw.paloaltonetworks.com`). Environment variable:
               `CLOUDNGFWAWS_HOST`. JSON conf file variable: `host`.
        :param pulumi.Input[_builtins.str] json_config_file: Retrieve provider configuration from this JSON file.
        :param pulumi.Input[_builtins.str] lfa_arn: The ARN allowing firewall admin permissions. This is preferentially used over the `arn` param if both are specified.
               Environment variable: `CLOUDNGFWAWS_LFA_ARN`. JSON conf file variable: `lfa-arn`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loggings: The logging options for the provider. Environment variable: `CLOUDNGFWAWS_LOGGING`. JSON conf file variable: `logging`.
        :param pulumi.Input[_builtins.str] lra_arn: The ARN allowing rulestack admin permissions. This is preferentially used over the `arn` param if both are specified.
               Environment variable: `CLOUDNGFWAWS_LRA_ARN`. JSON conf file variable: `lra-arn`.
        :param pulumi.Input[_builtins.str] mp_region: AWS management plane region. Environment variable: `CLOUDNGFWAWS_MP_REGION`. JSON conf file variable: `mp_region`.
        :param pulumi.Input[_builtins.str] mp_region_host: AWS management plane MP region host Environment variable: `CLOUDNGFWAWS_MP_REGION_HOST`. JSON conf file variable:
               `mp_region_host`.
        :param pulumi.Input[_builtins.str] profile: (Used for the initial `sts assume role`) AWS PROFILE. Environment variable: `CLOUDNGFWAWS_PROFILE`. JSON conf file
               variable: `profile`.
        :param pulumi.Input[_builtins.str] protocol: The protocol (defaults to `https`). Environment variable: `CLOUDNGFWAWS_PROTOCOL`. JSON conf file variable: `protocol`.
               Valid values are `https` or `http`.
        :param pulumi.Input[_builtins.str] region: AWS region. Environment variable: `CLOUDNGFWAWS_REGION`. JSON conf file variable: `region`.
        :param pulumi.Input[_builtins.str] secret_key: (Used for the initial `sts assume role`) AWS secret key. Environment variable: `CLOUDNGFWAWS_SECRET_KEY`. JSON conf file
               variable: `secret-key`.
        :param pulumi.Input[_builtins.bool] skip_verify_certificate: Skip verifying the SSL certificate. Environment variable: `CLOUDNGFWAWS_SKIP_VERIFY_CERTIFICATE`. JSON conf file
               variable: `skip-verify-certificate`.
        :param pulumi.Input[_builtins.bool] sync_mode: Enable synchronous mode while creating resources Environment variable: `CLOUDNGFWAWS_SYNC_MODE`. JSON conf file
               variable: `sync_mode`.
        :param pulumi.Input[_builtins.int] timeout: The timeout for any single API call (default: `30`). Environment variable: `CLOUDNGFWAWS_TIMEOUT`. JSON conf file
               variable: `timeout`.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if account_admin_arn is not None:
            pulumi.set(__self__, "account_admin_arn", account_admin_arn)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if gra_arn is not None:
            pulumi.set(__self__, "gra_arn", gra_arn)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if json_config_file is not None:
            pulumi.set(__self__, "json_config_file", json_config_file)
        if lfa_arn is not None:
            pulumi.set(__self__, "lfa_arn", lfa_arn)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if lra_arn is not None:
            pulumi.set(__self__, "lra_arn", lra_arn)
        if mp_region is not None:
            pulumi.set(__self__, "mp_region", mp_region)
        if mp_region_host is not None:
            pulumi.set(__self__, "mp_region_host", mp_region_host)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_timeout is not None:
            pulumi.set(__self__, "resource_timeout", resource_timeout)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if skip_verify_certificate is not None:
            pulumi.set(__self__, "skip_verify_certificate", skip_verify_certificate)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS access key. Environment variable: `CLOUDNGFWAWS_ACCESS_KEY`. JSON conf file
        variable: `access-key`.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="accountAdminArn")
    def account_admin_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN allowing account admin permissions. Environment variable: `CLOUDNGFWAWS_ACCT_ADMIN_ARN`. JSON conf file
        variable: `account-admin-arn`.
        """
        return pulumi.get(self, "account_admin_arn")

    @account_admin_arn.setter
    def account_admin_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_admin_arn", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN allowing firewall, rulestack, and global rulestack admin permissions. Global rulestack admin permissions can be
        enabled only if the AWS account is onboarded by AWS Firewall Manager. Use 'lfa_arn' and 'lra_arn' if you want to enable
        only firewall and rulestack admin permissions. Environment variable: `CLOUDNGFWAWS_ARN`. JSON conf file variable: `arn`.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="graArn")
    def gra_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN allowing global rulestack admin permissions. Global rulestack admin permissions can be enabled only if the AWS
        account is onboarded by AWS Firewall Manager. 'gra_arn' is preferentially used over the `arn` param if both are
        specified. Environment variable: `CLOUDNGFWAWS_GRA_ARN`. JSON conf file variable: `gra-arn`.
        """
        return pulumi.get(self, "gra_arn")

    @gra_arn.setter
    def gra_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gra_arn", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional HTTP headers to send with API calls. Environment variable: `CLOUDNGFWAWS_HEADERS`. JSON conf file variable:
        `headers`.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the API (default: `api.us-east-1.aws.cloudngfw.paloaltonetworks.com`). Environment variable:
        `CLOUDNGFWAWS_HOST`. JSON conf file variable: `host`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="jsonConfigFile")
    def json_config_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Retrieve provider configuration from this JSON file.
        """
        return pulumi.get(self, "json_config_file")

    @json_config_file.setter
    def json_config_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json_config_file", value)

    @_builtins.property
    @pulumi.getter(name="lfaArn")
    def lfa_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN allowing firewall admin permissions. This is preferentially used over the `arn` param if both are specified.
        Environment variable: `CLOUDNGFWAWS_LFA_ARN`. JSON conf file variable: `lfa-arn`.
        """
        return pulumi.get(self, "lfa_arn")

    @lfa_arn.setter
    def lfa_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lfa_arn", value)

    @_builtins.property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The logging options for the provider. Environment variable: `CLOUDNGFWAWS_LOGGING`. JSON conf file variable: `logging`.
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "loggings", value)

    @_builtins.property
    @pulumi.getter(name="lraArn")
    def lra_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN allowing rulestack admin permissions. This is preferentially used over the `arn` param if both are specified.
        Environment variable: `CLOUDNGFWAWS_LRA_ARN`. JSON conf file variable: `lra-arn`.
        """
        return pulumi.get(self, "lra_arn")

    @lra_arn.setter
    def lra_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lra_arn", value)

    @_builtins.property
    @pulumi.getter(name="mpRegion")
    def mp_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS management plane region. Environment variable: `CLOUDNGFWAWS_MP_REGION`. JSON conf file variable: `mp_region`.
        """
        return pulumi.get(self, "mp_region")

    @mp_region.setter
    def mp_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mp_region", value)

    @_builtins.property
    @pulumi.getter(name="mpRegionHost")
    def mp_region_host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS management plane MP region host Environment variable: `CLOUDNGFWAWS_MP_REGION_HOST`. JSON conf file variable:
        `mp_region_host`.
        """
        return pulumi.get(self, "mp_region_host")

    @mp_region_host.setter
    def mp_region_host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mp_region_host", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS PROFILE. Environment variable: `CLOUDNGFWAWS_PROFILE`. JSON conf file
        variable: `profile`.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol (defaults to `https`). Environment variable: `CLOUDNGFWAWS_PROTOCOL`. JSON conf file variable: `protocol`.
        Valid values are `https` or `http`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region. Environment variable: `CLOUDNGFWAWS_REGION`. JSON conf file variable: `region`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTimeout")
    def resource_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "resource_timeout")

    @resource_timeout.setter
    def resource_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_timeout", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS secret key. Environment variable: `CLOUDNGFWAWS_SECRET_KEY`. JSON conf file
        variable: `secret-key`.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="skipVerifyCertificate")
    def skip_verify_certificate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip verifying the SSL certificate. Environment variable: `CLOUDNGFWAWS_SKIP_VERIFY_CERTIFICATE`. JSON conf file
        variable: `skip-verify-certificate`.
        """
        return pulumi.get(self, "skip_verify_certificate")

    @skip_verify_certificate.setter
    def skip_verify_certificate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_verify_certificate", value)

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable synchronous mode while creating resources Environment variable: `CLOUDNGFWAWS_SYNC_MODE`. JSON conf file
        variable: `sync_mode`.
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_mode", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout for any single API call (default: `30`). Environment variable: `CLOUDNGFWAWS_TIMEOUT`. JSON conf file
        variable: `timeout`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("pulumi:providers:cloudngfwaws")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_admin_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 gra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 lfa_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region_host: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The provider type for the cloudngfwaws package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: (Used for the initial `sts assume role`) AWS access key. Environment variable: `CLOUDNGFWAWS_ACCESS_KEY`. JSON conf file
               variable: `access-key`.
        :param pulumi.Input[_builtins.str] account_admin_arn: The ARN allowing account admin permissions. Environment variable: `CLOUDNGFWAWS_ACCT_ADMIN_ARN`. JSON conf file
               variable: `account-admin-arn`.
        :param pulumi.Input[_builtins.str] arn: The ARN allowing firewall, rulestack, and global rulestack admin permissions. Global rulestack admin permissions can be
               enabled only if the AWS account is onboarded by AWS Firewall Manager. Use 'lfa_arn' and 'lra_arn' if you want to enable
               only firewall and rulestack admin permissions. Environment variable: `CLOUDNGFWAWS_ARN`. JSON conf file variable: `arn`.
        :param pulumi.Input[_builtins.str] gra_arn: The ARN allowing global rulestack admin permissions. Global rulestack admin permissions can be enabled only if the AWS
               account is onboarded by AWS Firewall Manager. 'gra_arn' is preferentially used over the `arn` param if both are
               specified. Environment variable: `CLOUDNGFWAWS_GRA_ARN`. JSON conf file variable: `gra-arn`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] headers: Additional HTTP headers to send with API calls. Environment variable: `CLOUDNGFWAWS_HEADERS`. JSON conf file variable:
               `headers`.
        :param pulumi.Input[_builtins.str] host: The hostname of the API (default: `api.us-east-1.aws.cloudngfw.paloaltonetworks.com`). Environment variable:
               `CLOUDNGFWAWS_HOST`. JSON conf file variable: `host`.
        :param pulumi.Input[_builtins.str] json_config_file: Retrieve provider configuration from this JSON file.
        :param pulumi.Input[_builtins.str] lfa_arn: The ARN allowing firewall admin permissions. This is preferentially used over the `arn` param if both are specified.
               Environment variable: `CLOUDNGFWAWS_LFA_ARN`. JSON conf file variable: `lfa-arn`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] loggings: The logging options for the provider. Environment variable: `CLOUDNGFWAWS_LOGGING`. JSON conf file variable: `logging`.
        :param pulumi.Input[_builtins.str] lra_arn: The ARN allowing rulestack admin permissions. This is preferentially used over the `arn` param if both are specified.
               Environment variable: `CLOUDNGFWAWS_LRA_ARN`. JSON conf file variable: `lra-arn`.
        :param pulumi.Input[_builtins.str] mp_region: AWS management plane region. Environment variable: `CLOUDNGFWAWS_MP_REGION`. JSON conf file variable: `mp_region`.
        :param pulumi.Input[_builtins.str] mp_region_host: AWS management plane MP region host Environment variable: `CLOUDNGFWAWS_MP_REGION_HOST`. JSON conf file variable:
               `mp_region_host`.
        :param pulumi.Input[_builtins.str] profile: (Used for the initial `sts assume role`) AWS PROFILE. Environment variable: `CLOUDNGFWAWS_PROFILE`. JSON conf file
               variable: `profile`.
        :param pulumi.Input[_builtins.str] protocol: The protocol (defaults to `https`). Environment variable: `CLOUDNGFWAWS_PROTOCOL`. JSON conf file variable: `protocol`.
               Valid values are `https` or `http`.
        :param pulumi.Input[_builtins.str] region: AWS region. Environment variable: `CLOUDNGFWAWS_REGION`. JSON conf file variable: `region`.
        :param pulumi.Input[_builtins.str] secret_key: (Used for the initial `sts assume role`) AWS secret key. Environment variable: `CLOUDNGFWAWS_SECRET_KEY`. JSON conf file
               variable: `secret-key`.
        :param pulumi.Input[_builtins.bool] skip_verify_certificate: Skip verifying the SSL certificate. Environment variable: `CLOUDNGFWAWS_SKIP_VERIFY_CERTIFICATE`. JSON conf file
               variable: `skip-verify-certificate`.
        :param pulumi.Input[_builtins.bool] sync_mode: Enable synchronous mode while creating resources Environment variable: `CLOUDNGFWAWS_SYNC_MODE`. JSON conf file
               variable: `sync_mode`.
        :param pulumi.Input[_builtins.int] timeout: The timeout for any single API call (default: `30`). Environment variable: `CLOUDNGFWAWS_TIMEOUT`. JSON conf file
               variable: `timeout`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the cloudngfwaws package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 account_admin_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 gra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_config_file: Optional[pulumi.Input[_builtins.str]] = None,
                 lfa_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 lra_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region: Optional[pulumi.Input[_builtins.str]] = None,
                 mp_region_host: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_verify_certificate: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["account_admin_arn"] = account_admin_arn
            __props__.__dict__["arn"] = arn
            __props__.__dict__["gra_arn"] = gra_arn
            __props__.__dict__["headers"] = pulumi.Output.from_input(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            __props__.__dict__["host"] = host
            __props__.__dict__["json_config_file"] = json_config_file
            __props__.__dict__["lfa_arn"] = lfa_arn
            __props__.__dict__["loggings"] = pulumi.Output.from_input(loggings).apply(pulumi.runtime.to_json) if loggings is not None else None
            __props__.__dict__["lra_arn"] = lra_arn
            __props__.__dict__["mp_region"] = mp_region
            __props__.__dict__["mp_region_host"] = mp_region_host
            __props__.__dict__["profile"] = profile
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_timeout"] = pulumi.Output.from_input(resource_timeout).apply(pulumi.runtime.to_json) if resource_timeout is not None else None
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["skip_verify_certificate"] = pulumi.Output.from_input(skip_verify_certificate).apply(pulumi.runtime.to_json) if skip_verify_certificate is not None else None
            __props__.__dict__["sync_mode"] = pulumi.Output.from_input(sync_mode).apply(pulumi.runtime.to_json) if sync_mode is not None else None
            __props__.__dict__["timeout"] = pulumi.Output.from_input(timeout).apply(pulumi.runtime.to_json) if timeout is not None else None
        super(Provider, __self__).__init__(
            'cloudngfwaws',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS access key. Environment variable: `CLOUDNGFWAWS_ACCESS_KEY`. JSON conf file
        variable: `access-key`.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="accountAdminArn")
    def account_admin_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN allowing account admin permissions. Environment variable: `CLOUDNGFWAWS_ACCT_ADMIN_ARN`. JSON conf file
        variable: `account-admin-arn`.
        """
        return pulumi.get(self, "account_admin_arn")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN allowing firewall, rulestack, and global rulestack admin permissions. Global rulestack admin permissions can be
        enabled only if the AWS account is onboarded by AWS Firewall Manager. Use 'lfa_arn' and 'lra_arn' if you want to enable
        only firewall and rulestack admin permissions. Environment variable: `CLOUDNGFWAWS_ARN`. JSON conf file variable: `arn`.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="graArn")
    def gra_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN allowing global rulestack admin permissions. Global rulestack admin permissions can be enabled only if the AWS
        account is onboarded by AWS Firewall Manager. 'gra_arn' is preferentially used over the `arn` param if both are
        specified. Environment variable: `CLOUDNGFWAWS_GRA_ARN`. JSON conf file variable: `gra-arn`.
        """
        return pulumi.get(self, "gra_arn")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The hostname of the API (default: `api.us-east-1.aws.cloudngfw.paloaltonetworks.com`). Environment variable:
        `CLOUDNGFWAWS_HOST`. JSON conf file variable: `host`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="jsonConfigFile")
    def json_config_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Retrieve provider configuration from this JSON file.
        """
        return pulumi.get(self, "json_config_file")

    @_builtins.property
    @pulumi.getter(name="lfaArn")
    def lfa_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN allowing firewall admin permissions. This is preferentially used over the `arn` param if both are specified.
        Environment variable: `CLOUDNGFWAWS_LFA_ARN`. JSON conf file variable: `lfa-arn`.
        """
        return pulumi.get(self, "lfa_arn")

    @_builtins.property
    @pulumi.getter(name="lraArn")
    def lra_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN allowing rulestack admin permissions. This is preferentially used over the `arn` param if both are specified.
        Environment variable: `CLOUDNGFWAWS_LRA_ARN`. JSON conf file variable: `lra-arn`.
        """
        return pulumi.get(self, "lra_arn")

    @_builtins.property
    @pulumi.getter(name="mpRegion")
    def mp_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS management plane region. Environment variable: `CLOUDNGFWAWS_MP_REGION`. JSON conf file variable: `mp_region`.
        """
        return pulumi.get(self, "mp_region")

    @_builtins.property
    @pulumi.getter(name="mpRegionHost")
    def mp_region_host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS management plane MP region host Environment variable: `CLOUDNGFWAWS_MP_REGION_HOST`. JSON conf file variable:
        `mp_region_host`.
        """
        return pulumi.get(self, "mp_region_host")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS PROFILE. Environment variable: `CLOUDNGFWAWS_PROFILE`. JSON conf file
        variable: `profile`.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol (defaults to `https`). Environment variable: `CLOUDNGFWAWS_PROTOCOL`. JSON conf file variable: `protocol`.
        Valid values are `https` or `http`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS region. Environment variable: `CLOUDNGFWAWS_REGION`. JSON conf file variable: `region`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Used for the initial `sts assume role`) AWS secret key. Environment variable: `CLOUDNGFWAWS_SECRET_KEY`. JSON conf file
        variable: `secret-key`.
        """
        return pulumi.get(self, "secret_key")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:cloudngfwaws/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

