# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityRuleArgs', 'SecurityRule']

@pulumi.input_type
class SecurityRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 applications: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 category: pulumi.Input['SecurityRuleCategoryArgs'],
                 destination: pulumi.Input['SecurityRuleDestinationArgs'],
                 priority: pulumi.Input[_builtins.int],
                 rulestack: pulumi.Input[_builtins.str],
                 source: pulumi.Input['SecurityRuleSourceArgs'],
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 prot_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_list: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecurityRule resource.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The list of applications.
        :param pulumi.Input['SecurityRuleCategoryArgs'] category: The category spec.
        :param pulumi.Input['SecurityRuleDestinationArgs'] destination: The destination spec.
        :param pulumi.Input[_builtins.int] priority: The rule priority.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input['SecurityRuleSourceArgs'] source: The source spec.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] decryption_rule_type: Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.bool] enabled: Set to false to disable this rule. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] logging: Enable logging at end. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination definition.
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source definition.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prot_port_lists: Protocol port list.
        :param pulumi.Input[_builtins.str] protocol: The protocol.
        :param pulumi.Input[_builtins.str] rule_list: The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rulestack", rulestack)
        pulumi.set(__self__, "source", source)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if decryption_rule_type is not None:
            pulumi.set(__self__, "decryption_rule_type", decryption_rule_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if prot_port_lists is not None:
            pulumi.set(__self__, "prot_port_lists", prot_port_lists)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if rule_list is not None:
            pulumi.set(__self__, "rule_list", rule_list)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of applications.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input['SecurityRuleCategoryArgs']:
        """
        The category spec.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input['SecurityRuleCategoryArgs']):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['SecurityRuleDestinationArgs']:
        """
        The destination spec.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['SecurityRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The rule priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Input[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['SecurityRuleSourceArgs']:
        """
        The source spec.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['SecurityRuleSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @decryption_rule_type.setter
    def decryption_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to false to disable this rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable logging at end. Defaults to `true`.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the destination definition.
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the source definition.
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter(name="protPortLists")
    def prot_port_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Protocol port list.
        """
        return pulumi.get(self, "prot_port_lists")

    @prot_port_lists.setter
    def prot_port_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prot_port_lists", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="ruleList")
    def rule_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        """
        return pulumi.get(self, "rule_list")

    @rule_list.setter
    def rule_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_list", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SecurityRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input['SecurityRuleCategoryArgs']] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['SecurityRuleDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 prot_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_list: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['SecurityRuleSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityRule resources.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The list of applications.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input['SecurityRuleCategoryArgs'] category: The category spec.
        :param pulumi.Input[_builtins.str] decryption_rule_type: Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input['SecurityRuleDestinationArgs'] destination: The destination spec.
        :param pulumi.Input[_builtins.bool] enabled: Set to false to disable this rule. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] logging: Enable logging at end. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination definition.
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source definition.
        :param pulumi.Input[_builtins.int] priority: The rule priority.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prot_port_lists: Protocol port list.
        :param pulumi.Input[_builtins.str] protocol: The protocol.
        :param pulumi.Input[_builtins.str] rule_list: The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input['SecurityRuleSourceArgs'] source: The source spec.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if decryption_rule_type is not None:
            pulumi.set(__self__, "decryption_rule_type", decryption_rule_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if prot_port_lists is not None:
            pulumi.set(__self__, "prot_port_lists", prot_port_lists)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if rule_list is not None:
            pulumi.set(__self__, "rule_list", rule_list)
        if rulestack is not None:
            pulumi.set(__self__, "rulestack", rulestack)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of applications.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['SecurityRuleCategoryArgs']]:
        """
        The category spec.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['SecurityRuleCategoryArgs']]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @decryption_rule_type.setter
    def decryption_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['SecurityRuleDestinationArgs']]:
        """
        The destination spec.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['SecurityRuleDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to false to disable this rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable logging at end. Defaults to `true`.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the destination definition.
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Negate the source definition.
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="protPortLists")
    def prot_port_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Protocol port list.
        """
        return pulumi.get(self, "prot_port_lists")

    @prot_port_lists.setter
    def prot_port_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "prot_port_lists", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="ruleList")
    def rule_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        """
        return pulumi.get(self, "rule_list")

    @rule_list.setter
    def rule_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_list", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['SecurityRuleSourceArgs']]:
        """
        The source spec.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['SecurityRuleSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)


@pulumi.type_token("cloudngfwaws:index/securityRule:SecurityRule")
class SecurityRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[Union['SecurityRuleCategoryArgs', 'SecurityRuleCategoryArgsDict']]] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['SecurityRuleDestinationArgs', 'SecurityRuleDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 prot_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_list: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['SecurityRuleSourceArgs', 'SecurityRuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for security rule manipulation.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        example = cloudngfwaws.SecurityRule("example",
            rulestack=r.name,
            rule_list="LocalRule",
            priority=3,
            name="tf-security-rule",
            description="Also configured by Terraform",
            source={
                "cidrs": ["any"],
            },
            destination={
                "cidrs": ["192.168.0.0/16"],
            },
            negate_destination=True,
            applications=["any"],
            category={},
            action="Allow",
            logging=True,
            audit_comment="initial config")
        ```

        ## Import

        import name is <scope>:<rulestack>:<rule_list>:<priority>

        ```sh
        $ pulumi import cloudngfwaws:index/securityRule:SecurityRule example Local:terraform-rulestack:LocalRule:3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The list of applications.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[Union['SecurityRuleCategoryArgs', 'SecurityRuleCategoryArgsDict']] category: The category spec.
        :param pulumi.Input[_builtins.str] decryption_rule_type: Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[Union['SecurityRuleDestinationArgs', 'SecurityRuleDestinationArgsDict']] destination: The destination spec.
        :param pulumi.Input[_builtins.bool] enabled: Set to false to disable this rule. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] logging: Enable logging at end. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination definition.
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source definition.
        :param pulumi.Input[_builtins.int] priority: The rule priority.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prot_port_lists: Protocol port list.
        :param pulumi.Input[_builtins.str] protocol: The protocol.
        :param pulumi.Input[_builtins.str] rule_list: The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[Union['SecurityRuleSourceArgs', 'SecurityRuleSourceArgsDict']] source: The source spec.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for security rule manipulation.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        example = cloudngfwaws.SecurityRule("example",
            rulestack=r.name,
            rule_list="LocalRule",
            priority=3,
            name="tf-security-rule",
            description="Also configured by Terraform",
            source={
                "cidrs": ["any"],
            },
            destination={
                "cidrs": ["192.168.0.0/16"],
            },
            negate_destination=True,
            applications=["any"],
            category={},
            action="Allow",
            logging=True,
            audit_comment="initial config")
        ```

        ## Import

        import name is <scope>:<rulestack>:<rule_list>:<priority>

        ```sh
        $ pulumi import cloudngfwaws:index/securityRule:SecurityRule example Local:terraform-rulestack:LocalRule:3
        ```

        :param str resource_name: The name of the resource.
        :param SecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[Union['SecurityRuleCategoryArgs', 'SecurityRuleCategoryArgsDict']]] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['SecurityRuleDestinationArgs', 'SecurityRuleDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 prot_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_list: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['SecurityRuleSourceArgs', 'SecurityRuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityRuleArgs.__new__(SecurityRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            __props__.__dict__["audit_comment"] = audit_comment
            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["decryption_rule_type"] = decryption_rule_type
            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["logging"] = logging
            __props__.__dict__["name"] = name
            __props__.__dict__["negate_destination"] = negate_destination
            __props__.__dict__["negate_source"] = negate_source
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["prot_port_lists"] = prot_port_lists
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["rule_list"] = rule_list
            if rulestack is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack'")
            __props__.__dict__["rulestack"] = rulestack
            __props__.__dict__["scope"] = scope
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_token"] = None
        super(SecurityRule, __self__).__init__(
            'cloudngfwaws:index/securityRule:SecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[Union['SecurityRuleCategoryArgs', 'SecurityRuleCategoryArgsDict']]] = None,
            decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['SecurityRuleDestinationArgs', 'SecurityRuleDestinationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            logging: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            prot_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            rule_list: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['SecurityRuleSourceArgs', 'SecurityRuleSourceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityRule':
        """
        Get an existing SecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The list of applications.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[Union['SecurityRuleCategoryArgs', 'SecurityRuleCategoryArgsDict']] category: The category spec.
        :param pulumi.Input[_builtins.str] decryption_rule_type: Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[Union['SecurityRuleDestinationArgs', 'SecurityRuleDestinationArgsDict']] destination: The destination spec.
        :param pulumi.Input[_builtins.bool] enabled: Set to false to disable this rule. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] logging: Enable logging at end. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.bool] negate_destination: Negate the destination definition.
        :param pulumi.Input[_builtins.bool] negate_source: Negate the source definition.
        :param pulumi.Input[_builtins.int] priority: The rule priority.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] prot_port_lists: Protocol port list.
        :param pulumi.Input[_builtins.str] protocol: The protocol.
        :param pulumi.Input[_builtins.str] rule_list: The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[Union['SecurityRuleSourceArgs', 'SecurityRuleSourceArgsDict']] source: The source spec.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityRuleState.__new__(_SecurityRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["applications"] = applications
        __props__.__dict__["audit_comment"] = audit_comment
        __props__.__dict__["category"] = category
        __props__.__dict__["decryption_rule_type"] = decryption_rule_type
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["logging"] = logging
        __props__.__dict__["name"] = name
        __props__.__dict__["negate_destination"] = negate_destination
        __props__.__dict__["negate_source"] = negate_source
        __props__.__dict__["priority"] = priority
        __props__.__dict__["prot_port_lists"] = prot_port_lists
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["rule_list"] = rule_list
        __props__.__dict__["rulestack"] = rulestack
        __props__.__dict__["scope"] = scope
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_token"] = update_token
        return SecurityRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        The action to take. Valid values are `Allow`, `DenySilent`, `DenyResetServer`, or `DenyResetBoth`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of applications.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output['outputs.SecurityRuleCategory']:
        """
        The category spec.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Decryption rule type. Valid values are ``or`SSLOutboundInspection`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.SecurityRuleDestination']:
        """
        The destination spec.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to false to disable this rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable logging at end. Defaults to `true`.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Negate the destination definition.
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Negate the source definition.
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The rule priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="protPortLists")
    def prot_port_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Protocol port list.
        """
        return pulumi.get(self, "prot_port_lists")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ruleList")
    def rule_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rulebase. Valid values are `PreRule`, `PostRule`, or `LocalRule`. Defaults to `PreRule`.
        """
        return pulumi.get(self, "rule_list")

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Output[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.SecurityRuleSource']:
        """
        The source spec.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

