import io
from datetime import date
from django.conf import settings

def generate_policy_pdf(customer_policy):
   
    policy_name = customer_policy.policy.name
    user_name = customer_policy.user.get_full_name() or customer_policy.user.username
    start_date = customer_policy.start_date.strftime("%Y-%m-%d")
    end_date = customer_policy.end_date.strftime("%Y-%m-%d")

    pdf_content = (
        f"*** Official Insurance Policy Document ***\n\n"
        f"Policy Name: {policy_name}\n"
        f"Holder: {user_name}\n"
        f"Policy ID: {customer_policy.pk}\n"
        f"Coverage Period: {start_date} to {end_date}\n\n"
        f"This document confirms policy purchase."
    ).encode('utf-8') 

    policy_doc = io.BytesIO(pdf_content)
    
    return policy_doc