# Dynamanager

<div align="center">

<!-- Project details -->
[![Python support][bp1]][bp2]
[![PyPI Release][bp3]][bp2]
[![Repository][bscm1]][bp4]
[![Releases][bscm2]][bp5]
[![Licence][blic1]][blic2]
[![Expand your project structure from atoms of code to galactic dimensions.][bp6]][bp7]

<!-- Information on development -->
[![Contributions Welcome][bp8]][bp9]
[![Open issues][bscm3]][bp10]
[![Merge Requests][bscm4]][bscm5]

<!-- Styling policies -->
[![BDD][bbbd1]][bbbd2]
[![Code style: Ruff][bfo1]][bfo2]
[![Docstrings][bli1]][bli2]
[![Gitmoji][bcv1]][bcv2]
[![Semantic Line Breaks][bp11]][bp12]

<!-- Development utilities -->
[![Poetry][bp13]][bp14]
[![Pre-commit][bp15]][bp16]
[![Bandit][bp17]][bp18]
[![isort][bfo3]][bfo4]
[![Editorconfig][bp19]][bp20]

<!-- Open Source benchmarks -->
<!-- UPDATEME by toggling this comment off after replacing your project's index in both anchors below
[![OpenSSF Best Practices][boss1]][boss2] -->
<!-- UPDATEME by toggling this comment off after replacing your project's index in both anchors below
[![OSSRank][boss3]][boss4] -->

<!-- Quality assurance -->
[![Semantic versions][bp21]][bp5]
[![Code Quality][bcov1]][bcov2]
[![Coverage][bcov3]][bcov4]
[![Pipelines][bscm6]][bscm7]

_Straightforward application config management powered by Dynaconf_ :gear:

</div>

## Installation

```bash
pip install -U dynamanager
```

or install with `Poetry`:

```bash
poetry add dynamanager
```

## :chart_with_upwards_trend: Releases

You can see the list of available releases on the [GitLab Releases][r1] page.

We follow [EffVer][fs4] specification for versioning.

We use [`GitLab Changelog`][lab5] entries to track changes. You can categorise commits and Merge Requests made to this project using [git trailers][lab10] in your commit messages.

### List of trailers and corresponding categories

|            **Git trailer**            |    **Category in CHANGELOG**    |
| :-----------------------------------: | :-----------------------------: |
| `enhancement`, `feature`              | :rocket: Features               |
| `bug`, `refactoring`, `bugfix`, `fix` | :wrench: Fixes & Refactoring    |
| `build`, `ci`, `testing`              | :package: Build System & CI/CD  |
| `breaking`                            | :boom: Breaking Changes         |
| `documentation`                       | :memo: Documentation            |
| `dependencies`                        | :arrow_up: Dependencies updates |

## :shield: Licence

[![Licence][blic1]][blic2]

This project is licenced under the terms of the `MIT` licence. See [LICENCE][blic2] for more details.

## :page_with_curl: Citation

```bibtex
@misc{Dynamanager,
  author = {The Galactipy Contributors},
  title = {Straightforward application config management powered by Dynaconf},
  year = {2025},
  publisher = {GitLab},
  journal = {GitLab repository},
  howpublished = {\url{https://gitlab.com/galactipy/dynamanager}}
}
```

## Credits [![Expand your project structure from atoms of code to galactic dimensions.][bp6]][bp7]

This project was generated with [`galactipy`][bp7].

<!-- Anchors -->

[bp1]: https://img.shields.io/pypi/pyversions/dynamanager?style=for-the-badge
[bp2]: https://pypi.org/project/dynamanager/
[bp3]: https://img.shields.io/pypi/v/dynamanager?style=for-the-badge&logo=pypi&color=3775a9
[bp4]: https://gitlab.com/galactipy/dynamanager
[bp5]: https://gitlab.com/galactipy/dynamanager/-/releases
[bp6]: https://img.shields.io/badge/made%20with-galactipy%20%F0%9F%8C%8C-179287?style=for-the-badge&labelColor=193A3E
[bp7]: https://kutt.it/7fYqQl
[bp8]: https://img.shields.io/static/v1.svg?label=Contributions&message=Welcome&color=0059b3&style=for-the-badge
[bp9]: https://gitlab.com/galactipy/dynamanager/-/blob/master/CONTRIBUTING.md
[bp10]: https://gitlab.com/galactipy/dynamanager/-/issues
[bp11]: https://img.shields.io/badge/sembr-367DA9?style=for-the-badge&logo=read.cv&logoColor=white
[bp12]: https://sembr.org/
[bp13]: https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json&style=for-the-badge
[bp14]: https://python-poetry.org/
[bp15]: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=for-the-badge
[bp16]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.pre-commit-config.yaml
[bp17]: https://img.shields.io/badge/security-bandit-yellow?style=for-the-badge
[bp18]: https://bandit.readthedocs.io/en/latest/
[bp19]: https://img.shields.io/badge/Editorconfig-E0EFEF?style=for-the-badge&logo=editorconfig&logoColor=000
[bp20]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.editorconfig
[bp21]: https://img.shields.io/badge/effver-0097a7?style=for-the-badge&logo=semver

[blic1]: https://img.shields.io/gitlab/license/galactipy/dynamanager?style=for-the-badge
[blic2]: https://gitlab.com/galactipy/dynamanager/-/blob/master/LICENCE

<!-- TODO Replace the `100` ID with your project's index at https://www.bestpractices.dev/en
[boss1]: https://img.shields.io/cii/level/100?style=for-the-badge&logo=linux-foundation&label=openssf%20best%20practices
[boss2]: https://www.bestpractices.dev/en/projects/100 -->
<!-- TODO Replace the `200` ID with your project's index at https://ossrank.com/
[boss3]: https://shields.io/endpoint?url=https://ossrank.com/shield/200&style=for-the-badge
[boss4]: https://ossrank.com/p/200 -->

[bcov1]: https://img.shields.io/codacy/grade/ef5c6f3846d44020b6213f0772f685c5?style=for-the-badge&logo=codacy
[bcov2]: https://app.codacy.com/gl/galactipy/dynamanager/dashboard
[bcov3]: https://img.shields.io/codacy/coverage/ef5c6f3846d44020b6213f0772f685c5?style=for-the-badge&logo=codacy
[bcov4]: https://app.codacy.com/gl/galactipy/dynamanager/coverage

[fs4]: https://jacobtomlinson.dev/effver/

[wno3]: https://liberapay.com/
[wno4]: https://opencollective.com/
[wno5]: https://ko-fi.com/
[wno6]: https://opensource.guide/
[wno7]: https://github.com/nayafia/lemonade-stand

[ft1]: https://python-poetry.org/
[ft2]: https://github.com/mtkennerly/poetry-dynamic-versioning
[ft3]: https://github.com/python-poetry/poetry-plugin-bundle
[ft4]: https://github.com/python-poetry/poetry-plugin-export
[ft5]: https://github.com/MousaZeidBaker/poetry-plugin-up
[ft6]: https://gitlab.com/galactipy/dynamanager/-/blob/master/pyproject.toml
[ft7]: https://mypy.readthedocs.io
[ft8]: https://docs.safetycli.com/safety-2/
[ft9]: https://bandit.readthedocs.io/en/latest/
[ft10]: https://docs.pytest.org/en/latest/
[ft11]: https://www.codacy.com/
[ft12]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.vscode/settings.json
[ft13]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.editorconfig
[ft14]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.gitignore
[ft15]: https://pypi.org/
[ft16]: https://docs.pyinvoke.org/en/stable/
[ft17]: #invoke-usage
[ft18]: https://gitlab.com/galactipy/dynamanager/-/blob/master/.gitlab/merge_request_templates/default.md
[ft19]: https://gitlab.com/galactipy/dynamanager/-/tree/master/.gitlab/issue_templates
[ft20]: https://shields.io/

[inv1]: https://python-poetry.org/docs/#installation

[r1]: https://gitlab.com/galactipy/dynamanager/-/releases

[bscm1]: https://img.shields.io/badge/GitLab-330F63?style=for-the-badge&logo=gitlab&logoColor=white
[bscm2]: https://img.shields.io/gitlab/v/release/galactipy%2Fdynamanager?style=for-the-badge&logo=semantic-release&color=FFCA28
[bscm3]: https://img.shields.io/gitlab/issues/open/galactipy%2Fdynamanager?style=for-the-badge&color=fca326
[bscm4]: https://img.shields.io/gitlab/merge-requests/open/galactipy%2Fdynamanager?style=for-the-badge&color=6fdac9
[bscm5]: https://gitlab.com/galactipy/dynamanager/-/merge_requests
[bscm6]: https://img.shields.io/gitlab/pipeline-status/galactipy%2Fdynamanager?branch=master&style=for-the-badge&logo=gitlab&logoColor=white&label=master
[bscm7]: https://gitlab.com/galactipy/dynamanager/-/pipelines

[lab5]: https://docs.gitlab.com/ee/user/project/changelogs.html
[lab10]: https://docs.gitlab.com/ee/user/project/changelogs.html#add-a-trailer-to-a-git-commit

[bfo1]: https://img.shields.io/badge/code%20style-ruff-261230?style=for-the-badge&labelColor=grey
[bfo2]: https://docs.astral.sh
[bfo3]: https://img.shields.io/badge/imports-isort-1674b1?style=for-the-badge&labelColor=ef8336
[bfo4]: https://pycqa.github.io/isort/

[bli1]: https://img.shields.io/badge/docstrings-numpydoc-4dabcf?style=for-the-badge&labelColor=4d77cf
[bli2]: https://numpydoc.readthedocs.io/en/latest/format.html

[bbbd1]: https://img.shields.io/badge/BDD-23D96C?style=for-the-badge&logo=cucumber&logoColor=white
[bbbd2]: https://cucumber.io/

[bcv1]: https://img.shields.io/badge/%F0%9F%98%9C_gitmoji-ffdd67?style=for-the-badge
[bcv2]: https://gitmoji.dev/
