# Generated by Django 5.2.6 on 2025-09-16 18:23

import uuid

import django.db.models.deletion
import pgvector.django.vector
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ChatSession",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Session title (auto-generated if empty)",
                        max_length=255,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Whether session accepts new messages"
                    ),
                ),
                ("messages_count", models.PositiveIntegerField(default=0)),
                ("total_tokens_used", models.PositiveIntegerField(default=0)),
                (
                    "total_cost_usd",
                    models.DecimalField(
                        decimal_places=6,
                        default=0.0,
                        help_text="Total session cost for monitoring",
                        max_digits=10,
                    ),
                ),
                (
                    "model_name",
                    models.CharField(
                        default="openai/gpt-4o-mini",
                        help_text="LLM model used for this session",
                        max_length=100,
                    ),
                ),
                (
                    "temperature",
                    models.FloatField(
                        default=0.7, help_text="Temperature setting for LLM"
                    ),
                ),
                (
                    "max_context_chunks",
                    models.PositiveIntegerField(
                        default=5, help_text="Maximum chunks to include in context"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="Owner of this record",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "django_cfg_knowbase_chat_sessions",
            },
        ),
        migrations.CreateModel(
            name="ChatMessage",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "role",
                    models.CharField(
                        choices=[
                            ("user", "User"),
                            ("assistant", "Assistant"),
                            ("system", "System"),
                        ],
                        help_text="Message sender role",
                        max_length=10,
                    ),
                ),
                ("content", models.TextField(help_text="Message content")),
                (
                    "context_chunks",
                    models.JSONField(
                        default=list, help_text="IDs of chunks used for context"
                    ),
                ),
                (
                    "tokens_used",
                    models.PositiveIntegerField(
                        default=0, help_text="Tokens used for this message"
                    ),
                ),
                (
                    "cost_usd",
                    models.DecimalField(
                        decimal_places=6,
                        default=0.0,
                        help_text="Cost in USD for this message",
                        max_digits=10,
                    ),
                ),
                (
                    "processing_time_ms",
                    models.PositiveIntegerField(
                        default=0, help_text="Processing time in milliseconds"
                    ),
                ),
                (
                    "model_name",
                    models.CharField(
                        blank=True,
                        help_text="Model used for response generation",
                        max_length=100,
                    ),
                ),
                (
                    "finish_reason",
                    models.CharField(
                        blank=True,
                        help_text="Why the model stopped generating",
                        max_length=20,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="Owner of this record",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "session",
                    models.ForeignKey(
                        help_text="Parent chat session",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="messages",
                        to="django_cfg_knowbase.chatsession",
                    ),
                ),
            ],
            options={
                "db_table": "django_cfg_knowbase_chat_messages",
                "ordering": ["created_at"],
            },
        ),
        migrations.CreateModel(
            name="Document",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("title", models.CharField(help_text="Document title", max_length=512)),
                ("content", models.TextField(help_text="Full document content")),
                (
                    "content_hash",
                    models.CharField(
                        db_index=True,
                        help_text="SHA-256 hash for duplicate detection",
                        max_length=64,
                    ),
                ),
                (
                    "file_type",
                    models.CharField(
                        default="text/plain",
                        help_text="MIME type of original file",
                        max_length=100,
                    ),
                ),
                (
                    "file_size",
                    models.PositiveIntegerField(
                        default=0, help_text="Original file size in bytes"
                    ),
                ),
                (
                    "processing_status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("processing", "Processing"),
                            ("completed", "Completed"),
                            ("failed", "Failed"),
                            ("cancelled", "Cancelled"),
                        ],
                        db_index=True,
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("processing_started_at", models.DateTimeField(blank=True, null=True)),
                (
                    "processing_completed_at",
                    models.DateTimeField(blank=True, null=True),
                ),
                ("processing_error", models.TextField(blank=True, default="")),
                ("chunks_count", models.PositiveIntegerField(default=0)),
                ("total_tokens", models.PositiveIntegerField(default=0)),
                (
                    "total_cost_usd",
                    models.DecimalField(
                        decimal_places=6,
                        default=0.0,
                        help_text="Total processing cost in USD",
                        max_digits=10,
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(
                        default=dict, help_text="Additional document metadata"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="Owner of this record",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "django_cfg_knowbase_documents",
            },
        ),
        migrations.CreateModel(
            name="DocumentChunk",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("content", models.TextField(help_text="Chunk text content")),
                (
                    "chunk_index",
                    models.PositiveIntegerField(
                        help_text="Sequential chunk number within document"
                    ),
                ),
                (
                    "embedding",
                    pgvector.django.vector.VectorField(
                        dimensions=1536,
                        help_text="Vector embedding for semantic search",
                    ),
                ),
                (
                    "token_count",
                    models.PositiveIntegerField(
                        default=0, help_text="Number of tokens in chunk"
                    ),
                ),
                (
                    "character_count",
                    models.PositiveIntegerField(
                        default=0, help_text="Number of characters in chunk"
                    ),
                ),
                (
                    "embedding_model",
                    models.CharField(
                        default="text-embedding-ada-002",
                        help_text="Model used for embedding generation",
                        max_length=100,
                    ),
                ),
                (
                    "embedding_cost",
                    models.DecimalField(
                        decimal_places=6,
                        default=0.0,
                        help_text="Cost in USD for embedding generation",
                        max_digits=10,
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(default=dict, help_text="Chunk-specific metadata"),
                ),
                (
                    "document",
                    models.ForeignKey(
                        help_text="Parent document",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="chunks",
                        to="django_cfg_knowbase.document",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="Owner of this record",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "django_cfg_knowbase_document_chunks",
                "ordering": ["document", "chunk_index"],
            },
        ),
        migrations.AddIndex(
            model_name="chatsession",
            index=models.Index(
                fields=["user", "-created_at"], name="django_cfg_knowbase_ch_user_id_227a9f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="chatsession",
            index=models.Index(
                fields=["is_active"], name="django_cfg_knowbase_ch_is_acti_6fcdc8_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="chatmessage",
            index=models.Index(
                fields=["session", "-created_at"], name="django_cfg_knowbase_ch_session_782e67_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="chatmessage",
            index=models.Index(fields=["role"], name="django_cfg_knowbase_ch_role_e0d53e_idx"),
        ),
        migrations.AddIndex(
            model_name="chatmessage",
            index=models.Index(
                fields=["-created_at"], name="django_cfg_knowbase_ch_created_49bad9_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="document",
            index=models.Index(
                fields=["user", "processing_status"],
                name="django_cfg_knowbase_do_user_id_3f12df_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="document",
            index=models.Index(
                fields=["content_hash"], name="django_cfg_knowbase_do_content_0655c8_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="document",
            index=models.Index(
                fields=["-processing_completed_at"],
                name="django_cfg_knowbase_do_process_f2c2a8_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="document",
            constraint=models.UniqueConstraint(
                fields=("user", "content_hash"), name="unique_user_document"
            ),
        ),
        migrations.AddIndex(
            model_name="documentchunk",
            index=models.Index(fields=["user"], name="django_cfg_knowbase_do_user_id_a4e4de_idx"),
        ),
        migrations.AddIndex(
            model_name="documentchunk",
            index=models.Index(
                fields=["document", "chunk_index"],
                name="django_cfg_knowbase_do_documen_64aaaa_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="documentchunk",
            constraint=models.UniqueConstraint(
                fields=("document", "chunk_index"), name="unique_document_chunk"
            ),
        ),
    ]
