# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.0-rc1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from authentik_client.models.current_brand_flags import CurrentBrandFlags
from authentik_client.models.footer_link import FooterLink
from authentik_client.models.ui_theme_enum import UiThemeEnum
from typing import Optional, Set
from typing_extensions import Self

class CurrentBrand(BaseModel):
    """
    Partial brand information for styling
    """ # noqa: E501
    matched_domain: StrictStr
    branding_title: StrictStr
    branding_logo: StrictStr
    branding_favicon: StrictStr
    branding_custom_css: StrictStr
    ui_footer_links: List[FooterLink]
    ui_theme: UiThemeEnum
    flow_authentication: Optional[StrictStr] = None
    flow_invalidation: Optional[StrictStr] = None
    flow_recovery: Optional[StrictStr] = None
    flow_unenrollment: Optional[StrictStr] = None
    flow_user_settings: Optional[StrictStr] = None
    flow_device_code: Optional[StrictStr] = None
    default_locale: StrictStr
    flags: CurrentBrandFlags
    __properties: ClassVar[List[str]] = ["matched_domain", "branding_title", "branding_logo", "branding_favicon", "branding_custom_css", "ui_footer_links", "ui_theme", "flow_authentication", "flow_invalidation", "flow_recovery", "flow_unenrollment", "flow_user_settings", "flow_device_code", "default_locale", "flags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CurrentBrand from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "ui_footer_links",
            "ui_theme",
            "default_locale",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ui_footer_links (list)
        _items = []
        if self.ui_footer_links:
            for _item_ui_footer_links in self.ui_footer_links:
                if _item_ui_footer_links:
                    _items.append(_item_ui_footer_links.to_dict())
            _dict['ui_footer_links'] = _items
        # override the default output from pydantic by calling `to_dict()` of flags
        if self.flags:
            _dict['flags'] = self.flags.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CurrentBrand from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "matched_domain": obj.get("matched_domain"),
            "branding_title": obj.get("branding_title"),
            "branding_logo": obj.get("branding_logo"),
            "branding_favicon": obj.get("branding_favicon"),
            "branding_custom_css": obj.get("branding_custom_css"),
            "ui_footer_links": [FooterLink.from_dict(_item) for _item in obj["ui_footer_links"]] if obj.get("ui_footer_links") is not None else None,
            "ui_theme": obj.get("ui_theme"),
            "flow_authentication": obj.get("flow_authentication"),
            "flow_invalidation": obj.get("flow_invalidation"),
            "flow_recovery": obj.get("flow_recovery"),
            "flow_unenrollment": obj.get("flow_unenrollment"),
            "flow_user_settings": obj.get("flow_user_settings"),
            "flow_device_code": obj.get("flow_device_code"),
            "default_locale": obj.get("default_locale"),
            "flags": CurrentBrandFlags.from_dict(obj["flags"]) if obj.get("flags") is not None else None
        })
        return _obj


