"""Constants for the CPLN Python SDK.

This module defines default values and constants used throughout the SDK.
"""

# API version configuration
DEFAULT_CPLN_API_VERSION = "1.0.0"
"""str: The default Control Plane API version to use."""

MINIMUM_CPLN_API_VERSION = "1.0.0"
"""str: The minimum supported Control Plane API version."""

# Network configuration
DEFAULT_TIMEOUT_SECONDS = 60
"""int: Default timeout for API requests in seconds."""

DEFAULT_CPLN_API_URL = "https://api.cpln.io"
"""str: The default Control Plane API base URL."""
