import{S as e,U as t}from"./socket-client.js";import{E as n,a as i}from"./components/event-viewer.js";import{M as o}from"./components/module-viewer.js";import{S as s}from"./components/session-manager.js";import{A as r}from"./components/agent-inference.js";import{E as a}from"./components/export-manager.js";import{W as l}from"./components/working-directory.js";import{F as c}from"./components/file-tool-tracker.js";class d{constructor(){this.eventViewer=null,this.moduleViewer=null,this.sessionManager=null,this.socketManager=null,this.agentInference=null,this.uiStateManager=null,this.eventProcessor=null,this.exportManager=null,this.workingDirectoryManager=null,this.fileToolTracker=null,this.init()}init(){console.log("Initializing refactored Claude MPM Dashboard..."),this.initializeSocketManager(),this.initializeCoreComponents(),this.initializeAgentInference(),this.initializeUIStateManager(),this.initializeWorkingDirectoryManager(),this.initializeFileToolTracker(),this.initializeEventProcessor(),this.initializeExportManager(),this.setupModuleInteractions(),this.initializeFromURL(),console.log("Claude MPM Dashboard initialized successfully")}initializeSocketManager(){this.socketManager=new e,this.socketManager.setupConnectionControls(),this.socketClient=this.socketManager.getSocketClient(),window.socketClient=this.socketClient}initializeCoreComponents(){this.eventViewer=new n("events-list",this.socketClient),this.moduleViewer=new o,this.sessionManager=new s(this.socketClient),window.eventViewer=this.eventViewer,window.moduleViewer=this.moduleViewer,window.sessionManager=this.sessionManager}initializeAgentInference(){this.agentInference=new r(this.eventViewer),this.agentInference.initialize()}initializeUIStateManager(){this.uiStateManager=new t,this.setupTabFilters()}initializeWorkingDirectoryManager(){this.workingDirectoryManager=new l(this.socketManager)}initializeFileToolTracker(){this.fileToolTracker=new c(this.agentInference,this.workingDirectoryManager)}initializeEventProcessor(){this.eventProcessor=new i(this.eventViewer,this.agentInference)}initializeExportManager(){this.exportManager=new a(this.eventViewer)}setupModuleInteractions(){this.socketManager.onEventUpdate(e=>{this.fileToolTracker.updateFileOperations(e),this.fileToolTracker.updateToolCalls(e),this.agentInference.processAgentInference(),"events"===this.uiStateManager.getCurrentTab()&&this.exportManager.scrollListToBottom("events-list"),this.renderCurrentTab()}),this.socketManager.onConnectionStatusChange((e,t)=>{"connected"===t&&this.workingDirectoryManager.updateGitBranch(this.workingDirectoryManager.getCurrentWorkingDir())}),document.addEventListener("tabChanged",e=>{this.renderCurrentTab(),this.uiStateManager.updateTabNavigationItems()}),document.addEventListener("eventsClearing",()=>{this.fileToolTracker.clear(),this.agentInference.initialize()}),document.addEventListener("showCardDetails",e=>{this.showCardDetails(e.detail.tabName,e.detail.index)}),document.addEventListener("sessionFilterChanged",e=>{console.log("Session filter changed, re-rendering current tab:",this.uiStateManager.getCurrentTab()),this.renderCurrentTab()})}setupTabFilters(){const e=document.getElementById("agents-search-input"),t=document.getElementById("agents-type-filter");e&&e.addEventListener("input",()=>{"agents"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),t&&t.addEventListener("change",()=>{"agents"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()});const n=document.getElementById("tools-search-input"),i=document.getElementById("tools-type-filter");n&&n.addEventListener("input",()=>{"tools"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),i&&i.addEventListener("change",()=>{"tools"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()});const o=document.getElementById("files-search-input"),s=document.getElementById("files-type-filter");o&&o.addEventListener("input",()=>{"files"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()}),s&&s.addEventListener("change",()=>{"files"===this.uiStateManager.getCurrentTab()&&this.renderCurrentTab()})}initializeFromURL(){const e=new URLSearchParams(window.location.search);this.socketManager.initializeFromURL(e)}renderCurrentTab(){const e=this.uiStateManager.getCurrentTab();switch(e){case"events":break;case"agents":this.renderAgents();break;case"tools":this.renderTools();break;case"files":this.renderFiles()}this.uiStateManager.getSelectedCard().tab===e&&this.uiStateManager.updateCardSelectionUI(),this.uiStateManager.updateUnifiedSelectionUI()}renderAgents(){const e=document.getElementById("agents-list");if(!e)return;this.agentInference.processAgentInference();const t=this.eventProcessor.getFilteredEventsForTab("agents"),n=this.eventProcessor.generateAgentHTML(t);e.innerHTML=n,this.exportManager.scrollListToBottom("agents-list");const i=this.agentInference.getUniqueAgentInstances();this.updateAgentsFilterDropdowns(i)}renderTools(){const e=document.getElementById("tools-list");if(!e)return;const t=this.fileToolTracker.getToolCalls(),n=Array.from(t.entries()),i=this.eventProcessor.getUniqueToolInstances(n),o=this.eventProcessor.generateToolHTML(i);e.innerHTML=o,this.exportManager.scrollListToBottom("tools-list"),this.updateToolsFilterDropdowns(i)}renderFiles(){const e=document.getElementById("files-list");if(!e)return;const t=this.fileToolTracker.getFileOperations(),n=Array.from(t.entries()),i=this.eventProcessor.getUniqueFileInstances(n),o=this.eventProcessor.generateFileHTML(i);e.innerHTML=o,this.exportManager.scrollListToBottom("files-list"),this.updateFilesFilterDropdowns(n)}updateAgentsFilterDropdowns(e){const t=new Set;e.forEach(e=>{e.agentName&&"Unknown"!==e.agentName&&t.add(e.agentName)});const n=Array.from(t).filter(e=>e&&""!==e.trim());this.populateFilterDropdown("agents-type-filter",n,"All Agent Types"),n.length>0?console.log("Agent types found for filter:",n):console.log("No agent types found for filter. Instances:",e.length)}updateToolsFilterDropdowns(e){const t=[...new Set(e.map(([e,t])=>t.tool_name))].filter(e=>e);this.populateFilterDropdown("tools-type-filter",t,"All Tools")}updateFilesFilterDropdowns(e){const t=[...new Set(e.flatMap(([e,t])=>t.operations.map(e=>e.operation)))].filter(e=>e);this.populateFilterDropdown("files-type-filter",t,"All Operations")}populateFilterDropdown(e,t,n="All"){const i=document.getElementById(e);if(!i)return;const o=i.value,s=t.sort((e,t)=>e.localeCompare(t));i.innerHTML=`<option value="">${n}</option>`,s.forEach(e=>{const t=document.createElement("option");t.value=e,t.textContent=e,i.appendChild(t)}),o&&s.includes(o)&&(i.value=o)}showCardDetails(e,t){switch(e){case"events":this.eventViewer&&this.eventViewer.showEventDetails(t);break;case"agents":this.showAgentDetailsByIndex(t);break;case"tools":this.showToolDetailsByIndex(t);break;case"files":this.showFileDetailsByIndex(t)}}showAgentDetailsByIndex(e){const t=this.eventProcessor.getFilteredEventsForTab("agents");if(!t||!Array.isArray(t)||e<0||e>=t.length)return void console.warn("Dashboard: Invalid agent index or events array");const n=this.eventProcessor.applyAgentsFilters([t[e]]);if(n.length>0&&this.moduleViewer&&"function"==typeof this.moduleViewer.showAgentEvent){const t=n[0];this.moduleViewer.showAgentEvent(t,e)}}showAgentInstanceDetails(e){const t=this.agentInference.getPMDelegations().get(e);if(!t){const t=this.agentInference.getUniqueAgentInstances().find(t=>t.id===e);return t?void this.showImpliedAgentDetails(t):void console.error("Agent instance not found:",e)}this.moduleViewer&&"function"==typeof this.moduleViewer.showAgentInstance?this.moduleViewer.showAgentInstance(t):console.log("Agent Instance Details:",{id:e,agentName:t.agentName,type:"PM Delegation",eventCount:t.agentEvents.length,startTime:t.timestamp,pmCall:t.pmCall})}showImpliedAgentDetails(e){this.moduleViewer&&"function"==typeof this.moduleViewer.showImpliedAgent?this.moduleViewer.showImpliedAgent(e):console.log("Implied Agent Details:",{id:e.id,agentName:e.agentName,type:"Implied PM Delegation",eventCount:e.eventCount,startTime:e.timestamp,note:"No explicit PM call found - inferred from agent activity"})}showToolDetailsByIndex(e){const t=this.fileToolTracker.getToolCalls(),n=Array.from(t.entries()),i=this.eventProcessor.applyToolCallFilters(n);if(e>=0&&e<i.length){const[t]=i[e];this.showToolCallDetails(t)}}showFileDetailsByIndex(e){const t=this.fileToolTracker.getFileOperations();let n=Array.from(t.entries());if(n=this.eventProcessor.applyFilesFilters(n),e>=0&&e<n.length){const[t]=n[e];this.showFileDetails(t)}}showToolCallDetails(e){const t=this.fileToolTracker.getToolCall(e);t&&this.moduleViewer&&this.moduleViewer.showToolCall(t,e)}showFileDetails(e){const t=this.fileToolTracker.getFileOperationsForFile(e);t&&this.moduleViewer&&this.moduleViewer.showFileOperations(t,e)}switchTab(e){this.uiStateManager.switchTab(e)}selectCard(e,t,n,i){this.uiStateManager.selectCard(e,t,n,i)}clearEvents(){this.exportManager.clearEvents()}exportEvents(){this.exportManager.exportEvents()}clearSelection(){this.uiStateManager.clearSelection(),this.eventViewer&&this.eventViewer.clearSelection(),this.moduleViewer&&this.moduleViewer.clear()}get currentWorkingDir(){return this.workingDirectoryManager.getCurrentWorkingDir()}set currentWorkingDir(e){this.workingDirectoryManager.setWorkingDirectory(e)}get currentTab(){return this.uiStateManager.getCurrentTab()}get selectedCard(){return this.uiStateManager.getSelectedCard()}get fileOperations(){return this.fileToolTracker.getFileOperations()}get toolCalls(){return this.fileToolTracker.getToolCalls()}get tabNavigation(){return this.uiStateManager?this.uiStateManager.tabNavigation:null}}function g(){const e=document.createElement("div");return e.id="file-viewer-modal",e.className="modal file-viewer-modal",e.innerHTML='\n        <div class="modal-content file-viewer-content">\n            <div class="file-viewer-header">\n                <h2 class="file-viewer-title">\n                    <span class="file-viewer-icon">📄</span>\n                    <span class="file-viewer-title-text">File Viewer</span>\n                </h2>\n                <div class="file-viewer-meta">\n                    <span class="file-viewer-file-path"></span>\n                    <span class="file-viewer-file-size"></span>\n                </div>\n                <button class="file-viewer-close" onclick="hideFileViewerModal()">\n                    <span>&times;</span>\n                </button>\n            </div>\n            <div class="file-viewer-body">\n                <div class="file-viewer-loading">\n                    <div class="loading-spinner"></div>\n                    <span>Loading file content...</span>\n                </div>\n                <div class="file-viewer-error" style="display: none;">\n                    <div class="error-icon">⚠️</div>\n                    <div class="error-message"></div>\n                    <div class="error-suggestions"></div>\n                </div>\n                <div class="file-viewer-content-area" style="display: none;">\n                    <div class="file-viewer-toolbar">\n                        <div class="file-viewer-info">\n                            <span class="file-extension"></span>\n                            <span class="file-encoding"></span>\n                        </div>\n                        <div class="file-viewer-actions">\n                            <button class="file-content-copy" onclick="copyFileContent()">\n                                📋 Copy\n                            </button>\n                        </div>\n                    </div>\n                    <div class="file-viewer-scroll-wrapper">\n                        <pre class="file-content-display"><code class="file-content-code"></code></pre>\n                    </div>\n                </div>\n            </div>\n        </div>\n    ',e.addEventListener("click",t=>{t.target===e&&hideFileViewerModal()}),document.addEventListener("keydown",t=>{"Escape"===t.key&&"flex"===e.style.display&&hideFileViewerModal()}),e}async function h(e,t,n){const i=e.querySelector(".file-viewer-file-path"),o=e.querySelector(".file-viewer-file-size");i.textContent=t,o.textContent="",e.querySelector(".file-viewer-loading").style.display="flex",e.querySelector(".file-viewer-error").style.display="none",e.querySelector(".file-viewer-content-area").style.display="none";try{const i=window.socket||window.dashboard?.socketClient?.socket;if(!i)throw new Error("No socket connection available");const o=new Promise((e,n)=>{const o=s=>{s.file_path===t&&(i.off("file_content_response",o),s.success?e(s):n(new Error(s.error||"Failed to read file")))};i.on("file_content_response",o),setTimeout(()=>{i.off("file_content_response",o),n(new Error("Request timeout"))},1e4)});i.emit("read_file",{file_path:t,working_dir:n}),console.log("📄 File viewer request sent:",{filePath:t,workingDir:n});const s=await o;console.log("📦 File content received:",s),e.querySelector(".file-viewer-loading").style.display="none",function(e,t){console.log("📝 displayFileContent called with:",t);const n=e.querySelector(".file-viewer-content-area"),i=e.querySelector(".file-extension"),o=e.querySelector(".file-encoding"),s=e.querySelector(".file-viewer-file-size"),r=e.querySelector(".file-content-code");i&&(i.textContent=`Type: ${t.extension||"unknown"}`);o&&(o.textContent=`Encoding: ${t.encoding||"unknown"}`);s&&(s.textContent=`Size: ${function(e){if(!e)return"0 B";const t=1024,n=["B","KB","MB","GB"],i=Math.floor(Math.log(e)/Math.log(t));return parseFloat((e/Math.pow(t,i)).toFixed(2))+" "+n[i]}(t.file_size)}`);if(r&&t.content){console.log("💡 Setting file content, length:",t.content.length),r.innerHTML=function(e,t){const n=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");switch(t){case".js":case".jsx":case".ts":case".tsx":return function(e){return f(e.replace(/\b(function|const|let|var|if|else|for|while|return|import|export|class|extends)\b/g,'<span class="keyword">$1</span>').replace(/(\/\*[\s\S]*?\*\/|\/\/.*)/g,'<span class="comment">$1</span>').replace(/('[^']*'|"[^"]*"|`[^`]*`)/g,'<span class="string">$1</span>').replace(/\b(\d+)\b/g,'<span class="number">$1</span>'))}(n);case".py":return function(e){return f(e.replace(/\b(def|class|if|elif|else|for|while|return|import|from|as|try|except|finally|with)\b/g,'<span class="keyword">$1</span>').replace(/(#.*)/g,'<span class="comment">$1</span>').replace(/('[^']*'|"[^"]*"|"""[\s\S]*?""")/g,'<span class="string">$1</span>').replace(/\b(\d+)\b/g,'<span class="number">$1</span>'))}(n);case".json":return function(e){return f(e.replace(/("[\w\s]*")\s*:/g,'<span class="property">$1</span>:').replace(/:\s*(".*?")/g,': <span class="string">$1</span>').replace(/:\s*(\d+)/g,': <span class="number">$1</span>').replace(/:\s*(true|false|null)/g,': <span class="keyword">$1</span>'))}(n);case".css":return function(e){return f(e.replace(/([.#]?[\w-]+)\s*\{/g,'<span class="selector">$1</span> {').replace(/([\w-]+)\s*:/g,'<span class="property">$1</span>:').replace(/:\s*([^;]+);/g,': <span class="value">$1</span>;').replace(/(\/\*[\s\S]*?\*\/)/g,'<span class="comment">$1</span>'))}(n);case".html":case".htm":return function(e){return f(e.replace(/(&lt;\/?[\w-]+)/g,'<span class="tag">$1</span>').replace(/([\w-]+)=(['"][^'"]*['"])/g,'<span class="attribute">$1</span>=<span class="string">$2</span>').replace(/(&lt;!--[\s\S]*?--&gt;)/g,'<span class="comment">$1</span>'))}(n);case".md":case".markdown":return function(e){return f(e.replace(/^(#{1,6})\s+(.*)$/gm,'<span class="header">$1</span> <span class="header-text">$2</span>').replace(/\*\*(.*?)\*\*/g,'<span class="bold">**$1**</span>').replace(/\*(.*?)\*/g,'<span class="italic">*$1*</span>').replace(/`([^`]+)`/g,'<span class="code">`$1`</span>').replace(/^\s*[-*+]\s+(.*)$/gm,'<span class="list-marker">•</span> $1'))}(n);default:return f(n)}}(t.content,t.extension);const n=e.querySelector(".file-viewer-scroll-wrapper");n&&setTimeout(()=>{const t=e.querySelector(".modal-content"),i=e.querySelector(".file-viewer-header"),o=e.querySelector(".file-viewer-toolbar"),s=t?.offsetHeight||0,r=i?.offsetHeight||0,a=o?.offsetHeight||0,l=s-r-a-40;console.log("🎯 Setting file viewer scroll height:",{modalHeight:s,headerHeight:r,toolbarHeight:a,availableHeight:l}),n.style.maxHeight=`${l}px`,n.style.overflowY="auto"},50)}else console.warn("⚠️ Missing codeElement or file content");n&&(n.style.display="block",console.log("✅ File content area displayed"))}(e,s)}catch(s){console.error("❌ Failed to fetch file content:",s),e.querySelector(".file-viewer-loading").style.display="none";let i=s.message||"Unknown error occurred",o=[];s.message.includes("No socket connection")?(i="Failed to connect to the monitoring server",o=["Check if the monitoring server is running","Verify the socket connection in the dashboard","Try refreshing the page and reconnecting"]):s.message.includes("timeout")?(i="Request timed out",o=["The file may be too large to load quickly","Check your network connection","Try again in a few moments"]):s.message.includes("File does not exist")?(i="File not found",o=["The file may have been moved or deleted","Check the file path spelling","Refresh the file list to see current files"]):s.message.includes("Access denied")&&(i="Access denied",o=["The file is outside the allowed directories","File access is restricted for security reasons"]),function(e,t){const n=e.querySelector(".file-viewer-error"),i=e.querySelector(".error-message"),o=e.querySelector(".error-suggestions");let s=t.error||"Unknown error occurred";i.innerHTML=`\n        <div class="error-main">${s}</div>\n        ${t.file_path?`<div class="error-file">File: ${t.file_path}</div>`:""}\n        ${t.working_dir?`<div class="error-dir">Working directory: ${t.working_dir}</div>`:""}\n    `,t.suggestions&&t.suggestions.length>0?o.innerHTML=`\n            <h4>Suggestions:</h4>\n            <ul>\n                ${t.suggestions.map(e=>`<li>${e}</li>`).join("")}\n            </ul>\n        `:o.innerHTML="";console.log("📋 Displaying file viewer error:",{originalError:t.error,processedMessage:s,suggestions:t.suggestions}),n.style.display="block"}(e,{error:i,file_path:t,working_dir:n,suggestions:o})}}function f(e){return e.split("\n").map((e,t)=>`<span class="line-number">${String(t+1).padStart(3," ")}</span> ${e||" "}`).join("\n")}function p(e,t){const n=e.querySelector(".git-diff-error"),i=e.querySelector(".error-message"),o=e.querySelector(".error-suggestions");let s=t.error||"Unknown error occurred",r=!1;if(s.includes("not tracked by git")?(s="📝 This file is not tracked by git yet",r=!0):s.includes("No git history found")&&(s="📋 No git history available for this file"),i.innerHTML=`\n        <div class="error-main">${s}</div>\n        ${t.file_path?`<div class="error-file">File: ${t.file_path}</div>`:""}\n        ${t.working_dir?`<div class="error-dir">Working directory: ${t.working_dir}</div>`:""}\n    `,t.suggestions&&t.suggestions.length>0){const e=r?"How to track this file:":"Suggestions:";o.innerHTML=`\n            <h4>${e}</h4>\n            <ul>\n                ${t.suggestions.map(e=>`<li>${e}</li>`).join("")}\n            </ul>\n        `}else o.innerHTML="";console.log("📋 Displaying git diff error:",{originalError:t.error,processedMessage:s,isUntracked:r,suggestions:t.suggestions}),n.style.display="block"}function u(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}window.clearEvents=function(){window.dashboard&&window.dashboard.clearEvents()},window.exportEvents=function(){window.dashboard&&window.dashboard.exportEvents()},window.clearSelection=function(){window.dashboard&&window.dashboard.clearSelection()},window.switchTab=function(e){window.dashboard&&window.dashboard.switchTab(e)},window.showFileViewerModal=function(e,t){!t&&window.dashboard&&window.dashboard.currentWorkingDir&&(t=window.dashboard.currentWorkingDir);let n=document.getElementById("file-viewer-modal");n||(n=g(),document.body.appendChild(n)),h(n,e,t),n.style.display="flex",document.body.style.overflow="hidden"},window.hideFileViewerModal=function(){const e=document.getElementById("file-viewer-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.copyFileContent=function(){const e=document.getElementById("file-viewer-modal");if(!e)return;const t=e.querySelector(".file-content-code");if(!t)return;const n=t.textContent;if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(n).then(()=>{const t=e.querySelector(".file-content-copy"),n=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=n},2e3)}).catch(e=>{console.error("Failed to copy text:",e)});else{const t=document.createElement("textarea");t.value=n,document.body.appendChild(t),t.select(),document.execCommand("copy"),document.body.removeChild(t);const i=e.querySelector(".file-content-copy"),o=i.textContent;i.textContent="✅ Copied!",setTimeout(()=>{i.textContent=o},2e3)}},window.showGitDiffModal=function(e,t,n){!n&&window.dashboard&&window.dashboard.currentWorkingDir&&(n=window.dashboard.currentWorkingDir);let i=document.getElementById("git-diff-modal");i||(i=function(){const e=document.createElement("div");return e.id="git-diff-modal",e.className="modal git-diff-modal",e.innerHTML='\n        <div class="modal-content git-diff-content">\n            <div class="git-diff-header">\n                <h2 class="git-diff-title">\n                    <span class="git-diff-icon">📋</span>\n                    <span class="git-diff-title-text">Git Diff</span>\n                </h2>\n                <div class="git-diff-meta">\n                    <span class="git-diff-file-path"></span>\n                    <span class="git-diff-timestamp"></span>\n                </div>\n                <button class="git-diff-close" onclick="hideGitDiffModal()">\n                    <span>&times;</span>\n                </button>\n            </div>\n            <div class="git-diff-body">\n                <div class="git-diff-loading">\n                    <div class="loading-spinner"></div>\n                    <span>Loading git diff...</span>\n                </div>\n                <div class="git-diff-error" style="display: none;">\n                    <div class="error-icon">⚠️</div>\n                    <div class="error-message"></div>\n                    <div class="error-suggestions"></div>\n                </div>\n                <div class="git-diff-content-area" style="display: none;">\n                    <div class="git-diff-toolbar">\n                        <div class="git-diff-info">\n                            <span class="commit-hash"></span>\n                            <span class="diff-method"></span>\n                        </div>\n                        <div class="git-diff-actions">\n                            <button class="git-diff-copy" onclick="copyGitDiff()">\n                                📋 Copy\n                            </button>\n                        </div>\n                    </div>\n                    <div class="git-diff-scroll-wrapper">\n                        <pre class="git-diff-display"><code class="git-diff-code"></code></pre>\n                    </div>\n                </div>\n            </div>\n        </div>\n    ',e.addEventListener("click",t=>{t.target===e&&hideGitDiffModal()}),document.addEventListener("keydown",t=>{"Escape"===t.key&&"flex"===e.style.display&&hideGitDiffModal()}),e}(),document.body.appendChild(i)),async function(e,t,n,i){const o=e.querySelector(".git-diff-file-path"),s=e.querySelector(".git-diff-timestamp");o.textContent=t,s.textContent=n?new Date(n).toLocaleString():"Latest",e.querySelector(".git-diff-loading").style.display="flex",e.querySelector(".git-diff-error").style.display="none",e.querySelector(".git-diff-content-area").style.display="none";try{let o=8765;if(window.dashboard&&window.dashboard.socketClient&&window.dashboard.socketClient.port)o=window.dashboard.socketClient.port;else{const e=document.getElementById("port-input");e&&e.value&&(o=e.value)}const s=new URLSearchParams({file:t});n&&s.append("timestamp",n),i&&s.append("working_dir",i);const a=`http://localhost:${o}/api/git-diff?${s}`;console.log("🌐 Making git diff request to:",a),console.log("📋 Git diff request parameters:",{filePath:t,timestamp:n,workingDir:i,urlParams:s.toString()});try{const e=await fetch(`http://localhost:${o}/health`,{method:"GET",headers:{Accept:"application/json","Content-Type":"application/json"},mode:"cors"});if(!e.ok)throw new Error(`Server health check failed: ${e.status} ${e.statusText}`);console.log("✅ Server health check passed")}catch(r){throw new Error(`Cannot reach server at localhost:${o}. Health check failed: ${r.message}`)}const l=await fetch(a,{method:"GET",headers:{Accept:"application/json","Content-Type":"application/json"},mode:"cors"});if(!l.ok)throw new Error(`HTTP ${l.status}: ${l.statusText}`);const c=await l.json();console.log("📦 Git diff response:",c),e.querySelector(".git-diff-loading").style.display="none",c.success?(console.log("📊 Displaying successful git diff"),function(e,t){console.log("📝 displayGitDiff called with:",t);const n=e.querySelector(".git-diff-content-area"),i=e.querySelector(".commit-hash"),o=e.querySelector(".diff-method"),s=e.querySelector(".git-diff-code");console.log("🔍 Elements found:",{contentArea:!!n,commitHashElement:!!i,methodElement:!!o,codeElement:!!s}),i&&(i.textContent=`Commit: ${t.commit_hash}`);o&&(o.textContent=`Method: ${t.method}`);if(s&&t.diff){console.log("💡 Setting diff content, length:",t.diff.length),s.innerHTML=t.diff.split("\n").map(e=>{const t=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");return e.startsWith("+++")||e.startsWith("---")?`<span class="diff-header">${t}</span>`:e.startsWith("@@")?`<span class="diff-meta">${t}</span>`:e.startsWith("+")?`<span class="diff-addition">${t}</span>`:e.startsWith("-")?`<span class="diff-deletion">${t}</span>`:e.startsWith("commit ")||e.startsWith("Author:")||e.startsWith("Date:")?`<span class="diff-header">${t}</span>`:`<span class="diff-context">${t}</span>`}).join("\n");const n=e.querySelector(".git-diff-scroll-wrapper");n&&setTimeout(()=>{const t=e.querySelector(".modal-content"),i=e.querySelector(".git-diff-header"),o=e.querySelector(".git-diff-toolbar"),s=t?.offsetHeight||0,r=i?.offsetHeight||0,a=o?.offsetHeight||0,l=s-r-a-40;console.log("🎯 Setting explicit scroll height:",{modalHeight:s,headerHeight:r,toolbarHeight:a,availableHeight:l}),n.style.maxHeight=`${l}px`,n.style.overflowY="auto"},50)}else console.warn("⚠️ Missing codeElement or diff data");n&&(n.style.display="block",console.log("✅ Content area displayed"))}(e,c)):(console.log("⚠️ Displaying git diff error:",c),p(e,c))}catch(a){console.error("❌ Failed to fetch git diff:",a),console.error("Error details:",{name:a.name,message:a.message,stack:a.stack,filePath:t,timestamp:n,workingDir:i}),e.querySelector(".git-diff-loading").style.display="none";let o=`Network error: ${a.message}`,s=[];a.message.includes("Failed to fetch")?(o="Failed to connect to the monitoring server",s=["Check if the monitoring server is running on port 8765","Verify the port configuration in the dashboard","Check browser console for CORS or network errors","Try refreshing the page and reconnecting"]):a.message.includes("health check failed")?(o=a.message,s=["The server may be starting up - try again in a few seconds","Check if another process is using port 8765","Restart the claude-mpm monitoring server"]):a.message.includes("HTTP")&&(o=`Server error: ${a.message}`,s=["The server encountered an internal error","Check the server logs for more details","Try with a different file or working directory"]),p(e,{error:o,file_path:t,working_dir:i,suggestions:s,debug_info:{error_type:a.name,original_message:a.message,port:window.dashboard?.socketClient?.port||document.getElementById("port-input")?.value||"8765",timestamp:(new Date).toISOString()}})}}(i,e,t,n),i.style.display="flex",document.body.style.overflow="hidden"},window.hideGitDiffModal=function(){const e=document.getElementById("git-diff-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.copyGitDiff=function(){const e=document.getElementById("git-diff-modal");if(!e)return;const t=e.querySelector(".git-diff-code");if(!t)return;const n=t.textContent;if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(n).then(()=>{const t=e.querySelector(".git-diff-copy"),n=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=n},2e3)}).catch(e=>{console.error("Failed to copy text:",e)});else{const t=document.createElement("textarea");t.value=n,document.body.appendChild(t),t.select(),document.execCommand("copy"),document.body.removeChild(t);const i=e.querySelector(".git-diff-copy"),o=i.textContent;i.textContent="✅ Copied!",setTimeout(()=>{i.textContent=o},2e3)}},window.showFileViewerModal=function(e){let t="";window.dashboard&&window.dashboard.currentWorkingDir&&(t=window.dashboard.currentWorkingDir);let n=document.getElementById("file-viewer-modal");n||(n=g(),document.body.appendChild(n)),h(n,e,t),n.style.display="flex",document.body.style.overflow="hidden"},window.hideFileViewerModal=function(){const e=document.getElementById("file-viewer-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.copyFileContent=function(){const e=document.getElementById("file-viewer-modal");if(!e)return;const t=e.querySelector(".file-content-code");if(!t)return;const n=t.textContent;if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(n).then(()=>{const t=e.querySelector(".file-content-copy"),n=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=n},2e3)}).catch(e=>{console.error("Failed to copy text:",e)});else{const t=document.createElement("textarea");t.value=n,document.body.appendChild(t),t.select(),document.execCommand("copy"),document.body.removeChild(t);const i=e.querySelector(".file-content-copy"),o=i.textContent;i.textContent="✅ Copied!",setTimeout(()=>{i.textContent=o},2e3)}},window.showSearchViewerModal=function(e,t){let n=document.getElementById("search-viewer-modal");n||(n=function(){const e=document.createElement("div");return e.id="search-viewer-modal",e.className="modal search-viewer-modal",e.innerHTML='\n        <div class="modal-content search-viewer-content">\n            <div class="search-viewer-header">\n                <h2 class="search-viewer-title">\n                    <span class="search-viewer-icon">🔍</span>\n                    <span class="search-viewer-title-text">Search Results</span>\n                </h2>\n                <button class="search-viewer-close" onclick="hideSearchViewerModal()">\n                    <span>&times;</span>\n                </button>\n            </div>\n            <div class="search-viewer-body">\n                <div class="search-params-section">\n                    <h3>Search Parameters</h3>\n                    <pre class="search-params-display"></pre>\n                </div>\n                <div class="search-results-section">\n                    <h3>Search Results</h3>\n                    <div class="search-results-display"></div>\n                </div>\n            </div>\n        </div>\n    ',e.addEventListener("click",t=>{t.target===e&&hideSearchViewerModal()}),document.addEventListener("keydown",t=>{"Escape"===t.key&&"flex"===e.style.display&&hideSearchViewerModal()}),e}(),document.body.appendChild(n)),function(e,t,n){const i=e.querySelector(".search-params-display"),o=e.querySelector(".search-results-display");i&&t&&(i.textContent=JSON.stringify(t,null,2));if(o&&n){let e="";"string"==typeof n?e=`<pre class="search-results-text">${u(n)}</pre>`:Array.isArray(n)?(e='<ul class="search-results-list">',n.forEach(t=>{e+="object"==typeof t?`<li><pre>${JSON.stringify(t,null,2)}</pre></li>`:`<li>${u(String(t))}</li>`}),e+="</ul>"):e="object"==typeof n?`<pre class="search-results-json">${JSON.stringify(n,null,2)}</pre>`:`<div class="search-results-text">${u(String(n))}</div>`,o.innerHTML=e}}(n,e,t),n.style.display="flex",document.body.style.overflow="hidden"},window.hideSearchViewerModal=function(){const e=document.getElementById("search-viewer-modal");e&&(e.style.display="none",document.body.style.overflow="")},window.showAgentInstanceDetails=function(e){window.dashboard&&"function"==typeof window.dashboard.showAgentInstanceDetails?window.dashboard.showAgentInstanceDetails(e):console.error("Dashboard not available or method not found")},document.addEventListener("DOMContentLoaded",function(){window.dashboard=new d,console.log("Dashboard loaded and initialized")});
//# sourceMappingURL=dashboard.js.map
