# Generated by Django 3.2.23 on 2024-06-26 19:01

import uuid

import django.core.serializers.json
import django.db.models.deletion
import nautobot.core.models.fields
import nautobot.extras.models.mixins
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0102_set_null_objectchange_contenttype"),
        ("dcim", "0052_fix_interface_redundancy_group_created"),
        ("nautobot_ssot", "0009_ssotconfig_ssotinfobloxconfig"),
    ]

    operations = [
        migrations.CreateModel(
            name="AutomationGatewayModel",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("description", models.CharField(blank=True, max_length=512)),
                ("location_descendants", models.BooleanField(default=True)),
                ("enabled", models.BooleanField(default=False)),
                (
                    "gateway",
                    models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to="extras.externalintegration"),
                ),
                ("location", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="dcim.location")),
                ("tags", nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Automation Gateway Management",
                "verbose_name_plural": "Automation Gateway Management",
                "ordering": ["name", "location"],
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
