import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { DeleteGitHubAccountTokenInput, DeleteGitHubAccountTokenOutput } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link DeleteGitHubAccountTokenCommand}.
 */
export interface DeleteGitHubAccountTokenCommandInput extends DeleteGitHubAccountTokenInput {
}
/**
 * @public
 *
 * The output of {@link DeleteGitHubAccountTokenCommand}.
 */
export interface DeleteGitHubAccountTokenCommandOutput extends DeleteGitHubAccountTokenOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Deletes a GitHub account connection.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, DeleteGitHubAccountTokenCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, DeleteGitHubAccountTokenCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // DeleteGitHubAccountTokenInput
 *   tokenName: "STRING_VALUE",
 * };
 * const command = new DeleteGitHubAccountTokenCommand(input);
 * const response = await client.send(command);
 * // { // DeleteGitHubAccountTokenOutput
 * //   tokenName: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DeleteGitHubAccountTokenCommandInput - {@link DeleteGitHubAccountTokenCommandInput}
 * @returns {@link DeleteGitHubAccountTokenCommandOutput}
 * @see {@link DeleteGitHubAccountTokenCommandInput} for command's `input` shape.
 * @see {@link DeleteGitHubAccountTokenCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link GitHubAccountTokenDoesNotExistException} (client fault)
 *  <p>No GitHub account connection exists with the named specified in the call.</p>
 *
 * @throws {@link GitHubAccountTokenNameRequiredException} (client fault)
 *  <p>The call is missing a required GitHub account connection name.</p>
 *
 * @throws {@link InvalidGitHubAccountTokenNameException} (client fault)
 *  <p>The format of the specified GitHub account connection name is invalid.</p>
 *
 * @throws {@link OperationNotSupportedException} (client fault)
 *  <p>The API used does not support the deployment.</p>
 *
 * @throws {@link ResourceValidationException} (client fault)
 *  <p>The specified resource could not be validated.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class DeleteGitHubAccountTokenCommand extends $Command<DeleteGitHubAccountTokenCommandInput, DeleteGitHubAccountTokenCommandOutput, CodeDeployClientResolvedConfig> {
    readonly input: DeleteGitHubAccountTokenCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DeleteGitHubAccountTokenCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CodeDeployClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteGitHubAccountTokenCommandInput, DeleteGitHubAccountTokenCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
