import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { ListDeploymentConfigsInput, ListDeploymentConfigsOutput } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link ListDeploymentConfigsCommand}.
 */
export interface ListDeploymentConfigsCommandInput extends ListDeploymentConfigsInput {
}
/**
 * @public
 *
 * The output of {@link ListDeploymentConfigsCommand}.
 */
export interface ListDeploymentConfigsCommandOutput extends ListDeploymentConfigsOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Lists the deployment configurations with the IAM user or Amazon Web Services account.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, ListDeploymentConfigsCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, ListDeploymentConfigsCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // ListDeploymentConfigsInput
 *   nextToken: "STRING_VALUE",
 * };
 * const command = new ListDeploymentConfigsCommand(input);
 * const response = await client.send(command);
 * // { // ListDeploymentConfigsOutput
 * //   deploymentConfigsList: [ // DeploymentConfigsList
 * //     "STRING_VALUE",
 * //   ],
 * //   nextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListDeploymentConfigsCommandInput - {@link ListDeploymentConfigsCommandInput}
 * @returns {@link ListDeploymentConfigsCommandOutput}
 * @see {@link ListDeploymentConfigsCommandInput} for command's `input` shape.
 * @see {@link ListDeploymentConfigsCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link InvalidNextTokenException} (client fault)
 *  <p>The next token was specified in an invalid format.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class ListDeploymentConfigsCommand extends $Command<ListDeploymentConfigsCommandInput, ListDeploymentConfigsCommandOutput, CodeDeployClientResolvedConfig> {
    readonly input: ListDeploymentConfigsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ListDeploymentConfigsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CodeDeployClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListDeploymentConfigsCommandInput, ListDeploymentConfigsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
