import sqlalchemy as sa

from sqlalchemy.ext.compiler import compiles
from sqlalchemy.sql.expression import FunctionElement
from sqlalchemy.dialects.mssql.base import ischema_names
from geoalchemy2.types import Geometry


ischema_names["geometry"] = Geometry


class utcnow(FunctionElement):
    inherit_cache = True
    type = sa.DateTime()


@compiles(utcnow, "postgresql")
def pg_utcnow(element, compiler, **kw):
    return "TIMEZONE('utc', CURRENT_TIMESTAMP)"
