# 💸 Costs & Value Transparency

## 💡 How Janito Handles Costs

- 🆓 **No Extra Fees:** Janito is open source and does not charge any additional fees for usage.
- 🔑 **Bring Your Own API Key:** By default, Janito uses [OpenAI](https://platform.openai.com), but you can also connect your own Azure or compatible API key. You pay only for what you use, directly to the provider.
- 👀 **Full Visibility:** You can monitor your API usage and costs through your provider’s dashboard, with no hidden markups.

## 🔄 Comparison: Subscription Models in Other Tools

- ✅ **Costs Under Control:** Subscription models can help users predict their monthly expenses, providing cost certainty regardless of usage spikes.
- 💳 **Flat Monthly Fees:** Many AI coding assistants or IDE plugins charge a monthly subscription, regardless of how much you use them.
- 🕳️ **Opaque Value:** These tools manage the context, prompts, and API usage behind the scenes. You don’t know how much of your subscription is spent on actual model calls versus overhead or unused features.
- 🚫 **Limited Control:** You can’t tune the context window, prompt, or tool usage to optimize for cost or value.

## 🧠 Context Optimization and Token Efficiency

- 🧩 **Smart Context Selection:** Janito’s tools are designed to select only the most relevant files, code snippets, or configuration details for each request, based on your prompt and intent.
- 🎯 **Aligned with Your Goals:** Instead of sending your entire project or irrelevant data, Janito tailors the context to what you actually need—whether that’s UI, backend, or documentation.
- 💰 **Token Usage Efficiency:** By minimizing unnecessary context, Janito helps you get more value from each API call, reducing token usage and cost while maximizing the quality of responses.

## 🔍 Janito’s Advantage: Cost Transparency

- 💸 **Pay for What You Use:** Every API call is under your control. You decide when and how to use the model, and can optimize prompts or tool usage for efficiency.
- 🚫 **No Hidden Usage:** There’s no “black box” between you and the model—no risk of surprise overages or wasted spend.
- 🎯 **Direct Value:** You see exactly how your usage translates to results, and can adjust your workflow to maximize value for your spend.

## 🏁 Summary

With Janito, you’re in control: no subscriptions, no hidden fees, and full transparency into how your costs deliver value.
