<a id="mypy-boto3-ecs"></a>

# mypy-boto3-ecs

[![PyPI - mypy-boto3-ecs](https://img.shields.io/pypi/v/mypy-boto3-ecs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ecs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ecs?color=blue)](https://pypistats.org/packages/mypy-boto3-ecs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ECS 1.17.93](https://boto3.amazonaws.com/v1/documentation/api/1.17.93/reference/services/ecs.html#ECS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.18.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ecs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecs/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ecs](#mypy-boto3-ecs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ECS` service.

```bash
python -m pip install boto3-stubs[ecs]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ecs]` in your environment:
  `python -m pip install 'boto3-stubs[ecs]'`

Both type checking and auto-complete should work for `ECS` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ecs]` in your environment:
  `python -m pip install 'boto3-stubs[ecs]'`

Both type checking and auto-complete should work for `ECS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ecs]` in your environment:
  `python -m pip install 'boto3-stubs[ecs]'`
- Run `mypy` as usual

Type checking should work for `ECS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ecs]` in your environment:
  `python -m pip install 'boto3-stubs[ecs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ECS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ECSClient` provides annotations for `boto3.client("ecs")`.

```python
import boto3

from mypy_boto3_ecs import ECSClient

client: ECSClient = boto3.client("ecs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ECSClient = session.client("ecs")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ecs.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ecs import ECSClient
from mypy_boto3_ecs.paginator import (
    ListAccountSettingsPaginator,
    ListAttributesPaginator,
    ListClustersPaginator,
    ListContainerInstancesPaginator,
    ListServicesPaginator,
    ListTaskDefinitionFamiliesPaginator,
    ListTaskDefinitionsPaginator,
    ListTasksPaginator,
)

client: ECSClient = boto3.client("ecs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_account_settings_paginator: ListAccountSettingsPaginator = client.get_paginator("list_account_settings")
list_attributes_paginator: ListAttributesPaginator = client.get_paginator("list_attributes")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_container_instances_paginator: ListContainerInstancesPaginator = client.get_paginator("list_container_instances")
list_services_paginator: ListServicesPaginator = client.get_paginator("list_services")
list_task_definition_families_paginator: ListTaskDefinitionFamiliesPaginator = client.get_paginator("list_task_definition_families")
list_task_definitions_paginator: ListTaskDefinitionsPaginator = client.get_paginator("list_task_definitions")
list_tasks_paginator: ListTasksPaginator = client.get_paginator("list_tasks")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ecs.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ecs import ECSClient
from mypy_boto3_ecs.waiter import (
    ServicesInactiveWaiter,
    ServicesStableWaiter,
    TasksRunningWaiter,
    TasksStoppedWaiter,
)

client: ECSClient = boto3.client("ecs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
services_inactive_waiter: ServicesInactiveWaiter = client.get_waiter("services_inactive")
services_stable_waiter: ServicesStableWaiter = client.get_waiter("services_stable")
tasks_running_waiter: TasksRunningWaiter = client.get_waiter("tasks_running")
tasks_stopped_waiter: TasksStoppedWaiter = client.get_waiter("tasks_stopped")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ecs.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ecs.literals import (
    AgentUpdateStatusType,
    AssignPublicIpType,
    CapacityProviderFieldType,
    CapacityProviderStatusType,
    CapacityProviderUpdateStatusType,
    ClusterFieldType,
    ClusterSettingNameType,
    CompatibilityType,
    ConnectivityType,
    ContainerConditionType,
    ContainerInstanceFieldType,
    ContainerInstanceStatusType,
    DeploymentControllerTypeType,
    DeploymentRolloutStateType,
    DesiredStatusType,
    DeviceCgroupPermissionType,
    EFSAuthorizationConfigIAMType,
    EFSTransitEncryptionType,
    EnvironmentFileTypeType,
    ExecuteCommandLoggingType,
    FirelensConfigurationTypeType,
    HealthStatusType,
    IpcModeType,
    LaunchTypeType,
    ListAccountSettingsPaginatorName,
    ListAttributesPaginatorName,
    ListClustersPaginatorName,
    ListContainerInstancesPaginatorName,
    ListServicesPaginatorName,
    ListTaskDefinitionFamiliesPaginatorName,
    ListTaskDefinitionsPaginatorName,
    ListTasksPaginatorName,
    LogDriverType,
    ManagedAgentNameType,
    ManagedScalingStatusType,
    ManagedTerminationProtectionType,
    NetworkModeType,
    PidModeType,
    PlacementConstraintTypeType,
    PlacementStrategyTypeType,
    PlatformDeviceTypeType,
    PropagateTagsType,
    ProxyConfigurationTypeType,
    ResourceTypeType,
    ScaleUnitType,
    SchedulingStrategyType,
    ScopeType,
    ServiceFieldType,
    ServicesInactiveWaiterName,
    ServicesStableWaiterName,
    SettingNameType,
    SortOrderType,
    StabilityStatusType,
    TargetTypeType,
    TaskDefinitionFamilyStatusType,
    TaskDefinitionFieldType,
    TaskDefinitionPlacementConstraintTypeType,
    TaskDefinitionStatusType,
    TaskFieldType,
    TaskSetFieldType,
    TaskStopCodeType,
    TasksRunningWaiterName,
    TasksStoppedWaiterName,
    TransportProtocolType,
    UlimitNameType,
)

def check_value(value: AgentUpdateStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ecs.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ecs.type_defs import (
    AttachmentStateChangeTypeDef,
    AttachmentTypeDef,
    AttributeTypeDef,
    AutoScalingGroupProviderTypeDef,
    AutoScalingGroupProviderUpdateTypeDef,
    AwsVpcConfigurationTypeDef,
    CapacityProviderStrategyItemTypeDef,
    CapacityProviderTypeDef,
    ClusterConfigurationTypeDef,
    ClusterSettingTypeDef,
    ClusterTypeDef,
    ContainerDefinitionTypeDef,
    ContainerDependencyTypeDef,
    ContainerInstanceTypeDef,
    ContainerOverrideTypeDef,
    ContainerStateChangeTypeDef,
    ContainerTypeDef,
    CreateCapacityProviderResponseTypeDef,
    CreateClusterResponseTypeDef,
    CreateServiceResponseTypeDef,
    CreateTaskSetResponseTypeDef,
    DeleteAccountSettingResponseTypeDef,
    DeleteAttributesResponseTypeDef,
    DeleteCapacityProviderResponseTypeDef,
    DeleteClusterResponseTypeDef,
    DeleteServiceResponseTypeDef,
    DeleteTaskSetResponseTypeDef,
    DeploymentCircuitBreakerTypeDef,
    DeploymentConfigurationTypeDef,
    DeploymentControllerTypeDef,
    DeploymentTypeDef,
    DeregisterContainerInstanceResponseTypeDef,
    DeregisterTaskDefinitionResponseTypeDef,
    DescribeCapacityProvidersResponseTypeDef,
    DescribeClustersResponseTypeDef,
    DescribeContainerInstancesResponseTypeDef,
    DescribeServicesResponseTypeDef,
    DescribeTaskDefinitionResponseTypeDef,
    DescribeTaskSetsResponseTypeDef,
    DescribeTasksResponseTypeDef,
    DeviceTypeDef,
    DiscoverPollEndpointResponseTypeDef,
    DockerVolumeConfigurationTypeDef,
    EFSAuthorizationConfigTypeDef,
    EFSVolumeConfigurationTypeDef,
    EnvironmentFileTypeDef,
    EphemeralStorageTypeDef,
    ExecuteCommandConfigurationTypeDef,
    ExecuteCommandLogConfigurationTypeDef,
    ExecuteCommandResponseTypeDef,
    FSxWindowsFileServerAuthorizationConfigTypeDef,
    FSxWindowsFileServerVolumeConfigurationTypeDef,
    FailureTypeDef,
    FirelensConfigurationTypeDef,
    HealthCheckTypeDef,
    HostEntryTypeDef,
    HostVolumePropertiesTypeDef,
    InferenceAcceleratorOverrideTypeDef,
    InferenceAcceleratorTypeDef,
    KernelCapabilitiesTypeDef,
    KeyValuePairTypeDef,
    LinuxParametersTypeDef,
    ListAccountSettingsResponseTypeDef,
    ListAttributesResponseTypeDef,
    ListClustersResponseTypeDef,
    ListContainerInstancesResponseTypeDef,
    ListServicesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTaskDefinitionFamiliesResponseTypeDef,
    ListTaskDefinitionsResponseTypeDef,
    ListTasksResponseTypeDef,
    LoadBalancerTypeDef,
    LogConfigurationTypeDef,
    ManagedAgentStateChangeTypeDef,
    ManagedAgentTypeDef,
    ManagedScalingTypeDef,
    MountPointTypeDef,
    NetworkBindingTypeDef,
    NetworkConfigurationTypeDef,
    NetworkInterfaceTypeDef,
    PaginatorConfigTypeDef,
    PlacementConstraintTypeDef,
    PlacementStrategyTypeDef,
    PlatformDeviceTypeDef,
    PortMappingTypeDef,
    ProxyConfigurationTypeDef,
    PutAccountSettingDefaultResponseTypeDef,
    PutAccountSettingResponseTypeDef,
    PutAttributesResponseTypeDef,
    PutClusterCapacityProvidersResponseTypeDef,
    RegisterContainerInstanceResponseTypeDef,
    RegisterTaskDefinitionResponseTypeDef,
    RepositoryCredentialsTypeDef,
    ResourceRequirementTypeDef,
    ResourceTypeDef,
    RunTaskResponseTypeDef,
    ScaleTypeDef,
    SecretTypeDef,
    ServiceEventTypeDef,
    ServiceRegistryTypeDef,
    ServiceTypeDef,
    SessionTypeDef,
    SettingTypeDef,
    StartTaskResponseTypeDef,
    StopTaskResponseTypeDef,
    SubmitAttachmentStateChangesResponseTypeDef,
    SubmitContainerStateChangeResponseTypeDef,
    SubmitTaskStateChangeResponseTypeDef,
    SystemControlTypeDef,
    TagTypeDef,
    TaskDefinitionPlacementConstraintTypeDef,
    TaskDefinitionTypeDef,
    TaskOverrideTypeDef,
    TaskSetTypeDef,
    TaskTypeDef,
    TmpfsTypeDef,
    UlimitTypeDef,
    UpdateCapacityProviderResponseTypeDef,
    UpdateClusterResponseTypeDef,
    UpdateClusterSettingsResponseTypeDef,
    UpdateContainerAgentResponseTypeDef,
    UpdateContainerInstancesStateResponseTypeDef,
    UpdateServicePrimaryTaskSetResponseTypeDef,
    UpdateServiceResponseTypeDef,
    UpdateTaskSetResponseTypeDef,
    VersionInfoTypeDef,
    VolumeFromTypeDef,
    VolumeTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AttachmentStateChangeTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ecs` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ecs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
