<p align="center">
  <img src="asset/flow_logo_small.png" alt="logo"/>
</p>

## Informations
Application pour permettre l'excution de task ou de workflow bas sur des scripts Python.
Un task reprsente un ensemble de fonction.
Un flow reprsente un ensemble de fonction o la sortie de la fonction A devient les paramtres de la fonction suivante.


### Prrequis
- Python 3
<br>

## Installation
```console
pip install zpp_flow
```
<br>

## Utilisation

### config

La commande permet de lister les paramtres de configuration. 
Il est possible de les diter en rajoutant le nom du paramtre et sa valeur  la commande

```console
flow config PARAM_NAME VALUE
```

### run

La commande permet d'excuter une task ou un flow. Pour cela, il suffit de renseigner le nom de la task.

```console
flow run TASK_NAME
```

En paramtre supplmentaire, il est possible d'utiliser:
<br>
**--task** pour filtrer sur les task
<br>
**--flow** pour filtrer sur les flow
<br>
**--debug** pour afficher la totalit des retour de code
<br>
**--repeat** INT pour rpeter les actions  intervalles rgulires. Par dfaut l'intervalle est en seconde mais il est possible d'utiliser des cls de temps (m: minutes, h: heures, d: jours)
<br>
**--starter** HH:MM:SS pour dmarrer la task  un moment prcis (les secondes ne sont pas obligatoires)
<br>


### list

La commande permet d'afficher la liste des task et flow disponibles.

```console
flow list
```

### info

La commande permet d'afficher les dtails sur une task ou un flow spcifique.

```console
flow info TASK_NAME
```

### details

La commande permet d'afficher les dtails pour l'ensemble des task et flow disponibles.

```console
flow details
```

### fabric

La commande permet d'ouvrir le rpertoire de script

```console
flow fabric
```

### tree:

La commande permet d'afficher l'arborescence du rpertoire de script

```console
flow tree
```

### pull:

La commande permet de rcuprer un fichier depuis le rpertoire de script

```console
flow pull FILE_NAME
```

Il est possible de rajouter l'option **--output** pour prciser le chemin de sortie

### push:

La commande permet d'envoyer un fichier dans le rpertoire de script

```console
flow push FILE_NAME
```

Il est possible de rajouter l'option **--folder** pour prciser le rpertoire de destination

### pop:

La commande permet de supprimer un script du rpertoire de script

```console
flow pop FILE_NAME
```
<br>

## Cration de script

Pour tre pris en compte par l'application, les scripts doivent une certaine syntaxe.
Chaque fonction est indpendante de base et doit avoir un dcorateur @zpp_flow.task ou @zpp_flow.flow
Le dcorateur peut contenir plusieurs paramtres comme **name** pour dfinir le nom de la task ou **order** pour dfinir l'ordre d'excution.

```python
import zpp_flow

@zpp_flow.task
def hello_world():
	print("Bonjour je suis une task")
```

Dans une fonction, il est possible de dfinir des arguments qui pourront tre utiliss dans le reste du flow

```python
from zpp_flow.core.runner import set_persist

set_persist(argument, value)
```