# Generated by Django 4.1.2 on 2023-01-24 15:14

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("edc_appointment", "0033_alter_appointment_appt_reason_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="AppointmentType",
            fields=[
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "plural_name",
                    models.CharField(max_length=250, null=True, verbose_name="Plural name"),
                ),
                (
                    "display_name",
                    models.CharField(
                        db_index=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        db_index=True,
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.CharField(default="1.0", editable=False, max_length=35),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
            ],
            options={
                "verbose_name": "Appointment Type",
                "verbose_name_plural": "Appointment Types",
            },
        ),
        migrations.AlterField(
            model_name="appointment",
            name="appt_type",
            field=models.CharField(
                choices=[
                    ("clinic", "In clinic"),
                    ("home", "At home"),
                    ("hospital", "In hospital"),
                    ("telephone", "By telephone"),
                ],
                default="clinic",
                max_length=20,
                verbose_name="Appointment type",
            ),
        ),
        migrations.AlterField(
            model_name="historicalappointment",
            name="appt_type",
            field=models.CharField(
                choices=[
                    ("clinic", "In clinic"),
                    ("home", "At home"),
                    ("hospital", "In hospital"),
                    ("telephone", "By telephone"),
                ],
                default="clinic",
                max_length=20,
                verbose_name="Appointment type",
            ),
        ),
        migrations.AddField(
            model_name="appointment",
            name="appt_type_new",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_appointment.appointmenttype",
                verbose_name="Appointment type",
            ),
        ),
        migrations.AddField(
            model_name="historicalappointment",
            name="appt_type_new",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_appointment.appointmenttype",
                verbose_name="Appointment type",
            ),
        ),
    ]
