# Generated by Django 4.2.7 on 2023-12-04 22:19

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("edc_appointment", "0046_infosources"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="appointment",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
        ),
        migrations.AlterModelOptions(
            name="appointmenttype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Appointment Type",
                "verbose_name_plural": "Appointment Types",
            },
        ),
        migrations.AlterModelOptions(
            name="infosources",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Information Source",
                "verbose_name_plural": "Information Sources",
            },
        ),
        migrations.RemoveIndex(
            model_name="appointment",
            name="edc_appoint_subject_56a935_idx",
        ),
        migrations.RemoveIndex(
            model_name="infosources",
            name="edc_appoint_id_ffb4c6_idx",
        ),
        migrations.AlterUniqueTogether(
            name="appointment",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="appointment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="appointment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalappointment",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalappointment",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="appointmenttype",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="appointmenttype",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="appointmenttype",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="infosources",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="infosources",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="infosources",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=["appt_datetime"], name="edc_appoint_appt_da_7c2e7a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(fields=["appt_status"], name="edc_appoint_appt_st_57c8d0_idx"),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=["timepoint", "visit_code_sequence"],
                name="edc_appoint_timepoi_c6dbd3_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=["subject_identifier", "appt_reason"],
                name="edc_appoint_subject_e1b995_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=[
                    "site",
                    "subject_identifier",
                    "timepoint",
                    "visit_code_sequence",
                ],
                name="edc_appoint_site_id_312976_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "appt_reason",
                    "timepoint",
                    "visit_code_sequence",
                ],
                name="edc_appoint_subject_f115dc_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=["modified", "created"], name="edc_appoint_modifie_fa1fe2_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="appointment",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_appoint_user_mo_9cfb72_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="appointmenttype",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_appoint_display_386d1e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="infosources",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_appoint_display_38737a_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="appointment",
            constraint=models.UniqueConstraint(
                fields=(
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "timepoint",
                    "visit_code_sequence",
                ),
                name="unique_edc_appointment_appointment_100",
            ),
        ),
        migrations.AddConstraint(
            model_name="appointment",
            constraint=models.UniqueConstraint(
                fields=(
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "appt_datetime",
                ),
                name="unique_edc_appointment_appointment_200",
            ),
        ),
    ]
