# Generated by Django 2.0.7 on 2018-07-17 12:42

import _socket
import django_audit_fields.fields.uuid_auto_field
import django_revision.revision_field
from django.db import migrations, models

import edc_model.validators.date
import edc_model_fields.fields.hostname_modification_field
import edc_model_fields.fields.other_charfield
import edc_model_fields.fields.userfield
import edc_protocol.validators
import django.utils.timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="SubjectOffstudy",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Subject Identifier"
                    ),
                ),
                (
                    "offstudy_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Off-study date and time",
                    ),
                ),
                (
                    "offstudy_reason",
                    models.CharField(
                        choices=[
                            ("lost", "Lost to follow-up"),
                            ("completed protocol", "Completed protocol"),
                            ("consent_withdrawal", "Completed protocol"),
                            ("dead", "Deceased"),
                        ],
                        max_length=125,
                        verbose_name="Please code the primary reason participant taken off-study",
                    ),
                ),
                (
                    "offstudy_reason_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
            ],
            options={"abstract": False},
        )
    ]
