# Generated by Django 6.0 on 2025-03-12 10:41

import django.db.models.deletion
import django.db.models.manager
from django.db import migrations, models

import edc_pharmacy.models.stock.allocation
import edc_pharmacy.models.stock.confirmation_at_site
import edc_pharmacy.models.stock.confirmation_at_site_item
import edc_pharmacy.models.stock.dispense
import edc_pharmacy.models.stock.dispense_item
import edc_sites.managers


class Migration(migrations.Migration):

    dependencies = [
        ("edc_pharmacy", "0060_alter_container_max_per_subject_and_more"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="historicalstocktransferconfirmation",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Stock Transfer Site Confirmation",
                "verbose_name_plural": "historical Stock Transfer Site Confirmations",
            },
        ),
        migrations.AlterModelOptions(
            name="stocktransferconfirmation",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Stock Transfer Site Confirmation",
                "verbose_name_plural": "Stock Transfer Site Confirmations",
            },
        ),
        migrations.AlterModelManagers(
            name="allocation",
            managers=[
                ("objects", edc_pharmacy.models.stock.allocation.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="dispense",
            managers=[
                ("objects", edc_pharmacy.models.stock.dispense.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="dispenseitem",
            managers=[
                ("objects", edc_pharmacy.models.stock.dispense_item.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="stocktransferconfirmation",
            managers=[
                ("objects", edc_pharmacy.models.stock.confirmation_at_site.Manager()),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="stocktransferconfirmationitem",
            managers=[
                (
                    "objects",
                    edc_pharmacy.models.stock.confirmation_at_site_item.Manager(),
                ),
                ("on_site", edc_sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="storagebin",
            managers=[
                ("on_site", edc_sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="storagebinitem",
            managers=[
                ("on_site", edc_sites.managers.CurrentSiteManager()),
                ("objects", django.db.models.manager.Manager()),
            ],
        ),
        migrations.AddField(
            model_name="allocation",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="dispense",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="dispenseitem",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalallocation",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispense",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispenseitem",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="allocated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="transferred",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="historicalstocktransferconfirmation",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransferconfirmationitem",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalstoragebin",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="historicalstoragebinitem",
            name="site",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="allocated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="stock",
            name="transferred",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="stocktransferconfirmation",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="stocktransferconfirmationitem",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="storagebin",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="storagebinitem",
            name="site",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="sites.site",
            ),
        ),
    ]
