import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#base64_encode Config#base64_encode}.
     *
     * @stability stable
     */
    readonly base64Encode?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#boundary Config#boundary}.
     *
     * @stability stable
     */
    readonly boundary?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#gzip Config#gzip}.
     *
     * @stability stable
     */
    readonly gzip?: boolean | cdktf.IResolvable;
    /**
     * part block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#part Config#part}
     *
     * @stability stable
     */
    readonly part: ConfigPart[];
}
/**
 * @stability stable
 */
export interface ConfigPart {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#content Config#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#content_type Config#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#filename Config#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html#merge_type Config#merge_type}.
     *
     * @stability stable
     */
    readonly mergeType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html cloudinit_config}.
 *
 * @stability stable
 */
export declare class Config extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/cloudinit/r/config.html cloudinit_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConfigConfig);
    private _base64Encode?;
    /**
     * @stability stable
     */
    get base64Encode(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set base64Encode(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetBase64Encode(): void;
    /**
     * @stability stable
     */
    get base64EncodeInput(): boolean | cdktf.IResolvable | undefined;
    private _boundary?;
    /**
     * @stability stable
     */
    get boundary(): string | undefined;
    /**
     * @stability stable
     */
    set boundary(value: string | undefined);
    /**
     * @stability stable
     */
    resetBoundary(): void;
    /**
     * @stability stable
     */
    get boundaryInput(): string | undefined;
    private _gzip?;
    /**
     * @stability stable
     */
    get gzip(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set gzip(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetGzip(): void;
    /**
     * @stability stable
     */
    get gzipInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get rendered(): string;
    private _part?;
    /**
     * @stability stable
     */
    get part(): ConfigPart[];
    /**
     * @stability stable
     */
    set part(value: ConfigPart[]);
    /**
     * @stability stable
     */
    get partInput(): ConfigPart[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
