# Cloudru Resource Provider

The Cloudru Resource Provider lets you manage [Cloud.ru Advanced](https://cloud.ru/advanced) resources.

## Installing

This package is available for several languages/platforms:

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```bash
npm install @pulumi/cloudru
```

or `yarn`:

```bash
yarn add @pulumi/cloudru
```

### Python

To use from Python, install using `pip`:

```bash
pip install pulumi_cloudru
```

### Go

To use from Go, use `go get` to grab the latest version of the library:

```bash
go get github.com/pulumi/pulumi-cloudru/sdk/go/...
```

### .NET

To use from .NET, install using `dotnet add package`:

Temporary unavailable
```bash
dotnet add package Pulumi.Cloudru
```

## Configuration

The following configuration points are available for the `cloudru` provider:

- `cloudru:region` (environment: `CLOUDRU_REGION`) - the region in which to deploy resources

## Reference

For detailed reference documentation, please visit [the Pulumi registry](https://www.pulumi.com/registry/packages/cloudru/api-docs/).
