# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceDiscoveryRuleArgs', 'ServiceDiscoveryRule']

@pulumi.input_type
class ServiceDiscoveryRuleArgs:
    def __init__(__self__, *,
                 discovery_rules: pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]],
                 log_file_suffixes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name_rules: pulumi.Input['ServiceDiscoveryRuleNameRulesArgs'],
                 service_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_path_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceDiscoveryRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]] discovery_rules: Specifies the discovery rule. If the array contains multiple conditions, only the
               processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
               `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
               the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
               `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
               whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
               to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
               on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_file_suffixes: Specifies the log file suffix. This is a list of strings.
               The values can be: **log**, **trace**, and **out**.
        :param pulumi.Input['ServiceDiscoveryRuleNameRulesArgs'] name_rules: Specifies the naming rules for discovered services and applications.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] service_type: Specifies the service type, which is used only for rule classification and UI display.
               You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        :param pulumi.Input[_builtins.bool] detect_log_enabled: Specifies whether to enable log collection. The default value is true.
        :param pulumi.Input[_builtins.bool] discovery_rule_enabled: Specifies whether the rule is enabled. The default value is true.
        :param pulumi.Input[_builtins.bool] is_default_rule: Specifies whether the rule is the default one. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]] log_path_rules: Specifies the log path configuration rule. If cmdLineHash is a fixed string,
               logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
               .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
               value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        :param pulumi.Input[_builtins.str] name: Specifies the rule name, which contains 4 to 63 characters. It must start
               with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        :param pulumi.Input[_builtins.int] priority: Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        :param pulumi.Input[_builtins.str] region: The region in which to create the service discovery rule resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "discovery_rules", discovery_rules)
        pulumi.set(__self__, "log_file_suffixes", log_file_suffixes)
        pulumi.set(__self__, "name_rules", name_rules)
        pulumi.set(__self__, "service_type", service_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_log_enabled is not None:
            pulumi.set(__self__, "detect_log_enabled", detect_log_enabled)
        if discovery_rule_enabled is not None:
            pulumi.set(__self__, "discovery_rule_enabled", discovery_rule_enabled)
        if is_default_rule is not None:
            pulumi.set(__self__, "is_default_rule", is_default_rule)
        if log_path_rules is not None:
            pulumi.set(__self__, "log_path_rules", log_path_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="discoveryRules")
    def discovery_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]]:
        """
        Specifies the discovery rule. If the array contains multiple conditions, only the
        processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
        `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
        the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
        `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
        whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
        to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
        on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        """
        return pulumi.get(self, "discovery_rules")

    @discovery_rules.setter
    def discovery_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]]):
        pulumi.set(self, "discovery_rules", value)

    @_builtins.property
    @pulumi.getter(name="logFileSuffixes")
    def log_file_suffixes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the log file suffix. This is a list of strings.
        The values can be: **log**, **trace**, and **out**.
        """
        return pulumi.get(self, "log_file_suffixes")

    @log_file_suffixes.setter
    def log_file_suffixes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "log_file_suffixes", value)

    @_builtins.property
    @pulumi.getter(name="nameRules")
    def name_rules(self) -> pulumi.Input['ServiceDiscoveryRuleNameRulesArgs']:
        """
        Specifies the naming rules for discovered services and applications.
        The object structure is documented below.
        """
        return pulumi.get(self, "name_rules")

    @name_rules.setter
    def name_rules(self, value: pulumi.Input['ServiceDiscoveryRuleNameRulesArgs']):
        pulumi.set(self, "name_rules", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the service type, which is used only for rule classification and UI display.
        You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectLogEnabled")
    def detect_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable log collection. The default value is true.
        """
        return pulumi.get(self, "detect_log_enabled")

    @detect_log_enabled.setter
    def detect_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detect_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="discoveryRuleEnabled")
    def discovery_rule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the rule is enabled. The default value is true.
        """
        return pulumi.get(self, "discovery_rule_enabled")

    @discovery_rule_enabled.setter
    def discovery_rule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discovery_rule_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultRule")
    def is_default_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the rule is the default one. The default value is false.
        """
        return pulumi.get(self, "is_default_rule")

    @is_default_rule.setter
    def is_default_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_rule", value)

    @_builtins.property
    @pulumi.getter(name="logPathRules")
    def log_path_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]]:
        """
        Specifies the log path configuration rule. If cmdLineHash is a fixed string,
        logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
        .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
        value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        """
        return pulumi.get(self, "log_path_rules")

    @log_path_rules.setter
    def log_path_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]]):
        pulumi.set(self, "log_path_rules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the rule name, which contains 4 to 63 characters. It must start
        with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the service discovery rule resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServiceDiscoveryRuleState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]]] = None,
                 is_default_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_file_suffixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_path_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_rules: Optional[pulumi.Input['ServiceDiscoveryRuleNameRulesArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceDiscoveryRule resources.
        :param pulumi.Input[_builtins.bool] detect_log_enabled: Specifies whether to enable log collection. The default value is true.
        :param pulumi.Input[_builtins.bool] discovery_rule_enabled: Specifies whether the rule is enabled. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]] discovery_rules: Specifies the discovery rule. If the array contains multiple conditions, only the
               processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
               `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
               the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
               `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
               whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
               to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
               on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        :param pulumi.Input[_builtins.bool] is_default_rule: Specifies whether the rule is the default one. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_file_suffixes: Specifies the log file suffix. This is a list of strings.
               The values can be: **log**, **trace**, and **out**.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]] log_path_rules: Specifies the log path configuration rule. If cmdLineHash is a fixed string,
               logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
               .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
               value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        :param pulumi.Input[_builtins.str] name: Specifies the rule name, which contains 4 to 63 characters. It must start
               with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        :param pulumi.Input['ServiceDiscoveryRuleNameRulesArgs'] name_rules: Specifies the naming rules for discovered services and applications.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] priority: Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        :param pulumi.Input[_builtins.str] region: The region in which to create the service discovery rule resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_id: The rule ID in uuid format.
        :param pulumi.Input[_builtins.str] service_type: Specifies the service type, which is used only for rule classification and UI display.
               You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_log_enabled is not None:
            pulumi.set(__self__, "detect_log_enabled", detect_log_enabled)
        if discovery_rule_enabled is not None:
            pulumi.set(__self__, "discovery_rule_enabled", discovery_rule_enabled)
        if discovery_rules is not None:
            pulumi.set(__self__, "discovery_rules", discovery_rules)
        if is_default_rule is not None:
            pulumi.set(__self__, "is_default_rule", is_default_rule)
        if log_file_suffixes is not None:
            pulumi.set(__self__, "log_file_suffixes", log_file_suffixes)
        if log_path_rules is not None:
            pulumi.set(__self__, "log_path_rules", log_path_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_rules is not None:
            pulumi.set(__self__, "name_rules", name_rules)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectLogEnabled")
    def detect_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable log collection. The default value is true.
        """
        return pulumi.get(self, "detect_log_enabled")

    @detect_log_enabled.setter
    def detect_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detect_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="discoveryRuleEnabled")
    def discovery_rule_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the rule is enabled. The default value is true.
        """
        return pulumi.get(self, "discovery_rule_enabled")

    @discovery_rule_enabled.setter
    def discovery_rule_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "discovery_rule_enabled", value)

    @_builtins.property
    @pulumi.getter(name="discoveryRules")
    def discovery_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]]]:
        """
        Specifies the discovery rule. If the array contains multiple conditions, only the
        processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
        `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
        the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
        `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
        whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
        to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
        on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        """
        return pulumi.get(self, "discovery_rules")

    @discovery_rules.setter
    def discovery_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleDiscoveryRuleArgs']]]]):
        pulumi.set(self, "discovery_rules", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultRule")
    def is_default_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the rule is the default one. The default value is false.
        """
        return pulumi.get(self, "is_default_rule")

    @is_default_rule.setter
    def is_default_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_rule", value)

    @_builtins.property
    @pulumi.getter(name="logFileSuffixes")
    def log_file_suffixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the log file suffix. This is a list of strings.
        The values can be: **log**, **trace**, and **out**.
        """
        return pulumi.get(self, "log_file_suffixes")

    @log_file_suffixes.setter
    def log_file_suffixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_file_suffixes", value)

    @_builtins.property
    @pulumi.getter(name="logPathRules")
    def log_path_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]]:
        """
        Specifies the log path configuration rule. If cmdLineHash is a fixed string,
        logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
        .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
        value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        """
        return pulumi.get(self, "log_path_rules")

    @log_path_rules.setter
    def log_path_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDiscoveryRuleLogPathRuleArgs']]]]):
        pulumi.set(self, "log_path_rules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the rule name, which contains 4 to 63 characters. It must start
        with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameRules")
    def name_rules(self) -> Optional[pulumi.Input['ServiceDiscoveryRuleNameRulesArgs']]:
        """
        Specifies the naming rules for discovered services and applications.
        The object structure is documented below.
        """
        return pulumi.get(self, "name_rules")

    @name_rules.setter
    def name_rules(self, value: Optional[pulumi.Input['ServiceDiscoveryRuleNameRulesArgs']]):
        pulumi.set(self, "name_rules", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the service discovery rule resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule ID in uuid format.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the service type, which is used only for rule classification and UI display.
        You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_type", value)


@pulumi.type_token("sbercloud:Aom/serviceDiscoveryRule:ServiceDiscoveryRule")
class ServiceDiscoveryRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleDiscoveryRuleArgs', 'ServiceDiscoveryRuleDiscoveryRuleArgsDict']]]]] = None,
                 is_default_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_file_suffixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_path_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleLogPathRuleArgs', 'ServiceDiscoveryRuleLogPathRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_rules: Optional[pulumi.Input[Union['ServiceDiscoveryRuleNameRulesArgs', 'ServiceDiscoveryRuleNameRulesArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AOM service discovery rule resource within SberCloud.

        ## Example Usage

        ### Basic example

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        discovery_rule = sbercloud.aom.ServiceDiscoveryRule("discovery_rule",
            name="test-rule",
            priority=9999,
            detect_log_enabled=True,
            discovery_rule_enabled=True,
            is_default_rule=False,
            log_file_suffixes=["log"],
            service_type="Java",
            discovery_rules=[{
                "check_contents": ["java"],
                "check_mode": "contain",
                "check_type": "cmdLine",
            }],
            log_path_rules=[{
                "name_type": "cmdLineHash",
                "args": ["java"],
                "values": ["/tmp/log"],
            }],
            name_rules={
                "service_name_rules": [{
                    "name_type": "str",
                    "args": ["java"],
                }],
                "application_name_rules": [{
                    "name_type": "str",
                    "args": ["java"],
                }],
            })
        ```

        ## Import

        AOM service discovery rules can be imported using the `name`, e.g.

        ```sh
        $ pulumi import sbercloud:Aom/serviceDiscoveryRule:ServiceDiscoveryRule alarm_rule rule_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] detect_log_enabled: Specifies whether to enable log collection. The default value is true.
        :param pulumi.Input[_builtins.bool] discovery_rule_enabled: Specifies whether the rule is enabled. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleDiscoveryRuleArgs', 'ServiceDiscoveryRuleDiscoveryRuleArgsDict']]]] discovery_rules: Specifies the discovery rule. If the array contains multiple conditions, only the
               processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
               `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
               the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
               `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
               whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
               to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
               on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        :param pulumi.Input[_builtins.bool] is_default_rule: Specifies whether the rule is the default one. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_file_suffixes: Specifies the log file suffix. This is a list of strings.
               The values can be: **log**, **trace**, and **out**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleLogPathRuleArgs', 'ServiceDiscoveryRuleLogPathRuleArgsDict']]]] log_path_rules: Specifies the log path configuration rule. If cmdLineHash is a fixed string,
               logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
               .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
               value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        :param pulumi.Input[_builtins.str] name: Specifies the rule name, which contains 4 to 63 characters. It must start
               with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        :param pulumi.Input[Union['ServiceDiscoveryRuleNameRulesArgs', 'ServiceDiscoveryRuleNameRulesArgsDict']] name_rules: Specifies the naming rules for discovered services and applications.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] priority: Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        :param pulumi.Input[_builtins.str] region: The region in which to create the service discovery rule resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] service_type: Specifies the service type, which is used only for rule classification and UI display.
               You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDiscoveryRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AOM service discovery rule resource within SberCloud.

        ## Example Usage

        ### Basic example

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        discovery_rule = sbercloud.aom.ServiceDiscoveryRule("discovery_rule",
            name="test-rule",
            priority=9999,
            detect_log_enabled=True,
            discovery_rule_enabled=True,
            is_default_rule=False,
            log_file_suffixes=["log"],
            service_type="Java",
            discovery_rules=[{
                "check_contents": ["java"],
                "check_mode": "contain",
                "check_type": "cmdLine",
            }],
            log_path_rules=[{
                "name_type": "cmdLineHash",
                "args": ["java"],
                "values": ["/tmp/log"],
            }],
            name_rules={
                "service_name_rules": [{
                    "name_type": "str",
                    "args": ["java"],
                }],
                "application_name_rules": [{
                    "name_type": "str",
                    "args": ["java"],
                }],
            })
        ```

        ## Import

        AOM service discovery rules can be imported using the `name`, e.g.

        ```sh
        $ pulumi import sbercloud:Aom/serviceDiscoveryRule:ServiceDiscoveryRule alarm_rule rule_name
        ```

        :param str resource_name: The name of the resource.
        :param ServiceDiscoveryRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDiscoveryRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 discovery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleDiscoveryRuleArgs', 'ServiceDiscoveryRuleDiscoveryRuleArgsDict']]]]] = None,
                 is_default_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_file_suffixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_path_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleLogPathRuleArgs', 'ServiceDiscoveryRuleLogPathRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_rules: Optional[pulumi.Input[Union['ServiceDiscoveryRuleNameRulesArgs', 'ServiceDiscoveryRuleNameRulesArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDiscoveryRuleArgs.__new__(ServiceDiscoveryRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["detect_log_enabled"] = detect_log_enabled
            __props__.__dict__["discovery_rule_enabled"] = discovery_rule_enabled
            if discovery_rules is None and not opts.urn:
                raise TypeError("Missing required property 'discovery_rules'")
            __props__.__dict__["discovery_rules"] = discovery_rules
            __props__.__dict__["is_default_rule"] = is_default_rule
            if log_file_suffixes is None and not opts.urn:
                raise TypeError("Missing required property 'log_file_suffixes'")
            __props__.__dict__["log_file_suffixes"] = log_file_suffixes
            __props__.__dict__["log_path_rules"] = log_path_rules
            __props__.__dict__["name"] = name
            if name_rules is None and not opts.urn:
                raise TypeError("Missing required property 'name_rules'")
            __props__.__dict__["name_rules"] = name_rules
            __props__.__dict__["priority"] = priority
            __props__.__dict__["region"] = region
            if service_type is None and not opts.urn:
                raise TypeError("Missing required property 'service_type'")
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["rule_id"] = None
        super(ServiceDiscoveryRule, __self__).__init__(
            'sbercloud:Aom/serviceDiscoveryRule:ServiceDiscoveryRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detect_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            discovery_rule_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            discovery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleDiscoveryRuleArgs', 'ServiceDiscoveryRuleDiscoveryRuleArgsDict']]]]] = None,
            is_default_rule: Optional[pulumi.Input[_builtins.bool]] = None,
            log_file_suffixes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_path_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleLogPathRuleArgs', 'ServiceDiscoveryRuleLogPathRuleArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_rules: Optional[pulumi.Input[Union['ServiceDiscoveryRuleNameRulesArgs', 'ServiceDiscoveryRuleNameRulesArgsDict']]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceDiscoveryRule':
        """
        Get an existing ServiceDiscoveryRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] detect_log_enabled: Specifies whether to enable log collection. The default value is true.
        :param pulumi.Input[_builtins.bool] discovery_rule_enabled: Specifies whether the rule is enabled. The default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleDiscoveryRuleArgs', 'ServiceDiscoveryRuleDiscoveryRuleArgsDict']]]] discovery_rules: Specifies the discovery rule. If the array contains multiple conditions, only the
               processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
               `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
               the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
               `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
               whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
               to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
               on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        :param pulumi.Input[_builtins.bool] is_default_rule: Specifies whether the rule is the default one. The default value is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] log_file_suffixes: Specifies the log file suffix. This is a list of strings.
               The values can be: **log**, **trace**, and **out**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDiscoveryRuleLogPathRuleArgs', 'ServiceDiscoveryRuleLogPathRuleArgsDict']]]] log_path_rules: Specifies the log path configuration rule. If cmdLineHash is a fixed string,
               logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
               .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
               value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        :param pulumi.Input[_builtins.str] name: Specifies the rule name, which contains 4 to 63 characters. It must start
               with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        :param pulumi.Input[Union['ServiceDiscoveryRuleNameRulesArgs', 'ServiceDiscoveryRuleNameRulesArgsDict']] name_rules: Specifies the naming rules for discovered services and applications.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] priority: Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        :param pulumi.Input[_builtins.str] region: The region in which to create the service discovery rule resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] rule_id: The rule ID in uuid format.
        :param pulumi.Input[_builtins.str] service_type: Specifies the service type, which is used only for rule classification and UI display.
               You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDiscoveryRuleState.__new__(_ServiceDiscoveryRuleState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["detect_log_enabled"] = detect_log_enabled
        __props__.__dict__["discovery_rule_enabled"] = discovery_rule_enabled
        __props__.__dict__["discovery_rules"] = discovery_rules
        __props__.__dict__["is_default_rule"] = is_default_rule
        __props__.__dict__["log_file_suffixes"] = log_file_suffixes
        __props__.__dict__["log_path_rules"] = log_path_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["name_rules"] = name_rules
        __props__.__dict__["priority"] = priority
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["service_type"] = service_type
        return ServiceDiscoveryRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detectLogEnabled")
    def detect_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable log collection. The default value is true.
        """
        return pulumi.get(self, "detect_log_enabled")

    @_builtins.property
    @pulumi.getter(name="discoveryRuleEnabled")
    def discovery_rule_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the rule is enabled. The default value is true.
        """
        return pulumi.get(self, "discovery_rule_enabled")

    @_builtins.property
    @pulumi.getter(name="discoveryRules")
    def discovery_rules(self) -> pulumi.Output[Sequence['outputs.ServiceDiscoveryRuleDiscoveryRule']]:
        """
        Specifies the discovery rule. If the array contains multiple conditions, only the
        processes that meet all the conditions will be matched. If the value of `check_type` is **cmdLine**, set the value of
        `check_mode` to **contain**. `check_content` is in the format of ["xxx"], indicating that the process must contain
        the xxx parameter. If the value of `check_type` is **env**, set the value of `check_mode` to **contain**.
        `check_content` is in the format of ["k1","v1"], indicating that the process must contain the environment variable
        whose name is k1 and value is v1. If the value of `check_type` is **scope**, set the value of `check_mode`
        to **equals**. `check_content` is in the format of ["hostId1","hostId2"], indicating that the rule takes effect only
        on specified nodes. If no nodes are specified, the rule applies to all nodes of the project.
        """
        return pulumi.get(self, "discovery_rules")

    @_builtins.property
    @pulumi.getter(name="isDefaultRule")
    def is_default_rule(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the rule is the default one. The default value is false.
        """
        return pulumi.get(self, "is_default_rule")

    @_builtins.property
    @pulumi.getter(name="logFileSuffixes")
    def log_file_suffixes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the log file suffix. This is a list of strings.
        The values can be: **log**, **trace**, and **out**.
        """
        return pulumi.get(self, "log_file_suffixes")

    @_builtins.property
    @pulumi.getter(name="logPathRules")
    def log_path_rules(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceDiscoveryRuleLogPathRule']]]:
        """
        Specifies the log path configuration rule. If cmdLineHash is a fixed string,
        logs in the specified log path or log file are collected. Otherwise, only the files whose names end with
        .log or .trace are collected. If the value of `name_type` is **cmdLineHash**, args is in the format of ["00001"] and
        value is in the format of ["/xxx/xx.log"], indicating that the log path is /xxx/xx.log when the startup command is 00001.
        """
        return pulumi.get(self, "log_path_rules")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the rule name, which contains 4 to 63 characters. It must start
        with a lowercase letter but cannot end with a hyphen (-). Only digits, lowercase letters, and hyphens are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameRules")
    def name_rules(self) -> pulumi.Output['outputs.ServiceDiscoveryRuleNameRules']:
        """
        Specifies the naming rules for discovered services and applications.
        The object structure is documented below.
        """
        return pulumi.get(self, "name_rules")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the rule priority. Value range: 1 to 9999. The default value is 9999.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the service discovery rule resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The rule ID in uuid format.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the service type, which is used only for rule classification and UI display.
        You can enter any field. For example, enter Java or Python by technology stack, or enter collector or database by function.
        """
        return pulumi.get(self, "service_type")

