# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigAclPolicyAssociateArgs', 'ApigAclPolicyAssociate']

@pulumi.input_type
class ApigAclPolicyAssociateArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 policy_id: pulumi.Input[_builtins.str],
                 publish_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigAclPolicyAssociate resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the APIs and the ACL policy belong.
        :param pulumi.Input[_builtins.str] policy_id: The ACL Policy ID for APIs binding.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] publish_ids: The publish IDs corresponding to the APIs bound by the ACL policy.
        :param pulumi.Input[_builtins.str] region: The region where the ACL policy and the APIs are located.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "publish_ids", publish_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the APIs and the ACL policy belong.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ACL Policy ID for APIs binding.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The publish IDs corresponding to the APIs bound by the ACL policy.
        """
        return pulumi.get(self, "publish_ids")

    @publish_ids.setter
    def publish_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "publish_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the ACL policy and the APIs are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigAclPolicyAssociateState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigAclPolicyAssociate resources.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the APIs and the ACL policy belong.
        :param pulumi.Input[_builtins.str] policy_id: The ACL Policy ID for APIs binding.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] publish_ids: The publish IDs corresponding to the APIs bound by the ACL policy.
        :param pulumi.Input[_builtins.str] region: The region where the ACL policy and the APIs are located.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if publish_ids is not None:
            pulumi.set(__self__, "publish_ids", publish_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the APIs and the ACL policy belong.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL Policy ID for APIs binding.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The publish IDs corresponding to the APIs bound by the ACL policy.
        """
        return pulumi.get(self, "publish_ids")

    @publish_ids.setter
    def publish_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "publish_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the ACL policy and the APIs are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/apigAclPolicyAssociate:ApigAclPolicyAssociate")
class ApigAclPolicyAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigAclPolicyAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the APIs and the ACL policy belong.
        :param pulumi.Input[_builtins.str] policy_id: The ACL Policy ID for APIs binding.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] publish_ids: The publish IDs corresponding to the APIs bound by the ACL policy.
        :param pulumi.Input[_builtins.str] region: The region where the ACL policy and the APIs are located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigAclPolicyAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigAclPolicyAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigAclPolicyAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigAclPolicyAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigAclPolicyAssociateArgs.__new__(ApigAclPolicyAssociateArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            if publish_ids is None and not opts.urn:
                raise TypeError("Missing required property 'publish_ids'")
            __props__.__dict__["publish_ids"] = publish_ids
            __props__.__dict__["region"] = region
        super(ApigAclPolicyAssociate, __self__).__init__(
            'sbercloud:index/apigAclPolicyAssociate:ApigAclPolicyAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigAclPolicyAssociate':
        """
        Get an existing ApigAclPolicyAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the APIs and the ACL policy belong.
        :param pulumi.Input[_builtins.str] policy_id: The ACL Policy ID for APIs binding.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] publish_ids: The publish IDs corresponding to the APIs bound by the ACL policy.
        :param pulumi.Input[_builtins.str] region: The region where the ACL policy and the APIs are located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigAclPolicyAssociateState.__new__(_ApigAclPolicyAssociateState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["publish_ids"] = publish_ids
        __props__.__dict__["region"] = region
        return ApigAclPolicyAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the APIs and the ACL policy belong.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ACL Policy ID for APIs binding.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The publish IDs corresponding to the APIs bound by the ACL policy.
        """
        return pulumi.get(self, "publish_ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the ACL policy and the APIs are located.
        """
        return pulumi.get(self, "region")

