# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigApplicationAclArgs', 'ApigApplicationAcl']

@pulumi.input_type
class ApigApplicationAclArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigApplicationAcl resource.
        :param pulumi.Input[_builtins.str] application_id: The ID of the application to which the ACL rules belong.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] type: The ACL type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The ACL values.
        :param pulumi.Input[_builtins.str] region: The region where the application and ACL rules are located.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the application to which the ACL rules belong.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The ACL type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The ACL values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application and ACL rules are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigApplicationAclState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApigApplicationAcl resources.
        :param pulumi.Input[_builtins.str] application_id: The ID of the application to which the ACL rules belong.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] region: The region where the application and ACL rules are located.
        :param pulumi.Input[_builtins.str] type: The ACL type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The ACL values.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the application to which the ACL rules belong.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application and ACL rules are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ACL values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("sbercloud:index/apigApplicationAcl:ApigApplicationAcl")
class ApigApplicationAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Create a ApigApplicationAcl resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The ID of the application to which the ACL rules belong.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] region: The region where the application and ACL rules are located.
        :param pulumi.Input[_builtins.str] type: The ACL type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The ACL values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigApplicationAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigApplicationAcl resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigApplicationAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigApplicationAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigApplicationAclArgs.__new__(ApigApplicationAclArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if values is None and not opts.urn:
                raise TypeError("Missing required property 'values'")
            __props__.__dict__["values"] = values
        super(ApigApplicationAcl, __self__).__init__(
            'sbercloud:index/apigApplicationAcl:ApigApplicationAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ApigApplicationAcl':
        """
        Get an existing ApigApplicationAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The ID of the application to which the ACL rules belong.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] region: The region where the application and ACL rules are located.
        :param pulumi.Input[_builtins.str] type: The ACL type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The ACL values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigApplicationAclState.__new__(_ApigApplicationAclState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["values"] = values
        return ApigApplicationAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the application to which the ACL rules belong.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the application and ACL rules are located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The ACL type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The ACL values.
        """
        return pulumi.get(self, "values")

