# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigApplicationQuotaArgs', 'ApigApplicationQuota']

@pulumi.input_type
class ApigApplicationQuotaArgs:
    def __init__(__self__, *,
                 call_limits: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 time_interval: pulumi.Input[_builtins.int],
                 time_unit: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigApplicationQuota resource.
        :param pulumi.Input[_builtins.int] call_limits: Specifies the access limit of the application quota.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the application quota belongs.
        :param pulumi.Input[_builtins.int] time_interval: Specifies the limited time value for flow control of the application quota.
        :param pulumi.Input[_builtins.str] time_unit: Specifies the limited time unit of the application quota.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application quota.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the application quota.
        """
        pulumi.set(__self__, "call_limits", call_limits)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "time_interval", time_interval)
        pulumi.set(__self__, "time_unit", time_unit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="callLimits")
    def call_limits(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the access limit of the application quota.
        """
        return pulumi.get(self, "call_limits")

    @call_limits.setter
    def call_limits(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "call_limits", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the dedicated instance to which the application quota belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the limited time value for flow control of the application quota.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "time_interval", value)

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the limited time unit of the application quota.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_unit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the application quota.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the application quota.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigApplicationQuotaState:
    def __init__(__self__, *,
                 bind_num: Optional[pulumi.Input[_builtins.int]] = None,
                 call_limits: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 time_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigApplicationQuota resources.
        :param pulumi.Input[_builtins.int] bind_num: The number of bound APPs.
        :param pulumi.Input[_builtins.int] call_limits: Specifies the access limit of the application quota.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the application quota, in RFC3339 format.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application quota.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the application quota belongs.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the application quota.
        :param pulumi.Input[_builtins.int] time_interval: Specifies the limited time value for flow control of the application quota.
        :param pulumi.Input[_builtins.str] time_unit: Specifies the limited time unit of the application quota.
        """
        if bind_num is not None:
            pulumi.set(__self__, "bind_num", bind_num)
        if call_limits is not None:
            pulumi.set(__self__, "call_limits", call_limits)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="bindNum")
    def bind_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bound APPs.
        """
        return pulumi.get(self, "bind_num")

    @bind_num.setter
    def bind_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bind_num", value)

    @_builtins.property
    @pulumi.getter(name="callLimits")
    def call_limits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the access limit of the application quota.
        """
        return pulumi.get(self, "call_limits")

    @call_limits.setter
    def call_limits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "call_limits", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the application quota, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the application quota.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the dedicated instance to which the application quota belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the application quota.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the limited time value for flow control of the application quota.
        """
        return pulumi.get(self, "time_interval")

    @time_interval.setter
    def time_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_interval", value)

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the limited time unit of the application quota.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_unit", value)


@pulumi.type_token("sbercloud:index/apigApplicationQuota:ApigApplicationQuota")
class ApigApplicationQuota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 call_limits: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 time_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigApplicationQuota resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] call_limits: Specifies the access limit of the application quota.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application quota.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the application quota belongs.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the application quota.
        :param pulumi.Input[_builtins.int] time_interval: Specifies the limited time value for flow control of the application quota.
        :param pulumi.Input[_builtins.str] time_unit: Specifies the limited time unit of the application quota.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigApplicationQuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigApplicationQuota resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigApplicationQuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigApplicationQuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 call_limits: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 time_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigApplicationQuotaArgs.__new__(ApigApplicationQuotaArgs)

            if call_limits is None and not opts.urn:
                raise TypeError("Missing required property 'call_limits'")
            __props__.__dict__["call_limits"] = call_limits
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if time_interval is None and not opts.urn:
                raise TypeError("Missing required property 'time_interval'")
            __props__.__dict__["time_interval"] = time_interval
            if time_unit is None and not opts.urn:
                raise TypeError("Missing required property 'time_unit'")
            __props__.__dict__["time_unit"] = time_unit
            __props__.__dict__["bind_num"] = None
            __props__.__dict__["created_at"] = None
        super(ApigApplicationQuota, __self__).__init__(
            'sbercloud:index/apigApplicationQuota:ApigApplicationQuota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bind_num: Optional[pulumi.Input[_builtins.int]] = None,
            call_limits: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            time_interval: Optional[pulumi.Input[_builtins.int]] = None,
            time_unit: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigApplicationQuota':
        """
        Get an existing ApigApplicationQuota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bind_num: The number of bound APPs.
        :param pulumi.Input[_builtins.int] call_limits: Specifies the access limit of the application quota.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the application quota, in RFC3339 format.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the application quota.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the application quota belongs.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the application quota.
        :param pulumi.Input[_builtins.int] time_interval: Specifies the limited time value for flow control of the application quota.
        :param pulumi.Input[_builtins.str] time_unit: Specifies the limited time unit of the application quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigApplicationQuotaState.__new__(_ApigApplicationQuotaState)

        __props__.__dict__["bind_num"] = bind_num
        __props__.__dict__["call_limits"] = call_limits
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["time_interval"] = time_interval
        __props__.__dict__["time_unit"] = time_unit
        return ApigApplicationQuota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bindNum")
    def bind_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bound APPs.
        """
        return pulumi.get(self, "bind_num")

    @_builtins.property
    @pulumi.getter(name="callLimits")
    def call_limits(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the access limit of the application quota.
        """
        return pulumi.get(self, "call_limits")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the application quota, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the application quota.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the dedicated instance to which the application quota belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the application quota.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the limited time value for flow control of the application quota.
        """
        return pulumi.get(self, "time_interval")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the limited time unit of the application quota.
        """
        return pulumi.get(self, "time_unit")

