# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApigApplicationQuotaAssociateArgs', 'ApigApplicationQuotaAssociate']

@pulumi.input_type
class ApigApplicationQuotaAssociateArgs:
    def __init__(__self__, *,
                 applications: pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]],
                 instance_id: pulumi.Input[_builtins.str],
                 quota_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigApplicationQuotaAssociate resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]] applications: The configuration of applications bound to the quota.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application quota (policy) belongs.
        :param pulumi.Input[_builtins.str] quota_id: The ID of the application quota (policy).
        :param pulumi.Input[_builtins.str] region: The region where the application quota (policy) is located.
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "quota_id", quota_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]]:
        """
        The configuration of applications bound to the quota.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the application quota (policy) belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the application quota (policy).
        """
        return pulumi.get(self, "quota_id")

    @quota_id.setter
    def quota_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "quota_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application quota (policy) is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigApplicationQuotaAssociateState:
    def __init__(__self__, *,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigApplicationQuotaAssociate resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]] applications: The configuration of applications bound to the quota.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application quota (policy) belongs.
        :param pulumi.Input[_builtins.str] quota_id: The ID of the application quota (policy).
        :param pulumi.Input[_builtins.str] region: The region where the application quota (policy) is located.
        """
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if quota_id is not None:
            pulumi.set(__self__, "quota_id", quota_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]]]:
        """
        The configuration of applications bound to the quota.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApigApplicationQuotaAssociateApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the application quota (policy) belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the application quota (policy).
        """
        return pulumi.get(self, "quota_id")

    @quota_id.setter
    def quota_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application quota (policy) is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/apigApplicationQuotaAssociate:ApigApplicationQuotaAssociate")
class ApigApplicationQuotaAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigApplicationQuotaAssociateApplicationArgs', 'ApigApplicationQuotaAssociateApplicationArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigApplicationQuotaAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigApplicationQuotaAssociateApplicationArgs', 'ApigApplicationQuotaAssociateApplicationArgsDict']]]] applications: The configuration of applications bound to the quota.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application quota (policy) belongs.
        :param pulumi.Input[_builtins.str] quota_id: The ID of the application quota (policy).
        :param pulumi.Input[_builtins.str] region: The region where the application quota (policy) is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigApplicationQuotaAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigApplicationQuotaAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigApplicationQuotaAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigApplicationQuotaAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigApplicationQuotaAssociateApplicationArgs', 'ApigApplicationQuotaAssociateApplicationArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigApplicationQuotaAssociateArgs.__new__(ApigApplicationQuotaAssociateArgs)

            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if quota_id is None and not opts.urn:
                raise TypeError("Missing required property 'quota_id'")
            __props__.__dict__["quota_id"] = quota_id
            __props__.__dict__["region"] = region
        super(ApigApplicationQuotaAssociate, __self__).__init__(
            'sbercloud:index/apigApplicationQuotaAssociate:ApigApplicationQuotaAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigApplicationQuotaAssociateApplicationArgs', 'ApigApplicationQuotaAssociateApplicationArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            quota_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigApplicationQuotaAssociate':
        """
        Get an existing ApigApplicationQuotaAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigApplicationQuotaAssociateApplicationArgs', 'ApigApplicationQuotaAssociateApplicationArgsDict']]]] applications: The configuration of applications bound to the quota.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application quota (policy) belongs.
        :param pulumi.Input[_builtins.str] quota_id: The ID of the application quota (policy).
        :param pulumi.Input[_builtins.str] region: The region where the application quota (policy) is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigApplicationQuotaAssociateState.__new__(_ApigApplicationQuotaAssociateState)

        __props__.__dict__["applications"] = applications
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["quota_id"] = quota_id
        __props__.__dict__["region"] = region
        return ApigApplicationQuotaAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence['outputs.ApigApplicationQuotaAssociateApplication']]:
        """
        The configuration of applications bound to the quota.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the application quota (policy) belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the application quota (policy).
        """
        return pulumi.get(self, "quota_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the application quota (policy) is located.
        """
        return pulumi.get(self, "region")

