# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigCertificateArgs', 'ApigCertificate']

@pulumi.input_type
class ApigCertificateArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_root_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigCertificate resource.
        :param pulumi.Input[_builtins.str] content: The certificate content.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.str] instance_id: The dedicated instance ID to which the certificate belongs.
        :param pulumi.Input[_builtins.str] name: The certificate name.
        :param pulumi.Input[_builtins.str] region: The region where the certificate is located.
        :param pulumi.Input[_builtins.str] trusted_root_ca: The trusted root CA certificate.
        :param pulumi.Input[_builtins.str] type: The certificate type.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "private_key", private_key)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trusted_root_ca is not None:
            pulumi.set(__self__, "trusted_root_ca", trusted_root_ca)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dedicated instance ID to which the certificate belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the certificate is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="trustedRootCa")
    def trusted_root_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trusted root CA certificate.
        """
        return pulumi.get(self, "trusted_root_ca")

    @trusted_root_ca.setter
    def trusted_root_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trusted_root_ca", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ApigCertificateState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 effected_at: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_root_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigCertificate resources.
        :param pulumi.Input[_builtins.str] content: The certificate content.
        :param pulumi.Input[_builtins.str] effected_at: The effective time of the certificate.
        :param pulumi.Input[_builtins.str] expires_at: The expiration time of the certificate.
        :param pulumi.Input[_builtins.str] instance_id: The dedicated instance ID to which the certificate belongs.
        :param pulumi.Input[_builtins.str] name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.str] region: The region where the certificate is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: The SAN (Subject Alternative Names) of the certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: What signature algorithm the certificate uses.
        :param pulumi.Input[_builtins.str] trusted_root_ca: The trusted root CA certificate.
        :param pulumi.Input[_builtins.str] type: The certificate type.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if effected_at is not None:
            pulumi.set(__self__, "effected_at", effected_at)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if trusted_root_ca is not None:
            pulumi.set(__self__, "trusted_root_ca", trusted_root_ca)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="effectedAt")
    def effected_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time of the certificate.
        """
        return pulumi.get(self, "effected_at")

    @effected_at.setter
    def effected_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effected_at", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the certificate.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dedicated instance ID to which the certificate belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the certificate is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The SAN (Subject Alternative Names) of the certificate.
        """
        return pulumi.get(self, "sans")

    @sans.setter
    def sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sans", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What signature algorithm the certificate uses.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="trustedRootCa")
    def trusted_root_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trusted root CA certificate.
        """
        return pulumi.get(self, "trusted_root_ca")

    @trusted_root_ca.setter
    def trusted_root_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trusted_root_ca", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:index/apigCertificate:ApigCertificate")
class ApigCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_root_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigCertificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The certificate content.
        :param pulumi.Input[_builtins.str] instance_id: The dedicated instance ID to which the certificate belongs.
        :param pulumi.Input[_builtins.str] name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.str] region: The region where the certificate is located.
        :param pulumi.Input[_builtins.str] trusted_root_ca: The trusted root CA certificate.
        :param pulumi.Input[_builtins.str] type: The certificate type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigCertificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_root_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigCertificateArgs.__new__(ApigCertificateArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = None if content is None else pulumi.Output.secret(content)
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["region"] = region
            __props__.__dict__["trusted_root_ca"] = None if trusted_root_ca is None else pulumi.Output.secret(trusted_root_ca)
            __props__.__dict__["type"] = type
            __props__.__dict__["effected_at"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["sans"] = None
            __props__.__dict__["signature_algorithm"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["content", "privateKey", "trustedRootCa"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApigCertificate, __self__).__init__(
            'sbercloud:index/apigCertificate:ApigCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            effected_at: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_root_ca: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigCertificate':
        """
        Get an existing ApigCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The certificate content.
        :param pulumi.Input[_builtins.str] effected_at: The effective time of the certificate.
        :param pulumi.Input[_builtins.str] expires_at: The expiration time of the certificate.
        :param pulumi.Input[_builtins.str] instance_id: The dedicated instance ID to which the certificate belongs.
        :param pulumi.Input[_builtins.str] name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.str] region: The region where the certificate is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sans: The SAN (Subject Alternative Names) of the certificate.
        :param pulumi.Input[_builtins.str] signature_algorithm: What signature algorithm the certificate uses.
        :param pulumi.Input[_builtins.str] trusted_root_ca: The trusted root CA certificate.
        :param pulumi.Input[_builtins.str] type: The certificate type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigCertificateState.__new__(_ApigCertificateState)

        __props__.__dict__["content"] = content
        __props__.__dict__["effected_at"] = effected_at
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["region"] = region
        __props__.__dict__["sans"] = sans
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["trusted_root_ca"] = trusted_root_ca
        __props__.__dict__["type"] = type
        return ApigCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="effectedAt")
    def effected_at(self) -> pulumi.Output[_builtins.str]:
        """
        The effective time of the certificate.
        """
        return pulumi.get(self, "effected_at")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of the certificate.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The dedicated instance ID to which the certificate belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the certificate is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def sans(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The SAN (Subject Alternative Names) of the certificate.
        """
        return pulumi.get(self, "sans")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        What signature algorithm the certificate uses.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="trustedRootCa")
    def trusted_root_ca(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The trusted root CA certificate.
        """
        return pulumi.get(self, "trusted_root_ca")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate type.
        """
        return pulumi.get(self, "type")

