# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApigChannelArgs', 'ApigChannel']

@pulumi.input_type
class ApigChannelArgs:
    def __init__(__self__, *,
                 balance_strategy: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 health_check: Optional[pulumi.Input['ApigChannelHealthCheckArgs']] = None,
                 member_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]] = None,
                 member_type: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]] = None,
                 microservice: Optional[pulumi.Input['ApigChannelMicroserviceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigChannel resource.
        :param pulumi.Input[_builtins.int] balance_strategy: The distribution algorithm.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the channel belongs.
        :param pulumi.Input[_builtins.int] port: The default port for health check in channel.
        :param pulumi.Input['ApigChannelHealthCheckArgs'] health_check: The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        :param pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]] member_groups: The backend server groups of the channel.
        :param pulumi.Input[_builtins.str] member_type: The member type of the channel.
        :param pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]] members: The backend servers of the channel.
        :param pulumi.Input['ApigChannelMicroserviceArgs'] microservice: The configuration of the microservice.
        :param pulumi.Input[_builtins.str] name: The channel name.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.
        :param pulumi.Input[_builtins.str] type: The type of the channel.
        """
        pulumi.set(__self__, "balance_strategy", balance_strategy)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "port", port)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if member_groups is not None:
            pulumi.set(__self__, "member_groups", member_groups)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if microservice is not None:
            pulumi.set(__self__, "microservice", microservice)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="balanceStrategy")
    def balance_strategy(self) -> pulumi.Input[_builtins.int]:
        """
        The distribution algorithm.
        """
        return pulumi.get(self, "balance_strategy")

    @balance_strategy.setter
    def balance_strategy(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "balance_strategy", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the channel belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The default port for health check in channel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ApigChannelHealthCheckArgs']]:
        """
        The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ApigChannelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="memberGroups")
    def member_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]]:
        """
        The backend server groups of the channel.
        """
        return pulumi.get(self, "member_groups")

    @member_groups.setter
    def member_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]]):
        pulumi.set(self, "member_groups", value)

    @_builtins.property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The member type of the channel.
        """
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_type", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]]:
        """
        The backend servers of the channel.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def microservice(self) -> Optional[pulumi.Input['ApigChannelMicroserviceArgs']]:
        """
        The configuration of the microservice.
        """
        return pulumi.get(self, "microservice")

    @microservice.setter
    def microservice(self, value: Optional[pulumi.Input['ApigChannelMicroserviceArgs']]):
        pulumi.set(self, "microservice", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The channel name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the dedicated instance is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the channel.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ApigChannelState:
    def __init__(__self__, *,
                 balance_strategy: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input['ApigChannelHealthCheckArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 member_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]] = None,
                 member_type: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]] = None,
                 microservice: Optional[pulumi.Input['ApigChannelMicroserviceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigChannel resources.
        :param pulumi.Input[_builtins.int] balance_strategy: The distribution algorithm.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the channel.
        :param pulumi.Input['ApigChannelHealthCheckArgs'] health_check: The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the channel belongs.
        :param pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]] member_groups: The backend server groups of the channel.
        :param pulumi.Input[_builtins.str] member_type: The member type of the channel.
        :param pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]] members: The backend servers of the channel.
        :param pulumi.Input['ApigChannelMicroserviceArgs'] microservice: The configuration of the microservice.
        :param pulumi.Input[_builtins.str] name: The channel name.
        :param pulumi.Input[_builtins.int] port: The default port for health check in channel.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.
        :param pulumi.Input[_builtins.int] status: The current status of the channel.
        :param pulumi.Input[_builtins.str] type: The type of the channel.
        """
        if balance_strategy is not None:
            pulumi.set(__self__, "balance_strategy", balance_strategy)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if member_groups is not None:
            pulumi.set(__self__, "member_groups", member_groups)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if microservice is not None:
            pulumi.set(__self__, "microservice", microservice)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="balanceStrategy")
    def balance_strategy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The distribution algorithm.
        """
        return pulumi.get(self, "balance_strategy")

    @balance_strategy.setter
    def balance_strategy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "balance_strategy", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the channel.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['ApigChannelHealthCheckArgs']]:
        """
        The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['ApigChannelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the channel belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="memberGroups")
    def member_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]]:
        """
        The backend server groups of the channel.
        """
        return pulumi.get(self, "member_groups")

    @member_groups.setter
    def member_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberGroupArgs']]]]):
        pulumi.set(self, "member_groups", value)

    @_builtins.property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The member type of the channel.
        """
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_type", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]]:
        """
        The backend servers of the channel.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApigChannelMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def microservice(self) -> Optional[pulumi.Input['ApigChannelMicroserviceArgs']]:
        """
        The configuration of the microservice.
        """
        return pulumi.get(self, "microservice")

    @microservice.setter
    def microservice(self, value: Optional[pulumi.Input['ApigChannelMicroserviceArgs']]):
        pulumi.set(self, "microservice", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The channel name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default port for health check in channel.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the dedicated instance is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The current status of the channel.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the channel.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:index/apigChannel:ApigChannel")
class ApigChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balance_strategy: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input[Union['ApigChannelHealthCheckArgs', 'ApigChannelHealthCheckArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 member_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberGroupArgs', 'ApigChannelMemberGroupArgsDict']]]]] = None,
                 member_type: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberArgs', 'ApigChannelMemberArgsDict']]]]] = None,
                 microservice: Optional[pulumi.Input[Union['ApigChannelMicroserviceArgs', 'ApigChannelMicroserviceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigChannel resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] balance_strategy: The distribution algorithm.
        :param pulumi.Input[Union['ApigChannelHealthCheckArgs', 'ApigChannelHealthCheckArgsDict']] health_check: The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the channel belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberGroupArgs', 'ApigChannelMemberGroupArgsDict']]]] member_groups: The backend server groups of the channel.
        :param pulumi.Input[_builtins.str] member_type: The member type of the channel.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberArgs', 'ApigChannelMemberArgsDict']]]] members: The backend servers of the channel.
        :param pulumi.Input[Union['ApigChannelMicroserviceArgs', 'ApigChannelMicroserviceArgsDict']] microservice: The configuration of the microservice.
        :param pulumi.Input[_builtins.str] name: The channel name.
        :param pulumi.Input[_builtins.int] port: The default port for health check in channel.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.
        :param pulumi.Input[_builtins.str] type: The type of the channel.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigChannel resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balance_strategy: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input[Union['ApigChannelHealthCheckArgs', 'ApigChannelHealthCheckArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 member_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberGroupArgs', 'ApigChannelMemberGroupArgsDict']]]]] = None,
                 member_type: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberArgs', 'ApigChannelMemberArgsDict']]]]] = None,
                 microservice: Optional[pulumi.Input[Union['ApigChannelMicroserviceArgs', 'ApigChannelMicroserviceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigChannelArgs.__new__(ApigChannelArgs)

            if balance_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'balance_strategy'")
            __props__.__dict__["balance_strategy"] = balance_strategy
            __props__.__dict__["health_check"] = health_check
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["member_groups"] = member_groups
            __props__.__dict__["member_type"] = member_type
            __props__.__dict__["members"] = members
            __props__.__dict__["microservice"] = microservice
            __props__.__dict__["name"] = name
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(ApigChannel, __self__).__init__(
            'sbercloud:index/apigChannel:ApigChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            balance_strategy: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            health_check: Optional[pulumi.Input[Union['ApigChannelHealthCheckArgs', 'ApigChannelHealthCheckArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            member_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberGroupArgs', 'ApigChannelMemberGroupArgsDict']]]]] = None,
            member_type: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberArgs', 'ApigChannelMemberArgsDict']]]]] = None,
            microservice: Optional[pulumi.Input[Union['ApigChannelMicroserviceArgs', 'ApigChannelMicroserviceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigChannel':
        """
        Get an existing ApigChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] balance_strategy: The distribution algorithm.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the channel.
        :param pulumi.Input[Union['ApigChannelHealthCheckArgs', 'ApigChannelHealthCheckArgsDict']] health_check: The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the channel belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberGroupArgs', 'ApigChannelMemberGroupArgsDict']]]] member_groups: The backend server groups of the channel.
        :param pulumi.Input[_builtins.str] member_type: The member type of the channel.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApigChannelMemberArgs', 'ApigChannelMemberArgsDict']]]] members: The backend servers of the channel.
        :param pulumi.Input[Union['ApigChannelMicroserviceArgs', 'ApigChannelMicroserviceArgsDict']] microservice: The configuration of the microservice.
        :param pulumi.Input[_builtins.str] name: The channel name.
        :param pulumi.Input[_builtins.int] port: The default port for health check in channel.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.
        :param pulumi.Input[_builtins.int] status: The current status of the channel.
        :param pulumi.Input[_builtins.str] type: The type of the channel.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigChannelState.__new__(_ApigChannelState)

        __props__.__dict__["balance_strategy"] = balance_strategy
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["member_groups"] = member_groups
        __props__.__dict__["member_type"] = member_type
        __props__.__dict__["members"] = members
        __props__.__dict__["microservice"] = microservice
        __props__.__dict__["name"] = name
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return ApigChannel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="balanceStrategy")
    def balance_strategy(self) -> pulumi.Output[_builtins.int]:
        """
        The distribution algorithm.
        """
        return pulumi.get(self, "balance_strategy")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the channel.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.ApigChannelHealthCheck']:
        """
        The health configuration of cloud servers associated with the load balance channel for APIG regularly check.
        """
        return pulumi.get(self, "health_check")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the channel belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="memberGroups")
    def member_groups(self) -> pulumi.Output[Sequence['outputs.ApigChannelMemberGroup']]:
        """
        The backend server groups of the channel.
        """
        return pulumi.get(self, "member_groups")

    @_builtins.property
    @pulumi.getter(name="memberType")
    def member_type(self) -> pulumi.Output[_builtins.str]:
        """
        The member type of the channel.
        """
        return pulumi.get(self, "member_type")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.ApigChannelMember']]:
        """
        The backend servers of the channel.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def microservice(self) -> pulumi.Output['outputs.ApigChannelMicroservice']:
        """
        The configuration of the microservice.
        """
        return pulumi.get(self, "microservice")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The channel name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The default port for health check in channel.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the dedicated instance is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The current status of the channel.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the channel.
        """
        return pulumi.get(self, "type")

