# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigEndpointConnectionManagementArgs', 'ApigEndpointConnectionManagement']

@pulumi.input_type
class ApigEndpointConnectionManagementArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 endpoint_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigEndpointConnectionManagement resource.
        :param pulumi.Input[_builtins.str] action: Specifies the operation type endpoint connection.
        :param pulumi.Input[_builtins.str] endpoint_id: Specifies the ID of the endpoint connection.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the operation type endpoint connection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the endpoint connection.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigEndpointConnectionManagementState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigEndpointConnectionManagement resources.
        :param pulumi.Input[_builtins.str] action: Specifies the operation type endpoint connection.
        :param pulumi.Input[_builtins.str] endpoint_id: Specifies the ID of the endpoint connection.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        :param pulumi.Input[_builtins.str] status: The current ststus of the endpoint connection.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the operation type endpoint connection.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the endpoint connection.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current ststus of the endpoint connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:index/apigEndpointConnectionManagement:ApigEndpointConnectionManagement")
class ApigEndpointConnectionManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigEndpointConnectionManagement resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Specifies the operation type endpoint connection.
        :param pulumi.Input[_builtins.str] endpoint_id: Specifies the ID of the endpoint connection.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigEndpointConnectionManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigEndpointConnectionManagement resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigEndpointConnectionManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigEndpointConnectionManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigEndpointConnectionManagementArgs.__new__(ApigEndpointConnectionManagementArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = None
        super(ApigEndpointConnectionManagement, __self__).__init__(
            'sbercloud:index/apigEndpointConnectionManagement:ApigEndpointConnectionManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigEndpointConnectionManagement':
        """
        Get an existing ApigEndpointConnectionManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Specifies the operation type endpoint connection.
        :param pulumi.Input[_builtins.str] endpoint_id: Specifies the ID of the endpoint connection.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        :param pulumi.Input[_builtins.str] status: The current ststus of the endpoint connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigEndpointConnectionManagementState.__new__(_ApigEndpointConnectionManagementState)

        __props__.__dict__["action"] = action
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return ApigEndpointConnectionManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the operation type endpoint connection.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the endpoint connection.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the dedicated instance to which the endpoint connection belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current ststus of the endpoint connection.
        """
        return pulumi.get(self, "status")

