# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigPluginAssociateArgs', 'ApigPluginAssociate']

@pulumi.input_type
class ApigPluginAssociateArgs:
    def __init__(__self__, *,
                 api_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 env_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 plugin_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigPluginAssociate resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_ids: The APIs bound by the plugin.
        :param pulumi.Input[_builtins.str] env_id: The environment ID where the API was published.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the plugin belongs.
        :param pulumi.Input[_builtins.str] plugin_id: The plugin ID.
        :param pulumi.Input[_builtins.str] region: The region where the plugin is located.
        """
        pulumi.set(__self__, "api_ids", api_ids)
        pulumi.set(__self__, "env_id", env_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "plugin_id", plugin_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="apiIds")
    def api_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The APIs bound by the plugin.
        """
        return pulumi.get(self, "api_ids")

    @api_ids.setter
    def api_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "api_ids", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[_builtins.str]:
        """
        The environment ID where the API was published.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the plugin belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[_builtins.str]:
        """
        The plugin ID.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the plugin is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApigPluginAssociateState:
    def __init__(__self__, *,
                 api_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigPluginAssociate resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_ids: The APIs bound by the plugin.
        :param pulumi.Input[_builtins.str] env_id: The environment ID where the API was published.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the plugin belongs.
        :param pulumi.Input[_builtins.str] plugin_id: The plugin ID.
        :param pulumi.Input[_builtins.str] region: The region where the plugin is located.
        """
        if api_ids is not None:
            pulumi.set(__self__, "api_ids", api_ids)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="apiIds")
    def api_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The APIs bound by the plugin.
        """
        return pulumi.get(self, "api_ids")

    @api_ids.setter
    def api_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_ids", value)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment ID where the API was published.
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the plugin belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plugin ID.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the plugin is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/apigPluginAssociate:ApigPluginAssociate")
class ApigPluginAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigPluginAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_ids: The APIs bound by the plugin.
        :param pulumi.Input[_builtins.str] env_id: The environment ID where the API was published.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the plugin belongs.
        :param pulumi.Input[_builtins.str] plugin_id: The plugin ID.
        :param pulumi.Input[_builtins.str] region: The region where the plugin is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigPluginAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigPluginAssociate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigPluginAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigPluginAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 env_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigPluginAssociateArgs.__new__(ApigPluginAssociateArgs)

            if api_ids is None and not opts.urn:
                raise TypeError("Missing required property 'api_ids'")
            __props__.__dict__["api_ids"] = api_ids
            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["region"] = region
        super(ApigPluginAssociate, __self__).__init__(
            'sbercloud:index/apigPluginAssociate:ApigPluginAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            env_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigPluginAssociate':
        """
        Get an existing ApigPluginAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_ids: The APIs bound by the plugin.
        :param pulumi.Input[_builtins.str] env_id: The environment ID where the API was published.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the plugin belongs.
        :param pulumi.Input[_builtins.str] plugin_id: The plugin ID.
        :param pulumi.Input[_builtins.str] region: The region where the plugin is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigPluginAssociateState.__new__(_ApigPluginAssociateState)

        __props__.__dict__["api_ids"] = api_ids
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["region"] = region
        return ApigPluginAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiIds")
    def api_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The APIs bound by the plugin.
        """
        return pulumi.get(self, "api_ids")

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[_builtins.str]:
        """
        The environment ID where the API was published.
        """
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the plugin belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[_builtins.str]:
        """
        The plugin ID.
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the plugin is located.
        """
        return pulumi.get(self, "region")

