# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApigSignatureArgs', 'ApigSignature']

@pulumi.input_type
class ApigSignatureArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApigSignature resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the signature belongs.
        :param pulumi.Input[_builtins.str] type: The signature type.
        :param pulumi.Input[_builtins.str] algorithm: The signature algorithm.
        :param pulumi.Input[_builtins.str] key: The signature key.
        :param pulumi.Input[_builtins.str] name: The signature name.
        :param pulumi.Input[_builtins.str] region: The region where the signature is located.
        :param pulumi.Input[_builtins.str] secret: The signature secret.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "type", type)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the signature belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The signature type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature algorithm.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the signature is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature secret.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _ApigSignatureState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApigSignature resources.
        :param pulumi.Input[_builtins.str] algorithm: The signature algorithm.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the signature.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the signature belongs.
        :param pulumi.Input[_builtins.str] key: The signature key.
        :param pulumi.Input[_builtins.str] name: The signature name.
        :param pulumi.Input[_builtins.str] region: The region where the signature is located.
        :param pulumi.Input[_builtins.str] secret: The signature secret.
        :param pulumi.Input[_builtins.str] type: The signature type.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the signature.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature algorithm.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the signature.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the signature belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the signature is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature secret.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The signature type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the signature.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/apigSignature:ApigSignature")
class ApigSignature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ApigSignature resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The signature algorithm.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the signature belongs.
        :param pulumi.Input[_builtins.str] key: The signature key.
        :param pulumi.Input[_builtins.str] name: The signature name.
        :param pulumi.Input[_builtins.str] region: The region where the signature is located.
        :param pulumi.Input[_builtins.str] secret: The signature secret.
        :param pulumi.Input[_builtins.str] type: The signature type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApigSignatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApigSignature resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApigSignatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApigSignatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApigSignatureArgs.__new__(ApigSignatureArgs)

            __props__.__dict__["algorithm"] = algorithm
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApigSignature, __self__).__init__(
            'sbercloud:index/apigSignature:ApigSignature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApigSignature':
        """
        Get an existing ApigSignature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The signature algorithm.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the signature.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the signature belongs.
        :param pulumi.Input[_builtins.str] key: The signature key.
        :param pulumi.Input[_builtins.str] name: The signature name.
        :param pulumi.Input[_builtins.str] region: The region where the signature is located.
        :param pulumi.Input[_builtins.str] secret: The signature secret.
        :param pulumi.Input[_builtins.str] type: The signature type.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the signature.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApigSignatureState.__new__(_ApigSignatureState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["secret"] = secret
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return ApigSignature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The signature algorithm.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the signature.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the signature belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The signature key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The signature name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the signature is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        The signature secret.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The signature type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the signature.
        """
        return pulumi.get(self, "updated_at")

