# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 instance_config: pulumi.Input['ConfigurationInstanceConfigArgs'],
                 scaling_configuration_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input['ConfigurationInstanceConfigArgs'] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS configuration.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "instance_config", instance_config)
        pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> pulumi.Input['ConfigurationInstanceConfigArgs']:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @instance_config.setter
    def instance_config(self, value: pulumi.Input['ConfigurationInstanceConfigArgs']):
        pulumi.set(self, "instance_config", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_config: Optional[pulumi.Input['ConfigurationInstanceConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input['ConfigurationInstanceConfigArgs'] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS configuration.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: The AS configuration status, the value can be **Bound** or **Unbound**.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_config is not None:
            pulumi.set(__self__, "instance_config", instance_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> Optional[pulumi.Input['ConfigurationInstanceConfigArgs']]:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @instance_config.setter
    def instance_config(self, value: Optional[pulumi.Input['ConfigurationInstanceConfigArgs']]):
        pulumi.set(self, "instance_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AS configuration status, the value can be **Bound** or **Unbound**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:As/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_config: Optional[pulumi.Input[Union['ConfigurationInstanceConfigArgs', 'ConfigurationInstanceConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AS configuration resource within SberCloud.

        ## Example Usage

        ### Basic AS Configuration

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        flavor_id = config.require_object("flavorId")
        image_id = config.require_object("imageId")
        ssh_key = config.require_object("sshKey")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "flavor": flavor_id,
                "image": image_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
                "disks": [{
                    "size": 40,
                    "volume_type": "SSD",
                    "disk_type": "SYS",
                }],
            })
        ```

        ### AS Configuration With Encrypted Data Disk

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        flavor_id = config.require_object("flavorId")
        image_id = config.require_object("imageId")
        ssh_key = config.require_object("sshKey")
        kms_id = config.require_object("kmsId")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "flavor": flavor_id,
                "image": image_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
                "disks": [
                    {
                        "size": 40,
                        "volume_type": "SSD",
                        "disk_type": "SYS",
                    },
                    {
                        "size": 100,
                        "volume_type": "SSD",
                        "disk_type": "DATA",
                        "kms_id": kms_id,
                    },
                ],
            })
        ```

        ### AS Configuration uses the existing instance specifications as the template

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        ssh_key = config.require_object("sshKey")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "instance_id": instance_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
            })
        ```

        ## Import

        AS configurations can be imported by their `id`, e.g.

        ```sh
        $ pulumi import sbercloud:As/configuration:Configuration test 18518c8a-9d15-416b-8add-2ee874751d18
        ```

        Note that the imported state may not be identical to your resource definition, due to `instance_config.0.instance_id`

        is missing from the API response. You can ignore changes after importing an AS configuration as below.

        resource "sbercloud_as_configuration" "test" {

          ...

          lifecycle {

            ignore_changes = [ instance_config.0.instance_id ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigurationInstanceConfigArgs', 'ConfigurationInstanceConfigArgsDict']] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS configuration.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AS configuration resource within SberCloud.

        ## Example Usage

        ### Basic AS Configuration

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        flavor_id = config.require_object("flavorId")
        image_id = config.require_object("imageId")
        ssh_key = config.require_object("sshKey")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "flavor": flavor_id,
                "image": image_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
                "disks": [{
                    "size": 40,
                    "volume_type": "SSD",
                    "disk_type": "SYS",
                }],
            })
        ```

        ### AS Configuration With Encrypted Data Disk

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        flavor_id = config.require_object("flavorId")
        image_id = config.require_object("imageId")
        ssh_key = config.require_object("sshKey")
        kms_id = config.require_object("kmsId")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "flavor": flavor_id,
                "image": image_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
                "disks": [
                    {
                        "size": 40,
                        "volume_type": "SSD",
                        "disk_type": "SYS",
                    },
                    {
                        "size": 100,
                        "volume_type": "SSD",
                        "disk_type": "DATA",
                        "kms_id": kms_id,
                    },
                ],
            })
        ```

        ### AS Configuration uses the existing instance specifications as the template

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        ssh_key = config.require_object("sshKey")
        security_group_id = config.require_object("securityGroupId")
        my_as_config = sbercloud.as_.Configuration("my_as_config",
            scaling_configuration_name="my_as_config",
            instance_config={
                "instance_id": instance_id,
                "key_name": ssh_key,
                "security_group_ids": [security_group_id],
            })
        ```

        ## Import

        AS configurations can be imported by their `id`, e.g.

        ```sh
        $ pulumi import sbercloud:As/configuration:Configuration test 18518c8a-9d15-416b-8add-2ee874751d18
        ```

        Note that the imported state may not be identical to your resource definition, due to `instance_config.0.instance_id`

        is missing from the API response. You can ignore changes after importing an AS configuration as below.

        resource "sbercloud_as_configuration" "test" {

          ...

          lifecycle {

            ignore_changes = [ instance_config.0.instance_id ]

          }

        }

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_config: Optional[pulumi.Input[Union['ConfigurationInstanceConfigArgs', 'ConfigurationInstanceConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            if instance_config is None and not opts.urn:
                raise TypeError("Missing required property 'instance_config'")
            __props__.__dict__["instance_config"] = instance_config
            __props__.__dict__["region"] = region
            if scaling_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_configuration_name'")
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Configuration, __self__).__init__(
            'sbercloud:As/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_config: Optional[pulumi.Input[Union['ConfigurationInstanceConfigArgs', 'ConfigurationInstanceConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigurationInstanceConfigArgs', 'ConfigurationInstanceConfigArgsDict']] instance_config: Specifies the information about instance configuration.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS configuration.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Specifies the AS configuration name.
               The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: The AS configuration status, the value can be **Bound** or **Unbound**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_config"] = instance_config
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["status"] = status
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> pulumi.Output['outputs.ConfigurationInstanceConfig']:
        """
        Specifies the information about instance configuration.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the AS configuration.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the AS configuration name.
        The name contains only letters, digits, underscores (_), and hyphens (-), and cannot exceed 64 characters.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The AS configuration status, the value can be **Bound** or **Unbound**.
        """
        return pulumi.get(self, "status")

