# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 networks: pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]],
                 scaling_group_name: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_instances: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desire_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_periodic_audit_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]] = None,
                 max_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]] networks: Specifies an array of one or more network IDs. The system supports up to five networks.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] scaling_group_name: Specifies the name of the scaling group. The name can contain
               letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new group.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name. If you change the agency,
               the new agency will be available for ECSs scaled out after the change.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the availability zones in which to create the instances in the
               autoscaling group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; use availability_zones instead
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
               and is 300 by default.
        :param pulumi.Input[_builtins.str] delete_instances: Specifies whether to delete the instances in the AS group when deleting
               the AS group. The options are `yes` and `no`.
        :param pulumi.Input[_builtins.bool] delete_publicip: Specifies whether to delete the elastic IP address bound to the instances of
               AS group when deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the AS group.
               The value can contain 0 to 256 characters.
        :param pulumi.Input[_builtins.int] desire_instance_number: Specifies the expected number of instances. The default value is the
               minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the AS Group. The options are `true` and `false`.
               The default value is `true`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the AS group.
               
               <a name="group_network_object"></a>
               The `networks` block supports:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcibly delete the AS group, remove the ECS instances and
               release them. The default value is `false`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_grace_period: Specifies the health check grace period for instances.
               The unit is second and the value ranges from 0 to 86400. The default value is 600.
               
               > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        :param pulumi.Input[_builtins.str] health_periodic_audit_method: Specifies the health check method for instances in the AS group.
               The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
               this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_time: Specifies the health check period for instances. The unit is minute
               and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        :param pulumi.Input[_builtins.str] instance_terminate_policy: Specifies the instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.
               
               + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
               are removed first.
               + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
               + **OLD_INSTANCE**: The earlier-created instances are removed first.
               + **NEW_INSTANCE**: The later-created instances are removed first.
        :param pulumi.Input[_builtins.str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]] lbaas_listeners: Specifies an array of one or more enhanced load balancer. The system supports
               the binding of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[_builtins.int] max_instance_number: Specifies the maximum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.int] min_instance_number: Specifies the minimum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.str] multi_az_scaling_policy: Specifies the priority policy used to select target AZs when adjusting
               the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.
               
               + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
               availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
               on the PICK_FIRST policy.
               + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
               availability_zones list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: schema: Deprecated; The notification mode has been canceled
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS group.
               If omitted, the provider-level region will be used. Changing this creates a new group.
        :param pulumi.Input[_builtins.str] scaling_configuration_id: Specifies the configuration ID which defines configurations
               of instances in the AS group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]] security_groups: Specifies an array of one or more security group IDs to associate with the group.
               The object structure is documented below.
               
               > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
               the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
               ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
               group in the AS configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the AS group.
        """
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if delete_instances is not None:
            pulumi.set(__self__, "delete_instances", delete_instances)
        if delete_publicip is not None:
            pulumi.set(__self__, "delete_publicip", delete_publicip)
        if delete_volume is not None:
            pulumi.set(__self__, "delete_volume", delete_volume)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desire_instance_number is not None:
            pulumi.set(__self__, "desire_instance_number", desire_instance_number)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if health_periodic_audit_grace_period is not None:
            pulumi.set(__self__, "health_periodic_audit_grace_period", health_periodic_audit_grace_period)
        if health_periodic_audit_method is not None:
            pulumi.set(__self__, "health_periodic_audit_method", health_periodic_audit_method)
        if health_periodic_audit_time is not None:
            pulumi.set(__self__, "health_periodic_audit_time", health_periodic_audit_time)
        if instance_terminate_policy is not None:
            pulumi.set(__self__, "instance_terminate_policy", instance_terminate_policy)
        if lb_listener_id is not None:
            warnings.warn("""use lbaas_listeners instead""", DeprecationWarning)
            pulumi.log.warn("""lb_listener_id is deprecated: use lbaas_listeners instead""")
        if lb_listener_id is not None:
            pulumi.set(__self__, "lb_listener_id", lb_listener_id)
        if lbaas_listeners is not None:
            pulumi.set(__self__, "lbaas_listeners", lbaas_listeners)
        if max_instance_number is not None:
            pulumi.set(__self__, "max_instance_number", max_instance_number)
        if min_instance_number is not None:
            pulumi.set(__self__, "min_instance_number", min_instance_number)
        if multi_az_scaling_policy is not None:
            pulumi.set(__self__, "multi_az_scaling_policy", multi_az_scaling_policy)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_id is not None:
            pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]:
        """
        Specifies an array of one or more network IDs. The system supports up to five networks.
        The object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the scaling group. The name can contain
        letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IAM agency name. If you change the agency,
        the new agency will be available for ECSs scaled out after the change.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the availability zones in which to create the instances in the
        autoscaling group.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; use availability_zones instead
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
        and is 300 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cool_down_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to delete the instances in the AS group when deleting
        the AS group. The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @delete_instances.setter
    def delete_instances(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_instances", value)

    @_builtins.property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the elastic IP address bound to the instances of
        AS group when deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @delete_publicip.setter
    def delete_publicip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_publicip", value)

    @_builtins.property
    @pulumi.getter(name="deleteVolume")
    def delete_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_volume")

    @delete_volume.setter
    def delete_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_volume", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the AS group.
        The value can contain 0 to 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the expected number of instances. The default value is the
        minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @desire_instance_number.setter
    def desire_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desire_instance_number", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the AS Group. The options are `true` and `false`.
        The default value is `true`.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the AS group.

        <a name="group_network_object"></a>
        The `networks` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly delete the AS group, remove the ECS instances and
        release them. The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditGracePeriod")
    def health_periodic_audit_grace_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the health check grace period for instances.
        The unit is second and the value ranges from 0 to 86400. The default value is 600.

        > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_grace_period")

    @health_periodic_audit_grace_period.setter
    def health_periodic_audit_grace_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_periodic_audit_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the health check method for instances in the AS group.
        The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
        this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @health_periodic_audit_method.setter
    def health_periodic_audit_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_periodic_audit_method", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the health check period for instances. The unit is minute
        and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @health_periodic_audit_time.setter
    def health_periodic_audit_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_periodic_audit_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.

        + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
        are removed first.
        + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
        + **OLD_INSTANCE**: The earlier-created instances are removed first.
        + **NEW_INSTANCE**: The later-created instances are removed first.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @instance_terminate_policy.setter
    def instance_terminate_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_terminate_policy", value)

    @_builtins.property
    @pulumi.getter(name="lbListenerId")
    @_utilities.deprecated("""use lbaas_listeners instead""")
    def lb_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @lb_listener_id.setter
    def lb_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lb_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]:
        """
        Specifies an array of one or more enhanced load balancer. The system supports
        the binding of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @lbaas_listeners.setter
    def lbaas_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]):
        pulumi.set(self, "lbaas_listeners", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @max_instance_number.setter
    def max_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instance_number", value)

    @_builtins.property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @min_instance_number.setter
    def min_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instance_number", value)

    @_builtins.property
    @pulumi.getter(name="multiAzScalingPolicy")
    def multi_az_scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority policy used to select target AZs when adjusting
        the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.

        + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
        availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
        on the PICK_FIRST policy.
        + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
        availability_zones list.
        """
        return pulumi.get(self, "multi_az_scaling_policy")

    @multi_az_scaling_policy.setter
    def multi_az_scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_scaling_policy", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; The notification mode has been canceled
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS group.
        If omitted, the provider-level region will be used. Changing this creates a new group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the configuration ID which defines configurations
        of instances in the AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @scaling_configuration_id.setter
    def scaling_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]:
        """
        Specifies an array of one or more security group IDs to associate with the group.
        The object structure is documented below.

        > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
        the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
        ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
        group in the AS configuration.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the AS group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 activity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 current_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_instances: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desire_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 detail: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_periodic_audit_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_scaling: Optional[pulumi.Input[_builtins.bool]] = None,
                 lb_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]] = None,
                 max_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name. If you change the agency,
               the new agency will be available for ECSs scaled out after the change.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the availability zones in which to create the instances in the
               autoscaling group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; use availability_zones instead
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
               and is 300 by default.
        :param pulumi.Input[_builtins.int] current_instance_number: The number of current instances in the AS group.
        :param pulumi.Input[_builtins.str] delete_instances: Specifies whether to delete the instances in the AS group when deleting
               the AS group. The options are `yes` and `no`.
        :param pulumi.Input[_builtins.bool] delete_publicip: Specifies whether to delete the elastic IP address bound to the instances of
               AS group when deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the AS group.
               The value can contain 0 to 256 characters.
        :param pulumi.Input[_builtins.int] desire_instance_number: Specifies the expected number of instances. The default value is the
               minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the AS Group. The options are `true` and `false`.
               The default value is `true`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the AS group.
               
               <a name="group_network_object"></a>
               The `networks` block supports:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcibly delete the AS group, remove the ECS instances and
               release them. The default value is `false`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_grace_period: Specifies the health check grace period for instances.
               The unit is second and the value ranges from 0 to 86400. The default value is 600.
               
               > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        :param pulumi.Input[_builtins.str] health_periodic_audit_method: Specifies the health check method for instances in the AS group.
               The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
               this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_time: Specifies the health check period for instances. The unit is minute
               and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        :param pulumi.Input[_builtins.str] instance_terminate_policy: Specifies the instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.
               
               + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
               are removed first.
               + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
               + **OLD_INSTANCE**: The earlier-created instances are removed first.
               + **NEW_INSTANCE**: The later-created instances are removed first.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instances IDs of the AS group.
        :param pulumi.Input[_builtins.str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]] lbaas_listeners: Specifies an array of one or more enhanced load balancer. The system supports
               the binding of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[_builtins.int] max_instance_number: Specifies the maximum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.int] min_instance_number: Specifies the minimum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.str] multi_az_scaling_policy: Specifies the priority policy used to select target AZs when adjusting
               the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.
               
               + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
               availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
               on the PICK_FIRST policy.
               + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
               availability_zones list.
        :param pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]] networks: Specifies an array of one or more network IDs. The system supports up to five networks.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: schema: Deprecated; The notification mode has been canceled
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS group.
               If omitted, the provider-level region will be used. Changing this creates a new group.
        :param pulumi.Input[_builtins.str] scaling_configuration_id: Specifies the configuration ID which defines configurations
               of instances in the AS group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Specifies the name of the scaling group. The name can contain
               letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]] security_groups: Specifies an array of one or more security group IDs to associate with the group.
               The object structure is documented below.
               
               > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
               the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
               ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
               group in the AS configuration.
        :param pulumi.Input[_builtins.str] status: The status of the AS group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the AS group.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new group.
        """
        if activity_type is not None:
            pulumi.set(__self__, "activity_type", activity_type)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if current_instance_number is not None:
            pulumi.set(__self__, "current_instance_number", current_instance_number)
        if delete_instances is not None:
            pulumi.set(__self__, "delete_instances", delete_instances)
        if delete_publicip is not None:
            pulumi.set(__self__, "delete_publicip", delete_publicip)
        if delete_volume is not None:
            pulumi.set(__self__, "delete_volume", delete_volume)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desire_instance_number is not None:
            pulumi.set(__self__, "desire_instance_number", desire_instance_number)
        if detail is not None:
            pulumi.set(__self__, "detail", detail)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if health_periodic_audit_grace_period is not None:
            pulumi.set(__self__, "health_periodic_audit_grace_period", health_periodic_audit_grace_period)
        if health_periodic_audit_method is not None:
            pulumi.set(__self__, "health_periodic_audit_method", health_periodic_audit_method)
        if health_periodic_audit_time is not None:
            pulumi.set(__self__, "health_periodic_audit_time", health_periodic_audit_time)
        if instance_terminate_policy is not None:
            pulumi.set(__self__, "instance_terminate_policy", instance_terminate_policy)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if is_scaling is not None:
            pulumi.set(__self__, "is_scaling", is_scaling)
        if lb_listener_id is not None:
            warnings.warn("""use lbaas_listeners instead""", DeprecationWarning)
            pulumi.log.warn("""lb_listener_id is deprecated: use lbaas_listeners instead""")
        if lb_listener_id is not None:
            pulumi.set(__self__, "lb_listener_id", lb_listener_id)
        if lbaas_listeners is not None:
            pulumi.set(__self__, "lbaas_listeners", lbaas_listeners)
        if max_instance_number is not None:
            pulumi.set(__self__, "max_instance_number", max_instance_number)
        if min_instance_number is not None:
            pulumi.set(__self__, "min_instance_number", min_instance_number)
        if multi_az_scaling_policy is not None:
            pulumi.set(__self__, "multi_az_scaling_policy", multi_az_scaling_policy)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_configuration_id is not None:
            pulumi.set(__self__, "scaling_configuration_id", scaling_configuration_id)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="activityType")
    def activity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "activity_type")

    @activity_type.setter
    def activity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activity_type", value)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IAM agency name. If you change the agency,
        the new agency will be available for ECSs scaled out after the change.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the availability zones in which to create the instances in the
        autoscaling group.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; use availability_zones instead
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
        and is 300 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cool_down_time", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="currentInstanceNumber")
    def current_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of current instances in the AS group.
        """
        return pulumi.get(self, "current_instance_number")

    @current_instance_number.setter
    def current_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "current_instance_number", value)

    @_builtins.property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to delete the instances in the AS group when deleting
        the AS group. The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @delete_instances.setter
    def delete_instances(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_instances", value)

    @_builtins.property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the elastic IP address bound to the instances of
        AS group when deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @delete_publicip.setter
    def delete_publicip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_publicip", value)

    @_builtins.property
    @pulumi.getter(name="deleteVolume")
    def delete_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_volume")

    @delete_volume.setter
    def delete_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_volume", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the AS group.
        The value can contain 0 to 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the expected number of instances. The default value is the
        minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @desire_instance_number.setter
    def desire_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desire_instance_number", value)

    @_builtins.property
    @pulumi.getter
    def detail(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "detail")

    @detail.setter
    def detail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detail", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the AS Group. The options are `true` and `false`.
        The default value is `true`.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the AS group.

        <a name="group_network_object"></a>
        The `networks` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly delete the AS group, remove the ECS instances and
        release them. The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditGracePeriod")
    def health_periodic_audit_grace_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the health check grace period for instances.
        The unit is second and the value ranges from 0 to 86400. The default value is 600.

        > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_grace_period")

    @health_periodic_audit_grace_period.setter
    def health_periodic_audit_grace_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_periodic_audit_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the health check method for instances in the AS group.
        The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
        this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @health_periodic_audit_method.setter
    def health_periodic_audit_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_periodic_audit_method", value)

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the health check period for instances. The unit is minute
        and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @health_periodic_audit_time.setter
    def health_periodic_audit_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_periodic_audit_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.

        + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
        are removed first.
        + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
        + **OLD_INSTANCE**: The earlier-created instances are removed first.
        + **NEW_INSTANCE**: The later-created instances are removed first.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @instance_terminate_policy.setter
    def instance_terminate_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_terminate_policy", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The instances IDs of the AS group.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="isScaling")
    def is_scaling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_scaling")

    @is_scaling.setter
    def is_scaling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_scaling", value)

    @_builtins.property
    @pulumi.getter(name="lbListenerId")
    @_utilities.deprecated("""use lbaas_listeners instead""")
    def lb_listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @lb_listener_id.setter
    def lb_listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lb_listener_id", value)

    @_builtins.property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]:
        """
        Specifies an array of one or more enhanced load balancer. The system supports
        the binding of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @lbaas_listeners.setter
    def lbaas_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupLbaasListenerArgs']]]]):
        pulumi.set(self, "lbaas_listeners", value)

    @_builtins.property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @max_instance_number.setter
    def max_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instance_number", value)

    @_builtins.property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @min_instance_number.setter
    def min_instance_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instance_number", value)

    @_builtins.property
    @pulumi.getter(name="multiAzScalingPolicy")
    def multi_az_scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority policy used to select target AZs when adjusting
        the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.

        + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
        availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
        on the PICK_FIRST policy.
        + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
        availability_zones list.
        """
        return pulumi.get(self, "multi_az_scaling_policy")

    @multi_az_scaling_policy.setter
    def multi_az_scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_scaling_policy", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]]:
        """
        Specifies an array of one or more network IDs. The system supports up to five networks.
        The object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; The notification mode has been canceled
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS group.
        If omitted, the provider-level region will be used. Changing this creates a new group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the configuration ID which defines configurations
        of instances in the AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @scaling_configuration_id.setter
    def scaling_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the scaling group. The name can contain
        letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]:
        """
        Specifies an array of one or more security group IDs to associate with the group.
        The object structure is documented below.

        > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
        the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
        ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
        group in the AS configuration.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupSecurityGroupArgs']]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the AS group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the AS group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:As/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_instances: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desire_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_periodic_audit_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupLbaasListenerArgs', 'GroupLbaasListenerArgsDict']]]]] = None,
                 max_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupNetworkArgs', 'GroupNetworkArgsDict']]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupSecurityGroupArgs', 'GroupSecurityGroupArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AS group resource within SberCloud.

        ## Example Usage

        ### Basic Autoscaling Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group = sbercloud.as_.Group("my_as_group",
            scaling_group_name="my_as_group",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="yes",
            networks=[{
                "id": subnet_id,
            }])
        ```

        ### Autoscaling Group with tags

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group_tags = sbercloud.as_.Group("my_as_group_tags",
            scaling_group_name="my_as_group_tags",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="yes",
            networks=[{
                "id": subnet_id,
            }],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ### Autoscaling Group Only Remove Members When Scaling Down

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group_only_remove_members = sbercloud.as_.Group("my_as_group_only_remove_members",
            scaling_group_name="my_as_group_only_remove_members",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="no",
            networks=[{
                "id": subnet_id,
            }])
        ```

        ### Autoscaling Group With Elastic Load Balancer Listener

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        ipv4_subnet_id = config.require_object("ipv4SubnetId")
        loadbalancer1 = sbercloud.elb.Loadbalancer("loadbalancer_1",
            name="loadbalancer_1",
            vip_subnet_id=ipv4_subnet_id)
        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = sbercloud.elb.Pool("pool_1",
            name="pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id=listener1.id)
        my_as_group_with_enhanced_lb = sbercloud.as_.Group("my_as_group_with_enhanced_lb",
            scaling_group_name="my_as_group_with_enhanced_lb",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            networks=[{
                "id": subnet_id,
            }],
            lbaas_listeners=[{
                "pool_id": pool1.id,
                "protocol_port": listener1.protocol_port,
            }])
        ```

        ## Import

        AS groups can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:As/group:Group my_as_group 9ec5bea6-a728-4082-8109-5a7dc5c7af74
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name. If you change the agency,
               the new agency will be available for ECSs scaled out after the change.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the availability zones in which to create the instances in the
               autoscaling group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; use availability_zones instead
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
               and is 300 by default.
        :param pulumi.Input[_builtins.str] delete_instances: Specifies whether to delete the instances in the AS group when deleting
               the AS group. The options are `yes` and `no`.
        :param pulumi.Input[_builtins.bool] delete_publicip: Specifies whether to delete the elastic IP address bound to the instances of
               AS group when deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the AS group.
               The value can contain 0 to 256 characters.
        :param pulumi.Input[_builtins.int] desire_instance_number: Specifies the expected number of instances. The default value is the
               minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the AS Group. The options are `true` and `false`.
               The default value is `true`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the AS group.
               
               <a name="group_network_object"></a>
               The `networks` block supports:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcibly delete the AS group, remove the ECS instances and
               release them. The default value is `false`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_grace_period: Specifies the health check grace period for instances.
               The unit is second and the value ranges from 0 to 86400. The default value is 600.
               
               > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        :param pulumi.Input[_builtins.str] health_periodic_audit_method: Specifies the health check method for instances in the AS group.
               The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
               this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_time: Specifies the health check period for instances. The unit is minute
               and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        :param pulumi.Input[_builtins.str] instance_terminate_policy: Specifies the instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.
               
               + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
               are removed first.
               + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
               + **OLD_INSTANCE**: The earlier-created instances are removed first.
               + **NEW_INSTANCE**: The later-created instances are removed first.
        :param pulumi.Input[_builtins.str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupLbaasListenerArgs', 'GroupLbaasListenerArgsDict']]]] lbaas_listeners: Specifies an array of one or more enhanced load balancer. The system supports
               the binding of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[_builtins.int] max_instance_number: Specifies the maximum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.int] min_instance_number: Specifies the minimum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.str] multi_az_scaling_policy: Specifies the priority policy used to select target AZs when adjusting
               the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.
               
               + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
               availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
               on the PICK_FIRST policy.
               + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
               availability_zones list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupNetworkArgs', 'GroupNetworkArgsDict']]]] networks: Specifies an array of one or more network IDs. The system supports up to five networks.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: schema: Deprecated; The notification mode has been canceled
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS group.
               If omitted, the provider-level region will be used. Changing this creates a new group.
        :param pulumi.Input[_builtins.str] scaling_configuration_id: Specifies the configuration ID which defines configurations
               of instances in the AS group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Specifies the name of the scaling group. The name can contain
               letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupSecurityGroupArgs', 'GroupSecurityGroupArgsDict']]]] security_groups: Specifies an array of one or more security group IDs to associate with the group.
               The object structure is documented below.
               
               > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
               the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
               ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
               group in the AS configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the AS group.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AS group resource within SberCloud.

        ## Example Usage

        ### Basic Autoscaling Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group = sbercloud.as_.Group("my_as_group",
            scaling_group_name="my_as_group",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="yes",
            networks=[{
                "id": subnet_id,
            }])
        ```

        ### Autoscaling Group with tags

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group_tags = sbercloud.as_.Group("my_as_group_tags",
            scaling_group_name="my_as_group_tags",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="yes",
            networks=[{
                "id": subnet_id,
            }],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ### Autoscaling Group Only Remove Members When Scaling Down

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        my_as_group_only_remove_members = sbercloud.as_.Group("my_as_group_only_remove_members",
            scaling_group_name="my_as_group_only_remove_members",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            delete_publicip=True,
            delete_instances="no",
            networks=[{
                "id": subnet_id,
            }])
        ```

        ### Autoscaling Group With Elastic Load Balancer Listener

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        ipv4_subnet_id = config.require_object("ipv4SubnetId")
        loadbalancer1 = sbercloud.elb.Loadbalancer("loadbalancer_1",
            name="loadbalancer_1",
            vip_subnet_id=ipv4_subnet_id)
        listener1 = sbercloud.elb.Listener("listener_1",
            name="listener_1",
            protocol="HTTP",
            protocol_port=8080,
            loadbalancer_id=loadbalancer1.id)
        pool1 = sbercloud.elb.Pool("pool_1",
            name="pool_1",
            protocol="HTTP",
            lb_method="ROUND_ROBIN",
            listener_id=listener1.id)
        my_as_group_with_enhanced_lb = sbercloud.as_.Group("my_as_group_with_enhanced_lb",
            scaling_group_name="my_as_group_with_enhanced_lb",
            scaling_configuration_id=configuration_id,
            desire_instance_number=2,
            min_instance_number=0,
            max_instance_number=10,
            vpc_id=vpc_id,
            networks=[{
                "id": subnet_id,
            }],
            lbaas_listeners=[{
                "pool_id": pool1.id,
                "protocol_port": listener1.protocol_port,
            }])
        ```

        ## Import

        AS groups can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:As/group:Group my_as_group 9ec5bea6-a728-4082-8109-5a7dc5c7af74
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_instances: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desire_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_periodic_audit_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_periodic_audit_method: Optional[pulumi.Input[_builtins.str]] = None,
                 health_periodic_audit_time: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_terminate_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 lb_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupLbaasListenerArgs', 'GroupLbaasListenerArgsDict']]]]] = None,
                 max_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
                 multi_az_scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupNetworkArgs', 'GroupNetworkArgsDict']]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupSecurityGroupArgs', 'GroupSecurityGroupArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["cool_down_time"] = cool_down_time
            __props__.__dict__["delete_instances"] = delete_instances
            __props__.__dict__["delete_publicip"] = delete_publicip
            __props__.__dict__["delete_volume"] = delete_volume
            __props__.__dict__["description"] = description
            __props__.__dict__["desire_instance_number"] = desire_instance_number
            __props__.__dict__["enable"] = enable
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["health_periodic_audit_grace_period"] = health_periodic_audit_grace_period
            __props__.__dict__["health_periodic_audit_method"] = health_periodic_audit_method
            __props__.__dict__["health_periodic_audit_time"] = health_periodic_audit_time
            __props__.__dict__["instance_terminate_policy"] = instance_terminate_policy
            __props__.__dict__["lb_listener_id"] = lb_listener_id
            __props__.__dict__["lbaas_listeners"] = lbaas_listeners
            __props__.__dict__["max_instance_number"] = max_instance_number
            __props__.__dict__["min_instance_number"] = min_instance_number
            __props__.__dict__["multi_az_scaling_policy"] = multi_az_scaling_policy
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["region"] = region
            __props__.__dict__["scaling_configuration_id"] = scaling_configuration_id
            if scaling_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_name'")
            __props__.__dict__["scaling_group_name"] = scaling_group_name
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["activity_type"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_instance_number"] = None
            __props__.__dict__["detail"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["is_scaling"] = None
            __props__.__dict__["scaling_configuration_name"] = None
            __props__.__dict__["status"] = None
        super(Group, __self__).__init__(
            'sbercloud:As/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activity_type: Optional[pulumi.Input[_builtins.str]] = None,
            agency_name: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            current_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
            delete_instances: Optional[pulumi.Input[_builtins.str]] = None,
            delete_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_volume: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            desire_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
            detail: Optional[pulumi.Input[_builtins.str]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            health_periodic_audit_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
            health_periodic_audit_method: Optional[pulumi.Input[_builtins.str]] = None,
            health_periodic_audit_time: Optional[pulumi.Input[_builtins.int]] = None,
            instance_terminate_policy: Optional[pulumi.Input[_builtins.str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_scaling: Optional[pulumi.Input[_builtins.bool]] = None,
            lb_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            lbaas_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupLbaasListenerArgs', 'GroupLbaasListenerArgsDict']]]]] = None,
            max_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
            min_instance_number: Optional[pulumi.Input[_builtins.int]] = None,
            multi_az_scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupNetworkArgs', 'GroupNetworkArgsDict']]]]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupSecurityGroupArgs', 'GroupSecurityGroupArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name. If you change the agency,
               the new agency will be available for ECSs scaled out after the change.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the availability zones in which to create the instances in the
               autoscaling group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; use availability_zones instead
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
               and is 300 by default.
        :param pulumi.Input[_builtins.int] current_instance_number: The number of current instances in the AS group.
        :param pulumi.Input[_builtins.str] delete_instances: Specifies whether to delete the instances in the AS group when deleting
               the AS group. The options are `yes` and `no`.
        :param pulumi.Input[_builtins.bool] delete_publicip: Specifies whether to delete the elastic IP address bound to the instances of
               AS group when deleting the instances. The options are `true` and `false`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the AS group.
               The value can contain 0 to 256 characters.
        :param pulumi.Input[_builtins.int] desire_instance_number: Specifies the expected number of instances. The default value is the
               minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the AS Group. The options are `true` and `false`.
               The default value is `true`.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the AS group.
               
               <a name="group_network_object"></a>
               The `networks` block supports:
        :param pulumi.Input[_builtins.bool] force_delete: Specifies whether to forcibly delete the AS group, remove the ECS instances and
               release them. The default value is `false`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_grace_period: Specifies the health check grace period for instances.
               The unit is second and the value ranges from 0 to 86400. The default value is 600.
               
               > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        :param pulumi.Input[_builtins.str] health_periodic_audit_method: Specifies the health check method for instances in the AS group.
               The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
               this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        :param pulumi.Input[_builtins.int] health_periodic_audit_time: Specifies the health check period for instances. The unit is minute
               and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        :param pulumi.Input[_builtins.str] instance_terminate_policy: Specifies the instance removal policy. The policy has four
               options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.
               
               + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
               are removed first.
               + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
               + **OLD_INSTANCE**: The earlier-created instances are removed first.
               + **NEW_INSTANCE**: The later-created instances are removed first.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instances IDs of the AS group.
        :param pulumi.Input[_builtins.str] lb_listener_id: The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupLbaasListenerArgs', 'GroupLbaasListenerArgsDict']]]] lbaas_listeners: Specifies an array of one or more enhanced load balancer. The system supports
               the binding of up to six load balancers. The object structure is documented below.
        :param pulumi.Input[_builtins.int] max_instance_number: Specifies the maximum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.int] min_instance_number: Specifies the minimum number of instances. The default value is 0.
        :param pulumi.Input[_builtins.str] multi_az_scaling_policy: Specifies the priority policy used to select target AZs when adjusting
               the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.
               
               + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
               availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
               on the PICK_FIRST policy.
               + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
               availability_zones list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupNetworkArgs', 'GroupNetworkArgsDict']]]] networks: Specifies an array of one or more network IDs. The system supports up to five networks.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: schema: Deprecated; The notification mode has been canceled
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS group.
               If omitted, the provider-level region will be used. Changing this creates a new group.
        :param pulumi.Input[_builtins.str] scaling_configuration_id: Specifies the configuration ID which defines configurations
               of instances in the AS group.
        :param pulumi.Input[_builtins.str] scaling_group_name: Specifies the name of the scaling group. The name can contain
               letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupSecurityGroupArgs', 'GroupSecurityGroupArgsDict']]]] security_groups: Specifies an array of one or more security group IDs to associate with the group.
               The object structure is documented below.
               
               > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
               the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
               ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
               group in the AS configuration.
        :param pulumi.Input[_builtins.str] status: The status of the AS group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the AS group.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["activity_type"] = activity_type
        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["cool_down_time"] = cool_down_time
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["current_instance_number"] = current_instance_number
        __props__.__dict__["delete_instances"] = delete_instances
        __props__.__dict__["delete_publicip"] = delete_publicip
        __props__.__dict__["delete_volume"] = delete_volume
        __props__.__dict__["description"] = description
        __props__.__dict__["desire_instance_number"] = desire_instance_number
        __props__.__dict__["detail"] = detail
        __props__.__dict__["enable"] = enable
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["health_periodic_audit_grace_period"] = health_periodic_audit_grace_period
        __props__.__dict__["health_periodic_audit_method"] = health_periodic_audit_method
        __props__.__dict__["health_periodic_audit_time"] = health_periodic_audit_time
        __props__.__dict__["instance_terminate_policy"] = instance_terminate_policy
        __props__.__dict__["instances"] = instances
        __props__.__dict__["is_scaling"] = is_scaling
        __props__.__dict__["lb_listener_id"] = lb_listener_id
        __props__.__dict__["lbaas_listeners"] = lbaas_listeners
        __props__.__dict__["max_instance_number"] = max_instance_number
        __props__.__dict__["min_instance_number"] = min_instance_number
        __props__.__dict__["multi_az_scaling_policy"] = multi_az_scaling_policy
        __props__.__dict__["networks"] = networks
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_configuration_id"] = scaling_configuration_id
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_name"] = scaling_group_name
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activityType")
    def activity_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "activity_type")

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IAM agency name. If you change the agency,
        the new agency will be available for ECSs scaled out after the change.
        """
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the availability zones in which to create the instances in the
        autoscaling group.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        schema: Deprecated; use availability_zones instead
        """
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the cooling duration (in seconds). The value ranges from 0 to 86400,
        and is 300 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="currentInstanceNumber")
    def current_instance_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of current instances in the AS group.
        """
        return pulumi.get(self, "current_instance_number")

    @_builtins.property
    @pulumi.getter(name="deleteInstances")
    def delete_instances(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to delete the instances in the AS group when deleting
        the AS group. The options are `yes` and `no`.
        """
        return pulumi.get(self, "delete_instances")

    @_builtins.property
    @pulumi.getter(name="deletePublicip")
    def delete_publicip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to delete the elastic IP address bound to the instances of
        AS group when deleting the instances. The options are `true` and `false`.
        """
        return pulumi.get(self, "delete_publicip")

    @_builtins.property
    @pulumi.getter(name="deleteVolume")
    def delete_volume(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "delete_volume")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the AS group.
        The value can contain 0 to 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="desireInstanceNumber")
    def desire_instance_number(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the expected number of instances. The default value is the
        minimum number of instances. The value ranges from the minimum number of instances to the maximum number of instances.
        """
        return pulumi.get(self, "desire_instance_number")

    @_builtins.property
    @pulumi.getter
    def detail(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "detail")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the AS Group. The options are `true` and `false`.
        The default value is `true`.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the AS group.

        <a name="group_network_object"></a>
        The `networks` block supports:
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcibly delete the AS group, remove the ECS instances and
        release them. The default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditGracePeriod")
    def health_periodic_audit_grace_period(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the health check grace period for instances.
        The unit is second and the value ranges from 0 to 86400. The default value is 600.

        > This parameter is valid only when the instance health check method of the AS group is `ELB_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_grace_period")

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditMethod")
    def health_periodic_audit_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the health check method for instances in the AS group.
        The health check methods include `ELB_AUDIT` and `NOVA_AUDIT`. If load balancing is configured, the default value of
        this parameter is `ELB_AUDIT`. Otherwise, the default value is `NOVA_AUDIT`.
        """
        return pulumi.get(self, "health_periodic_audit_method")

    @_builtins.property
    @pulumi.getter(name="healthPeriodicAuditTime")
    def health_periodic_audit_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the health check period for instances. The unit is minute
        and value includes 0, 1, 5 (default), 15, 60, and 180. If the value is set to 0, health check is performed every 10 seconds.
        """
        return pulumi.get(self, "health_periodic_audit_time")

    @_builtins.property
    @pulumi.getter(name="instanceTerminatePolicy")
    def instance_terminate_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the instance removal policy. The policy has four
        options: `OLD_CONFIG_OLD_INSTANCE` (default), `OLD_CONFIG_NEW_INSTANCE`, `OLD_INSTANCE`, and `NEW_INSTANCE`.

        + **OLD_CONFIG_OLD_INSTANCE** (default): The earlier-created instances based on the earlier-created AS configurations
        are removed first.
        + **OLD_CONFIG_NEW_INSTANCE**: The later-created instances based on the earlier-created AS configurations are removed first.
        + **OLD_INSTANCE**: The earlier-created instances are removed first.
        + **NEW_INSTANCE**: The later-created instances are removed first.
        """
        return pulumi.get(self, "instance_terminate_policy")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The instances IDs of the AS group.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="isScaling")
    def is_scaling(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_scaling")

    @_builtins.property
    @pulumi.getter(name="lbListenerId")
    @_utilities.deprecated("""use lbaas_listeners instead""")
    def lb_listener_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The system supports the binding of up to six ELB listeners, the IDs of which are separated using a comma.
        """
        return pulumi.get(self, "lb_listener_id")

    @_builtins.property
    @pulumi.getter(name="lbaasListeners")
    def lbaas_listeners(self) -> pulumi.Output[Sequence['outputs.GroupLbaasListener']]:
        """
        Specifies an array of one or more enhanced load balancer. The system supports
        the binding of up to six load balancers. The object structure is documented below.
        """
        return pulumi.get(self, "lbaas_listeners")

    @_builtins.property
    @pulumi.getter(name="maxInstanceNumber")
    def max_instance_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of instances. The default value is 0.
        """
        return pulumi.get(self, "max_instance_number")

    @_builtins.property
    @pulumi.getter(name="minInstanceNumber")
    def min_instance_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the minimum number of instances. The default value is 0.
        """
        return pulumi.get(self, "min_instance_number")

    @_builtins.property
    @pulumi.getter(name="multiAzScalingPolicy")
    def multi_az_scaling_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the priority policy used to select target AZs when adjusting
        the number of instances in an AS group. The value can be `EQUILIBRIUM_DISTRIBUTE` and `PICK_FIRST`.

        + **EQUILIBRIUM_DISTRIBUTE** (default): When adjusting the number of instances, ensure that instances in each AZ in the
        availability_zones list is evenly distributed. If instances cannot be added in the target AZ, select another AZ based
        on the PICK_FIRST policy.
        + **PICK_FIRST**: When adjusting the number of instances, target AZs are determined in the order in the
        availability_zones list.
        """
        return pulumi.get(self, "multi_az_scaling_policy")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.GroupNetwork']]:
        """
        Specifies an array of one or more network IDs. The system supports up to five networks.
        The object structure is documented below.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        schema: Deprecated; The notification mode has been canceled
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the AS group.
        If omitted, the provider-level region will be used. Changing this creates a new group.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationId")
    def scaling_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the configuration ID which defines configurations
        of instances in the AS group.
        """
        return pulumi.get(self, "scaling_configuration_id")

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "scaling_configuration_name")

    @_builtins.property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the scaling group. The name can contain
        letters, digits, underscores(_), and hyphens(-),and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_group_name")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence['outputs.GroupSecurityGroup']]:
        """
        Specifies an array of one or more security group IDs to associate with the group.
        The object structure is documented below.

        > If the security group is specified both in the AS configuration and AS group, scaled ECS instances will be added to
        the security group specified in the AS configuration. If the security group is not specified in either of them, scaled
        ECS instances will be added to the default security group. For your convenience, you are advised to specify the security
        group in the AS configuration.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the AS group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the AS group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID. Changing this creates a new group.
        """
        return pulumi.get(self, "vpc_id")

