# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BandwidthPolicyIntervalAlarmAction',
    'BandwidthPolicyMetaData',
    'BandwidthPolicyScalingPolicyAction',
    'BandwidthPolicyScheduledPolicy',
    'ConfigurationInstanceConfig',
    'ConfigurationInstanceConfigDisk',
    'ConfigurationInstanceConfigPersonality',
    'ConfigurationInstanceConfigPublicIp',
    'ConfigurationInstanceConfigPublicIpEip',
    'ConfigurationInstanceConfigPublicIpEipBandwidth',
    'GroupLbaasListener',
    'GroupNetwork',
    'GroupSecurityGroup',
    'PolicyScalingPolicyAction',
    'PolicyScheduledPolicy',
]

@pulumi.output_type
class BandwidthPolicyIntervalAlarmAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lowerBound":
            suggest = "lower_bound"
        elif key == "upperBound":
            suggest = "upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPolicyIntervalAlarmAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPolicyIntervalAlarmAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPolicyIntervalAlarmAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limits: Optional[_builtins.int] = None,
                 lower_bound: Optional[_builtins.str] = None,
                 operation: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 upper_bound: Optional[_builtins.str] = None):
        """
        :param _builtins.int limits: Specifies the operation restrictions.
               - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
               - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
               - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.
               
               <a name="ASBandWidthPolicy_ScheduledPolicy"></a>
               The `scheduled_policy` block supports:
        :param _builtins.str lower_bound: Specifies the lower limit of the value range.
        :param _builtins.str operation: Specifies the operation to be performed. The default operation is ADD.
               The options are as follows:
               - **ADD**: indicates adding the bandwidth size.
               - **REDUCE**: indicates reducing the bandwidth size.
               - **SET**: indicates setting the bandwidth size to a specified value.
        :param _builtins.int size: Specifies the bandwidth (Mbit/s).
               The value is an integer from 1 to 2000. The default value is 1.
        :param _builtins.str upper_bound: Specifies the upper limit of the value range.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if lower_bound is not None:
            pulumi.set(__self__, "lower_bound", lower_bound)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if upper_bound is not None:
            pulumi.set(__self__, "upper_bound", upper_bound)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[_builtins.int]:
        """
        Specifies the operation restrictions.
        - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
        - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
        - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.

        <a name="ASBandWidthPolicy_ScheduledPolicy"></a>
        The `scheduled_policy` block supports:
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> Optional[_builtins.str]:
        """
        Specifies the lower limit of the value range.
        """
        return pulumi.get(self, "lower_bound")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[_builtins.str]:
        """
        Specifies the operation to be performed. The default operation is ADD.
        The options are as follows:
        - **ADD**: indicates adding the bandwidth size.
        - **REDUCE**: indicates reducing the bandwidth size.
        - **SET**: indicates setting the bandwidth size to a specified value.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth (Mbit/s).
        The value is an integer from 1 to 2000. The default value is 1.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> Optional[_builtins.str]:
        """
        Specifies the upper limit of the value range.
        """
        return pulumi.get(self, "upper_bound")


@pulumi.output_type
class BandwidthPolicyMetaData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataBandwidthShareType":
            suggest = "metadata_bandwidth_share_type"
        elif key == "metadataEipAddress":
            suggest = "metadata_eip_address"
        elif key == "metadataEipId":
            suggest = "metadata_eip_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPolicyMetaData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPolicyMetaData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPolicyMetaData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_bandwidth_share_type: Optional[_builtins.str] = None,
                 metadata_eip_address: Optional[_builtins.str] = None,
                 metadata_eip_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str metadata_bandwidth_share_type: The bandwidth sharing type in the bandwidth policy.
        :param _builtins.str metadata_eip_address: The EIP IP address for the bandwidth in the bandwidth policy.
        :param _builtins.str metadata_eip_id: The EIP ID for the bandwidth in the bandwidth policy.
        """
        if metadata_bandwidth_share_type is not None:
            pulumi.set(__self__, "metadata_bandwidth_share_type", metadata_bandwidth_share_type)
        if metadata_eip_address is not None:
            pulumi.set(__self__, "metadata_eip_address", metadata_eip_address)
        if metadata_eip_id is not None:
            pulumi.set(__self__, "metadata_eip_id", metadata_eip_id)

    @_builtins.property
    @pulumi.getter(name="metadataBandwidthShareType")
    def metadata_bandwidth_share_type(self) -> Optional[_builtins.str]:
        """
        The bandwidth sharing type in the bandwidth policy.
        """
        return pulumi.get(self, "metadata_bandwidth_share_type")

    @_builtins.property
    @pulumi.getter(name="metadataEipAddress")
    def metadata_eip_address(self) -> Optional[_builtins.str]:
        """
        The EIP IP address for the bandwidth in the bandwidth policy.
        """
        return pulumi.get(self, "metadata_eip_address")

    @_builtins.property
    @pulumi.getter(name="metadataEipId")
    def metadata_eip_id(self) -> Optional[_builtins.str]:
        """
        The EIP ID for the bandwidth in the bandwidth policy.
        """
        return pulumi.get(self, "metadata_eip_id")


@pulumi.output_type
class BandwidthPolicyScalingPolicyAction(dict):
    def __init__(__self__, *,
                 limits: Optional[_builtins.int] = None,
                 operation: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.int limits: Specifies the operation restrictions.
               - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
               - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
               - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.
               
               <a name="ASBandWidthPolicy_ScheduledPolicy"></a>
               The `scheduled_policy` block supports:
        :param _builtins.str operation: Specifies the operation to be performed. The default operation is ADD.
               The options are as follows:
               - **ADD**: indicates adding the bandwidth size.
               - **REDUCE**: indicates reducing the bandwidth size.
               - **SET**: indicates setting the bandwidth size to a specified value.
        :param _builtins.int size: Specifies the bandwidth (Mbit/s).
               The value is an integer from 1 to 2000. The default value is 1.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[_builtins.int]:
        """
        Specifies the operation restrictions.
        - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
        - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
        - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.

        <a name="ASBandWidthPolicy_ScheduledPolicy"></a>
        The `scheduled_policy` block supports:
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[_builtins.str]:
        """
        Specifies the operation to be performed. The default operation is ADD.
        The options are as follows:
        - **ADD**: indicates adding the bandwidth size.
        - **REDUCE**: indicates reducing the bandwidth size.
        - **SET**: indicates setting the bandwidth size to a specified value.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth (Mbit/s).
        The value is an integer from 1 to 2000. The default value is 1.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class BandwidthPolicyScheduledPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTime":
            suggest = "launch_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "recurrenceType":
            suggest = "recurrence_type"
        elif key == "recurrenceValue":
            suggest = "recurrence_value"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPolicyScheduledPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPolicyScheduledPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPolicyScheduledPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_time: _builtins.str,
                 end_time: Optional[_builtins.str] = None,
                 recurrence_type: Optional[_builtins.str] = None,
                 recurrence_value: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str launch_time: Specifies the time when the scaling action is triggered.
               The time format complies with UTC.
               - If scaling_policy_type is set to SCHEDULED, the time format is YYYY-MM-DDThh:mmZ.
               - If scaling_policy_type is set to RECURRENCE, the time format is hh:mm.
        :param _builtins.str end_time: Specifies the end time of the scaling action triggered periodically.
               The time format complies with UTC. This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
               When the scaling action is triggered periodically, the end time cannot be earlier than the current and start time.
               The time format is YYYY-MM-DDThh:mmZ.
        :param _builtins.str recurrence_type: Specifies the periodic triggering type.
               This parameter is mandatory when scaling_policy_type is set to RECURRENCE. The options are as follows:
               - **Daily**: indicates that the scaling action is triggered once a day.
               - **Weekly**: indicates that the scaling action is triggered once a week.
               - **Monthly**: indicates that the scaling action is triggered once a month.
        :param _builtins.str recurrence_value: Specifies the day when a periodic scaling action is triggered.
               This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
               - If recurrence_type is set to Daily, the value is null, indicating that the scaling action is triggered once a day.
               - If recurrence_type is set to Weekly, the value ranges from 1 (Sunday) to 7 (Saturday).
               The digits refer to dates in each week and separated by a comma, such as 1,3,5.
               - If recurrence_type is set to Monthly, the value ranges from 1 to 31.
               The digits refer to the dates in each month and separated by a comma, such as 1,10,13,28.
        :param _builtins.str start_time: Specifies the start time of the scaling action triggered periodically.
               The time format complies with UTC. The default value is the local time.
               The time format is YYYY-MM-DDThh:mmZ.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> _builtins.str:
        """
        Specifies the time when the scaling action is triggered.
        The time format complies with UTC.
        - If scaling_policy_type is set to SCHEDULED, the time format is YYYY-MM-DDThh:mmZ.
        - If scaling_policy_type is set to RECURRENCE, the time format is hh:mm.
        """
        return pulumi.get(self, "launch_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        Specifies the end time of the scaling action triggered periodically.
        The time format complies with UTC. This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
        When the scaling action is triggered periodically, the end time cannot be earlier than the current and start time.
        The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[_builtins.str]:
        """
        Specifies the periodic triggering type.
        This parameter is mandatory when scaling_policy_type is set to RECURRENCE. The options are as follows:
        - **Daily**: indicates that the scaling action is triggered once a day.
        - **Weekly**: indicates that the scaling action is triggered once a week.
        - **Monthly**: indicates that the scaling action is triggered once a month.
        """
        return pulumi.get(self, "recurrence_type")

    @_builtins.property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[_builtins.str]:
        """
        Specifies the day when a periodic scaling action is triggered.
        This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
        - If recurrence_type is set to Daily, the value is null, indicating that the scaling action is triggered once a day.
        - If recurrence_type is set to Weekly, the value ranges from 1 (Sunday) to 7 (Saturday).
        The digits refer to dates in each week and separated by a comma, such as 1,3,5.
        - If recurrence_type is set to Monthly, the value ranges from 1 to 31.
        The digits refer to the dates in each month and separated by a comma, such as 1,10,13,28.
        """
        return pulumi.get(self, "recurrence_value")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Specifies the start time of the scaling action triggered periodically.
        The time format complies with UTC. The default value is the local time.
        The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ConfigurationInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPass":
            suggest = "admin_pass"
        elif key == "chargingMode":
            suggest = "charging_mode"
        elif key == "dedicatedHostId":
            suggest = "dedicated_host_id"
        elif key == "ecsGroupId":
            suggest = "ecs_group_id"
        elif key == "flavorPriorityPolicy":
            suggest = "flavor_priority_policy"
        elif key == "instanceId":
            suggest = "instance_id"
        elif key == "keyFingerprint":
            suggest = "key_fingerprint"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "userData":
            suggest = "user_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_pass: Optional[_builtins.str] = None,
                 charging_mode: Optional[_builtins.str] = None,
                 dedicated_host_id: Optional[_builtins.str] = None,
                 disks: Optional[Sequence['outputs.ConfigurationInstanceConfigDisk']] = None,
                 ecs_group_id: Optional[_builtins.str] = None,
                 flavor: Optional[_builtins.str] = None,
                 flavor_priority_policy: Optional[_builtins.str] = None,
                 image: Optional[_builtins.str] = None,
                 instance_id: Optional[_builtins.str] = None,
                 key_fingerprint: Optional[_builtins.str] = None,
                 key_name: Optional[_builtins.str] = None,
                 metadata: Optional[Mapping[str, _builtins.str]] = None,
                 personalities: Optional[Sequence['outputs.ConfigurationInstanceConfigPersonality']] = None,
                 public_ip: Optional['outputs.ConfigurationInstanceConfigPublicIp'] = None,
                 security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 tenancy: Optional[_builtins.str] = None,
                 user_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str charging_mode: Specifies a billing mode for an ECS.
               The value can be `postPaid` and `spot`. The default value is `postPaid`.
               Changing this will create a new resource.
        :param Sequence['ConfigurationInstanceConfigDiskArgs'] disks: Specifies the disk group information. System disks are mandatory and
               data disks are optional. The object structure is documented below.
               Changing this will create a new resource.
        :param _builtins.str ecs_group_id: Specifies the ECS group ID. Changing this will create a new resource.
        :param _builtins.str flavor: Specifies the ECS flavor name. A maximum of 10 flavors can be selected.
               Use a comma (,) to separate multiple flavor names. Changing this will create a new resource.
        :param _builtins.str flavor_priority_policy: Specifies the priority policy used when there are multiple flavors
               and instances to be created using an AS configuration. The value can be `PICK_FIRST` and `COST_FIRST`.
               
               + **PICK_FIRST** (default): When an ECS is added for capacity expansion, the target flavor is determined in the order
               in the flavor list.
               + **COST_FIRST**: When an ECS is added for capacity expansion, the target flavor is determined for minimal expenses.
               
               Changing this will create a new resource.
        :param _builtins.str image: Specifies the ECS image ID. Changing this will create a new resource.
        :param _builtins.str instance_id: Specifies the ECS instance ID when using its specification
               as the template to create AS configurations. In this case, `flavor`, `image`, and `disk` arguments do not take effect.
               If this argument is not specified, `flavor`, `image`, and `disk` arguments are mandatory.
               Changing this will create a new resource.
        :param _builtins.str key_name: Specifies the name of the SSH key pair used to log in to the instance.
               Changing this will create a new resource.
        :param Mapping[str, _builtins.str] metadata: Specifies the key/value pairs to make available from within the instance.
               Changing this will create a new resource.
        :param Sequence['ConfigurationInstanceConfigPersonalityArgs'] personalities: Specifies the customize personality of an instance by defining one or
               more files and their contents. The object structure is documented below.
               Changing this will create a new resource.
               
               <a name="instance_config_disk_object"></a>
               The `disk` block supports:
        :param 'ConfigurationInstanceConfigPublicIpArgs' public_ip: Specifies the EIP of the ECS instance.
               The object structure is documented below.
               Changing this will create a new resource.
        :param Sequence[_builtins.str] security_group_ids: Specifies an array of one or more security group IDs.
               Changing this will create a new resource.
        :param _builtins.str user_data: Specifies the user data to provide when launching the instance.
               The file content must be encoded with Base64. Changing this will create a new resource.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if flavor_priority_policy is not None:
            pulumi.set(__self__, "flavor_priority_policy", flavor_priority_policy)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key_fingerprint is not None:
            pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if personalities is not None:
            pulumi.set(__self__, "personalities", personalities)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "admin_pass")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        """
        Specifies a billing mode for an ECS.
        The value can be `postPaid` and `spot`. The default value is `postPaid`.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dedicated_host_id")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.ConfigurationInstanceConfigDisk']]:
        """
        Specifies the disk group information. System disks are mandatory and
        data disks are optional. The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ECS group ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[_builtins.str]:
        """
        Specifies the ECS flavor name. A maximum of 10 flavors can be selected.
        Use a comma (,) to separate multiple flavor names. Changing this will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="flavorPriorityPolicy")
    def flavor_priority_policy(self) -> Optional[_builtins.str]:
        """
        Specifies the priority policy used when there are multiple flavors
        and instances to be created using an AS configuration. The value can be `PICK_FIRST` and `COST_FIRST`.

        + **PICK_FIRST** (default): When an ECS is added for capacity expansion, the target flavor is determined in the order
        in the flavor list.
        + **COST_FIRST**: When an ECS is added for capacity expansion, the target flavor is determined for minimal expenses.

        Changing this will create a new resource.
        """
        return pulumi.get(self, "flavor_priority_policy")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Specifies the ECS image ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ECS instance ID when using its specification
        as the template to create AS configurations. In this case, `flavor`, `image`, and `disk` arguments do not take effect.
        If this argument is not specified, `flavor`, `image`, and `disk` arguments are mandatory.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_fingerprint")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the SSH key pair used to log in to the instance.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the key/value pairs to make available from within the instance.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def personalities(self) -> Optional[Sequence['outputs.ConfigurationInstanceConfigPersonality']]:
        """
        Specifies the customize personality of an instance by defining one or
        more files and their contents. The object structure is documented below.
        Changing this will create a new resource.

        <a name="instance_config_disk_object"></a>
        The `disk` block supports:
        """
        return pulumi.get(self, "personalities")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional['outputs.ConfigurationInstanceConfigPublicIp']:
        """
        Specifies the EIP of the ECS instance.
        The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of one or more security group IDs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenancy")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[_builtins.str]:
        """
        Specifies the user data to provide when launching the instance.
        The file content must be encoded with Base64. Changing this will create a new resource.
        """
        return pulumi.get(self, "user_data")


@pulumi.output_type
class ConfigurationInstanceConfigDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "volumeType":
            suggest = "volume_type"
        elif key == "dataDiskImageId":
            suggest = "data_disk_image_id"
        elif key == "dedicatedStorageId":
            suggest = "dedicated_storage_id"
        elif key == "kmsId":
            suggest = "kms_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstanceConfigDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstanceConfigDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstanceConfigDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: _builtins.str,
                 size: _builtins.int,
                 volume_type: _builtins.str,
                 data_disk_image_id: Optional[_builtins.str] = None,
                 dedicated_storage_id: Optional[_builtins.str] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_id: Optional[_builtins.str] = None,
                 snapshot_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.str disk_type: Specifies whether the disk is a system disk or a data disk.
               Option **DATA** indicates a data disk, option **SYS** indicates a system disk.
               Changing this will create a new resource.
        :param _builtins.str volume_type: Specifies the disk type. Changing this will create a new resource.
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
        :param _builtins.str kms_id: Specifies the encryption KMS ID of the **DATA** disk.
               Changing this will create a new resource.
               
               <a name="instance_config_public_ip_object"></a>
               The `public_ip` block supports:
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)
        if data_disk_image_id is not None:
            pulumi.set(__self__, "data_disk_image_id", data_disk_image_id)
        if dedicated_storage_id is not None:
            pulumi.set(__self__, "dedicated_storage_id", dedicated_storage_id)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        Specifies whether the disk is a system disk or a data disk.
        Option **DATA** indicates a data disk, option **SYS** indicates a system disk.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Specifies the disk type. Changing this will create a new resource.
        Available options are:
        + `SAS`: high I/O disk type.
        + `SSD`: ultra-high I/O disk type.
        + `GPSSD`: general purpose SSD disk type.
        """
        return pulumi.get(self, "volume_type")

    @_builtins.property
    @pulumi.getter(name="dataDiskImageId")
    def data_disk_image_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "data_disk_image_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedStorageId")
    def dedicated_storage_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dedicated_storage_id")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[_builtins.str]:
        """
        Specifies the encryption KMS ID of the **DATA** disk.
        Changing this will create a new resource.

        <a name="instance_config_public_ip_object"></a>
        The `public_ip` block supports:
        """
        return pulumi.get(self, "kms_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")


@pulumi.output_type
class ConfigurationInstanceConfigPersonality(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str content: Specifies the content of the injected file, which must be encoded with base64.
               Changing this creates a new resource.
        :param _builtins.str path: Specifies the path of the injected file. Changing this creates a new resource.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Specifies the content of the injected file, which must be encoded with base64.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Specifies the path of the injected file. Changing this creates a new resource.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ConfigurationInstanceConfigPublicIp(dict):
    def __init__(__self__, *,
                 eip: 'outputs.ConfigurationInstanceConfigPublicIpEip'):
        """
        :param 'ConfigurationInstanceConfigPublicIpEipArgs' eip: Specifies the EIP configuration that will be automatically assigned to the instance.
               The object structure is documented below. Changing this will create a new resource.
        """
        pulumi.set(__self__, "eip", eip)

    @_builtins.property
    @pulumi.getter
    def eip(self) -> 'outputs.ConfigurationInstanceConfigPublicIpEip':
        """
        Specifies the EIP configuration that will be automatically assigned to the instance.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "eip")


@pulumi.output_type
class ConfigurationInstanceConfigPublicIpEip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipType":
            suggest = "ip_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstanceConfigPublicIpEip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstanceConfigPublicIpEip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstanceConfigPublicIpEip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth: 'outputs.ConfigurationInstanceConfigPublicIpEipBandwidth',
                 ip_type: _builtins.str):
        """
        :param 'ConfigurationInstanceConfigPublicIpEipBandwidthArgs' bandwidth: Specifies the bandwidth information. The object structure is documented below.
               Changing this will create a new resource.
        :param _builtins.str ip_type: Specifies the EIP type. Possible values are **5_bgp** (dynamic BGP)
               and **5_sbgp** (static BGP). Changing this will create a new resource.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "ip_type", ip_type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> 'outputs.ConfigurationInstanceConfigPublicIpEipBandwidth':
        """
        Specifies the bandwidth information. The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> _builtins.str:
        """
        Specifies the EIP type. Possible values are **5_bgp** (dynamic BGP)
        and **5_sbgp** (static BGP). Changing this will create a new resource.
        """
        return pulumi.get(self, "ip_type")


@pulumi.output_type
class ConfigurationInstanceConfigPublicIpEipBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareType":
            suggest = "share_type"
        elif key == "chargingMode":
            suggest = "charging_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationInstanceConfigPublicIpEipBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationInstanceConfigPublicIpEipBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationInstanceConfigPublicIpEipBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_type: _builtins.str,
                 charging_mode: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str share_type: Specifies the bandwidth sharing type. The system only supports
               **PER** (indicates exclusive bandwidth). Changing this will create a new resource.
        :param _builtins.str charging_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be **traffic** or **bandwidth**. Changing this creates a new resource.
        :param _builtins.str id: The resource ID in UUID format.
        :param _builtins.int size: Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
               is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
               Changing this creates a new resource.
               
               <a name="instance_config_personality_object"></a>
               The `personality` block supports:
        """
        pulumi.set(__self__, "share_type", share_type)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Specifies the bandwidth sharing type. The system only supports
        **PER** (indicates exclusive bandwidth). Changing this will create a new resource.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[_builtins.str]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be **traffic** or **bandwidth**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
        is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
        Changing this creates a new resource.

        <a name="instance_config_personality_object"></a>
        The `personality` block supports:
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GroupLbaasListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "poolId":
            suggest = "pool_id"
        elif key == "protocolPort":
            suggest = "protocol_port"
        elif key == "listenerId":
            suggest = "listener_id"
        elif key == "protocolVersion":
            suggest = "protocol_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupLbaasListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupLbaasListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupLbaasListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pool_id: _builtins.str,
                 protocol_port: _builtins.int,
                 listener_id: Optional[_builtins.str] = None,
                 protocol_version: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str pool_id: Specifies the backend ECS group ID.
        :param _builtins.int protocol_port: Specifies the backend protocol, which is the port on which a backend ECS listens for
               traffic. The number of the port ranges from 1 to 65535.
        :param _builtins.int weight: Specifies the weight, which determines the portion of requests a backend ECS processes
               compared to other backend ECSs added to the same listener. The value of this parameter ranges from 0 to 100. The
               default value is 1.
        """
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> _builtins.str:
        """
        Specifies the backend ECS group ID.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> _builtins.int:
        """
        Specifies the backend protocol, which is the port on which a backend ECS listens for
        traffic. The number of the port ranges from 1 to 65535.
        """
        return pulumi.get(self, "protocol_port")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Specifies the weight, which determines the portion of requests a backend ECS processes
        compared to other backend ECSs added to the same listener. The value of this parameter ranges from 0 to 100. The
        default value is 1.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GroupNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv6BandwidthId":
            suggest = "ipv6_bandwidth_id"
        elif key == "ipv6Enable":
            suggest = "ipv6_enable"
        elif key == "sourceDestCheck":
            suggest = "source_dest_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 ipv6_bandwidth_id: Optional[_builtins.str] = None,
                 ipv6_enable: Optional[_builtins.bool] = None,
                 source_dest_check: Optional[_builtins.bool] = None):
        """
        :param _builtins.str id: Specifies the ID of the security group.
               
               <a name="group_lbaas_listener_object"></a>
               The `lbaas_listeners` block supports:
        :param _builtins.str ipv6_bandwidth_id: Specifies the ID of the shared bandwidth of an IPv6 address.
        :param _builtins.bool ipv6_enable: Specifies whether to support IPv6 addresses. The default value is `false`.
        :param _builtins.bool source_dest_check: Specifies whether processesing only traffic that is destined specifically
               for it. Defaults to true.
               
               <a name="group_security_group_object"></a>
               The `security_groups` block supports:
        """
        pulumi.set(__self__, "id", id)
        if ipv6_bandwidth_id is not None:
            pulumi.set(__self__, "ipv6_bandwidth_id", ipv6_bandwidth_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the ID of the security group.

        <a name="group_lbaas_listener_object"></a>
        The `lbaas_listeners` block supports:
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6BandwidthId")
    def ipv6_bandwidth_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the shared bandwidth of an IPv6 address.
        """
        return pulumi.get(self, "ipv6_bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to support IPv6 addresses. The default value is `false`.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[_builtins.bool]:
        """
        Specifies whether processesing only traffic that is destined specifically
        for it. Defaults to true.

        <a name="group_security_group_object"></a>
        The `security_groups` block supports:
        """
        return pulumi.get(self, "source_dest_check")


@pulumi.output_type
class GroupSecurityGroup(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: Specifies the ID of the security group.
               
               <a name="group_lbaas_listener_object"></a>
               The `lbaas_listeners` block supports:
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the ID of the security group.

        <a name="group_lbaas_listener_object"></a>
        The `lbaas_listeners` block supports:
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PolicyScalingPolicyAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceNumber":
            suggest = "instance_number"
        elif key == "instancePercentage":
            suggest = "instance_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyScalingPolicyAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyScalingPolicyAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyScalingPolicyAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_number: Optional[_builtins.int] = None,
                 instance_percentage: Optional[_builtins.int] = None,
                 operation: Optional[_builtins.str] = None):
        """
        :param _builtins.int instance_number: Specifies the number of instances to be operated. The default number is 1.
        :param _builtins.str operation: Specifies the operation to be performed. The options include `ADD` (default), `REMOVE`,
               and `SET`.
        """
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if instance_percentage is not None:
            pulumi.set(__self__, "instance_percentage", instance_percentage)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)

    @_builtins.property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[_builtins.int]:
        """
        Specifies the number of instances to be operated. The default number is 1.
        """
        return pulumi.get(self, "instance_number")

    @_builtins.property
    @pulumi.getter(name="instancePercentage")
    def instance_percentage(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "instance_percentage")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[_builtins.str]:
        """
        Specifies the operation to be performed. The options include `ADD` (default), `REMOVE`,
        and `SET`.
        """
        return pulumi.get(self, "operation")


@pulumi.output_type
class PolicyScheduledPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTime":
            suggest = "launch_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "recurrenceType":
            suggest = "recurrence_type"
        elif key == "recurrenceValue":
            suggest = "recurrence_value"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyScheduledPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyScheduledPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyScheduledPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_time: _builtins.str,
                 end_time: Optional[_builtins.str] = None,
                 recurrence_type: Optional[_builtins.str] = None,
                 recurrence_value: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str launch_time: Specifies the time when the scaling action is triggered.
               + If `scaling_policy_type` is set to `SCHEDULED`, the time format is **YYYY-MM-DDThh:mmZ**.
               + If `scaling_policy_type` is set to `RECURRENCE`, the time format is **hh:mm**.
               
               > the `launch_time` of the `SCHEDULED` policy cannot be earlier than the current time.
        :param _builtins.str end_time: Specifies the end time of the scaling action triggered periodically. The time format complies
               with UTC. This argument is mandatory when `scaling_policy_type`
               is set to `RECURRENCE`. The time format is YYYY-MM-DDThh:mmZ.
               
               <a name="scaling_policy_action_object"></a>
               The `scaling_policy_action` block supports:
        :param _builtins.str recurrence_type: Specifies the periodic triggering type. This argument is mandatory when
               `scaling_policy_type` is set to `RECURRENCE`. The options include `Daily`, `Weekly`, and `Monthly`.
        :param _builtins.str recurrence_value: Specifies the frequency at which scaling actions are triggered.
        :param _builtins.str start_time: Specifies the start time of the scaling action triggered periodically. The time format
               complies with UTC. The current time is used by default. The time format is YYYY-MM-DDThh:mmZ.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> _builtins.str:
        """
        Specifies the time when the scaling action is triggered.
        + If `scaling_policy_type` is set to `SCHEDULED`, the time format is **YYYY-MM-DDThh:mmZ**.
        + If `scaling_policy_type` is set to `RECURRENCE`, the time format is **hh:mm**.

        > the `launch_time` of the `SCHEDULED` policy cannot be earlier than the current time.
        """
        return pulumi.get(self, "launch_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        Specifies the end time of the scaling action triggered periodically. The time format complies
        with UTC. This argument is mandatory when `scaling_policy_type`
        is set to `RECURRENCE`. The time format is YYYY-MM-DDThh:mmZ.

        <a name="scaling_policy_action_object"></a>
        The `scaling_policy_action` block supports:
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[_builtins.str]:
        """
        Specifies the periodic triggering type. This argument is mandatory when
        `scaling_policy_type` is set to `RECURRENCE`. The options include `Daily`, `Weekly`, and `Monthly`.
        """
        return pulumi.get(self, "recurrence_type")

    @_builtins.property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[_builtins.str]:
        """
        Specifies the frequency at which scaling actions are triggered.
        """
        return pulumi.get(self, "recurrence_value")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Specifies the start time of the scaling action triggered periodically. The time format
        complies with UTC. The current time is used by default. The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "start_time")


