# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 scaling_policy_name: pulumi.Input[_builtins.str],
                 scaling_policy_type: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_action: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']] = None,
                 scheduled_policy: Optional[pulumi.Input['PolicyScheduledPolicyArgs']] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: Specifies the AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[_builtins.str] scaling_policy_name: Specifies the name of the AS policy. The name contains only letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[_builtins.str] scaling_policy_type: Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
               + **ALARM**: indicates that the scaling action is triggered by an alarm.
               + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
               + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        :param pulumi.Input[_builtins.str] alarm_id: Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
               is set to `ALARM`.
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds).
               The value ranges from 0 to 86400 and is 300 by default.
               
               <a name="scheduled_policy_object"></a>
               The `scheduled_policy` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS policy. If omitted, the
               provider-level region will be used. Changing this creates a new AS policy.
        :param pulumi.Input['PolicyScalingPolicyActionArgs'] scaling_policy_action: Specifies the action of the AS policy.
               The object structure is documented below.
        :param pulumi.Input['PolicyScheduledPolicyArgs'] scheduled_policy: Specifies the periodic or scheduled AS policy.
               This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
               The object structure is documented below.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_policy_action is not None:
            pulumi.set(__self__, "scaling_policy_action", scaling_policy_action)
        if scheduled_policy is not None:
            pulumi.set(__self__, "scheduled_policy", scheduled_policy)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the AS policy. The name contains only letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
        + **ALARM**: indicates that the scaling action is triggered by an alarm.
        + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
        + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
        is set to `ALARM`.
        """
        return pulumi.get(self, "alarm_id")

    @alarm_id.setter
    def alarm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cooling duration (in seconds).
        The value ranges from 0 to 86400 and is 300 by default.

        <a name="scheduled_policy_object"></a>
        The `scheduled_policy` block supports:
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cool_down_time", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS policy. If omitted, the
        provider-level region will be used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]:
        """
        Specifies the action of the AS policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @scaling_policy_action.setter
    def scaling_policy_action(self, value: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]):
        pulumi.set(self, "scaling_policy_action", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> Optional[pulumi.Input['PolicyScheduledPolicyArgs']]:
        """
        Specifies the periodic or scheduled AS policy.
        This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

    @scheduled_policy.setter
    def scheduled_policy(self, value: Optional[pulumi.Input['PolicyScheduledPolicyArgs']]):
        pulumi.set(self, "scheduled_policy", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_action: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']] = None,
                 scaling_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_policy: Optional[pulumi.Input['PolicyScheduledPolicyArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[_builtins.str] alarm_id: Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
               is set to `ALARM`.
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds).
               The value ranges from 0 to 86400 and is 300 by default.
               
               <a name="scheduled_policy_object"></a>
               The `scheduled_policy` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS policy. If omitted, the
               provider-level region will be used. Changing this creates a new AS policy.
        :param pulumi.Input[_builtins.str] scaling_group_id: Specifies the AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input['PolicyScalingPolicyActionArgs'] scaling_policy_action: Specifies the action of the AS policy.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] scaling_policy_name: Specifies the name of the AS policy. The name contains only letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[_builtins.str] scaling_policy_type: Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
               + **ALARM**: indicates that the scaling action is triggered by an alarm.
               + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
               + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        :param pulumi.Input['PolicyScheduledPolicyArgs'] scheduled_policy: Specifies the periodic or scheduled AS policy.
               This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] status: The AS policy status. The value can be *INSERVICE*, *PAUSED* or *EXECUTING*.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_policy_action is not None:
            pulumi.set(__self__, "scaling_policy_action", scaling_policy_action)
        if scaling_policy_name is not None:
            pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        if scaling_policy_type is not None:
            pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if scheduled_policy is not None:
            pulumi.set(__self__, "scheduled_policy", scheduled_policy)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
        is set to `ALARM`.
        """
        return pulumi.get(self, "alarm_id")

    @alarm_id.setter
    def alarm_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_id", value)

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cooling duration (in seconds).
        The value ranges from 0 to 86400 and is 300 by default.

        <a name="scheduled_policy_object"></a>
        The `scheduled_policy` block supports:
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cool_down_time", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the AS policy. If omitted, the
        provider-level region will be used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]:
        """
        Specifies the action of the AS policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @scaling_policy_action.setter
    def scaling_policy_action(self, value: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]):
        pulumi.set(self, "scaling_policy_action", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the AS policy. The name contains only letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
        + **ALARM**: indicates that the scaling action is triggered by an alarm.
        + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
        + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> Optional[pulumi.Input['PolicyScheduledPolicyArgs']]:
        """
        Specifies the periodic or scheduled AS policy.
        This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

    @scheduled_policy.setter
    def scheduled_policy(self, value: Optional[pulumi.Input['PolicyScheduledPolicyArgs']]):
        pulumi.set(self, "scheduled_policy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AS policy status. The value can be *INSERVICE*, *PAUSED* or *EXECUTING*.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:As/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_action: Optional[pulumi.Input[Union['PolicyScalingPolicyActionArgs', 'PolicyScalingPolicyActionArgsDict']]] = None,
                 scaling_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_policy: Optional[pulumi.Input[Union['PolicyScheduledPolicyArgs', 'PolicyScheduledPolicyArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AS policy resource within SberCloud.

        ## Example Usage

        ### AS Recurrence Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        my_aspolicy = sbercloud.as_.Policy("my_aspolicy",
            scaling_policy_name="my_aspolicy",
            scaling_policy_type="RECURRENCE",
            scaling_group_id=as_group_id,
            scaling_policy_action={
                "operation": "ADD",
                "instance_number": 1,
            },
            scheduled_policy={
                "launch_time": "07:00",
                "recurrence_type": "Daily",
                "start_time": "2022-11-30T12:00Z",
                "end_time": "2022-12-30T12:00Z",
            })
        ```

        ### AS Scheduled Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        my_aspolicy1 = sbercloud.as_.Policy("my_aspolicy_1",
            scaling_policy_name="my_aspolicy_1",
            scaling_policy_type="SCHEDULED",
            scaling_group_id=as_group_id,
            scaling_policy_action={
                "operation": "REMOVE",
                "instance_number": 1,
            },
            scheduled_policy={
                "launch_time": "2022-12-22T12:00Z",
            })
        ```

        ### AS Alarm Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        alarm_rule = sbercloud.ces.Alarmrule("alarm_rule",
            alarm_name="as_alarm_rule",
            metric={
                "namespace": "SYS.AS",
                "metric_name": "cpu_util",
                "dimensions": [{
                    "name": "AutoScalingGroup",
                    "value": as_group_id,
                }],
            },
            condition={
                "period": 300,
                "filter": "average",
                "comparison_operator": ">=",
                "value": 60,
                "unit": "%",
                "count": 1,
            },
            alarm_actions=[{
                "type": "autoscaling",
                "notification_lists": [],
            }])
        my_aspolicy2 = sbercloud.as_.Policy("my_aspolicy_2",
            scaling_policy_name="my_aspolicy_2",
            scaling_policy_type="ALARM",
            scaling_group_id=as_group_id,
            alarm_id=alarm_rule.id,
            cool_down_time=900,
            scaling_policy_action={
                "operation": "ADD",
                "instance_number": 1,
            })
        ```

        ## Import

        AS policies can be imported by their `id`, e.g.

        ```sh
        $ pulumi import sbercloud:As/policy:Policy test 9fcb65fe-fd79-4407-8fa0-07602044e1c3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alarm_id: Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
               is set to `ALARM`.
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds).
               The value ranges from 0 to 86400 and is 300 by default.
               
               <a name="scheduled_policy_object"></a>
               The `scheduled_policy` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS policy. If omitted, the
               provider-level region will be used. Changing this creates a new AS policy.
        :param pulumi.Input[_builtins.str] scaling_group_id: Specifies the AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[Union['PolicyScalingPolicyActionArgs', 'PolicyScalingPolicyActionArgsDict']] scaling_policy_action: Specifies the action of the AS policy.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] scaling_policy_name: Specifies the name of the AS policy. The name contains only letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[_builtins.str] scaling_policy_type: Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
               + **ALARM**: indicates that the scaling action is triggered by an alarm.
               + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
               + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        :param pulumi.Input[Union['PolicyScheduledPolicyArgs', 'PolicyScheduledPolicyArgsDict']] scheduled_policy: Specifies the periodic or scheduled AS policy.
               This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
               The object structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AS policy resource within SberCloud.

        ## Example Usage

        ### AS Recurrence Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        my_aspolicy = sbercloud.as_.Policy("my_aspolicy",
            scaling_policy_name="my_aspolicy",
            scaling_policy_type="RECURRENCE",
            scaling_group_id=as_group_id,
            scaling_policy_action={
                "operation": "ADD",
                "instance_number": 1,
            },
            scheduled_policy={
                "launch_time": "07:00",
                "recurrence_type": "Daily",
                "start_time": "2022-11-30T12:00Z",
                "end_time": "2022-12-30T12:00Z",
            })
        ```

        ### AS Scheduled Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        my_aspolicy1 = sbercloud.as_.Policy("my_aspolicy_1",
            scaling_policy_name="my_aspolicy_1",
            scaling_policy_type="SCHEDULED",
            scaling_group_id=as_group_id,
            scaling_policy_action={
                "operation": "REMOVE",
                "instance_number": 1,
            },
            scheduled_policy={
                "launch_time": "2022-12-22T12:00Z",
            })
        ```

        ### AS Alarm Policy

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        as_group_id = config.require_object("asGroupId")
        alarm_rule = sbercloud.ces.Alarmrule("alarm_rule",
            alarm_name="as_alarm_rule",
            metric={
                "namespace": "SYS.AS",
                "metric_name": "cpu_util",
                "dimensions": [{
                    "name": "AutoScalingGroup",
                    "value": as_group_id,
                }],
            },
            condition={
                "period": 300,
                "filter": "average",
                "comparison_operator": ">=",
                "value": 60,
                "unit": "%",
                "count": 1,
            },
            alarm_actions=[{
                "type": "autoscaling",
                "notification_lists": [],
            }])
        my_aspolicy2 = sbercloud.as_.Policy("my_aspolicy_2",
            scaling_policy_name="my_aspolicy_2",
            scaling_policy_type="ALARM",
            scaling_group_id=as_group_id,
            alarm_id=alarm_rule.id,
            cool_down_time=900,
            scaling_policy_action={
                "operation": "ADD",
                "instance_number": 1,
            })
        ```

        ## Import

        AS policies can be imported by their `id`, e.g.

        ```sh
        $ pulumi import sbercloud:As/policy:Policy test 9fcb65fe-fd79-4407-8fa0-07602044e1c3
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_action: Optional[pulumi.Input[Union['PolicyScalingPolicyActionArgs', 'PolicyScalingPolicyActionArgsDict']]] = None,
                 scaling_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_policy: Optional[pulumi.Input[Union['PolicyScheduledPolicyArgs', 'PolicyScheduledPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["alarm_id"] = alarm_id
            __props__.__dict__["cool_down_time"] = cool_down_time
            __props__.__dict__["region"] = region
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["scaling_policy_action"] = scaling_policy_action
            if scaling_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_name'")
            __props__.__dict__["scaling_policy_name"] = scaling_policy_name
            if scaling_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_type'")
            __props__.__dict__["scaling_policy_type"] = scaling_policy_type
            __props__.__dict__["scheduled_policy"] = scheduled_policy
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Policy, __self__).__init__(
            'sbercloud:As/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_id: Optional[pulumi.Input[_builtins.str]] = None,
            cool_down_time: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_policy_action: Optional[pulumi.Input[Union['PolicyScalingPolicyActionArgs', 'PolicyScalingPolicyActionArgsDict']]] = None,
            scaling_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_policy: Optional[pulumi.Input[Union['PolicyScheduledPolicyArgs', 'PolicyScheduledPolicyArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alarm_id: Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
               is set to `ALARM`.
        :param pulumi.Input[_builtins.int] cool_down_time: Specifies the cooling duration (in seconds).
               The value ranges from 0 to 86400 and is 300 by default.
               
               <a name="scheduled_policy_object"></a>
               The `scheduled_policy` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the AS policy. If omitted, the
               provider-level region will be used. Changing this creates a new AS policy.
        :param pulumi.Input[_builtins.str] scaling_group_id: Specifies the AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[Union['PolicyScalingPolicyActionArgs', 'PolicyScalingPolicyActionArgsDict']] scaling_policy_action: Specifies the action of the AS policy.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] scaling_policy_name: Specifies the name of the AS policy. The name contains only letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[_builtins.str] scaling_policy_type: Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
               + **ALARM**: indicates that the scaling action is triggered by an alarm.
               + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
               + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        :param pulumi.Input[Union['PolicyScheduledPolicyArgs', 'PolicyScheduledPolicyArgsDict']] scheduled_policy: Specifies the periodic or scheduled AS policy.
               This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] status: The AS policy status. The value can be *INSERVICE*, *PAUSED* or *EXECUTING*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["alarm_id"] = alarm_id
        __props__.__dict__["cool_down_time"] = cool_down_time
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_policy_action"] = scaling_policy_action
        __props__.__dict__["scaling_policy_name"] = scaling_policy_name
        __props__.__dict__["scaling_policy_type"] = scaling_policy_type
        __props__.__dict__["scheduled_policy"] = scheduled_policy
        __props__.__dict__["status"] = status
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the alarm rule ID. This parameter is mandatory when `scaling_policy_type`
        is set to `ALARM`.
        """
        return pulumi.get(self, "alarm_id")

    @_builtins.property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the cooling duration (in seconds).
        The value ranges from 0 to 86400 and is 300 by default.

        <a name="scheduled_policy_object"></a>
        The `scheduled_policy` block supports:
        """
        return pulumi.get(self, "cool_down_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the AS policy. If omitted, the
        provider-level region will be used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> pulumi.Output['outputs.PolicyScalingPolicyAction']:
        """
        Specifies the action of the AS policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @_builtins.property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the AS policy. The name contains only letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @_builtins.property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the AS policy type. The value can be `ALARM`, `SCHEDULED` or `RECURRENCE`.
        + **ALARM**: indicates that the scaling action is triggered by an alarm.
        + **SCHEDULED**: indicates that the scaling action is triggered as scheduled.
        + **RECURRENCE**: indicates that the scaling action is triggered periodically.
        """
        return pulumi.get(self, "scaling_policy_type")

    @_builtins.property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> pulumi.Output['outputs.PolicyScheduledPolicy']:
        """
        Specifies the periodic or scheduled AS policy.
        This parameter is mandatory when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The AS policy status. The value can be *INSERVICE*, *PAUSED* or *EXECUTING*.
        """
        return pulumi.get(self, "status")

