# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CbhAssetAgencyAuthorizationArgs', 'CbhAssetAgencyAuthorization']

@pulumi.input_type
class CbhAssetAgencyAuthorizationArgs:
    def __init__(__self__, *,
                 csms: pulumi.Input[_builtins.bool],
                 kms: pulumi.Input[_builtins.bool],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CbhAssetAgencyAuthorization resource.
        :param pulumi.Input[_builtins.bool] csms: Specifies whether to enable CSMS credential agency authorization. The value can be **true**
               or **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
               credential list. You can select credentials as resource accounts on the CBH instance.
        :param pulumi.Input[_builtins.bool] kms: Specifies whether to enable KMS key agency authorization. The value can be **true** or
               **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
               to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
               instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBH asset agency authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "csms", csms)
        pulumi.set(__self__, "kms", kms)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def csms(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether to enable CSMS credential agency authorization. The value can be **true**
        or **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
        credential list. You can select credentials as resource accounts on the CBH instance.
        """
        return pulumi.get(self, "csms")

    @csms.setter
    def csms(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "csms", value)

    @_builtins.property
    @pulumi.getter
    def kms(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether to enable KMS key agency authorization. The value can be **true** or
        **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
        to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
        instance.
        """
        return pulumi.get(self, "kms")

    @kms.setter
    def kms(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "kms", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CBH asset agency authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CbhAssetAgencyAuthorizationState:
    def __init__(__self__, *,
                 csms: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CbhAssetAgencyAuthorization resources.
        :param pulumi.Input[_builtins.bool] csms: Specifies whether to enable CSMS credential agency authorization. The value can be **true**
               or **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
               credential list. You can select credentials as resource accounts on the CBH instance.
        :param pulumi.Input[_builtins.bool] kms: Specifies whether to enable KMS key agency authorization. The value can be **true** or
               **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
               to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
               instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBH asset agency authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if csms is not None:
            pulumi.set(__self__, "csms", csms)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def csms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable CSMS credential agency authorization. The value can be **true**
        or **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
        credential list. You can select credentials as resource accounts on the CBH instance.
        """
        return pulumi.get(self, "csms")

    @csms.setter
    def csms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "csms", value)

    @_builtins.property
    @pulumi.getter
    def kms(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable KMS key agency authorization. The value can be **true** or
        **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
        to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
        instance.
        """
        return pulumi.get(self, "kms")

    @kms.setter
    def kms(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kms", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CBH asset agency authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/cbhAssetAgencyAuthorization:CbhAssetAgencyAuthorization")
class CbhAssetAgencyAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csms: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CBH asset agency authorization resource within SberCloud.

        > After you enable CSMS credentials and KMS key agency authorization, you need to wait about `10` minutes, the CBH
        instance can obtain a token with agency permissions. Destroying resources will not change the current asset
        agency authorization status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.CbhAssetAgencyAuthorization("test",
            csms=True,
            kms=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] csms: Specifies whether to enable CSMS credential agency authorization. The value can be **true**
               or **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
               credential list. You can select credentials as resource accounts on the CBH instance.
        :param pulumi.Input[_builtins.bool] kms: Specifies whether to enable KMS key agency authorization. The value can be **true** or
               **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
               to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
               instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBH asset agency authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CbhAssetAgencyAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CBH asset agency authorization resource within SberCloud.

        > After you enable CSMS credentials and KMS key agency authorization, you need to wait about `10` minutes, the CBH
        instance can obtain a token with agency permissions. Destroying resources will not change the current asset
        agency authorization status.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.CbhAssetAgencyAuthorization("test",
            csms=True,
            kms=True)
        ```

        :param str resource_name: The name of the resource.
        :param CbhAssetAgencyAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CbhAssetAgencyAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csms: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CbhAssetAgencyAuthorizationArgs.__new__(CbhAssetAgencyAuthorizationArgs)

            if csms is None and not opts.urn:
                raise TypeError("Missing required property 'csms'")
            __props__.__dict__["csms"] = csms
            if kms is None and not opts.urn:
                raise TypeError("Missing required property 'kms'")
            __props__.__dict__["kms"] = kms
            __props__.__dict__["region"] = region
        super(CbhAssetAgencyAuthorization, __self__).__init__(
            'sbercloud:index/cbhAssetAgencyAuthorization:CbhAssetAgencyAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            csms: Optional[pulumi.Input[_builtins.bool]] = None,
            kms: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'CbhAssetAgencyAuthorization':
        """
        Get an existing CbhAssetAgencyAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] csms: Specifies whether to enable CSMS credential agency authorization. The value can be **true**
               or **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
               credential list. You can select credentials as resource accounts on the CBH instance.
        :param pulumi.Input[_builtins.bool] kms: Specifies whether to enable KMS key agency authorization. The value can be **true** or
               **false**.
               If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
               to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
               instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBH asset agency authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CbhAssetAgencyAuthorizationState.__new__(_CbhAssetAgencyAuthorizationState)

        __props__.__dict__["csms"] = csms
        __props__.__dict__["kms"] = kms
        __props__.__dict__["region"] = region
        return CbhAssetAgencyAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def csms(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable CSMS credential agency authorization. The value can be **true**
        or **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to query your CSMS
        credential list. You can select credentials as resource accounts on the CBH instance.
        """
        return pulumi.get(self, "csms")

    @_builtins.property
    @pulumi.getter
    def kms(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable KMS key agency authorization. The value can be **true** or
        **false**.
        If set to **true** to enable agency authorization, the CBH service will have the permission to use the KMS interface
        to obtain the CSMS credential value. You can use this credential value to log in to the managed host on the CBH
        instance.
        """
        return pulumi.get(self, "kms")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the CBH asset agency authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

