# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CbhInstanceArgs', 'CbhInstance']

@pulumi.input_type
class CbhInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 charging_mode: pulumi.Input[_builtins.str],
                 flavor_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 period: pulumi.Input[_builtins.int],
                 period_unit: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 attach_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_address: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CbhInstance resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CBH instance.
               The options are as follows:
               + **postPaid**: pas-as-you-go.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the product ID of the CBH server. When updating the flavor, it can only be
               changed to a higher flavor.
               
               > 1. The flavor change is a high-risk operation, with a certain risk of failure.
               <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        :param pulumi.Input[_builtins.str] password: Specifies the password for logging in to the management console. The value of the field
               has the following restrictions:
               + The value of the field must contain `8` to `32` characters.
               + The value of the field must contain at least three of the following: letters, digits, and special characters
               (!@$%^-_=+[{}]:,./?~#*).
               + The value of the field cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CBH instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               
               This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the IDs of the security group. Multiple security group IDs are
               separated by commas (,) without spaces.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
        :param pulumi.Input[_builtins.int] attach_disk_size: Specifies the size of the additional data disk for the CBH instance.
               The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
               disk of the instance flavor and the additional disk cannot exceed **300TB**.
               
               > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
               <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the CBH instance
               belongs. For enterprise users, if omitted, default enterprise project will be used.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether the IPv6 network is enabled. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
               Only letters, digits, underscores (_), and hyphens (-) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action after the CBH instance is created.
               The valid values are as follows:
               + **start**: Startup instance.
               + **stop**: Shutdown instance.
               + **soft-reboot**: Normal reboot, shut down virtual machine service.
               + **hard-reboot**: Force reboot, reboot virtual machine.
               
               > The usage of `power_action` has some limitations:
               <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
               <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
               is **ACTIVE**.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the elastic IP address.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_address: Specifies the IP address of the subnet.
               If not specified, a new IP address will be assigned.
               
               > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
               deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
               resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBH instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "charging_mode", charging_mode)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if attach_disk_size is not None:
            pulumi.set(__self__, "attach_disk_size", attach_disk_size)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_address is not None:
            pulumi.set(__self__, "subnet_address", subnet_address)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the availability zone name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the charging mode of the CBH instance.
        The options are as follows:
        + **postPaid**: pas-as-you-go.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the product ID of the CBH server. When updating the flavor, it can only be
        changed to a higher flavor.

        > 1. The flavor change is a high-risk operation, with a certain risk of failure.
        <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password for logging in to the management console. The value of the field
        has the following restrictions:
        + The value of the field must contain `8` to `32` characters.
        + The value of the field must contain at least three of the following: letters, digits, and special characters
        (!@$%^-_=+[{}]:,./?~#*).
        + The value of the field cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the charging period of the CBH instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `3`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.

        This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IDs of the security group. Multiple security group IDs are
        separated by commas (,) without spaces.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="attachDiskSize")
    def attach_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the additional data disk for the CBH instance.
        The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
        disk of the instance flavor and the additional disk cannot exceed **300TB**.

        > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
        <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        """
        return pulumi.get(self, "attach_disk_size")

    @attach_disk_size.setter
    def attach_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "attach_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the CBH instance
        belongs. For enterprise users, if omitted, default enterprise project will be used.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the IPv6 network is enabled. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
        Only letters, digits, underscores (_), and hyphens (-) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action after the CBH instance is created.
        The valid values are as follows:
        + **start**: Startup instance.
        + **stop**: Shutdown instance.
        + **soft-reboot**: Normal reboot, shut down virtual machine service.
        + **hard-reboot**: Force reboot, reboot virtual machine.

        > The usage of `power_action` has some limitations:
        <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
        <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
        is **ACTIVE**.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the elastic IP address.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic IP.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetAddress")
    def subnet_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address of the subnet.
        If not specified, a new IP address will be assigned.

        > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
        deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
        resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        """
        return pulumi.get(self, "subnet_address")

    @subnet_address.setter
    def subnet_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_address", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the CBH instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CbhInstanceState:
    def __init__(__self__, *,
                 attach_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disk_size: Optional[pulumi.Input[_builtins.float]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_address: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CbhInstance resources.
        :param pulumi.Input[_builtins.int] attach_disk_size: Specifies the size of the additional data disk for the CBH instance.
               The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
               disk of the instance flavor and the additional disk cannot exceed **300TB**.
               
               > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
               <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CBH instance.
               The options are as follows:
               + **postPaid**: pas-as-you-go.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.float] data_disk_size: Indicates the data disk size of the instance. The unit is TB. It represents the sum of the disks
               that come with the flavor and the disks that have already been expanded.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the CBH instance
               belongs. For enterprise users, if omitted, default enterprise project will be used.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the product ID of the CBH server. When updating the flavor, it can only be
               changed to a higher flavor.
               
               > 1. The flavor change is a high-risk operation, with a certain risk of failure.
               <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether the IPv6 network is enabled. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
               Only letters, digits, underscores (_), and hyphens (-) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password for logging in to the management console. The value of the field
               has the following restrictions:
               + The value of the field must contain `8` to `32` characters.
               + The value of the field must contain at least three of the following: letters, digits, and special characters
               (!@$%^-_=+[{}]:,./?~#*).
               + The value of the field cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CBH instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               
               This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action after the CBH instance is created.
               The valid values are as follows:
               + **start**: Startup instance.
               + **stop**: Shutdown instance.
               + **soft-reboot**: Normal reboot, shut down virtual machine service.
               + **hard-reboot**: Force reboot, reboot virtual machine.
               
               > The usage of `power_action` has some limitations:
               <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
               <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
               is **ACTIVE**.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private IP address of the instance.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the elastic IP address.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the IDs of the security group. Multiple security group IDs are
               separated by commas (,) without spaces.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the instance.
        :param pulumi.Input[_builtins.str] subnet_address: Specifies the IP address of the subnet.
               If not specified, a new IP address will be assigned.
               
               > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
               deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
               resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBH instance.
        :param pulumi.Input[_builtins.str] version: Indicates the current version of the instance image.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
        """
        if attach_disk_size is not None:
            pulumi.set(__self__, "attach_disk_size", attach_disk_size)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_disk_size is not None:
            pulumi.set(__self__, "data_disk_size", data_disk_size)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_address is not None:
            pulumi.set(__self__, "subnet_address", subnet_address)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="attachDiskSize")
    def attach_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the additional data disk for the CBH instance.
        The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
        disk of the instance flavor and the additional disk cannot exceed **300TB**.

        > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
        <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        """
        return pulumi.get(self, "attach_disk_size")

    @attach_disk_size.setter
    def attach_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "attach_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability zone name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the CBH instance.
        The options are as follows:
        + **postPaid**: pas-as-you-go.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Indicates the data disk size of the instance. The unit is TB. It represents the sum of the disks
        that come with the flavor and the disks that have already been expanded.
        """
        return pulumi.get(self, "data_disk_size")

    @data_disk_size.setter
    def data_disk_size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID to which the CBH instance
        belongs. For enterprise users, if omitted, default enterprise project will be used.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the product ID of the CBH server. When updating the flavor, it can only be
        changed to a higher flavor.

        > 1. The flavor change is a high-risk operation, with a certain risk of failure.
        <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the IPv6 network is enabled. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
        Only letters, digits, underscores (_), and hyphens (-) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password for logging in to the management console. The value of the field
        has the following restrictions:
        + The value of the field must contain `8` to `32` characters.
        + The value of the field must contain at least three of the following: letters, digits, and special characters
        (!@$%^-_=+[{}]:,./?~#*).
        + The value of the field cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the CBH instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `3`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.

        This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action after the CBH instance is created.
        The valid values are as follows:
        + **start**: Startup instance.
        + **stop**: Shutdown instance.
        + **soft-reboot**: Normal reboot, shut down virtual machine service.
        + **hard-reboot**: Force reboot, reboot virtual machine.

        > The usage of `power_action` has some limitations:
        <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
        <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
        is **ACTIVE**.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the private IP address of the instance.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the elastic IP address.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic IP.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IDs of the security group. Multiple security group IDs are
        separated by commas (,) without spaces.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetAddress")
    def subnet_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address of the subnet.
        If not specified, a new IP address will be assigned.

        > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
        deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
        resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        """
        return pulumi.get(self, "subnet_address")

    @subnet_address.setter
    def subnet_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_address", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the CBH instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the current version of the instance image.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:index/cbhInstance:CbhInstance")
class CbhInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_address: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CBH instance resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        flavor_id = config.require_object("flavorId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        password = config.require_object("password")
        availability_zone = config.require_object("availabilityZone")
        test = sbercloud.CbhInstance("test",
            name=name,
            flavor_id=flavor_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            availability_zone=availability_zone,
            password=password,
            charging_mode="prePaid",
            period_unit="month",
            period=1)
        ```

        ## Import

        The CBH instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/cbhInstance:CbhInstance test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `charging_mode`, `period`, `period_unit`,

        `auto_renew`, `password`, `ipv6_enable`, `attach_disk_size`, `power_action`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated

        to align with the instance. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_cbh_instance" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              charging_mode, period, period_unit, auto_renew, password, ipv6_enable, attach_disk_size, power_action,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] attach_disk_size: Specifies the size of the additional data disk for the CBH instance.
               The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
               disk of the instance flavor and the additional disk cannot exceed **300TB**.
               
               > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
               <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CBH instance.
               The options are as follows:
               + **postPaid**: pas-as-you-go.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the CBH instance
               belongs. For enterprise users, if omitted, default enterprise project will be used.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the product ID of the CBH server. When updating the flavor, it can only be
               changed to a higher flavor.
               
               > 1. The flavor change is a high-risk operation, with a certain risk of failure.
               <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether the IPv6 network is enabled. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
               Only letters, digits, underscores (_), and hyphens (-) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password for logging in to the management console. The value of the field
               has the following restrictions:
               + The value of the field must contain `8` to `32` characters.
               + The value of the field must contain at least three of the following: letters, digits, and special characters
               (!@$%^-_=+[{}]:,./?~#*).
               + The value of the field cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CBH instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               
               This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action after the CBH instance is created.
               The valid values are as follows:
               + **start**: Startup instance.
               + **stop**: Shutdown instance.
               + **soft-reboot**: Normal reboot, shut down virtual machine service.
               + **hard-reboot**: Force reboot, reboot virtual machine.
               
               > The usage of `power_action` has some limitations:
               <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
               <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
               is **ACTIVE**.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the elastic IP address.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the IDs of the security group. Multiple security group IDs are
               separated by commas (,) without spaces.
        :param pulumi.Input[_builtins.str] subnet_address: Specifies the IP address of the subnet.
               If not specified, a new IP address will be assigned.
               
               > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
               deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
               resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBH instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CbhInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CBH instance resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        flavor_id = config.require_object("flavorId")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        password = config.require_object("password")
        availability_zone = config.require_object("availabilityZone")
        test = sbercloud.CbhInstance("test",
            name=name,
            flavor_id=flavor_id,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            availability_zone=availability_zone,
            password=password,
            charging_mode="prePaid",
            period_unit="month",
            period=1)
        ```

        ## Import

        The CBH instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/cbhInstance:CbhInstance test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `charging_mode`, `period`, `period_unit`,

        `auto_renew`, `password`, `ipv6_enable`, `attach_disk_size`, `power_action`.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated

        to align with the instance. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_cbh_instance" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              charging_mode, period, period_unit, auto_renew, password, ipv6_enable, attach_disk_size, power_action,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param CbhInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CbhInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_address: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CbhInstanceArgs.__new__(CbhInstanceArgs)

            __props__.__dict__["attach_disk_size"] = attach_disk_size
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            if charging_mode is None and not opts.urn:
                raise TypeError("Missing required property 'charging_mode'")
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            if period_unit is None and not opts.urn:
                raise TypeError("Missing required property 'period_unit'")
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["power_action"] = power_action
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["public_ip_id"] = public_ip_id
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["subnet_address"] = subnet_address
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["data_disk_size"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CbhInstance, __self__).__init__(
            'sbercloud:index/cbhInstance:CbhInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attach_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            data_disk_size: Optional[pulumi.Input[_builtins.float]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            power_action: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_address: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CbhInstance':
        """
        Get an existing CbhInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] attach_disk_size: Specifies the size of the additional data disk for the CBH instance.
               The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
               disk of the instance flavor and the additional disk cannot exceed **300TB**.
               
               > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
               <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone name.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the CBH instance.
               The options are as follows:
               + **postPaid**: pas-as-you-go.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.float] data_disk_size: Indicates the data disk size of the instance. The unit is TB. It represents the sum of the disks
               that come with the flavor and the disks that have already been expanded.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID to which the CBH instance
               belongs. For enterprise users, if omitted, default enterprise project will be used.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the product ID of the CBH server. When updating the flavor, it can only be
               changed to a higher flavor.
               
               > 1. The flavor change is a high-risk operation, with a certain risk of failure.
               <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether the IPv6 network is enabled. Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
               Only letters, digits, underscores (_), and hyphens (-) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password for logging in to the management console. The value of the field
               has the following restrictions:
               + The value of the field must contain `8` to `32` characters.
               + The value of the field must contain at least three of the following: letters, digits, and special characters
               (!@$%^-_=+[{}]:,./?~#*).
               + The value of the field cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the CBH instance.
               If `period_unit` is set to **month**, the value ranges from `1` to `9`.
               If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               
               This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action after the CBH instance is created.
               The valid values are as follows:
               + **start**: Startup instance.
               + **stop**: Shutdown instance.
               + **soft-reboot**: Normal reboot, shut down virtual machine service.
               + **hard-reboot**: Force reboot, reboot virtual machine.
               
               > The usage of `power_action` has some limitations:
               <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
               <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
               is **ACTIVE**.
        :param pulumi.Input[_builtins.str] private_ip: Indicates the private IP address of the instance.
        :param pulumi.Input[_builtins.str] public_ip: Indicates the elastic IP address.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the IDs of the security group. Multiple security group IDs are
               separated by commas (,) without spaces.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the instance.
        :param pulumi.Input[_builtins.str] subnet_address: Specifies the IP address of the subnet.
               If not specified, a new IP address will be assigned.
               
               > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
               deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
               resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBH instance.
        :param pulumi.Input[_builtins.str] version: Indicates the current version of the instance image.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CbhInstanceState.__new__(_CbhInstanceState)

        __props__.__dict__["attach_disk_size"] = attach_disk_size
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["data_disk_size"] = data_disk_size
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["power_action"] = power_action
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_ip_id"] = public_ip_id
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_address"] = subnet_address
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return CbhInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachDiskSize")
    def attach_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the size of the additional data disk for the CBH instance.
        The unit is TB. It refers to the additional disk size added on top of the existing disk. And the sum of the built-in
        disk of the instance flavor and the additional disk cannot exceed **300TB**.

        > 1. Storage expansion is a high-risk operation, with a certain risk of failure.
        <br/>2. Expansion failure may affect the usability of the instance. Please ensure to back up your data.
        """
        return pulumi.get(self, "attach_disk_size")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the availability zone name.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the CBH instance.
        The options are as follows:
        + **postPaid**: pas-as-you-go.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> pulumi.Output[_builtins.float]:
        """
        Indicates the data disk size of the instance. The unit is TB. It represents the sum of the disks
        that come with the flavor and the disks that have already been expanded.
        """
        return pulumi.get(self, "data_disk_size")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID to which the CBH instance
        belongs. For enterprise users, if omitted, default enterprise project will be used.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the product ID of the CBH server. When updating the flavor, it can only be
        changed to a higher flavor.

        > 1. The flavor change is a high-risk operation, with a certain risk of failure.
        <br/>2. Flavor change failing may impact the usability of the instance. Please be sure to back up your data.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the IPv6 network is enabled. Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the CBH instance. The field can contain `1` to `64` characters.
        Only letters, digits, underscores (_), and hyphens (-) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the password for logging in to the management console. The value of the field
        has the following restrictions:
        + The value of the field must contain `8` to `32` characters.
        + The value of the field must contain at least three of the following: letters, digits, and special characters
        (!@$%^-_=+[{}]:,./?~#*).
        + The value of the field cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the charging period of the CBH instance.
        If `period_unit` is set to **month**, the value ranges from `1` to `9`.
        If `period_unit` is set to **year**, the value ranges from `1` to `3`.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.

        This parameter is required, but it has no effect, since sbercloud doesn't have pre-paid billing type
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the power action after the CBH instance is created.
        The valid values are as follows:
        + **start**: Startup instance.
        + **stop**: Shutdown instance.
        + **soft-reboot**: Normal reboot, shut down virtual machine service.
        + **hard-reboot**: Force reboot, reboot virtual machine.

        > The usage of `power_action` has some limitations:
        <br/>1. The **start** operation can only be performed when the instance status is **SHUTOFF**.
        <br/>2. The **stop**, **soft-reboot**, and **hard-reboot** operations can only be performed when the instance status
        is **ACTIVE**.
        """
        return pulumi.get(self, "power_action")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the private IP address of the instance.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the elastic IP address.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the elastic IP.
        """
        return pulumi.get(self, "public_ip_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IDs of the security group. Multiple security group IDs are
        separated by commas (,) without spaces.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetAddress")
    def subnet_address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address of the subnet.
        If not specified, a new IP address will be assigned.

        > The CBH instance will automatically create an elastic network card based on the subnet address, which will be
        deleted along with the instance deletion. But if the `subnet_address` parameter is updated, the elastic network card
        resource corresponding to the original subnet address will remain, you need to manually delete it in the console.
        """
        return pulumi.get(self, "subnet_address")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the CBH instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the current version of the instance image.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a VPC.
        """
        return pulumi.get(self, "vpc_id")

