# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyBackupCycleArgs',
    'PolicyBackupCycleArgsDict',
    'PolicyLongTermRetentionArgs',
    'PolicyLongTermRetentionArgsDict',
    'VaultPolicyArgs',
    'VaultPolicyArgsDict',
    'VaultResourceArgs',
    'VaultResourceArgsDict',
]

MYPY = False

if not MYPY:
    class PolicyBackupCycleArgsDict(TypedDict):
        execution_times: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the backup time. Automated backups will be triggered at the backup
        time. The current time is in the UTC format (HH:MM). The minutes in the list must be set to **00** and the hours
        cannot be repeated. In the replication policy, you are advised to set one time point for one day.

        <a name="cbr_policy_long_term_retention"></a>
        The `long_term_retention` block supports:
        """
        days: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the weekly backup day of backup schedule. It supports seven days a week (MO, TU,
        WE, TH, FR, SA, SU) and this parameter is separated by a comma (,) without spaces, between date and date during the
        configuration.
        """
        interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the interval (in days) of backup schedule. The value range is `1` to `30`. This
        parameter and `days` are alternative.
        """
elif False:
    PolicyBackupCycleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyBackupCycleArgs:
    def __init__(__self__, *,
                 execution_times: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 days: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] execution_times: Specifies the backup time. Automated backups will be triggered at the backup
               time. The current time is in the UTC format (HH:MM). The minutes in the list must be set to **00** and the hours
               cannot be repeated. In the replication policy, you are advised to set one time point for one day.
               
               <a name="cbr_policy_long_term_retention"></a>
               The `long_term_retention` block supports:
        :param pulumi.Input[_builtins.str] days: Specifies the weekly backup day of backup schedule. It supports seven days a week (MO, TU,
               WE, TH, FR, SA, SU) and this parameter is separated by a comma (,) without spaces, between date and date during the
               configuration.
        :param pulumi.Input[_builtins.int] interval: Specifies the interval (in days) of backup schedule. The value range is `1` to `30`. This
               parameter and `days` are alternative.
        """
        pulumi.set(__self__, "execution_times", execution_times)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="executionTimes")
    def execution_times(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the backup time. Automated backups will be triggered at the backup
        time. The current time is in the UTC format (HH:MM). The minutes in the list must be set to **00** and the hours
        cannot be repeated. In the replication policy, you are advised to set one time point for one day.

        <a name="cbr_policy_long_term_retention"></a>
        The `long_term_retention` block supports:
        """
        return pulumi.get(self, "execution_times")

    @execution_times.setter
    def execution_times(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "execution_times", value)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the weekly backup day of backup schedule. It supports seven days a week (MO, TU,
        WE, TH, FR, SA, SU) and this parameter is separated by a comma (,) without spaces, between date and date during the
        configuration.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "days", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the interval (in days) of backup schedule. The value range is `1` to `30`. This
        parameter and `days` are alternative.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval", value)


if not MYPY:
    class PolicyLongTermRetentionArgsDict(TypedDict):
        daily: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the latest backup of each day is saved in the long term.
        """
        full_backup_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        How often (after how many incremental backups) a full backup is performed.
        """
        monthly: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the latest backup of each month is saved in the long term.
        """
        weekly: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the latest backup of each week is saved in the long term.
        """
        yearly: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the latest backup of each year is saved in the long term.

        > A maximum of 10 backups are retained for failed periodic backup tasks. They are retained for one month and can be
        manually deleted on the web console.
        """
elif False:
    PolicyLongTermRetentionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyLongTermRetentionArgs:
    def __init__(__self__, *,
                 daily: Optional[pulumi.Input[_builtins.int]] = None,
                 full_backup_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly: Optional[pulumi.Input[_builtins.int]] = None,
                 weekly: Optional[pulumi.Input[_builtins.int]] = None,
                 yearly: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] daily: Specifies the latest backup of each day is saved in the long term.
        :param pulumi.Input[_builtins.int] full_backup_interval: How often (after how many incremental backups) a full backup is performed.
        :param pulumi.Input[_builtins.int] monthly: Specifies the latest backup of each month is saved in the long term.
        :param pulumi.Input[_builtins.int] weekly: Specifies the latest backup of each week is saved in the long term.
        :param pulumi.Input[_builtins.int] yearly: Specifies the latest backup of each year is saved in the long term.
               
               > A maximum of 10 backups are retained for failed periodic backup tasks. They are retained for one month and can be
               manually deleted on the web console.
        """
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if full_backup_interval is not None:
            pulumi.set(__self__, "full_backup_interval", full_backup_interval)
        if monthly is not None:
            pulumi.set(__self__, "monthly", monthly)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)
        if yearly is not None:
            pulumi.set(__self__, "yearly", yearly)

    @_builtins.property
    @pulumi.getter
    def daily(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the latest backup of each day is saved in the long term.
        """
        return pulumi.get(self, "daily")

    @daily.setter
    def daily(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "daily", value)

    @_builtins.property
    @pulumi.getter(name="fullBackupInterval")
    def full_backup_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (after how many incremental backups) a full backup is performed.
        """
        return pulumi.get(self, "full_backup_interval")

    @full_backup_interval.setter
    def full_backup_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "full_backup_interval", value)

    @_builtins.property
    @pulumi.getter
    def monthly(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the latest backup of each month is saved in the long term.
        """
        return pulumi.get(self, "monthly")

    @monthly.setter
    def monthly(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monthly", value)

    @_builtins.property
    @pulumi.getter
    def weekly(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the latest backup of each week is saved in the long term.
        """
        return pulumi.get(self, "weekly")

    @weekly.setter
    def weekly(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weekly", value)

    @_builtins.property
    @pulumi.getter
    def yearly(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the latest backup of each year is saved in the long term.

        > A maximum of 10 backups are retained for failed periodic backup tasks. They are retained for one month and can be
        manually deleted on the web console.
        """
        return pulumi.get(self, "yearly")

    @yearly.setter
    def yearly(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "yearly", value)


if not MYPY:
    class VaultPolicyArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        A resource ID in UUID format.
        """
        destination_vault_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of destination vault to which the replication policy will associated.
        """
elif False:
    VaultPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultPolicyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 destination_vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: A resource ID in UUID format.
        :param pulumi.Input[_builtins.str] destination_vault_id: The ID of destination vault to which the replication policy will associated.
        """
        pulumi.set(__self__, "id", id)
        if destination_vault_id is not None:
            pulumi.set(__self__, "destination_vault_id", destination_vault_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        A resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="destinationVaultId")
    def destination_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of destination vault to which the replication policy will associated.
        """
        return pulumi.get(self, "destination_vault_id")

    @destination_vault_id.setter
    def destination_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_vault_id", value)


if not MYPY:
    class VaultResourceArgsDict(TypedDict):
        excludes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the array of disk IDs which will be excluded in the backup.
        Only **server** vault support this parameter.
        """
        includes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies the array of disk or SFS file system IDs which will be included in the backup.
        Only **disk** and **turbo** vault support this parameter.
        """
        server_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the ID of the ECS instance to be backed up.
        """
elif False:
    VaultResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VaultResourceArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Specifies the array of disk IDs which will be excluded in the backup.
               Only **server** vault support this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] includes: Specifies the array of disk or SFS file system IDs which will be included in the backup.
               Only **disk** and **turbo** vault support this parameter.
        :param pulumi.Input[_builtins.str] server_id: Specifies the ID of the ECS instance to be backed up.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the array of disk IDs which will be excluded in the backup.
        Only **server** vault support this parameter.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the array of disk or SFS file system IDs which will be included in the backup.
        Only **disk** and **turbo** vault support this parameter.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "includes", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the ECS instance to be backed up.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)


