# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVaultsResult',
    'AwaitableGetVaultsResult',
    'get_vaults',
    'get_vaults_output',
]

@pulumi.output_type
class GetVaultsResult:
    """
    A collection of values returned by getVaults.
    """
    def __init__(__self__, auto_expand_enabled=None, consistent_level=None, enterprise_project_id=None, id=None, name=None, policy_id=None, protection_type=None, region=None, size=None, status=None, type=None, vaults=None):
        if auto_expand_enabled and not isinstance(auto_expand_enabled, bool):
            raise TypeError("Expected argument 'auto_expand_enabled' to be a bool")
        pulumi.set(__self__, "auto_expand_enabled", auto_expand_enabled)
        if consistent_level and not isinstance(consistent_level, str):
            raise TypeError("Expected argument 'consistent_level' to be a str")
        pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if protection_type and not isinstance(protection_type, str):
            raise TypeError("Expected argument 'protection_type' to be a str")
        pulumi.set(__self__, "protection_type", protection_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vaults and not isinstance(vaults, list):
            raise TypeError("Expected argument 'vaults' to be a list")
        pulumi.set(__self__, "vaults", vaults)

    @_builtins.property
    @pulumi.getter(name="autoExpandEnabled")
    def auto_expand_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable automatic expansion of the backup protection type vault.
        """
        return pulumi.get(self, "auto_expand_enabled")

    @_builtins.property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[_builtins.str]:
        """
        The backup specifications.
        """
        return pulumi.get(self, "consistent_level")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The CBR vault name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[_builtins.str]:
        """
        The policy associated with the CBR vault.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[_builtins.str]:
        """
        The protection type of the CBR vault.
        """
        return pulumi.get(self, "protection_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The vault capacity, in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The object type of the CBR vault.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vaults(self) -> Sequence['outputs.GetVaultsVaultResult']:
        """
        List of CBR vault details. The object structure of each CBR vault is documented below.
        """
        return pulumi.get(self, "vaults")


class AwaitableGetVaultsResult(GetVaultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVaultsResult(
            auto_expand_enabled=self.auto_expand_enabled,
            consistent_level=self.consistent_level,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            policy_id=self.policy_id,
            protection_type=self.protection_type,
            region=self.region,
            size=self.size,
            status=self.status,
            type=self.type,
            vaults=self.vaults)


def get_vaults(auto_expand_enabled: Optional[_builtins.bool] = None,
               consistent_level: Optional[_builtins.str] = None,
               enterprise_project_id: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               policy_id: Optional[_builtins.str] = None,
               protection_type: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               size: Optional[_builtins.int] = None,
               status: Optional[_builtins.str] = None,
               type: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVaultsResult:
    """
    Use this data source to get available CBR vaults within Sbercloud.

    ## Example Usage

    ### Get vaults for all server type

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cbr.get_vaults(type="server")
    ```


    :param _builtins.bool auto_expand_enabled: Specifies whether to enable automatic expansion of the backup protection
           type vault. Default to **false**.
    :param _builtins.str consistent_level: Specifies the backup specifications.
           The value is crash_consistent by default (crash consistent backup).
           
           Only server type vaults support application consistent.
    :param _builtins.str enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
    :param _builtins.str name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores(_) and hyphens (-).
    :param _builtins.str policy_id: Specifies a policy to associate with the CBR vault.
    :param _builtins.str protection_type: Specifies the protection type of the CBR vault.
           The valid value is **backup**.
    :param _builtins.str region: Specifies the region in which to query the CBR vaults.
           If omitted, the provider-level region will be used.
    :param _builtins.int size: Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
    :param _builtins.str status: Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
    :param _builtins.str type: Specifies the object type of the CBR vault. The vaild values are as follows:
           + **server** (Cloud Servers)
           + **disk** (EVS Disks)
           + **turbo** (SFS Turbo file systems)
    """
    __args__ = dict()
    __args__['autoExpandEnabled'] = auto_expand_enabled
    __args__['consistentLevel'] = consistent_level
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['protectionType'] = protection_type
    __args__['region'] = region
    __args__['size'] = size
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Cbr/getVaults:getVaults', __args__, opts=opts, typ=GetVaultsResult).value

    return AwaitableGetVaultsResult(
        auto_expand_enabled=pulumi.get(__ret__, 'auto_expand_enabled'),
        consistent_level=pulumi.get(__ret__, 'consistent_level'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        protection_type=pulumi.get(__ret__, 'protection_type'),
        region=pulumi.get(__ret__, 'region'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        vaults=pulumi.get(__ret__, 'vaults'))
def get_vaults_output(auto_expand_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      consistent_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      protection_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVaultsResult]:
    """
    Use this data source to get available CBR vaults within Sbercloud.

    ## Example Usage

    ### Get vaults for all server type

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Cbr.get_vaults(type="server")
    ```


    :param _builtins.bool auto_expand_enabled: Specifies whether to enable automatic expansion of the backup protection
           type vault. Default to **false**.
    :param _builtins.str consistent_level: Specifies the backup specifications.
           The value is crash_consistent by default (crash consistent backup).
           
           Only server type vaults support application consistent.
    :param _builtins.str enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
    :param _builtins.str name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores(_) and hyphens (-).
    :param _builtins.str policy_id: Specifies a policy to associate with the CBR vault.
    :param _builtins.str protection_type: Specifies the protection type of the CBR vault.
           The valid value is **backup**.
    :param _builtins.str region: Specifies the region in which to query the CBR vaults.
           If omitted, the provider-level region will be used.
    :param _builtins.int size: Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
    :param _builtins.str status: Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
    :param _builtins.str type: Specifies the object type of the CBR vault. The vaild values are as follows:
           + **server** (Cloud Servers)
           + **disk** (EVS Disks)
           + **turbo** (SFS Turbo file systems)
    """
    __args__ = dict()
    __args__['autoExpandEnabled'] = auto_expand_enabled
    __args__['consistentLevel'] = consistent_level
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['policyId'] = policy_id
    __args__['protectionType'] = protection_type
    __args__['region'] = region
    __args__['size'] = size
    __args__['status'] = status
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Cbr/getVaults:getVaults', __args__, opts=opts, typ=GetVaultsResult)
    return __ret__.apply(lambda __response__: GetVaultsResult(
        auto_expand_enabled=pulumi.get(__response__, 'auto_expand_enabled'),
        consistent_level=pulumi.get(__response__, 'consistent_level'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        protection_type=pulumi.get(__response__, 'protection_type'),
        region=pulumi.get(__response__, 'region'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        vaults=pulumi.get(__response__, 'vaults')))
