# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PolicyBackupCycle',
    'PolicyLongTermRetention',
    'VaultPolicy',
    'VaultResource',
    'GetVaultsVaultResult',
    'GetVaultsVaultResourceResult',
]

@pulumi.output_type
class PolicyBackupCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionTimes":
            suggest = "execution_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBackupCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBackupCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBackupCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_times: Sequence[_builtins.str],
                 days: Optional[_builtins.str] = None,
                 interval: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] execution_times: Specifies the backup time. Automated backups will be triggered at the backup
               time. The current time is in the UTC format (HH:MM). The minutes in the list must be set to **00** and the hours
               cannot be repeated. In the replication policy, you are advised to set one time point for one day.
               
               <a name="cbr_policy_long_term_retention"></a>
               The `long_term_retention` block supports:
        :param _builtins.str days: Specifies the weekly backup day of backup schedule. It supports seven days a week (MO, TU,
               WE, TH, FR, SA, SU) and this parameter is separated by a comma (,) without spaces, between date and date during the
               configuration.
        :param _builtins.int interval: Specifies the interval (in days) of backup schedule. The value range is `1` to `30`. This
               parameter and `days` are alternative.
        """
        pulumi.set(__self__, "execution_times", execution_times)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="executionTimes")
    def execution_times(self) -> Sequence[_builtins.str]:
        """
        Specifies the backup time. Automated backups will be triggered at the backup
        time. The current time is in the UTC format (HH:MM). The minutes in the list must be set to **00** and the hours
        cannot be repeated. In the replication policy, you are advised to set one time point for one day.

        <a name="cbr_policy_long_term_retention"></a>
        The `long_term_retention` block supports:
        """
        return pulumi.get(self, "execution_times")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.str]:
        """
        Specifies the weekly backup day of backup schedule. It supports seven days a week (MO, TU,
        WE, TH, FR, SA, SU) and this parameter is separated by a comma (,) without spaces, between date and date during the
        configuration.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        Specifies the interval (in days) of backup schedule. The value range is `1` to `30`. This
        parameter and `days` are alternative.
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class PolicyLongTermRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullBackupInterval":
            suggest = "full_backup_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyLongTermRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyLongTermRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyLongTermRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily: Optional[_builtins.int] = None,
                 full_backup_interval: Optional[_builtins.int] = None,
                 monthly: Optional[_builtins.int] = None,
                 weekly: Optional[_builtins.int] = None,
                 yearly: Optional[_builtins.int] = None):
        """
        :param _builtins.int daily: Specifies the latest backup of each day is saved in the long term.
        :param _builtins.int full_backup_interval: How often (after how many incremental backups) a full backup is performed.
        :param _builtins.int monthly: Specifies the latest backup of each month is saved in the long term.
        :param _builtins.int weekly: Specifies the latest backup of each week is saved in the long term.
        :param _builtins.int yearly: Specifies the latest backup of each year is saved in the long term.
               
               > A maximum of 10 backups are retained for failed periodic backup tasks. They are retained for one month and can be
               manually deleted on the web console.
        """
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if full_backup_interval is not None:
            pulumi.set(__self__, "full_backup_interval", full_backup_interval)
        if monthly is not None:
            pulumi.set(__self__, "monthly", monthly)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)
        if yearly is not None:
            pulumi.set(__self__, "yearly", yearly)

    @_builtins.property
    @pulumi.getter
    def daily(self) -> Optional[_builtins.int]:
        """
        Specifies the latest backup of each day is saved in the long term.
        """
        return pulumi.get(self, "daily")

    @_builtins.property
    @pulumi.getter(name="fullBackupInterval")
    def full_backup_interval(self) -> Optional[_builtins.int]:
        """
        How often (after how many incremental backups) a full backup is performed.
        """
        return pulumi.get(self, "full_backup_interval")

    @_builtins.property
    @pulumi.getter
    def monthly(self) -> Optional[_builtins.int]:
        """
        Specifies the latest backup of each month is saved in the long term.
        """
        return pulumi.get(self, "monthly")

    @_builtins.property
    @pulumi.getter
    def weekly(self) -> Optional[_builtins.int]:
        """
        Specifies the latest backup of each week is saved in the long term.
        """
        return pulumi.get(self, "weekly")

    @_builtins.property
    @pulumi.getter
    def yearly(self) -> Optional[_builtins.int]:
        """
        Specifies the latest backup of each year is saved in the long term.

        > A maximum of 10 backups are retained for failed periodic backup tasks. They are retained for one month and can be
        manually deleted on the web console.
        """
        return pulumi.get(self, "yearly")


@pulumi.output_type
class VaultPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationVaultId":
            suggest = "destination_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 destination_vault_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: A resource ID in UUID format.
        :param _builtins.str destination_vault_id: The ID of destination vault to which the replication policy will associated.
        """
        pulumi.set(__self__, "id", id)
        if destination_vault_id is not None:
            pulumi.set(__self__, "destination_vault_id", destination_vault_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A resource ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="destinationVaultId")
    def destination_vault_id(self) -> Optional[_builtins.str]:
        """
        The ID of destination vault to which the replication policy will associated.
        """
        return pulumi.get(self, "destination_vault_id")


@pulumi.output_type
class VaultResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Optional[Sequence[_builtins.str]] = None,
                 includes: Optional[Sequence[_builtins.str]] = None,
                 server_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] excludes: Specifies the array of disk IDs which will be excluded in the backup.
               Only **server** vault support this parameter.
        :param Sequence[_builtins.str] includes: Specifies the array of disk or SFS file system IDs which will be included in the backup.
               Only **disk** and **turbo** vault support this parameter.
        :param _builtins.str server_id: Specifies the ID of the ECS instance to be backed up.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the array of disk IDs which will be excluded in the backup.
        Only **server** vault support this parameter.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the array of disk or SFS file system IDs which will be included in the backup.
        Only **disk** and **turbo** vault support this parameter.
        """
        return pulumi.get(self, "includes")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the ECS instance to be backed up.
        """
        return pulumi.get(self, "server_id")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 allocated: _builtins.float,
                 auto_bind: _builtins.bool,
                 auto_expand_enabled: _builtins.bool,
                 bind_rules: Mapping[str, _builtins.str],
                 consistent_level: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 policy_id: _builtins.str,
                 protection_type: _builtins.str,
                 resources: Sequence['outputs.GetVaultsVaultResourceResult'],
                 size: _builtins.int,
                 spec_code: _builtins.str,
                 status: _builtins.str,
                 storage: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 used: _builtins.float):
        """
        :param _builtins.float allocated: The allocated capacity of the vault, in GB.
        :param _builtins.bool auto_bind: Whether automatic association is supported.
        :param _builtins.bool auto_expand_enabled: Specifies whether to enable automatic expansion of the backup protection
               type vault. Default to **false**.
        :param Mapping[str, _builtins.str] bind_rules: The rules for automatic association.
        :param _builtins.str consistent_level: Specifies the backup specifications.
               The value is crash_consistent by default (crash consistent backup).
               
               Only server type vaults support application consistent.
        :param _builtins.str enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
        :param _builtins.str id: The vault ID in UUID format.
        :param _builtins.str name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param _builtins.str policy_id: Specifies a policy to associate with the CBR vault.
        :param _builtins.str protection_type: Specifies the protection type of the CBR vault.
               The valid value is **backup**.
        :param Sequence['GetVaultsVaultResourceArgs'] resources: An array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param _builtins.int size: Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
        :param _builtins.str spec_code: The specification code.
        :param _builtins.str status: Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
        :param _builtins.str storage: The name of the bucket for the vault.
        :param Mapping[str, _builtins.str] tags: The key/value pairs to associate with the vault.
        :param _builtins.str type: Specifies the object type of the CBR vault. The vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param _builtins.float used: The used capacity, in GB.
        """
        pulumi.set(__self__, "allocated", allocated)
        pulumi.set(__self__, "auto_bind", auto_bind)
        pulumi.set(__self__, "auto_expand_enabled", auto_expand_enabled)
        pulumi.set(__self__, "bind_rules", bind_rules)
        pulumi.set(__self__, "consistent_level", consistent_level)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "protection_type", protection_type)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "spec_code", spec_code)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter
    def allocated(self) -> _builtins.float:
        """
        The allocated capacity of the vault, in GB.
        """
        return pulumi.get(self, "allocated")

    @_builtins.property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> _builtins.bool:
        """
        Whether automatic association is supported.
        """
        return pulumi.get(self, "auto_bind")

    @_builtins.property
    @pulumi.getter(name="autoExpandEnabled")
    def auto_expand_enabled(self) -> _builtins.bool:
        """
        Specifies whether to enable automatic expansion of the backup protection
        type vault. Default to **false**.
        """
        return pulumi.get(self, "auto_expand_enabled")

    @_builtins.property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> Mapping[str, _builtins.str]:
        """
        The rules for automatic association.
        """
        return pulumi.get(self, "bind_rules")

    @_builtins.property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> _builtins.str:
        """
        Specifies the backup specifications.
        The value is crash_consistent by default (crash consistent backup).

        Only server type vaults support application consistent.
        """
        return pulumi.get(self, "consistent_level")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies a unique ID in UUID format of enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The vault ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> _builtins.str:
        """
        Specifies a policy to associate with the CBR vault.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> _builtins.str:
        """
        Specifies the protection type of the CBR vault.
        The valid value is **backup**.
        """
        return pulumi.get(self, "protection_type")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetVaultsVaultResourceResult']:
        """
        An array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the vault sapacity, in GB. The valid value range is `1` to `10,485,760`.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> _builtins.str:
        """
        The specification code.
        """
        return pulumi.get(self, "spec_code")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the CBR vault status, including **available**, **lock**, **frozen** and **error**.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.str:
        """
        The name of the bucket for the vault.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs to associate with the vault.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the object type of the CBR vault. The vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def used(self) -> _builtins.float:
        """
        The used capacity, in GB.
        """
        return pulumi.get(self, "used")


@pulumi.output_type
class GetVaultsVaultResourceResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[_builtins.str],
                 includes: Sequence[_builtins.str],
                 server_id: _builtins.str):
        """
        :param Sequence[_builtins.str] excludes: The array of disk IDs which will be excluded in the backup.
        :param Sequence[_builtins.str] includes: An array of disk or SFS file system IDs which will be included in the backup.
        :param _builtins.str server_id: The ID of the ECS instance to be backed up.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)
        pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Sequence[_builtins.str]:
        """
        The array of disk IDs which will be excluded in the backup.
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter
    def includes(self) -> Sequence[_builtins.str]:
        """
        An array of disk or SFS file system IDs which will be included in the backup.
        """
        return pulumi.get(self, "includes")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        The ID of the ECS instance to be backed up.
        """
        return pulumi.get(self, "server_id")


