# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VaultArgs', 'Vault']

@pulumi.input_type
class VaultArgs:
    def __init__(__self__, *,
                 protection_type: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 auto_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expand: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 consistent_level: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Vault resource.
        :param pulumi.Input[_builtins.str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
               
               > You cannot update `size` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[_builtins.bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[_builtins.bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
               
               > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               <a name="cbr_vault_resources"></a>
               The `resources` block supports:
        :param pulumi.Input[_builtins.str] backup_name_prefix: The backup name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] cloud_type: The cloud type of the vault.
        :param pulumi.Input[_builtins.str] consistent_level: Specifies the backup specifications.
               
               Only **server** type vaults support application consistent and defaults to **crash_consistent**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.bool] is_multi_az: Specifies whether multiple availability zones are used for backing up.
               Defaults to **false**.
        :param pulumi.Input[_builtins.bool] locked: Locked status of the vault.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]] policies: The policy details to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        """
        pulumi.set(__self__, "protection_type", protection_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if auto_bind is not None:
            pulumi.set(__self__, "auto_bind", auto_bind)
        if auto_expand is not None:
            pulumi.set(__self__, "auto_expand", auto_expand)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_name_prefix is not None:
            pulumi.set(__self__, "backup_name_prefix", backup_name_prefix)
        if bind_rules is not None:
            pulumi.set(__self__, "bind_rules", bind_rules)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if consistent_level is not None:
            pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_multi_az is not None:
            pulumi.set(__self__, "is_multi_az", is_multi_az)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protection_type", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.

        > You cannot update `size` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @auto_bind.setter
    def auto_bind(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_bind", value)

    @_builtins.property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.

        > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "auto_expand")

    @auto_expand.setter
    def auto_expand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_expand", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        <a name="cbr_vault_resources"></a>
        The `resources` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backupNamePrefix")
    def backup_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup name prefix.
        """
        return pulumi.get(self, "backup_name_prefix")

    @backup_name_prefix.setter
    def backup_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @bind_rules.setter
    def bind_rules(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bind_rules", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.

        Changing this will create a new vault.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud type of the vault.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_type", value)

    @_builtins.property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the backup specifications.

        Only **server** type vaults support application consistent and defaults to **crash_consistent**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "consistent_level")

    @consistent_level.setter
    def consistent_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consistent_level", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isMultiAz")
    def is_multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether multiple availability zones are used for backing up.
        Defaults to **false**.
        """
        return pulumi.get(self, "is_multi_az")

    @is_multi_az.setter
    def is_multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_multi_az", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Locked status of the vault.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]]:
        """
        The policy details to associate with the CBR vault.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VaultState:
    def __init__(__self__, *,
                 allocated: Optional[pulumi.Input[_builtins.float]] = None,
                 auto_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expand: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 consistent_level: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering Vault resources.
        :param pulumi.Input[_builtins.float] allocated: The allocated capacity of the vault, in GB.
        :param pulumi.Input[_builtins.bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[_builtins.bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
               
               > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               <a name="cbr_vault_resources"></a>
               The `resources` block supports:
        :param pulumi.Input[_builtins.str] backup_name_prefix: The backup name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] cloud_type: The cloud type of the vault.
        :param pulumi.Input[_builtins.str] consistent_level: Specifies the backup specifications.
               
               Only **server** type vaults support application consistent and defaults to **crash_consistent**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.bool] is_multi_az: Specifies whether multiple availability zones are used for backing up.
               Defaults to **false**.
        :param pulumi.Input[_builtins.bool] locked: Locked status of the vault.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]] policies: The policy details to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[_builtins.str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
               
               > You cannot update `size` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] spec_code: The specification code.
        :param pulumi.Input[_builtins.str] status: The vault status.
        :param pulumi.Input[_builtins.str] storage: The name of the bucket for the vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[_builtins.float] used: The used capacity, in GB.
        """
        if allocated is not None:
            pulumi.set(__self__, "allocated", allocated)
        if auto_bind is not None:
            pulumi.set(__self__, "auto_bind", auto_bind)
        if auto_expand is not None:
            pulumi.set(__self__, "auto_expand", auto_expand)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_name_prefix is not None:
            pulumi.set(__self__, "backup_name_prefix", backup_name_prefix)
        if bind_rules is not None:
            pulumi.set(__self__, "bind_rules", bind_rules)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if consistent_level is not None:
            pulumi.set(__self__, "consistent_level", consistent_level)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_multi_az is not None:
            pulumi.set(__self__, "is_multi_az", is_multi_az)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_type is not None:
            pulumi.set(__self__, "protection_type", protection_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if spec_code is not None:
            pulumi.set(__self__, "spec_code", spec_code)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used is not None:
            pulumi.set(__self__, "used", used)

    @_builtins.property
    @pulumi.getter
    def allocated(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The allocated capacity of the vault, in GB.
        """
        return pulumi.get(self, "allocated")

    @allocated.setter
    def allocated(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "allocated", value)

    @_builtins.property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @auto_bind.setter
    def auto_bind(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_bind", value)

    @_builtins.property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.

        > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "auto_expand")

    @auto_expand.setter
    def auto_expand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_expand", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        <a name="cbr_vault_resources"></a>
        The `resources` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backupNamePrefix")
    def backup_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup name prefix.
        """
        return pulumi.get(self, "backup_name_prefix")

    @backup_name_prefix.setter
    def backup_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @bind_rules.setter
    def bind_rules(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bind_rules", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.

        Changing this will create a new vault.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud type of the vault.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_type", value)

    @_builtins.property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the backup specifications.

        Only **server** type vaults support application consistent and defaults to **crash_consistent**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "consistent_level")

    @consistent_level.setter
    def consistent_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consistent_level", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isMultiAz")
    def is_multi_az(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether multiple availability zones are used for backing up.
        Defaults to **false**.
        """
        return pulumi.get(self, "is_multi_az")

    @is_multi_az.setter
    def is_multi_az(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_multi_az", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Locked status of the vault.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]]:
        """
        The policy details to associate with the CBR vault.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @protection_type.setter
    def protection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VaultResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.

        > You cannot update `size` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification code.
        """
        return pulumi.get(self, "spec_code")

    @spec_code.setter
    def spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_code", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket for the vault.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def used(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The used capacity, in GB.
        """
        return pulumi.get(self, "used")

    @used.setter
    def used(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "used", value)


@pulumi.type_token("sbercloud:Cbr/vault:Vault")
class Vault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expand: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 consistent_level: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultPolicyArgs', 'VaultPolicyArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultResourceArgs', 'VaultResourceArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a CBR Vault resource within Sbercloud.

        ## Example Usage

        ### Create a disk type vault

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        evs_volume_id = config.require_object("evsVolumeId")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="disk",
            protection_type="backup",
            size=50,
            auto_expand=True,
            resources=[{
                "includes": [evs_volume_id],
            }],
            tags={
                "foo": "bar",
            })
        ```

        ### Create an SFS turbo type vault

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        sfs_turbo_id = config.require_object("sfsTurboId")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="turbo",
            protection_type="backup",
            size=1000,
            resources=[{
                "includes": [sfs_turbo_id],
            }],
            tags={
                "foo": "bar",
            })
        ```

        ### Create an SFS turbo type vault with replicate protection type

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="turbo",
            protection_type="replication",
            size=1000)
        ```

        ## Import

        Vaults can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:Cbr/vault:Vault test 01c33779-7c83-4182-8b6b-24a671fcedf8
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `period_unit`, `period`, `auto_renew`.

        It is generally recommended running `pulumi preview` after importing a vault.

        You can then decide if changes should be applied to the vault, or the resource definition should be updated to align

        with the vault. Also you can ignore changes as below.

        resource "sbercloud_cbr_vault" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              period_unit, period, auto_renew,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[_builtins.bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
               
               > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               <a name="cbr_vault_resources"></a>
               The `resources` block supports:
        :param pulumi.Input[_builtins.str] backup_name_prefix: The backup name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] cloud_type: The cloud type of the vault.
        :param pulumi.Input[_builtins.str] consistent_level: Specifies the backup specifications.
               
               Only **server** type vaults support application consistent and defaults to **crash_consistent**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.bool] is_multi_az: Specifies whether multiple availability zones are used for backing up.
               Defaults to **false**.
        :param pulumi.Input[_builtins.bool] locked: Locked status of the vault.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultPolicyArgs', 'VaultPolicyArgsDict']]]] policies: The policy details to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[_builtins.str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultResourceArgs', 'VaultResourceArgsDict']]]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
               
               > You cannot update `size` if the vault is **prePaid** mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CBR Vault resource within Sbercloud.

        ## Example Usage

        ### Create a disk type vault

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        evs_volume_id = config.require_object("evsVolumeId")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="disk",
            protection_type="backup",
            size=50,
            auto_expand=True,
            resources=[{
                "includes": [evs_volume_id],
            }],
            tags={
                "foo": "bar",
            })
        ```

        ### Create an SFS turbo type vault

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        sfs_turbo_id = config.require_object("sfsTurboId")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="turbo",
            protection_type="backup",
            size=1000,
            resources=[{
                "includes": [sfs_turbo_id],
            }],
            tags={
                "foo": "bar",
            })
        ```

        ### Create an SFS turbo type vault with replicate protection type

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vault_name = config.require_object("vaultName")
        test = sbercloud.cbr.Vault("test",
            name=vault_name,
            type="turbo",
            protection_type="replication",
            size=1000)
        ```

        ## Import

        Vaults can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:Cbr/vault:Vault test 01c33779-7c83-4182-8b6b-24a671fcedf8
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `period_unit`, `period`, `auto_renew`.

        It is generally recommended running `pulumi preview` after importing a vault.

        You can then decide if changes should be applied to the vault, or the resource definition should be updated to align

        with the vault. Also you can ignore changes as below.

        resource "sbercloud_cbr_vault" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              period_unit, period, auto_renew,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param VaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_bind: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_expand: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
                 consistent_level: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultPolicyArgs', 'VaultPolicyArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultResourceArgs', 'VaultResourceArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultArgs.__new__(VaultArgs)

            __props__.__dict__["auto_bind"] = auto_bind
            __props__.__dict__["auto_expand"] = auto_expand
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["backup_name_prefix"] = backup_name_prefix
            __props__.__dict__["bind_rules"] = bind_rules
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["consistent_level"] = consistent_level
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["is_multi_az"] = is_multi_az
            __props__.__dict__["locked"] = locked
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["policies"] = policies
            __props__.__dict__["policy_id"] = policy_id
            if protection_type is None and not opts.urn:
                raise TypeError("Missing required property 'protection_type'")
            __props__.__dict__["protection_type"] = protection_type
            __props__.__dict__["region"] = region
            __props__.__dict__["resources"] = resources
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["allocated"] = None
            __props__.__dict__["spec_code"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage"] = None
            __props__.__dict__["used"] = None
        super(Vault, __self__).__init__(
            'sbercloud:Cbr/vault:Vault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated: Optional[pulumi.Input[_builtins.float]] = None,
            auto_bind: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_expand: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            backup_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            bind_rules: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_type: Optional[pulumi.Input[_builtins.str]] = None,
            consistent_level: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_multi_az: Optional[pulumi.Input[_builtins.bool]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultPolicyArgs', 'VaultPolicyArgsDict']]]]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            protection_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VaultResourceArgs', 'VaultResourceArgsDict']]]]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used: Optional[pulumi.Input[_builtins.float]] = None) -> 'Vault':
        """
        Get an existing Vault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] allocated: The allocated capacity of the vault, in GB.
        :param pulumi.Input[_builtins.bool] auto_bind: Specifies whether automatic association is enabled. Defaults to **false**.
        :param pulumi.Input[_builtins.bool] auto_expand: Specifies to enable auto capacity expansion for the backup protection type vault.
               Defaults to **false**.
               
               > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
               
               <a name="cbr_vault_resources"></a>
               The `resources` block supports:
        :param pulumi.Input[_builtins.str] backup_name_prefix: The backup name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] bind_rules: Specifies the tags to filter resources for automatic association with **auto_bind**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the vault.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
               
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] cloud_type: The cloud type of the vault.
        :param pulumi.Input[_builtins.str] consistent_level: Specifies the backup specifications.
               
               Only **server** type vaults support application consistent and defaults to **crash_consistent**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique ID in UUID format of enterprise project.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.bool] is_multi_az: Specifies whether multiple availability zones are used for backing up.
               Defaults to **false**.
        :param pulumi.Input[_builtins.bool] locked: Locked status of the vault.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
               characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the vault.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the vault.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultPolicyArgs', 'VaultPolicyArgsDict']]]] policies: The policy details to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] policy_id: Specifies a policy to associate with the CBR vault.
               `policy_id` cannot be used with the vault of replicate protection type.
        :param pulumi.Input[_builtins.str] protection_type: Specifies the protection type of the CBR vault.
               The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
               Changing this will create a new vault.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CBR vault. If omitted, the
               provider-level region will be used. Changing this will create a new vault.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VaultResourceArgs', 'VaultResourceArgsDict']]]] resources: Specifies an array of one or more resources to attach to the CBR vault.
               The object structure is documented below.
        :param pulumi.Input[_builtins.int] size: Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.
               
               > You cannot update `size` if the vault is **prePaid** mode.
        :param pulumi.Input[_builtins.str] spec_code: The specification code.
        :param pulumi.Input[_builtins.str] status: The vault status.
        :param pulumi.Input[_builtins.str] storage: The name of the bucket for the vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the CBR vault.
        :param pulumi.Input[_builtins.str] type: Specifies the object type of the CBR vault.
               Changing this will create a new vault. Vaild values are as follows:
               + **server** (Cloud Servers)
               + **disk** (EVS Disks)
               + **turbo** (SFS Turbo file systems)
        :param pulumi.Input[_builtins.float] used: The used capacity, in GB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultState.__new__(_VaultState)

        __props__.__dict__["allocated"] = allocated
        __props__.__dict__["auto_bind"] = auto_bind
        __props__.__dict__["auto_expand"] = auto_expand
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backup_name_prefix"] = backup_name_prefix
        __props__.__dict__["bind_rules"] = bind_rules
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["consistent_level"] = consistent_level
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["is_multi_az"] = is_multi_az
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["policies"] = policies
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["protection_type"] = protection_type
        __props__.__dict__["region"] = region
        __props__.__dict__["resources"] = resources
        __props__.__dict__["size"] = size
        __props__.__dict__["spec_code"] = spec_code
        __props__.__dict__["status"] = status
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used"] = used
        return Vault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def allocated(self) -> pulumi.Output[_builtins.float]:
        """
        The allocated capacity of the vault, in GB.
        """
        return pulumi.get(self, "allocated")

    @_builtins.property
    @pulumi.getter(name="autoBind")
    def auto_bind(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether automatic association is enabled. Defaults to **false**.
        """
        return pulumi.get(self, "auto_bind")

    @_builtins.property
    @pulumi.getter(name="autoExpand")
    def auto_expand(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies to enable auto capacity expansion for the backup protection type vault.
        Defaults to **false**.

        > You cannot configure `auto_expand` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "auto_expand")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.

        <a name="cbr_vault_resources"></a>
        The `resources` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="backupNamePrefix")
    def backup_name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The backup name prefix.
        """
        return pulumi.get(self, "backup_name_prefix")

    @_builtins.property
    @pulumi.getter(name="bindRules")
    def bind_rules(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags to filter resources for automatic association with **auto_bind**.
        """
        return pulumi.get(self, "bind_rules")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the vault.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.

        Changing this will create a new vault.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud type of the vault.
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter(name="consistentLevel")
    def consistent_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the backup specifications.

        Only **server** type vaults support application consistent and defaults to **crash_consistent**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "consistent_level")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique ID in UUID format of enterprise project.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="isMultiAz")
    def is_multi_az(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether multiple availability zones are used for backing up.
        Defaults to **false**.
        """
        return pulumi.get(self, "is_multi_az")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Locked status of the vault.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique name of the CBR vault. This parameter can contain a maximum of 64
        characters, which may consist of letters, digits, underscores(_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the vault.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the vault.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.VaultPolicy']]:
        """
        The policy details to associate with the CBR vault.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a policy to associate with the CBR vault.
        `policy_id` cannot be used with the vault of replicate protection type.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="protectionType")
    def protection_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protection type of the CBR vault.
        The valid values are **backup** and **replication**. Vaults of type **disk** don't support **replication**.
        Changing this will create a new vault.
        """
        return pulumi.get(self, "protection_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the CBR vault. If omitted, the
        provider-level region will be used. Changing this will create a new vault.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.VaultResource']]:
        """
        Specifies an array of one or more resources to attach to the CBR vault.
        The object structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the vault capacity, in GB. The valid value range is `1` to `10,485,760`.

        > You cannot update `size` if the vault is **prePaid** mode.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        The specification code.
        """
        return pulumi.get(self, "spec_code")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The vault status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket for the vault.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the CBR vault.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the object type of the CBR vault.
        Changing this will create a new vault. Vaild values are as follows:
        + **server** (Cloud Servers)
        + **disk** (EVS Disks)
        + **turbo** (SFS Turbo file systems)
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def used(self) -> pulumi.Output[_builtins.float]:
        """
        The used capacity, in GB.
        """
        return pulumi.get(self, "used")

