# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CbrBackupShareArgs', 'CbrBackupShare']

@pulumi.input_type
class CbrBackupShareArgs:
    def __init__(__self__, *,
                 backup_id: pulumi.Input[_builtins.str],
                 members: pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CbrBackupShare resource.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID.
        :param pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]] members: The list of shared members configuration.
        :param pulumi.Input[_builtins.str] region: The region where the shared backup is located.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "members", members)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Input[_builtins.str]:
        """
        The backup ID.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]]:
        """
        The list of shared members configuration.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the shared backup is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CbrBackupShareState:
    def __init__(__self__, *,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CbrBackupShare resources.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID.
        :param pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]] members: The list of shared members configuration.
        :param pulumi.Input[_builtins.str] region: The region where the shared backup is located.
        """
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backup ID.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]]]:
        """
        The list of shared members configuration.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CbrBackupShareMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the shared backup is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/cbrBackupShare:CbrBackupShare")
class CbrBackupShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrBackupShareMemberArgs', 'CbrBackupShareMemberArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a CbrBackupShare resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CbrBackupShareMemberArgs', 'CbrBackupShareMemberArgsDict']]]] members: The list of shared members configuration.
        :param pulumi.Input[_builtins.str] region: The region where the shared backup is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CbrBackupShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CbrBackupShare resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CbrBackupShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CbrBackupShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrBackupShareMemberArgs', 'CbrBackupShareMemberArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CbrBackupShareArgs.__new__(CbrBackupShareArgs)

            if backup_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_id'")
            __props__.__dict__["backup_id"] = backup_id
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["region"] = region
        super(CbrBackupShare, __self__).__init__(
            'sbercloud:index/cbrBackupShare:CbrBackupShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrBackupShareMemberArgs', 'CbrBackupShareMemberArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'CbrBackupShare':
        """
        Get an existing CbrBackupShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: The backup ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CbrBackupShareMemberArgs', 'CbrBackupShareMemberArgsDict']]]] members: The list of shared members configuration.
        :param pulumi.Input[_builtins.str] region: The region where the shared backup is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CbrBackupShareState.__new__(_CbrBackupShareState)

        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["members"] = members
        __props__.__dict__["region"] = region
        return CbrBackupShare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        The backup ID.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.CbrBackupShareMember']]:
        """
        The list of shared members configuration.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the shared backup is located.
        """
        return pulumi.get(self, "region")

