# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CbrBackupShareAccepterArgs', 'CbrBackupShareAccepter']

@pulumi.input_type
class CbrBackupShareAccepterArgs:
    def __init__(__self__, *,
                 backup_id: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CbrBackupShareAccepter resource.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the shared source backup.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault which the backup will be stored.
        :param pulumi.Input[_builtins.str] region: The region where the backup will be stored.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "vault_id", vault_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the shared source backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vault which the backup will be stored.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the backup will be stored.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CbrBackupShareAccepterState:
    def __init__(__self__, *,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CbrBackupShareAccepter resources.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the shared source backup.
        :param pulumi.Input[_builtins.str] region: The region where the backup will be stored.
        :param pulumi.Input[_builtins.str] source_project_id: The ID of the project to which the source backup belongs.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault which the backup will be stored.
        """
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_project_id is not None:
            pulumi.set(__self__, "source_project_id", source_project_id)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the shared source backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the backup will be stored.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceProjectId")
    def source_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project to which the source backup belongs.
        """
        return pulumi.get(self, "source_project_id")

    @source_project_id.setter
    def source_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_project_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vault which the backup will be stored.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("sbercloud:index/cbrBackupShareAccepter:CbrBackupShareAccepter")
class CbrBackupShareAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a CbrBackupShareAccepter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the shared source backup.
        :param pulumi.Input[_builtins.str] region: The region where the backup will be stored.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault which the backup will be stored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CbrBackupShareAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CbrBackupShareAccepter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CbrBackupShareAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CbrBackupShareAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CbrBackupShareAccepterArgs.__new__(CbrBackupShareAccepterArgs)

            if backup_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_id'")
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["region"] = region
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["source_project_id"] = None
        super(CbrBackupShareAccepter, __self__).__init__(
            'sbercloud:index/cbrBackupShareAccepter:CbrBackupShareAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CbrBackupShareAccepter':
        """
        Get an existing CbrBackupShareAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the shared source backup.
        :param pulumi.Input[_builtins.str] region: The region where the backup will be stored.
        :param pulumi.Input[_builtins.str] source_project_id: The ID of the project to which the source backup belongs.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault which the backup will be stored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CbrBackupShareAccepterState.__new__(_CbrBackupShareAccepterState)

        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["region"] = region
        __props__.__dict__["source_project_id"] = source_project_id
        __props__.__dict__["vault_id"] = vault_id
        return CbrBackupShareAccepter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the shared source backup.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the backup will be stored.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceProjectId")
    def source_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project to which the source backup belongs.
        """
        return pulumi.get(self, "source_project_id")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vault which the backup will be stored.
        """
        return pulumi.get(self, "vault_id")

