# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CbrCheckpointArgs', 'CbrCheckpoint']

@pulumi.input_type
class CbrCheckpointArgs:
    def __init__(__self__, *,
                 backups: pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]],
                 vault_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CbrCheckpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]] backups: The list of backups configuration.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault where the checkpoint to create.
        :param pulumi.Input[_builtins.str] description: The description of the checkpoint.
        :param pulumi.Input[_builtins.bool] incremental: Whether the backups are incremental backups.
        :param pulumi.Input[_builtins.str] name: The name of the checkpoint.
        :param pulumi.Input[_builtins.str] region: The region where the vault and backup resources are located.
        """
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "vault_id", vault_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if incremental is not None:
            pulumi.set(__self__, "incremental", incremental)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]]:
        """
        The list of backups configuration.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]]):
        pulumi.set(self, "backups", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vault where the checkpoint to create.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the checkpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def incremental(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the backups are incremental backups.
        """
        return pulumi.get(self, "incremental")

    @incremental.setter
    def incremental(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "incremental", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the checkpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the vault and backup resources are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CbrCheckpointState:
    def __init__(__self__, *,
                 backups: Optional[pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CbrCheckpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]] backups: The list of backups configuration.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the checkpoint.
        :param pulumi.Input[_builtins.str] description: The description of the checkpoint.
        :param pulumi.Input[_builtins.bool] incremental: Whether the backups are incremental backups.
        :param pulumi.Input[_builtins.str] name: The name of the checkpoint.
        :param pulumi.Input[_builtins.str] region: The region where the vault and backup resources are located.
        :param pulumi.Input[_builtins.str] status: The status of the checkpoint.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault where the checkpoint to create.
        """
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if incremental is not None:
            pulumi.set(__self__, "incremental", incremental)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]]]:
        """
        The list of backups configuration.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CbrCheckpointBackupArgs']]]]):
        pulumi.set(self, "backups", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the checkpoint.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the checkpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def incremental(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the backups are incremental backups.
        """
        return pulumi.get(self, "incremental")

    @incremental.setter
    def incremental(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "incremental", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the checkpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the vault and backup resources are located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the checkpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vault where the checkpoint to create.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("sbercloud:index/cbrCheckpoint:CbrCheckpoint")
class CbrCheckpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrCheckpointBackupArgs', 'CbrCheckpointBackupArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a CbrCheckpoint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CbrCheckpointBackupArgs', 'CbrCheckpointBackupArgsDict']]]] backups: The list of backups configuration.
        :param pulumi.Input[_builtins.str] description: The description of the checkpoint.
        :param pulumi.Input[_builtins.bool] incremental: Whether the backups are incremental backups.
        :param pulumi.Input[_builtins.str] name: The name of the checkpoint.
        :param pulumi.Input[_builtins.str] region: The region where the vault and backup resources are located.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault where the checkpoint to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CbrCheckpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CbrCheckpoint resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CbrCheckpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CbrCheckpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrCheckpointBackupArgs', 'CbrCheckpointBackupArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 incremental: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CbrCheckpointArgs.__new__(CbrCheckpointArgs)

            if backups is None and not opts.urn:
                raise TypeError("Missing required property 'backups'")
            __props__.__dict__["backups"] = backups
            __props__.__dict__["description"] = description
            __props__.__dict__["incremental"] = incremental
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(CbrCheckpoint, __self__).__init__(
            'sbercloud:index/cbrCheckpoint:CbrCheckpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CbrCheckpointBackupArgs', 'CbrCheckpointBackupArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            incremental: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CbrCheckpoint':
        """
        Get an existing CbrCheckpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CbrCheckpointBackupArgs', 'CbrCheckpointBackupArgsDict']]]] backups: The list of backups configuration.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the checkpoint.
        :param pulumi.Input[_builtins.str] description: The description of the checkpoint.
        :param pulumi.Input[_builtins.bool] incremental: Whether the backups are incremental backups.
        :param pulumi.Input[_builtins.str] name: The name of the checkpoint.
        :param pulumi.Input[_builtins.str] region: The region where the vault and backup resources are located.
        :param pulumi.Input[_builtins.str] status: The status of the checkpoint.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the vault where the checkpoint to create.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CbrCheckpointState.__new__(_CbrCheckpointState)

        __props__.__dict__["backups"] = backups
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["incremental"] = incremental
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["vault_id"] = vault_id
        return CbrCheckpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Sequence['outputs.CbrCheckpointBackup']]:
        """
        The list of backups configuration.
        """
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the checkpoint.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the checkpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def incremental(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the backups are incremental backups.
        """
        return pulumi.get(self, "incremental")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the checkpoint.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the vault and backup resources are located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the checkpoint.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vault where the checkpoint to create.
        """
        return pulumi.get(self, "vault_id")

