# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddonArgs', 'Addon']

@pulumi.input_type
class AddonArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 template_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input['AddonValuesArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Addon resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] template_name: Specifies the name of the add-on template.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE add-on resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        :param pulumi.Input['AddonValuesArgs'] values: Specifies the add-on template installation parameters.
               These parameters vary depending on the add-on. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the add-on.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "template_name", template_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the add-on template.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CCE add-on resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input['AddonValuesArgs']]:
        """
        Specifies the add-on template installation parameters.
        These parameters vary depending on the add-on. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input['AddonValuesArgs']]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _AddonState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input['AddonValuesArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Addon resources.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Description of add-on instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE add-on resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        :param pulumi.Input[_builtins.str] status: Add-on status information.
        :param pulumi.Input[_builtins.str] template_name: Specifies the name of the add-on template.
               Changing this parameter will create a new resource.
        :param pulumi.Input['AddonValuesArgs'] values: Specifies the add-on template installation parameters.
               These parameters vary depending on the add-on. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the add-on.
               Changing this parameter will create a new resource.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of add-on instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the CCE add-on resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add-on status information.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the add-on template.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input['AddonValuesArgs']]:
        """
        Specifies the add-on template installation parameters.
        These parameters vary depending on the add-on. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input['AddonValuesArgs']]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sbercloud:Cce/addon:Addon")
class Addon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Union['AddonValuesArgs', 'AddonValuesArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CCE add-on resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        addon_test = sbercloud.cce.Addon("addon_test",
            cluster_id=cluster_id,
            template_name="metrics-server",
            version="1.1.10")
        ```

        ## Import

        CCE add-on can be imported using the cluster ID and add-on ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Cce/addon:Addon my_addon bb6923e4-b16e-11eb-b0cd-0255ac101da1/c7ecb230-b16f-11eb-b3b6-0255ac1015a3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE add-on resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        :param pulumi.Input[_builtins.str] template_name: Specifies the name of the add-on template.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['AddonValuesArgs', 'AddonValuesArgsDict']] values: Specifies the add-on template installation parameters.
               These parameters vary depending on the add-on. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the add-on.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CCE add-on resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        addon_test = sbercloud.cce.Addon("addon_test",
            cluster_id=cluster_id,
            template_name="metrics-server",
            version="1.1.10")
        ```

        ## Import

        CCE add-on can be imported using the cluster ID and add-on ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Cce/addon:Addon my_addon bb6923e4-b16e-11eb-b0cd-0255ac101da1/c7ecb230-b16f-11eb-b3b6-0255ac1015a3
        ```

        :param str resource_name: The name of the resource.
        :param AddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Union['AddonValuesArgs', 'AddonValuesArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonArgs.__new__(AddonArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["region"] = region
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["values"] = values
            __props__.__dict__["version"] = version
            __props__.__dict__["description"] = None
            __props__.__dict__["status"] = None
        super(Addon, __self__).__init__(
            'sbercloud:Cce/addon:Addon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            template_name: Optional[pulumi.Input[_builtins.str]] = None,
            values: Optional[pulumi.Input[Union['AddonValuesArgs', 'AddonValuesArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Addon':
        """
        Get an existing Addon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Description of add-on instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the CCE add-on resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        :param pulumi.Input[_builtins.str] status: Add-on status information.
        :param pulumi.Input[_builtins.str] template_name: Specifies the name of the add-on template.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['AddonValuesArgs', 'AddonValuesArgsDict']] values: Specifies the add-on template installation parameters.
               These parameters vary depending on the add-on. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the add-on.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonState.__new__(_AddonState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["description"] = description
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["values"] = values
        __props__.__dict__["version"] = version
        return Addon(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of add-on instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the CCE add-on resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE add-on resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Add-on status information.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the add-on template.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional['outputs.AddonValues']]:
        """
        Specifies the add-on template installation parameters.
        These parameters vary depending on the add-on. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of the add-on.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "version")

